/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.models.UserModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FilestoreModel
implements Serializable,
Comparable<FilestoreModel> {
    private static final long serialVersionUID = 1L;
    private static final String metaRegexText = "version\\shttps://git-lfs.github.com/spec/v1\\s+" + "oid\\ssha256:([a-fA-F0-9]{64})\\s+" + "size\\s([0-9]+)";
    private static final Pattern metaRegex = Pattern.compile(metaRegexText);
    private static final int metaRegexIndexSHA = 1;
    private static final int metaRegexIndexSize = 2;
    public final String oid;
    private Long size;
    private Status status;
    private String stateChangedBy;
    private Date stateChangedOn;
    private List<String> repositories;

    public FilestoreModel(String id, long definedSize) {
        this.oid = id;
        this.size = definedSize;
        this.status = Status.ReferenceOnly;
    }

    public FilestoreModel(String id, long expectedSize, UserModel user, String repo) {
        this.oid = id;
        this.size = expectedSize;
        this.status = Status.Upload_Pending;
        this.stateChangedBy = user.getName();
        this.stateChangedOn = new Date();
        this.repositories = new ArrayList<String>();
        this.repositories.add(repo);
    }

    public static FilestoreModel fromMetaString(String meta) {
        Matcher m = metaRegex.matcher(meta);
        if (m.find()) {
            try {
                Long size = Long.parseLong(m.group(2));
                String sha = m.group(1);
                return new FilestoreModel(sha, size);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public synchronized long getSize() {
        return this.size;
    }

    public synchronized Status getStatus() {
        return this.status;
    }

    public synchronized String getChangedBy() {
        return this.stateChangedBy;
    }

    public synchronized Date getChangedOn() {
        return this.stateChangedOn;
    }

    public synchronized void setStatus(Status status, UserModel user) {
        this.status = status;
        this.stateChangedBy = user.getName();
        this.stateChangedOn = new Date();
    }

    public synchronized void reset(UserModel user, long size) {
        this.status = Status.Upload_Pending;
        this.stateChangedBy = user.getName();
        this.stateChangedOn = new Date();
        this.size = size;
    }

    public synchronized boolean actionUpload(UserModel user) {
        if (this.status == Status.Upload_Pending) {
            this.status = Status.Upload_In_Progress;
            this.stateChangedBy = user.getName();
            this.stateChangedOn = new Date();
            return true;
        }
        return false;
    }

    public synchronized boolean isInErrorState() {
        return this.status.value < 0;
    }

    public synchronized void addRepository(String repo) {
        if (this.status != Status.ReferenceOnly && !this.repositories.contains(repo)) {
            this.repositories.add(repo);
        }
    }

    public synchronized void removeRepository(String repo) {
        if (this.status != Status.ReferenceOnly) {
            this.repositories.remove(repo);
        }
    }

    public synchronized boolean isInRepositoryList(List<String> repoList) {
        if (this.status != Status.ReferenceOnly) {
            for (String name : this.repositories) {
                if (!repoList.contains(name)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int compareTo(FilestoreModel o) {
        return this.oid.compareTo(o.oid);
    }

    public static enum Status {
        ReferenceOnly(-42),
        Deleted(-30),
        AuthenticationRequired(-20),
        Error_Unknown(-8),
        Error_Unexpected_Stream_End(-7),
        Error_Invalid_Oid(-6),
        Error_Invalid_Size(-5),
        Error_Hash_Mismatch(-4),
        Error_Size_Mismatch(-3),
        Error_Exceeds_Size_Limit(-2),
        Error_Unauthorized(-1),
        Unavailable(0),
        Upload_Pending(1),
        Upload_In_Progress(2),
        Available(3);

        final int value;

        private Status(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.name().toLowerCase().replace('_', ' ');
        }

        public static Status fromState(int state) {
            for (Status s : Status.values()) {
                if (s.getValue() != state) continue;
                return s;
            }
            throw new NoSuchElementException(String.valueOf(state));
        }
    }
}

