/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class Mailing {
    public final Type type;
    public final Set<String> toAddresses;
    public final Set<String> ccAddresses;
    public final List<File> attachments;
    public String from;
    public String subject;
    public String content;
    public String id;

    public static Mailing newHtml() {
        return new Mailing(Type.html);
    }

    public static Mailing newPlain() {
        return new Mailing(Type.plain);
    }

    private Mailing(Type type) {
        this.type = type;
        this.toAddresses = new TreeSet<String>();
        this.ccAddresses = new TreeSet<String>();
        this.attachments = new ArrayList<File>();
    }

    public boolean hasRecipients() {
        return this.toAddresses.size() + this.ccAddresses.size() > 0;
    }

    public void setRecipients(String ... addrs) {
        this.setRecipients(Arrays.asList(addrs));
    }

    public void setRecipients(Collection<String> addrs) {
        this.toAddresses.clear();
        for (String addr : addrs) {
            this.toAddresses.add(addr.toLowerCase());
        }
        this.cleanup();
    }

    public boolean hasCCs() {
        return this.ccAddresses.size() > 0;
    }

    public void setCCs(String ... addrs) {
        this.setCCs(Arrays.asList(addrs));
    }

    public void setCCs(Collection<String> addrs) {
        this.ccAddresses.clear();
        for (String addr : addrs) {
            this.ccAddresses.add(addr.toLowerCase());
        }
        this.cleanup();
    }

    private void cleanup() {
        this.ccAddresses.removeAll(this.toAddresses);
    }

    public boolean hasAttachments() {
        return this.attachments.size() > 0;
    }

    public void addAttachment(File file) {
        this.attachments.add(file);
    }

    public String toString() {
        return this.subject + "\n\n" + this.content;
    }

    public static enum Type {
        plain,
        html;

    }
}

