/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.utils.JGitUtils;
import java.io.Serializable;
import java.util.Date;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;

public class RefModel
implements Serializable,
Comparable<RefModel> {
    private static final long serialVersionUID = 876822269940583606L;
    public final String displayName;
    private final Date date;
    private final String name;
    private final int type;
    private final String id;
    private final String referencedId;
    private final boolean annotated;
    private final PersonIdent person;
    private final String shortMessage;
    private final String fullMessage;
    private transient ObjectId objectId;
    private transient ObjectId referencedObjectId;
    public transient Ref reference;

    public RefModel(String displayName, Ref ref, RevObject refObject) {
        this.reference = ref;
        this.displayName = displayName;
        this.date = this.internalGetDate(refObject);
        this.name = ref != null ? ref.getName() : displayName;
        this.type = this.internalGetReferencedObjectType(refObject);
        this.objectId = ref != null ? ref.getObjectId() : ObjectId.zeroId();
        this.id = this.objectId.getName();
        this.referencedObjectId = this.internalGetReferencedObjectId(refObject);
        this.referencedId = this.referencedObjectId.getName();
        this.annotated = this.internalIsAnnotatedTag(ref, refObject);
        this.person = this.internalGetAuthorIdent(refObject);
        this.shortMessage = this.internalGetShortMessage(refObject);
        this.fullMessage = this.internalGetFullMessage(refObject);
    }

    private Date internalGetDate(RevObject referencedObject) {
        Date date = new Date(0L);
        if (referencedObject != null) {
            if (referencedObject instanceof RevTag) {
                RevTag tag = (RevTag)referencedObject;
                PersonIdent tagger = tag.getTaggerIdent();
                if (tagger != null) {
                    date = tagger.getWhen();
                }
            } else if (referencedObject instanceof RevCommit) {
                RevCommit commit = (RevCommit)referencedObject;
                date = JGitUtils.getAuthorDate(commit);
            }
        }
        return date;
    }

    public Date getDate() {
        return this.date;
    }

    public String getName() {
        return this.name;
    }

    private int internalGetReferencedObjectType(RevObject referencedObject) {
        int type = referencedObject.getType();
        if (referencedObject instanceof RevTag) {
            type = ((RevTag)referencedObject).getObject().getType();
        }
        return type;
    }

    public int getReferencedObjectType() {
        return this.type;
    }

    private ObjectId internalGetReferencedObjectId(RevObject referencedObject) {
        if (referencedObject instanceof RevTag) {
            return ((RevTag)referencedObject).getObject().getId();
        }
        return referencedObject.getId();
    }

    public ObjectId getReferencedObjectId() {
        if (this.referencedObjectId == null) {
            this.referencedObjectId = ObjectId.fromString((String)this.referencedId);
        }
        return this.referencedObjectId;
    }

    private String internalGetShortMessage(RevObject referencedObject) {
        String message = "";
        if (referencedObject instanceof RevTag) {
            message = ((RevTag)referencedObject).getShortMessage();
        } else if (referencedObject instanceof RevCommit) {
            message = ((RevCommit)referencedObject).getShortMessage();
        }
        return message;
    }

    public String getShortMessage() {
        return this.shortMessage;
    }

    private String internalGetFullMessage(RevObject referencedObject) {
        String message = "";
        if (referencedObject instanceof RevTag) {
            message = ((RevTag)referencedObject).getFullMessage();
        } else if (referencedObject instanceof RevCommit) {
            message = ((RevCommit)referencedObject).getFullMessage();
        }
        return message;
    }

    public String getFullMessage() {
        return this.fullMessage;
    }

    private PersonIdent internalGetAuthorIdent(RevObject referencedObject) {
        if (referencedObject instanceof RevTag) {
            return ((RevTag)referencedObject).getTaggerIdent();
        }
        if (referencedObject instanceof RevCommit) {
            return ((RevCommit)referencedObject).getAuthorIdent();
        }
        return null;
    }

    public PersonIdent getAuthorIdent() {
        return this.person;
    }

    public ObjectId getObjectId() {
        if (this.objectId == null) {
            this.objectId = ObjectId.fromString((String)this.id);
        }
        return this.objectId;
    }

    private boolean internalIsAnnotatedTag(Ref reference, RevObject referencedObject) {
        if (referencedObject instanceof RevTag) {
            return !this.getReferencedObjectId().equals((AnyObjectId)this.getObjectId());
        }
        return reference != null && reference.getPeeledObjectId() != null;
    }

    public boolean isAnnotatedTag() {
        return this.annotated;
    }

    public int hashCode() {
        return this.getReferencedObjectId().hashCode() + this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof RefModel) {
            RefModel other = (RefModel)o;
            return this.getName().equals(other.getName());
        }
        return super.equals(o);
    }

    @Override
    public int compareTo(RefModel o) {
        return this.getDate().compareTo(o.getDate());
    }

    public String toString() {
        return this.displayName;
    }
}

