/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.Constants;
import com.gitblit.utils.StringUtils;
import java.io.Serializable;

public class RegistrantAccessPermission
implements Serializable,
Comparable<RegistrantAccessPermission> {
    private static final long serialVersionUID = 1L;
    public String registrant;
    public Constants.AccessPermission permission;
    public Constants.RegistrantType registrantType;
    public Constants.PermissionType permissionType;
    public boolean mutable;
    public String source;

    public RegistrantAccessPermission() {
    }

    public RegistrantAccessPermission(Constants.RegistrantType registrantType) {
        this.registrantType = registrantType;
        this.permissionType = Constants.PermissionType.EXPLICIT;
        this.mutable = true;
    }

    public RegistrantAccessPermission(String registrant, Constants.AccessPermission permission, Constants.PermissionType permissionType, Constants.RegistrantType registrantType, String source, boolean mutable) {
        this.registrant = registrant;
        this.permission = permission;
        this.permissionType = permissionType;
        this.registrantType = registrantType;
        this.source = source;
        this.mutable = mutable;
    }

    public boolean isAdmin() {
        return Constants.PermissionType.ADMINISTRATOR.equals((Object)this.permissionType);
    }

    public boolean isOwner() {
        return Constants.PermissionType.OWNER.equals((Object)this.permissionType);
    }

    public boolean isExplicit() {
        return Constants.PermissionType.EXPLICIT.equals((Object)this.permissionType);
    }

    public boolean isRegex() {
        return Constants.PermissionType.REGEX.equals((Object)this.permissionType);
    }

    public boolean isTeam() {
        return Constants.PermissionType.TEAM.equals((Object)this.permissionType);
    }

    public boolean isMissing() {
        return Constants.PermissionType.MISSING.equals((Object)this.permissionType);
    }

    public int getScore() {
        switch (this.registrantType) {
            case REPOSITORY: {
                if (this.isAdmin()) {
                    return 0;
                }
                if (this.isOwner()) {
                    return 1;
                }
                if (this.isExplicit()) {
                    return 2;
                }
                if (this.isRegex()) {
                    return 3;
                }
                if (!this.isTeam()) break;
                return 4;
            }
        }
        return 0;
    }

    @Override
    public int compareTo(RegistrantAccessPermission p) {
        switch (this.registrantType) {
            case REPOSITORY: {
                int score1 = this.getScore();
                int score2 = p.getScore();
                if (score1 <= 2 && score2 <= 2) {
                    return StringUtils.compareRepositoryNames(this.registrant, p.registrant);
                }
                if (score1 < score2) {
                    return -1;
                }
                if (score2 < score1) {
                    return 1;
                }
                return StringUtils.compareRepositoryNames(this.registrant, p.registrant);
            }
        }
        return this.registrant.toLowerCase().compareTo(p.registrant.toLowerCase());
    }

    public int hashCode() {
        return this.registrant.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof RegistrantAccessPermission) {
            RegistrantAccessPermission p = (RegistrantAccessPermission)o;
            return this.registrant.equals(p.registrant);
        }
        return false;
    }

    public String toString() {
        return this.permission.asRole(this.registrant);
    }
}

