/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.models.RefModel;
import com.gitblit.wicket.GitBlitWebApp;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class RepositoryCommit
implements Serializable,
Comparable<RepositoryCommit> {
    private static final long serialVersionUID = -2214911650485772022L;
    public String repository;
    public String branch;
    private final String commitId;
    private List<RefModel> refs;
    private transient RevCommit commit;

    public RepositoryCommit(String repository, String branch, RevCommit commit) {
        this.repository = repository;
        this.branch = branch;
        this.commit = commit;
        this.commitId = commit.getName();
    }

    public void setRefs(List<RefModel> refs) {
        this.refs = refs;
    }

    public List<RefModel> getRefs() {
        return this.refs;
    }

    public ObjectId getId() {
        return this.commit.getId();
    }

    public String getName() {
        return this.commit.getName();
    }

    public String getShortName() {
        return this.commit.getName().substring(0, 8);
    }

    public String getShortMessage() {
        return this.commit.getShortMessage();
    }

    public Date getCommitDate() {
        return new Date((long)this.commit.getCommitTime() * 1000L);
    }

    public int getParentCount() {
        return this.commit.getParentCount();
    }

    public RevCommit[] getParents() {
        return this.commit.getParents();
    }

    public PersonIdent getAuthorIdent() {
        return this.commit.getAuthorIdent();
    }

    public PersonIdent getCommitterIdent() {
        return this.commit.getCommitterIdent();
    }

    public RevCommit getCommit() {
        return this.commit;
    }

    public boolean equals(Object o) {
        if (o instanceof RepositoryCommit) {
            RepositoryCommit commit = (RepositoryCommit)o;
            return this.repository.equals(commit.repository) && this.getName().equals(commit.getName());
        }
        return false;
    }

    public int hashCode() {
        return (this.repository + this.commit).hashCode();
    }

    @Override
    public int compareTo(RepositoryCommit o) {
        if (this.commit.getCommitTime() > o.commit.getCommitTime()) {
            return -1;
        }
        if (this.commit.getCommitTime() < o.commit.getCommitTime()) {
            return 1;
        }
        return 0;
    }

    public RepositoryCommit clone(String withRef) {
        return new RepositoryCommit(this.repository, withRef, this.commit);
    }

    public String toString() {
        return MessageFormat.format("{0} {1} {2,date,yyyy-MM-dd HH:mm} {3} {4}", this.getShortName(), this.branch, this.getCommitterIdent().getWhen(), this.getAuthorIdent().getName(), this.getShortMessage());
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        Repository repo = GitBlitWebApp.get().repositories().getRepository(this.repository);
        if (repo == null) {
            throw new IOException("Cannot find repositoy " + this.repository);
        }
        try (RevWalk walk = new RevWalk(repo);){
            this.commit = walk.parseCommit((AnyObjectId)repo.resolve(this.commitId));
        }
    }
}

