/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.util.RelativeDateFormatter;

public class TicketModel
implements Serializable,
Comparable<TicketModel> {
    private static final long serialVersionUID = 1L;
    public String project;
    public String repository;
    public long number;
    public Date created = new Date(0L);
    public String createdBy;
    public Date updated;
    public String updatedBy;
    public String title;
    public String body;
    public String topic;
    public Type type;
    public Status status;
    public String responsible;
    public String milestone;
    public String mergeSha;
    public String mergeTo;
    public List<Change> changes = new ArrayList<Change>();
    public Integer insertions;
    public Integer deletions;
    public Priority priority;
    public Severity severity;

    public static TicketModel buildTicket(Collection<Change> changes) {
        Integer latestRev;
        ArrayList<Change> effectiveChanges = new ArrayList<Change>();
        HashMap<String, Change> comments = new HashMap<String, Change>();
        HashMap<String, Change> references = new HashMap<String, Change>();
        HashMap<Integer, Integer> latestRevisions = new HashMap<Integer, Integer>();
        int latestPatchsetNumber = -1;
        ArrayList<Integer> deletedPatchsets = new ArrayList<Integer>();
        for (Change change : changes) {
            if (change.patchset == null) continue;
            if (change.patchset.isDeleted()) {
                deletedPatchsets.add(change.patchset.number);
                continue;
            }
            latestRev = (Integer)latestRevisions.get(change.patchset.number);
            if (latestRev == null || change.patchset.rev > latestRev) {
                latestRevisions.put(change.patchset.number, change.patchset.rev);
            }
            if (change.patchset.number <= latestPatchsetNumber) continue;
            latestPatchsetNumber = change.patchset.number;
        }
        for (Change change : changes) {
            int idx;
            Change clone;
            Change original;
            if (change.comment != null) {
                if (comments.containsKey(change.comment.id)) {
                    original = (Change)comments.get(change.comment.id);
                    clone = TicketModel.copy(original);
                    clone.comment.text = change.comment.text;
                    clone.comment.deleted = change.comment.deleted;
                    idx = effectiveChanges.indexOf(original);
                    effectiveChanges.remove(original);
                    effectiveChanges.add(idx, clone);
                    comments.put(clone.comment.id, clone);
                    continue;
                }
                effectiveChanges.add(change);
                comments.put(change.comment.id, change);
                continue;
            }
            if (change.patchset != null) {
                if (deletedPatchsets.contains(change.patchset.number)) continue;
                latestRev = (Integer)latestRevisions.get(change.patchset.number);
                if (change.patchset.number < latestPatchsetNumber && change.patchset.rev == latestRev) {
                    change.patchset.canDelete = true;
                }
                effectiveChanges.add(change);
                continue;
            }
            if (change.reference != null) {
                if (references.containsKey(change.reference.toString())) {
                    original = (Change)references.get(change.reference.toString());
                    clone = TicketModel.copy(original);
                    clone.reference.deleted = change.reference.deleted;
                    idx = effectiveChanges.indexOf(original);
                    effectiveChanges.remove(original);
                    effectiveChanges.add(idx, clone);
                    continue;
                }
                effectiveChanges.add(change);
                references.put(change.reference.toString(), change);
                continue;
            }
            effectiveChanges.add(change);
        }
        TicketModel ticket = new TicketModel();
        for (Change change : effectiveChanges) {
            if (!change.hasComment()) {
                change.comment = null;
            }
            if (!change.hasReference()) {
                change.reference = null;
            }
            if (!change.hasPatchset()) {
                change.patchset = null;
            }
            ticket.applyChange(change);
        }
        return ticket;
    }

    public TicketModel() {
        this.status = Status.New;
        this.type = Type.defaultType;
        this.priority = Priority.defaultPriority;
        this.severity = Severity.defaultSeverity;
    }

    public boolean isOpen() {
        return !this.status.isClosed();
    }

    public boolean isClosed() {
        return this.status.isClosed();
    }

    public boolean isMerged() {
        return this.isClosed() && !TicketModel.isEmpty(this.mergeSha);
    }

    public boolean isProposal() {
        return Type.Proposal == this.type;
    }

    public boolean isBug() {
        return Type.Bug == this.type;
    }

    public Date getLastUpdated() {
        return this.updated == null ? this.created : this.updated;
    }

    public boolean hasPatchsets() {
        return this.getPatchsets().size() > 0;
    }

    public boolean hasDiscussion() {
        for (Change change : this.getComments()) {
            if (change.author.equals(this.createdBy)) continue;
            return true;
        }
        return false;
    }

    public List<Change> getComments() {
        ArrayList<Change> list = new ArrayList<Change>();
        for (Change change : this.changes) {
            if (!change.hasComment()) continue;
            list.add(change);
        }
        return list;
    }

    public List<String> getParticipants() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Change change : this.changes) {
            if (!change.isParticipantChange()) continue;
            set.add(change.author);
        }
        if (this.responsible != null && this.responsible.length() > 0) {
            set.add(this.responsible);
        }
        return new ArrayList<String>(set);
    }

    public boolean hasLabel(String label) {
        return this.getLabels().contains(label);
    }

    public List<String> getLabels() {
        return this.getList(Field.labels);
    }

    public boolean isResponsible(String username) {
        return username.equals(this.responsible);
    }

    public boolean isAuthor(String username) {
        return username.equals(this.createdBy);
    }

    public boolean isReviewer(String username) {
        return this.getReviewers().contains(username);
    }

    public List<String> getReviewers() {
        return this.getList(Field.reviewers);
    }

    public boolean isWatching(String username) {
        return this.getWatchers().contains(username);
    }

    public List<String> getWatchers() {
        return this.getList(Field.watchers);
    }

    public boolean isVoter(String username) {
        return this.getVoters().contains(username);
    }

    public List<String> getVoters() {
        return this.getList(Field.voters);
    }

    public List<String> getMentions() {
        return this.getList(Field.mentions);
    }

    protected List<String> getList(Field field) {
        TreeSet<String> set = new TreeSet<String>();
        for (Change change : this.changes) {
            if (!change.hasField(field)) continue;
            String values = change.getString(field);
            block5: for (String value : values.split(",")) {
                switch (value.charAt(0)) {
                    case '+': {
                        set.add(value.substring(1));
                        continue block5;
                    }
                    case '-': {
                        set.remove(value.substring(1));
                        continue block5;
                    }
                    default: {
                        set.add(value);
                    }
                }
            }
        }
        if (!set.isEmpty()) {
            return new ArrayList<String>(set);
        }
        return Collections.emptyList();
    }

    public Attachment getAttachment(String name) {
        Attachment attachment = null;
        for (Change change : this.changes) {
            Attachment a;
            if (!change.hasAttachments() || (a = change.getAttachment(name)) == null) continue;
            attachment = a;
        }
        return attachment;
    }

    public boolean hasAttachments() {
        for (Change change : this.changes) {
            if (!change.hasAttachments()) continue;
            return true;
        }
        return false;
    }

    public boolean hasReferences() {
        for (Change change : this.changes) {
            if (!change.hasReference()) continue;
            return true;
        }
        return false;
    }

    public List<Attachment> getAttachments() {
        ArrayList<Attachment> list = new ArrayList<Attachment>();
        for (Change change : this.changes) {
            if (!change.hasAttachments()) continue;
            list.addAll(change.attachments);
        }
        return list;
    }

    public List<Reference> getReferences() {
        ArrayList<Reference> list = new ArrayList<Reference>();
        for (Change change : this.changes) {
            if (!change.hasReference()) continue;
            list.add(change.reference);
        }
        return list;
    }

    public List<Patchset> getPatchsets() {
        ArrayList<Patchset> list = new ArrayList<Patchset>();
        for (Change change : this.changes) {
            if (change.patchset == null) continue;
            list.add(change.patchset);
        }
        return list;
    }

    public List<Patchset> getPatchsetRevisions(int number) {
        ArrayList<Patchset> list = new ArrayList<Patchset>();
        for (Change change : this.changes) {
            if (change.patchset == null || number != change.patchset.number) continue;
            list.add(change.patchset);
        }
        return list;
    }

    public Patchset getPatchset(String sha) {
        for (Change change : this.changes) {
            if (change.patchset == null || !sha.equals(change.patchset.tip)) continue;
            return change.patchset;
        }
        return null;
    }

    public Patchset getPatchset(int number, int rev) {
        for (Change change : this.changes) {
            if (change.patchset == null || number != change.patchset.number || rev != change.patchset.rev) continue;
            return change.patchset;
        }
        return null;
    }

    public Patchset getCurrentPatchset() {
        Patchset patchset = null;
        for (Change change : this.changes) {
            if (change.patchset == null) continue;
            if (patchset == null) {
                patchset = change.patchset;
                continue;
            }
            if (patchset.compareTo(change.patchset) != 1) continue;
            patchset = change.patchset;
        }
        return patchset;
    }

    public boolean isCurrent(Patchset patchset) {
        if (patchset == null) {
            return false;
        }
        Patchset curr = this.getCurrentPatchset();
        if (curr == null) {
            return false;
        }
        return curr.equals(patchset);
    }

    public List<Change> getReviews(Patchset patchset) {
        if (patchset == null) {
            return Collections.emptyList();
        }
        LinkedHashMap<String, Change> reviews = new LinkedHashMap<String, Change>();
        for (Change change : this.changes) {
            if (!change.hasReview() || !change.review.isReviewOf(patchset)) continue;
            reviews.put(change.author, change);
        }
        return new ArrayList<Change>(reviews.values());
    }

    public boolean isApproved(Patchset patchset) {
        if (patchset == null) {
            return false;
        }
        boolean approved = false;
        boolean vetoed = false;
        for (Change change : this.getReviews(patchset)) {
            if (!change.hasReview() || !change.review.isReviewOf(patchset)) continue;
            if (Score.approved == change.review.score) {
                approved = true;
                continue;
            }
            if (Score.vetoed != change.review.score) continue;
            vetoed = true;
        }
        return approved && !vetoed;
    }

    public boolean isVetoed(Patchset patchset) {
        if (patchset == null) {
            return false;
        }
        for (Change change : this.getReviews(patchset)) {
            if (!change.hasReview() || !change.review.isReviewOf(patchset) || Score.vetoed != change.review.score) continue;
            return true;
        }
        return false;
    }

    public Review getReviewBy(String username) {
        for (Change change : this.getReviews(this.getCurrentPatchset())) {
            if (!change.author.equals(username)) continue;
            return change.review;
        }
        return null;
    }

    public boolean isPatchsetAuthor(String username) {
        for (Change change : this.changes) {
            if (!change.hasPatchset() || !change.author.equals(username)) continue;
            return true;
        }
        return false;
    }

    public void applyChange(Change change) {
        if (this.changes.size() == 0) {
            this.created = change.date;
            this.createdBy = change.author;
            this.status = Status.New;
        } else if (this.created == null || change.date.after(this.created)) {
            this.updated = change.date;
            this.updatedBy = change.author;
        }
        if (change.isMerge()) {
            if (TicketModel.isEmpty(this.responsible)) {
                this.responsible = change.author;
            }
            this.status = Status.Merged;
        }
        if (change.hasFieldChanges()) {
            for (Map.Entry<Field, String> entry : change.fields.entrySet()) {
                Field field = entry.getKey();
                String value = entry.getValue();
                switch (field) {
                    case type: {
                        this.type = Type.fromObject(value, this.type);
                        break;
                    }
                    case status: {
                        this.status = Status.fromObject(value, this.status);
                        break;
                    }
                    case title: {
                        this.title = this.toString(value);
                        break;
                    }
                    case body: {
                        this.body = this.toString(value);
                        break;
                    }
                    case topic: {
                        this.topic = this.toString(value);
                        break;
                    }
                    case responsible: {
                        this.responsible = this.toString(value);
                        break;
                    }
                    case milestone: {
                        this.milestone = this.toString(value);
                        break;
                    }
                    case mergeTo: {
                        this.mergeTo = this.toString(value);
                        break;
                    }
                    case mergeSha: {
                        this.mergeSha = this.toString(value);
                        break;
                    }
                    case priority: {
                        this.priority = Priority.fromObject(value, this.priority);
                        break;
                    }
                    case severity: {
                        this.severity = Severity.fromObject(value, this.severity);
                        break;
                    }
                }
            }
        }
        if (change.isEmptyChange()) {
            this.changes.remove(change);
        } else {
            this.changes.add(change);
        }
    }

    protected String toString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public String toIndexableString() {
        StringBuilder sb = new StringBuilder();
        if (!TicketModel.isEmpty(this.title)) {
            sb.append(this.title).append('\n');
        }
        if (!TicketModel.isEmpty(this.body)) {
            sb.append(this.body).append('\n');
        }
        for (Change change : this.changes) {
            if (!change.hasComment()) continue;
            sb.append(change.comment.text);
            sb.append('\n');
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("#");
        sb.append(this.number);
        sb.append(": " + this.title + "\n");
        for (Change change : this.changes) {
            sb.append(change);
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public int compareTo(TicketModel o) {
        return o.created.compareTo(this.created);
    }

    public boolean equals(Object o) {
        if (o instanceof TicketModel) {
            return this.number == ((TicketModel)o).number;
        }
        return super.equals(o);
    }

    public int hashCode() {
        return (this.repository + this.number).hashCode();
    }

    static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.size() == 0;
    }

    static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.size() == 0;
    }

    static String getSHA1(String text) {
        try {
            byte[] bytes = text.getBytes("iso-8859-1");
            return TicketModel.getSHA1(bytes);
        }
        catch (UnsupportedEncodingException u) {
            throw new RuntimeException(u);
        }
    }

    static String getSHA1(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(bytes, 0, bytes.length);
            byte[] digest = md.digest();
            return TicketModel.toHex(digest);
        }
        catch (NoSuchAlgorithmException t) {
            throw new RuntimeException(t);
        }
    }

    static String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            if ((bytes[i] & 0xFF) < 16) {
                sb.append('0');
            }
            sb.append(Long.toString(bytes[i] & 0xFF, 16));
        }
        return sb.toString();
    }

    static String join(Collection<String> values) {
        return TicketModel.join(values, " ");
    }

    static String join(String[] values, String separator) {
        return TicketModel.join(Arrays.asList(values), separator);
    }

    static String join(Collection<String> values, String separator) {
        StringBuilder sb = new StringBuilder();
        for (String value : values) {
            sb.append(value).append(separator);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - separator.length());
        }
        return sb.toString().trim();
    }

    static <T> T copy(T original) {
        Object o = null;
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(byteOut);
            oos.writeObject(original);
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(byteIn);
            try {
                o = ois.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
        return (T)o;
    }

    public static enum Severity {
        Unrated(-1),
        Negligible(1),
        Minor(2),
        Serious(3),
        Critical(4),
        Catastrophic(5);

        public static Severity defaultSeverity;
        final int value;

        private Severity(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Severity[] choices() {
            return new Severity[]{Unrated, Negligible, Minor, Serious, Critical, Catastrophic};
        }

        public String toString() {
            return this.name().toLowerCase().replace('_', ' ');
        }

        public static Severity fromObject(Object o, Severity defaultSeverity) {
            if (o instanceof Severity) {
                return (Severity)((Object)o);
            }
            if (o instanceof String) {
                for (Severity severity : Severity.values()) {
                    String str = o.toString();
                    if (!severity.name().equalsIgnoreCase(str) && !severity.toString().equalsIgnoreCase(str)) continue;
                    return severity;
                }
            } else if (o instanceof Number) {
                switch (((Number)o).intValue()) {
                    case -1: {
                        return Unrated;
                    }
                    case 1: {
                        return Negligible;
                    }
                    case 2: {
                        return Minor;
                    }
                    case 3: {
                        return Serious;
                    }
                    case 4: {
                        return Critical;
                    }
                    case 5: {
                        return Catastrophic;
                    }
                }
                return Unrated;
            }
            return defaultSeverity;
        }

        static {
            defaultSeverity = Unrated;
        }
    }

    public static enum Priority {
        Low(-1),
        Normal(0),
        High(1),
        Urgent(2);

        public static Priority defaultPriority;
        final int value;

        private Priority(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Priority[] choices() {
            return new Priority[]{Urgent, High, Normal, Low};
        }

        public String toString() {
            return this.name().toLowerCase().replace('_', ' ');
        }

        public static Priority fromObject(Object o, Priority defaultPriority) {
            if (o instanceof Priority) {
                return (Priority)((Object)o);
            }
            if (o instanceof String) {
                for (Priority priority : Priority.values()) {
                    String str = o.toString();
                    if (!priority.name().equalsIgnoreCase(str) && !priority.toString().equalsIgnoreCase(str)) continue;
                    return priority;
                }
            } else if (o instanceof Number) {
                switch (((Number)o).intValue()) {
                    case -1: {
                        return Low;
                    }
                    case 0: {
                        return Normal;
                    }
                    case 1: {
                        return High;
                    }
                    case 2: {
                        return Urgent;
                    }
                }
                return Normal;
            }
            return defaultPriority;
        }

        static {
            defaultPriority = Normal;
        }
    }

    public static enum PatchsetType {
        Proposal,
        FastForward,
        Rebase,
        Squash,
        Rebase_Squash,
        Amend,
        Delete;


        public boolean isRewrite() {
            return this != FastForward && this != Proposal;
        }

        public String toString() {
            return this.name().toLowerCase().replace('_', '+');
        }

        public static PatchsetType fromObject(Object o) {
            int id;
            if (o instanceof PatchsetType) {
                return (PatchsetType)((Object)o);
            }
            if (o instanceof String) {
                String name = o.toString();
                for (PatchsetType type : PatchsetType.values()) {
                    if (!type.name().equalsIgnoreCase(name) && !type.toString().equalsIgnoreCase(name)) continue;
                    return type;
                }
            } else if (o instanceof Number && (id = ((Number)o).intValue()) >= 0 && id < PatchsetType.values().length) {
                return PatchsetType.values()[id];
            }
            return null;
        }
    }

    public static enum CommentSource {
        Comment,
        Email;

    }

    public static enum Status {
        New,
        Open,
        Closed,
        Resolved,
        Fixed,
        Merged,
        Wontfix,
        Declined,
        Duplicate,
        Invalid,
        Abandoned,
        On_Hold,
        No_Change_Required;

        public static Status[] requestWorkflow;
        public static Status[] bugWorkflow;
        public static Status[] proposalWorkflow;
        public static Status[] milestoneWorkflow;

        public String toString() {
            return this.name().toLowerCase().replace('_', ' ');
        }

        public static Status fromObject(Object o, Status defaultStatus) {
            int id;
            if (o instanceof Status) {
                return (Status)((Object)o);
            }
            if (o instanceof String) {
                String name = o.toString();
                for (Status state : Status.values()) {
                    if (!state.name().equalsIgnoreCase(name) && !state.toString().equalsIgnoreCase(name)) continue;
                    return state;
                }
            } else if (o instanceof Number && (id = ((Number)o).intValue()) >= 0 && id < Status.values().length) {
                return Status.values()[id];
            }
            return defaultStatus;
        }

        public boolean isClosed() {
            return this.ordinal() > Open.ordinal();
        }

        static {
            requestWorkflow = new Status[]{Open, Resolved, Declined, Duplicate, Invalid, Abandoned, On_Hold, No_Change_Required};
            bugWorkflow = new Status[]{Open, Fixed, Wontfix, Duplicate, Invalid, Abandoned, On_Hold, No_Change_Required};
            proposalWorkflow = new Status[]{Open, Resolved, Declined, Abandoned, On_Hold, No_Change_Required};
            milestoneWorkflow = new Status[]{Open, Closed, Abandoned, On_Hold};
        }
    }

    public static enum Type {
        Enhancement,
        Task,
        Bug,
        Proposal,
        Question,
        Maintenance;

        public static Type defaultType;

        public static Type[] choices() {
            return new Type[]{Enhancement, Task, Bug, Question, Maintenance};
        }

        public String toString() {
            return this.name().toLowerCase().replace('_', ' ');
        }

        public static Type fromObject(Object o, Type defaultType) {
            int id;
            if (o instanceof Type) {
                return (Type)((Object)o);
            }
            if (o instanceof String) {
                for (Type type : Type.values()) {
                    String str = o.toString();
                    if (!type.name().equalsIgnoreCase(str) && !type.toString().equalsIgnoreCase(str)) continue;
                    return type;
                }
            } else if (o instanceof Number && (id = ((Number)o).intValue()) >= 0 && id < Type.values().length) {
                return Type.values()[id];
            }
            return defaultType;
        }

        static {
            defaultType = Task;
        }
    }

    public static enum Field {
        title,
        body,
        responsible,
        type,
        status,
        milestone,
        mergeSha,
        mergeTo,
        topic,
        labels,
        watchers,
        reviewers,
        voters,
        mentions,
        priority,
        severity;

    }

    public static enum Score {
        approved(2),
        looks_good(1),
        not_reviewed(0),
        needs_improvement(-1),
        vetoed(-2);

        final int value;

        private Score(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.name().toLowerCase().replace('_', ' ');
        }

        public static Score fromScore(int score) {
            for (Score s : Score.values()) {
                if (s.getValue() != score) continue;
                return s;
            }
            throw new NoSuchElementException(String.valueOf(score));
        }
    }

    public static class Review
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final int patchset;
        public final int rev;
        public Score score;

        public Review(int patchset, int revision) {
            this.patchset = patchset;
            this.rev = revision;
        }

        public boolean isReviewOf(Patchset p) {
            return this.patchset == p.number && this.rev == p.rev;
        }

        public String toString() {
            return "review of patchset " + this.patchset + " rev " + this.rev + ":" + (Object)((Object)this.score);
        }
    }

    public static class Attachment
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String name;
        public long size;
        public byte[] content;
        public Boolean deleted;

        public Attachment(String name) {
            this.name = name;
        }

        public boolean isDeleted() {
            return this.deleted != null && this.deleted != false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Attachment) {
                return this.name.equalsIgnoreCase(((Attachment)o).name);
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Reference
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String hash;
        public Long ticketId;
        public Boolean deleted;

        Reference(String commitHash) {
            this.hash = commitHash;
        }

        Reference(long ticketId, String changeHash) {
            this.ticketId = ticketId;
            this.hash = changeHash;
        }

        public ReferenceType getSourceType() {
            if (this.hash != null) {
                if (this.ticketId != null) {
                    return ReferenceType.Ticket;
                }
                return ReferenceType.Commit;
            }
            return ReferenceType.Undefined;
        }

        public boolean isDeleted() {
            return this.deleted != null && this.deleted != false;
        }

        public String toString() {
            switch (this.getSourceType()) {
                case Commit: {
                    return this.hash;
                }
                case Ticket: {
                    return this.ticketId.toString() + "#" + this.hash;
                }
            }
            return String.format("Unknown Reference Type", new Object[0]);
        }
    }

    public static enum ReferenceType {
        Undefined,
        Commit,
        Ticket;


        public String toString() {
            return this.name().toLowerCase().replace('_', ' ');
        }

        public static ReferenceType fromObject(Object o, ReferenceType defaultType) {
            int id;
            if (o instanceof ReferenceType) {
                return (ReferenceType)((Object)o);
            }
            if (o instanceof String) {
                for (ReferenceType type : ReferenceType.values()) {
                    String str = o.toString();
                    if (!type.name().equalsIgnoreCase(str) && !type.toString().equalsIgnoreCase(str)) continue;
                    return type;
                }
            } else if (o instanceof Number && (id = ((Number)o).intValue()) >= 0 && id < ReferenceType.values().length) {
                return ReferenceType.values()[id];
            }
            return defaultType;
        }
    }

    public static class TicketLink {
        public long targetTicketId;
        public String hash;
        public TicketAction action;
        public boolean success;
        public boolean isDelete;

        public TicketLink(long targetTicketId, TicketAction action) {
            this.targetTicketId = targetTicketId;
            this.action = action;
            this.success = false;
            this.isDelete = false;
        }

        public TicketLink(long targetTicketId, TicketAction action, String hash) {
            this.targetTicketId = targetTicketId;
            this.action = action;
            this.hash = hash;
            this.success = false;
            this.isDelete = false;
        }
    }

    public static enum TicketAction {
        Commit,
        Comment,
        Patchset,
        Close;

    }

    public static class Comment
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String text;
        public String id;
        public Boolean deleted;
        public CommentSource src;
        public String replyTo;

        Comment(String text) {
            this.text = text;
        }

        public boolean isDeleted() {
            return this.deleted != null && this.deleted != false;
        }

        public String toString() {
            return this.text;
        }
    }

    public static class Patchset
    implements Serializable,
    Comparable<Patchset> {
        private static final long serialVersionUID = 1L;
        public long ticketId;
        public int number;
        public int rev;
        public String tip;
        public String parent;
        public String base;
        public int insertions;
        public int deletions;
        public int commits;
        public int added;
        public PatchsetType type;
        public transient boolean canDelete = false;

        public boolean isFF() {
            return PatchsetType.FastForward == this.type;
        }

        public boolean isDeleted() {
            return PatchsetType.Delete == this.type;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Patchset) {
                return this.hashCode() == o.hashCode();
            }
            return false;
        }

        @Override
        public int compareTo(Patchset p) {
            if (this.number > p.number) {
                return -1;
            }
            if (p.number > this.number) {
                return 1;
            }
            if (this.rev > p.rev) {
                return -1;
            }
            if (p.rev > this.rev) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "patchset " + this.number + " revision " + this.rev;
        }
    }

    public static class Change
    implements Serializable,
    Comparable<Change> {
        private static final long serialVersionUID = 1L;
        public final Date date;
        public final String author;
        public Comment comment;
        public Reference reference;
        public Map<Field, String> fields;
        public Set<Attachment> attachments;
        public Patchset patchset;
        public Review review;
        private transient String id;
        public transient List<TicketLink> pendingLinks;

        public Change(String author) {
            this(author, new Date());
        }

        public Change(String author, Date date) {
            this.date = date;
            this.author = author;
        }

        public boolean isStatusChange() {
            return this.hasField(Field.status);
        }

        public Status getStatus() {
            Status state = Status.fromObject(this.getField(Field.status), null);
            return state;
        }

        public boolean isMerge() {
            return this.hasField(Field.status) && this.hasField(Field.mergeSha);
        }

        public boolean hasPatchset() {
            return this.patchset != null && !this.patchset.isDeleted();
        }

        public boolean hasReview() {
            return this.review != null;
        }

        public boolean hasComment() {
            return this.comment != null && !this.comment.isDeleted() && this.comment.text != null;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isDeleted();
        }

        public boolean hasPendingLinks() {
            return this.pendingLinks != null && this.pendingLinks.size() > 0;
        }

        public Comment comment(String text) {
            Matcher m;
            this.comment = new Comment(text);
            this.comment.id = TicketModel.getSHA1(this.date.toString() + this.author + text);
            String x = "(?:ref|task|issue|bug)?[\\s-]*#(\\d+)";
            try {
                Pattern p = Pattern.compile(x, 2);
                m = p.matcher(text);
                while (m.find()) {
                    String val = m.group(1);
                    long targetTicketId = Long.parseLong(val);
                    if (targetTicketId <= 0L) continue;
                    if (this.pendingLinks == null) {
                        this.pendingLinks = new ArrayList<TicketLink>();
                    }
                    this.pendingLinks.add(new TicketLink(targetTicketId, TicketAction.Comment));
                }
            }
            catch (Exception p) {
                // empty catch block
            }
            try {
                Pattern mentions = Pattern.compile("\\B@(?<user>[^\\s]+)\\b");
                m = mentions.matcher(text);
                while (m.find()) {
                    String username = m.group("user");
                    this.plusList(Field.mentions, username);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.comment;
        }

        public Reference referenceCommit(String commitHash) {
            this.reference = new Reference(commitHash);
            return this.reference;
        }

        public Reference referenceTicket(long ticketId, String changeHash) {
            this.reference = new Reference(ticketId, changeHash);
            return this.reference;
        }

        public Review review(Patchset patchset, Score score, boolean addReviewer) {
            if (addReviewer) {
                this.plusList(Field.reviewers, this.author);
            }
            this.review = new Review(patchset.number, patchset.rev);
            this.review.score = score;
            return this.review;
        }

        public boolean hasAttachments() {
            return !TicketModel.isEmpty(this.attachments);
        }

        public void addAttachment(Attachment attachment) {
            if (this.attachments == null) {
                this.attachments = new LinkedHashSet<Attachment>();
            }
            this.attachments.add(attachment);
        }

        public Attachment getAttachment(String name) {
            if (this.attachments != null) {
                for (Attachment attachment : this.attachments) {
                    if (!attachment.name.equalsIgnoreCase(name)) continue;
                    return attachment;
                }
            }
            return null;
        }

        public boolean isParticipantChange() {
            if (this.hasComment() || this.hasReview() || this.hasPatchset() || this.hasAttachments()) {
                return true;
            }
            if (TicketModel.isEmpty(this.fields)) {
                return false;
            }
            HashMap<Field, String> map = new HashMap<Field, String>(this.fields);
            map.remove((Object)Field.watchers);
            map.remove((Object)Field.voters);
            return !map.isEmpty();
        }

        public boolean hasField(Field field) {
            return !TicketModel.isEmpty(this.getString(field));
        }

        public boolean hasFieldChanges() {
            return !TicketModel.isEmpty(this.fields);
        }

        public String getField(Field field) {
            if (this.fields != null) {
                return this.fields.get((Object)field);
            }
            return null;
        }

        public void setField(Field field, Object value) {
            if (this.fields == null) {
                this.fields = new LinkedHashMap<Field, String>();
            }
            if (value == null) {
                this.fields.put(field, null);
            } else if (Enum.class.isAssignableFrom(value.getClass())) {
                this.fields.put(field, ((Enum)value).name());
            } else {
                this.fields.put(field, value.toString());
            }
        }

        public void remove(Field field) {
            if (this.fields != null) {
                this.fields.remove((Object)field);
            }
        }

        public String getString(Field field) {
            String value = this.getField(field);
            if (value == null) {
                return null;
            }
            return value;
        }

        public void watch(String ... username) {
            this.plusList(Field.watchers, username);
        }

        public void unwatch(String ... username) {
            this.minusList(Field.watchers, username);
        }

        public void vote(String ... username) {
            this.plusList(Field.voters, username);
        }

        public void unvote(String ... username) {
            this.minusList(Field.voters, username);
        }

        public void label(String ... label) {
            this.plusList(Field.labels, label);
        }

        public void unlabel(String ... label) {
            this.minusList(Field.labels, label);
        }

        protected void plusList(Field field, String ... items) {
            this.modList(field, "+", items);
        }

        protected void minusList(Field field, String ... items) {
            this.modList(field, "-", items);
        }

        private void modList(Field field, String prefix, String ... items) {
            ArrayList<String> list = new ArrayList<String>();
            for (String item : items) {
                list.add(prefix + item);
            }
            if (this.hasField(field)) {
                String flat = this.getString(field);
                if (TicketModel.isEmpty(flat)) {
                    this.setField(field, TicketModel.join(list, ","));
                } else {
                    TreeSet<String> set = new TreeSet<String>(Arrays.asList(flat.split(",")));
                    set.addAll(list);
                    this.setField(field, TicketModel.join(set, ","));
                }
            } else {
                this.setField(field, TicketModel.join(list, ","));
            }
        }

        public String getId() {
            if (this.id == null) {
                this.id = TicketModel.getSHA1(Long.toHexString(this.date.getTime()) + this.author);
            }
            return this.id;
        }

        @Override
        public int compareTo(Change c) {
            return this.date.compareTo(c.date);
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Change) {
                return this.getId().equals(((Change)o).getId());
            }
            return false;
        }

        private boolean isEmptyChange() {
            return this.comment == null && this.reference == null && this.fields == null && this.attachments == null && this.patchset == null && this.review == null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(RelativeDateFormatter.format((Date)this.date));
            if (this.hasComment()) {
                sb.append(" commented on by ");
            } else if (this.hasPatchset()) {
                sb.append(MessageFormat.format(" {0} uploaded by ", this.patchset));
            } else if (this.hasReference()) {
                sb.append(MessageFormat.format(" referenced in {0} by ", this.reference));
            } else {
                sb.append(" changed by ");
            }
            sb.append(this.author).append(" - ");
            if (this.hasComment()) {
                if (this.comment.isDeleted()) {
                    sb.append("(deleted) ");
                }
                sb.append(this.comment.text).append(" ");
            }
            if (this.hasFieldChanges()) {
                for (Map.Entry<Field, String> entry : this.fields.entrySet()) {
                    sb.append("\n  ");
                    sb.append(entry.getKey().name());
                    sb.append(':');
                    sb.append(entry.getValue());
                }
            }
            return sb.toString();
        }
    }
}

