/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.models.RepositoryModel;
import com.gitblit.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TreeNodeModel
implements Serializable,
Comparable<TreeNodeModel> {
    private static final long serialVersionUID = 1L;
    final TreeNodeModel parent;
    final String name;
    final List<TreeNodeModel> subFolders = new ArrayList<TreeNodeModel>();
    final List<RepositoryModel> repositories = new ArrayList<RepositoryModel>();

    public TreeNodeModel() {
        this.name = "/";
        this.parent = null;
    }

    protected TreeNodeModel(String name, TreeNodeModel parent) {
        this.name = name;
        this.parent = parent;
    }

    public int getDepth() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getDepth() + 1;
    }

    public TreeNodeModel add(String subFolder) {
        TreeNodeModel n = new TreeNodeModel(subFolder, this);
        this.subFolders.add(n);
        Collections.sort(this.subFolders);
        return n;
    }

    public void add(RepositoryModel repo) {
        this.repositories.add(repo);
        Collections.sort(this.repositories);
    }

    public void add(String path, RepositoryModel model) {
        TreeNodeModel folder = TreeNodeModel.getSubTreeNode(this, path, true);
        folder.add(model);
    }

    public String toString() {
        int i;
        String string = this.name + "\n";
        for (TreeNodeModel treeNodeModel : this.subFolders) {
            string = string + "f";
            for (i = 0; i < treeNodeModel.getDepth(); ++i) {
                string = string + "-";
            }
            string = string + treeNodeModel.toString();
        }
        for (RepositoryModel repositoryModel : this.repositories) {
            string = string + "r";
            for (i = 0; i < this.getDepth() + 1; ++i) {
                string = string + "-";
            }
            string = string + repositoryModel.toString() + "\n";
        }
        return string;
    }

    public boolean containsSubFolder(String path) {
        return TreeNodeModel.containsSubFolder(this, path);
    }

    public TreeNodeModel getSubFolder(String path) {
        return TreeNodeModel.getSubTreeNode(this, path, false);
    }

    public List<Serializable> getTreeAsListForFrontend() {
        ArrayList<Serializable> l = new ArrayList<Serializable>();
        TreeNodeModel.getTreeAsListForFrontend(l, this);
        return l;
    }

    private static void getTreeAsListForFrontend(List<Serializable> list, TreeNodeModel node) {
        list.add(node);
        for (TreeNodeModel t : node.subFolders) {
            TreeNodeModel.getTreeAsListForFrontend(list, t);
        }
        for (RepositoryModel r : node.repositories) {
            list.add(r);
        }
    }

    private static TreeNodeModel getSubTreeNode(TreeNodeModel node, String path, boolean create) {
        if (!StringUtils.isEmpty(path)) {
            boolean isPathInCurrentHierarchyLevel;
            boolean bl = isPathInCurrentHierarchyLevel = path.lastIndexOf(47) < 0;
            if (isPathInCurrentHierarchyLevel) {
                for (TreeNodeModel t : node.subFolders) {
                    if (!t.name.equals(path)) continue;
                    return t;
                }
                if (create) {
                    node.add(path);
                    return TreeNodeModel.getSubTreeNode(node, path, true);
                }
            } else {
                String folderInCurrentHierarchyLevel = StringUtils.getFirstPathElement(path);
                for (TreeNodeModel t : node.subFolders) {
                    if (!t.name.equals(folderInCurrentHierarchyLevel)) continue;
                    String folderInNextHierarchyLevel = path.substring(path.indexOf(47) + 1, path.length());
                    return TreeNodeModel.getSubTreeNode(t, folderInNextHierarchyLevel, create);
                }
                if (create) {
                    String folderInNextHierarchyLevel = path.substring(path.indexOf(47) + 1, path.length());
                    return TreeNodeModel.getSubTreeNode(node.add(folderInCurrentHierarchyLevel), folderInNextHierarchyLevel, true);
                }
            }
        }
        return null;
    }

    private static boolean containsSubFolder(TreeNodeModel node, String path) {
        return TreeNodeModel.getSubTreeNode(node, path, false) != null;
    }

    @Override
    public int compareTo(TreeNodeModel t) {
        return StringUtils.compareRepositoryNames(this.name, t.name);
    }

    public TreeNodeModel getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public List<TreeNodeModel> getSubFolders() {
        return this.subFolders;
    }

    public List<RepositoryModel> getRepositories() {
        return this.repositories;
    }
}

