/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.models;

import com.gitblit.utils.StringUtils;
import java.io.Serializable;

public class UserChoice
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String displayName;
    private final String userId;
    private final String email;

    public UserChoice(String userId) {
        this(null, userId, null);
    }

    public UserChoice(String displayName, String userId) {
        this(displayName, userId, null);
    }

    public UserChoice(String displayName, String userId, String email) {
        if (userId == null) {
            throw new IllegalArgumentException("The argument userId can't be null!");
        }
        if ("".equals(userId)) {
            throw new IllegalArgumentException("The argument userId can't be an empty String!");
        }
        this.displayName = displayName;
        this.userId = userId;
        this.email = email;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameOrUserId() {
        if (StringUtils.isEmpty(this.displayName)) {
            return this.userId;
        }
        return this.displayName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getEmail() {
        return this.email;
    }

    public String toString() {
        String dn = this.getDisplayNameOrUserId();
        if (dn.equals(this.userId)) {
            return dn;
        }
        return dn + " (" + this.userId + ")";
    }
}

