/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.service;

import com.gitblit.IStoredSettings;
import com.gitblit.auth.LdapAuthProvider;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LdapSyncService
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(LdapSyncService.class);
    private final IStoredSettings settings;
    private final LdapAuthProvider ldapAuthProvider;
    private final AtomicBoolean running = new AtomicBoolean(false);

    public LdapSyncService(IStoredSettings settings, LdapAuthProvider ldapAuthProvider) {
        this.settings = settings;
        this.ldapAuthProvider = ldapAuthProvider;
    }

    @Override
    public void run() {
        this.logger.info("Starting user and group sync with ldap service");
        if (!this.running.getAndSet(true)) {
            try {
                this.ldapAuthProvider.sync();
            }
            catch (Exception e) {
                this.logger.error("Failed to synchronize with ldap", (Throwable)e);
            }
            finally {
                this.running.getAndSet(false);
            }
        }
        this.logger.info("Finished user and group sync with ldap service");
    }

    public boolean isReady() {
        return this.settings.getBoolean("realm.ldap.synchronize", false);
    }
}

