/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.servlet;

import com.gitblit.manager.IAuthenticationManager;
import com.gitblit.manager.IRepositoryManager;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.servlet.AuthenticationFilter;
import com.gitblit.utils.StringUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AccessRestrictionFilter
extends AuthenticationFilter {
    protected IRuntimeManager runtimeManager;
    protected IRepositoryManager repositoryManager;

    protected AccessRestrictionFilter(IRuntimeManager runtimeManager, IAuthenticationManager authenticationManager, IRepositoryManager repositoryManager) {
        super(authenticationManager);
        this.runtimeManager = runtimeManager;
        this.repositoryManager = repositoryManager;
    }

    protected abstract String extractRepositoryName(String var1);

    protected abstract String getUrlRequestAction(String var1);

    protected abstract boolean isCreationAllowed(String var1);

    protected abstract boolean isActionAllowed(RepositoryModel var1, String var2, String var3);

    protected abstract boolean requiresAuthentication(RepositoryModel var1, String var2, String var3);

    protected abstract boolean canAccess(RepositoryModel var1, UserModel var2, String var3);

    protected RepositoryModel createRepository(UserModel user, String repository, String action) {
        return null;
    }

    protected String getAuthenticationHeader(HttpServletRequest httpRequest, String action) {
        return "WWW-Authenticate";
    }

    protected boolean hasValidRequestHeader(String action, HttpServletRequest request) {
        return true;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String fullUrl = this.getFullUrl(httpRequest);
        String repository = this.extractRepositoryName(fullUrl);
        if (StringUtils.isEmpty(repository)) {
            this.logger.info("ARF: Rejecting request, empty repository name in URL {}", (Object)fullUrl);
            httpResponse.setStatus(400);
            return;
        }
        if (this.repositoryManager.isCollectingGarbage(repository)) {
            this.logger.info(MessageFormat.format("ARF: Rejecting request for {0}, busy collecting garbage!", repository));
            httpResponse.sendError(403);
            return;
        }
        String fullSuffix = fullUrl.substring(repository.length());
        String urlRequestType = this.getUrlRequestAction(fullSuffix);
        if (StringUtils.isEmpty(urlRequestType)) {
            this.logger.info("ARF: Rejecting request for {}, no supported action found in URL {}", (Object)repository, (Object)fullSuffix);
            httpResponse.setStatus(400);
            return;
        }
        if ("/clone.bundle".equalsIgnoreCase(urlRequestType)) {
            this.logger.info(MessageFormat.format("ARF: Rejecting request for {0}, clone bundle is not implemented.", repository));
            httpResponse.sendError(501, "The 'clone.bundle' command is currently not implemented. Please use a normal clone command.");
            return;
        }
        UserModel user = this.getUser(httpRequest);
        RepositoryModel model = this.repositoryManager.getRepositoryModel(repository);
        if (model == null) {
            if (this.isCreationAllowed(urlRequestType)) {
                if (user == null) {
                    if (this.runtimeManager.isDebugMode()) {
                        this.logger.info(MessageFormat.format("ARF: CREATE CHALLENGE {0}", fullUrl));
                    }
                    httpResponse.setHeader(this.getAuthenticationHeader(httpRequest, urlRequestType), "Basic realm=\"Gitblit\"");
                    httpResponse.sendError(401);
                    return;
                }
                model = this.createRepository(user, repository, urlRequestType);
            }
            if (model == null) {
                this.logger.info(MessageFormat.format("ARF: {0} ({1})", fullUrl, 404));
                httpResponse.sendError(404);
                return;
            }
        }
        if (!this.isActionAllowed(model, urlRequestType, httpRequest.getMethod())) {
            this.logger.info(MessageFormat.format("ARF: action {0} on {1} forbidden ({2})", urlRequestType, model, 403));
            httpResponse.sendError(403);
            return;
        }
        AuthenticationFilter.AuthenticatedRequest authenticatedRequest = new AuthenticationFilter.AuthenticatedRequest(httpRequest);
        if (user != null) {
            authenticatedRequest.setUser(user);
        }
        if (!StringUtils.isEmpty(urlRequestType) && this.requiresAuthentication(model, urlRequestType, httpRequest.getMethod())) {
            if (user == null) {
                if (this.runtimeManager.isDebugMode()) {
                    this.logger.info(MessageFormat.format("ARF: CHALLENGE {0}", fullUrl));
                }
                httpResponse.setHeader(this.getAuthenticationHeader(httpRequest, urlRequestType), "Basic realm=\"Gitblit\"");
                httpResponse.sendError(401);
                return;
            }
            if (user.canAdmin() || this.canAccess(model, user, urlRequestType)) {
                this.newSession((HttpServletRequest)authenticatedRequest, httpResponse);
                this.logger.info(MessageFormat.format("ARF: authenticated {0} to {1} ({2})", user.username, fullUrl, 100));
                chain.doFilter((ServletRequest)authenticatedRequest, (ServletResponse)httpResponse);
                return;
            }
            if (this.runtimeManager.isDebugMode()) {
                this.logger.info(MessageFormat.format("ARF: {0} forbidden to access {1}", user.username, fullUrl));
            }
            httpResponse.sendError(403);
            return;
        }
        if (this.runtimeManager.isDebugMode()) {
            this.logger.info(MessageFormat.format("ARF: {0} ({1}) unauthenticated", fullUrl, 100));
        }
        chain.doFilter((ServletRequest)authenticatedRequest, (ServletResponse)httpResponse);
    }

    public static boolean hasContentInRequestHeader(HttpServletRequest request, String headerName, String content) {
        Iterator headerItr = Collections.list(request.getHeaders(headerName)).iterator();
        while (headerItr.hasNext()) {
            if (!((String)headerItr.next()).contains(content)) continue;
            return true;
        }
        return false;
    }
}

