/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.servlet;

import com.gitblit.IStoredSettings;
import com.gitblit.manager.IRepositoryManager;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.AbstractPlotRenderer;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revplot.PlotCommitList;
import org.eclipse.jgit.revplot.PlotLane;
import org.eclipse.jgit.revplot.PlotWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BranchGraphServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final int LANE_WIDTH = 14;
    private static final int ROW_HEIGHT = 24;
    private static final int RIGHT_PAD = 2;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Stroke[] strokeCache;
    private IStoredSettings settings;
    private IRepositoryManager repositoryManager;

    @Inject
    public BranchGraphServlet(IStoredSettings settings, IRepositoryManager repositoryManager) {
        this.settings = settings;
        this.repositoryManager = repositoryManager;
        this.strokeCache = new Stroke[4];
        for (int i = 1; i < this.strokeCache.length; ++i) {
            this.strokeCache[i] = new BasicStroke(i);
        }
    }

    public static String asLink(String baseURL, String repository, String objectId, int numberCommits) {
        if (baseURL.length() > 0 && baseURL.charAt(baseURL.length() - 1) == '/') {
            baseURL = baseURL.substring(0, baseURL.length() - 1);
        }
        return baseURL + "/graph/" + "?r=" + repository + (objectId == null ? "" : "&h=" + objectId) + (numberCommits > 0 ? "&l=" + numberCommits : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getLastModified(HttpServletRequest req) {
        String repository = req.getParameter("r");
        if (StringUtils.isEmpty(repository)) {
            return 0L;
        }
        String objectId = req.getParameter("h");
        try (Repository r = null;){
            ObjectId id;
            r = this.repositoryManager.getRepository(repository);
            if (StringUtils.isEmpty(objectId)) {
                objectId = JGitUtils.getHEADRef(r);
            }
            if ((id = r.resolve(objectId)) == null) {
                long l = 0L;
                return l;
            }
            RevCommit commit = JGitUtils.getCommit(r, objectId);
            long l = JGitUtils.getCommitDate(commit).getTime();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        InputStream is = null;
        Repository r = null;
        PlotWalk rw = null;
        try {
            int l;
            int maxCommits;
            ObjectId id;
            String repository = request.getParameter("r");
            if (StringUtils.isEmpty(repository)) {
                response.setStatus(400);
                response.getWriter().append("Bad request");
                return;
            }
            String objectId = request.getParameter("h");
            String length = request.getParameter("l");
            r = this.repositoryManager.getRepository(repository);
            if (r == null) {
                response.setStatus(400);
                response.getWriter().append("Bad request");
                return;
            }
            rw = new PlotWalk(r);
            if (StringUtils.isEmpty(objectId)) {
                objectId = JGitUtils.getHEADRef(r);
            }
            if ((id = r.resolve(objectId)) == null) {
                response.setStatus(400);
                response.getWriter().append("Bad request");
                return;
            }
            rw.markStart(rw.lookupCommit((AnyObjectId)id));
            int requestedCommits = maxCommits = this.settings.getInteger("web.itemsPerPage", 50);
            if (!StringUtils.isEmpty(length) && (l = Integer.parseInt(length)) > 0) {
                requestedCommits = l;
            }
            CommitList commitList = new CommitList();
            commitList.source((RevWalk)rw);
            commitList.fillTo(2 * Math.max(requestedCommits, maxCommits));
            int numLanes = 1;
            int numCommits = Math.min(requestedCommits, commitList.size());
            if (numCommits > 1) {
                TreeSet<String> parents = new TreeSet<String>();
                for (int i = 0; i < commitList.size(); ++i) {
                    PlotCommit commit = (PlotCommit)commitList.get(i);
                    boolean checkLane = false;
                    if (i < numCommits) {
                        checkLane = true;
                        for (RevCommit p : commit.getParents()) {
                            parents.add(p.getName());
                        }
                    } else if (parents.contains(commit.getName())) {
                        checkLane = true;
                    }
                    if (!checkLane) continue;
                    int pos = ((Lane)commit.getLane()).getPosition();
                    numLanes = Math.max(numLanes, pos + 1);
                }
            }
            int graphWidth = numLanes * 14 + 2;
            int rowHeight = 24;
            BufferedImage image = new BufferedImage(graphWidth, rowHeight * numCommits, 2);
            Graphics2D g = null;
            try {
                g = image.createGraphics();
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                LanesRenderer renderer = new LanesRenderer();
                for (int i = 0; i < commitList.size(); ++i) {
                    PlotCommit commit = (PlotCommit)commitList.get(i);
                    Graphics row = g.create(0, i * rowHeight, graphWidth, rowHeight);
                    try {
                        renderer.paint(row, (PlotCommit<Lane>)commit, rowHeight, graphWidth);
                        continue;
                    }
                    finally {
                        row.dispose();
                        row = null;
                    }
                }
            }
            finally {
                if (g != null) {
                    g.dispose();
                    g = null;
                }
            }
            response.setContentType("image/png");
            if (numCommits > 1) {
                response.setHeader("Cache-Control", "public, max-age=60, must-revalidate");
                response.setDateHeader("Last-Modified", JGitUtils.getCommitDate((RevCommit)commitList.get(0)).getTime());
            }
            ServletOutputStream os = response.getOutputStream();
            ImageIO.write((RenderedImage)image, "png", (OutputStream)os);
            os.flush();
            image.flush();
            image = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                is.close();
                is = null;
            }
            if (rw != null) {
                rw.dispose();
                rw = null;
            }
            if (r != null) {
                r.close();
                r = null;
            }
        }
    }

    private Stroke stroke(int width) {
        if (width < this.strokeCache.length) {
            return this.strokeCache[width];
        }
        return new BasicStroke(width);
    }

    class LanesRenderer
    extends AbstractPlotRenderer<Lane, Color>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Color commitDotFill = new Color(220, 220, 220);
        final Color commitDotOutline = new Color(110, 110, 110);
        transient Graphics2D g;

        LanesRenderer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void paint(Graphics in, PlotCommit<Lane> commit, int h, int w) {
            this.g = (Graphics2D)in.create();
            try {
                if (commit != null) {
                    this.paintCommit(commit, h);
                }
            }
            finally {
                this.g.dispose();
                this.g = null;
            }
        }

        protected void drawLine(Color color, int x1, int y1, int x2, int y2, int width) {
            if (y1 == y2) {
                x1 -= width / 2;
                x2 -= width / 2;
            } else if (x1 == x2) {
                y1 -= width / 2;
                y2 -= width / 2;
            }
            this.g.setColor(color);
            this.g.setStroke(BranchGraphServlet.this.stroke(width));
            this.g.drawLine(x1, y1, x2, y2);
        }

        protected void drawCommitDot(int x, int y, int w, int h) {
            this.g.setColor(this.commitDotFill);
            this.g.setStroke(BranchGraphServlet.this.strokeCache[2]);
            this.g.fillOval(x + 2, y + 1, w - 2, h - 2);
            this.g.setColor(this.commitDotOutline);
            this.g.drawOval(x + 2, y + 1, w - 2, h - 2);
        }

        protected void drawBoundaryDot(int x, int y, int w, int h) {
            this.drawCommitDot(x, y, w, h);
        }

        protected void drawText(String msg, int x, int y) {
        }

        protected Color laneColor(Lane myLane) {
            return myLane != null ? myLane.color : Color.black;
        }

        protected int drawLabel(int x, int y, Ref ref) {
            return 0;
        }
    }

    static class Lane
    extends PlotLane {
        private static final long serialVersionUID = 1L;
        Color color;

        Lane() {
        }

        public boolean equals(Object o) {
            return super.equals(o) && this.color.equals(((Lane)((Object)o)).color);
        }

        public int hashCode() {
            return super.hashCode() ^ this.color.hashCode();
        }
    }

    static class CommitList
    extends PlotCommitList<Lane> {
        final List<Color> laneColors = new ArrayList<Color>();
        final LinkedList<Color> colors;

        CommitList() {
            this.laneColors.add(new Color(133, 166, 214));
            this.laneColors.add(new Color(221, 205, 93));
            this.laneColors.add(new Color(199, 134, 57));
            this.laneColors.add(new Color(131, 150, 98));
            this.laneColors.add(new Color(197, 123, 127));
            this.laneColors.add(new Color(139, 136, 140));
            this.laneColors.add(new Color(48, 135, 144));
            this.laneColors.add(new Color(190, 93, 66));
            this.laneColors.add(new Color(143, 163, 54));
            this.laneColors.add(new Color(180, 148, 74));
            this.laneColors.add(new Color(101, 101, 217));
            this.laneColors.add(new Color(72, 153, 119));
            this.laneColors.add(new Color(23, 101, 160));
            this.laneColors.add(new Color(132, 164, 118));
            this.laneColors.add(new Color(255, 230, 59));
            this.laneColors.add(new Color(136, 176, 70));
            this.laneColors.add(new Color(255, 138, 1));
            this.laneColors.add(new Color(123, 187, 95));
            this.laneColors.add(new Color(233, 88, 98));
            this.laneColors.add(new Color(93, 158, 254));
            this.laneColors.add(new Color(175, 215, 0));
            this.laneColors.add(new Color(140, 134, 142));
            this.laneColors.add(new Color(232, 168, 21));
            this.laneColors.add(new Color(0, 172, 191));
            this.laneColors.add(new Color(251, 58, 4));
            this.laneColors.add(new Color(63, 64, 255));
            this.laneColors.add(new Color(27, 194, 130));
            this.laneColors.add(new Color(0, 104, 183));
            this.colors = new LinkedList();
            this.repackColors();
        }

        private void repackColors() {
            this.colors.addAll(this.laneColors);
        }

        protected Lane createLane() {
            Lane lane = new Lane();
            if (this.colors.isEmpty()) {
                this.repackColors();
            }
            lane.color = this.colors.removeFirst();
            return lane;
        }

        protected void recycleLane(Lane lane) {
            this.colors.add(lane.color);
        }
    }
}

