/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.servlet;

import com.gitblit.Constants;
import com.gitblit.manager.IAuthenticationManager;
import com.gitblit.manager.IRepositoryManager;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.servlet.AccessRestrictionFilter;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class DownloadZipFilter
extends AccessRestrictionFilter {
    @Inject
    public DownloadZipFilter(IRuntimeManager runtimeManager, IAuthenticationManager authenticationManager, IRepositoryManager repositoryManager) {
        super(runtimeManager, authenticationManager, repositoryManager);
    }

    @Override
    protected String extractRepositoryName(String url) {
        int a = url.indexOf("r=");
        if (a > -1) {
            String repository = url.substring(a + 2);
            if (repository.indexOf(38) > -1) {
                repository = repository.substring(0, repository.indexOf(38));
            }
            return repository;
        }
        return null;
    }

    @Override
    protected String getUrlRequestAction(String url) {
        return "DOWNLOAD";
    }

    @Override
    protected boolean isCreationAllowed(String action) {
        return false;
    }

    @Override
    protected boolean isActionAllowed(RepositoryModel repository, String action, String method) {
        return true;
    }

    @Override
    protected boolean requiresAuthentication(RepositoryModel repository, String action, String method) {
        return repository.accessRestriction.atLeast(Constants.AccessRestrictionType.VIEW);
    }

    @Override
    protected boolean canAccess(RepositoryModel repository, UserModel user, String action) {
        return user.canView(repository);
    }
}

