/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.servlet;

import com.gitblit.IStoredSettings;
import com.gitblit.manager.IGitblit;
import com.gitblit.models.FilestoreModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.servlet.AccessRestrictionFilter;
import com.gitblit.utils.JsonUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FilestoreServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final int PROTOCOL_VERSION = 1;
    public static final String GIT_LFS_META_MIME = "application/vnd.git-lfs+json";
    public static final String REGEX_PATH = "^(.*?)/(r)/(.*?)/info/lfs/objects/(batch|[a-fA-F0-9]{64})";
    public static final int REGEX_GROUP_BASE_URI = 1;
    public static final int REGEX_GROUP_PREFIX = 2;
    public static final int REGEX_GROUP_REPOSITORY = 3;
    public static final int REGEX_GROUP_ENDPOINT = 4;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static IGitblit gitblit;

    @Inject
    public FilestoreServlet(IStoredSettings settings, IGitblit gitblit) {
        FilestoreServlet.gitblit = gitblit;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UrlInfo info = FilestoreServlet.getInfoFromRequest(request);
        if (info == null) {
            this.sendError(response, 404);
            return;
        }
        if (info.oid != null) {
            this.sendError(response, 400);
            return;
        }
        IGitLFS.Batch batch = this.deserialize(request, response, IGitLFS.Batch.class);
        if (batch == null) {
            this.sendError(response, 400);
            return;
        }
        UserModel user = this.getUserOrAnonymous(request);
        IGitLFS.BatchResponse batchResponse = new IGitLFS.BatchResponse();
        if (batch.operation.equalsIgnoreCase("upload")) {
            for (IGitLFS.Request item : batch.objects) {
                FilestoreModel.Status state = gitblit.addObject(item.oid, item.size, user, info.repository);
                batchResponse.objects.add(this.getResponseForUpload(info.baseUrl, item.oid, item.size, user.getName(), info.repository.name, state));
            }
        } else if (batch.operation.equalsIgnoreCase("download")) {
            for (IGitLFS.Request item : batch.objects) {
                FilestoreModel.Status state = gitblit.downloadBlob(item.oid, user, info.repository, null);
                batchResponse.objects.add(this.getResponseForDownload(info.baseUrl, item.oid, item.size, user.getName(), info.repository.name, state));
            }
        } else {
            this.sendError(response, 501);
            return;
        }
        response.setStatus(200);
        this.serialize(response, batchResponse);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UrlInfo info = FilestoreServlet.getInfoFromRequest(request);
        if (info == null) {
            this.sendError(response, 404);
            return;
        }
        if (info.oid == null) {
            this.sendError(response, 400);
            return;
        }
        UserModel user = this.getUserOrAnonymous(request);
        long size = -1L;
        FilestoreModel.Status status = gitblit.uploadBlob(info.oid, size, user, info.repository, (InputStream)request.getInputStream());
        IGitLFS.Response responseObject = this.getResponseForUpload(info.baseUrl, info.oid, size, user.getName(), info.repository.name, status);
        this.logger.info(MessageFormat.format("FILESTORE-AUDIT {0}:{4} {1} {2}@{3}", "PUT", info.oid, user.getName(), info.repository.name, status.toString()));
        if (responseObject.error == null) {
            response.setStatus(responseObject.successCode);
        } else {
            this.serialize(response, responseObject.error);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UrlInfo info = FilestoreServlet.getInfoFromRequest(request);
        if (info == null || info.oid == null) {
            this.sendError(response, 404);
            return;
        }
        UserModel user = this.getUserOrAnonymous(request);
        FilestoreModel model = gitblit.getObject(info.oid, user, info.repository);
        long size = -1L;
        boolean isMetaRequest = AccessRestrictionFilter.hasContentInRequestHeader(request, "Accept", GIT_LFS_META_MIME);
        FilestoreModel.Status status = FilestoreModel.Status.Unavailable;
        if (model != null) {
            size = model.getSize();
            status = model.getStatus();
        }
        if (!isMetaRequest) {
            status = gitblit.downloadBlob(info.oid, user, info.repository, (OutputStream)response.getOutputStream());
            this.logger.info(MessageFormat.format("FILESTORE-AUDIT {0}:{4} {1} {2}@{3}", "GET", info.oid, user.getName(), info.repository.name, status.toString()));
        }
        if (status == FilestoreModel.Status.Error_Unexpected_Stream_End) {
            return;
        }
        IGitLFS.Response responseObject = this.getResponseForDownload(info.baseUrl, info.oid, size, user.getName(), info.repository.name, status);
        if (responseObject.error == null) {
            response.setStatus(responseObject.successCode);
            if (isMetaRequest) {
                this.serialize(response, responseObject);
            }
        } else {
            response.setStatus(responseObject.error.code);
            if (isMetaRequest) {
                this.serialize(response, responseObject.error);
            }
        }
    }

    private void sendError(HttpServletResponse response, int code) throws IOException {
        String msg = "";
        switch (code) {
            case 404: {
                msg = "Not Found";
                break;
            }
            case 501: {
                msg = "Not Implemented";
                break;
            }
            case 400: {
                msg = "Malformed Git-LFS request";
                break;
            }
            default: {
                msg = "Unknown Error";
            }
        }
        response.setStatus(code);
        this.serialize(response, new IGitLFS.ObjectError(code, msg));
    }

    private IGitLFS.Response getResponseForUpload(String baseUrl, String oid, long size, String user, String repo, FilestoreModel.Status state) {
        switch (state) {
            case AuthenticationRequired: {
                return new IGitLFS.Response(oid, size, 401, MessageFormat.format("Authentication required to write to repository {0}", repo));
            }
            case Error_Unauthorized: {
                return new IGitLFS.Response(oid, size, 403, MessageFormat.format("User {0}, does not have write permissions to repository {1}", user, repo));
            }
            case Error_Exceeds_Size_Limit: {
                return new IGitLFS.Response(oid, size, 509, MessageFormat.format("Object is larger than allowed limit of {1}", gitblit.getMaxUploadSize()));
            }
            case Error_Hash_Mismatch: {
                return new IGitLFS.Response(oid, size, 422, "Hash mismatch");
            }
            case Error_Invalid_Oid: {
                return new IGitLFS.Response(oid, size, 422, MessageFormat.format("{0} is not a valid oid", oid));
            }
            case Error_Invalid_Size: {
                return new IGitLFS.Response(oid, size, 422, MessageFormat.format("{0} is not a valid size", size));
            }
            case Error_Size_Mismatch: {
                return new IGitLFS.Response(oid, size, 422, "Object size mismatch");
            }
            case Deleted: {
                return new IGitLFS.Response(oid, size, 410, "Object was deleted : ".concat("TBD Reason"));
            }
            case Upload_In_Progress: {
                return new IGitLFS.Response(oid, size, 503, "File currently being uploaded by another user");
            }
            case Unavailable: {
                return new IGitLFS.Response(oid, size, 404, MessageFormat.format("Repository {0}, does not exist for user {1}", repo, user));
            }
            case Upload_Pending: {
                return new IGitLFS.Response(oid, size, 202, "upload", this.getObjectUri(baseUrl, repo, oid));
            }
            case Available: {
                return new IGitLFS.Response(oid, size, 200, "upload", this.getObjectUri(baseUrl, repo, oid));
            }
        }
        return new IGitLFS.Response(oid, size, 500, "Unknown Error");
    }

    private IGitLFS.Response getResponseForDownload(String baseUrl, String oid, long size, String user, String repo, FilestoreModel.Status state) {
        switch (state) {
            case Error_Unauthorized: {
                return new IGitLFS.Response(oid, size, 403, MessageFormat.format("User {0}, does not have read permissions to repository {1}", user, repo));
            }
            case Error_Invalid_Oid: {
                return new IGitLFS.Response(oid, size, 422, MessageFormat.format("{0} is not a valid oid", oid));
            }
            case Error_Unknown: {
                return new IGitLFS.Response(oid, size, 500, "Unknown Error");
            }
            case Deleted: {
                return new IGitLFS.Response(oid, size, 410, "Object was deleted : ".concat("TBD Reason"));
            }
            case Available: {
                return new IGitLFS.Response(oid, size, 200, "download", this.getObjectUri(baseUrl, repo, oid));
            }
        }
        return new IGitLFS.Response(oid, size, 404, "Object not available");
    }

    private String getObjectUri(String baseUrl, String repo, String oid) {
        return baseUrl + "/" + repo + "/" + "info/lfs/" + "objects/" + oid;
    }

    protected void serialize(HttpServletResponse response, Object o) throws IOException {
        if (o != null) {
            String json = JsonUtils.toJsonString(o);
            response.setCharacterEncoding("UTF-8");
            response.setContentType(GIT_LFS_META_MIME);
            response.getWriter().append(json);
        }
    }

    protected <X> X deserialize(HttpServletRequest request, HttpServletResponse response, Class<X> clazz) {
        String json = "";
        try {
            json = this.readJson(request, response);
            return JsonUtils.fromJsonString(json.toString(), clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String readJson(HttpServletRequest request, HttpServletResponse response) throws IOException {
        BufferedReader reader = request.getReader();
        StringBuilder json = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            json.append(line);
        }
        reader.close();
        if (json.length() == 0) {
            this.logger.error(MessageFormat.format("Failed to receive json data from {0}", request.getRemoteAddr()));
            response.setStatus(400);
            return null;
        }
        return json.toString();
    }

    private UserModel getUserOrAnonymous(HttpServletRequest r) {
        UserModel user = (UserModel)r.getUserPrincipal();
        if (user != null) {
            return user;
        }
        return UserModel.ANONYMOUS;
    }

    public static UrlInfo getInfoFromRequest(HttpServletRequest httpRequest) {
        String url = httpRequest.getRequestURL().toString();
        Pattern p = Pattern.compile(REGEX_PATH);
        Matcher m = p.matcher(url);
        if (m.find()) {
            RepositoryModel repo = gitblit.getRepositoryModel(m.group(3));
            String baseUrl = m.group(1) + "/" + m.group(2);
            if (m.group(4).equals("batch")) {
                return new UrlInfo(repo, null, baseUrl);
            }
            return new UrlInfo(repo, m.group(4), baseUrl);
        }
        return null;
    }

    public static interface IGitLFS {

        public static class HyperMediaLink
        implements Serializable {
            public String href;
            public transient String header;

            public HyperMediaLink(String action, String uri) {
                this.header = action;
                this.href = uri;
            }
        }

        public static class ObjectError
        implements Serializable {
            public String message;
            public int code;
            public String documentation_url;
            public Integer request_id;

            public ObjectError(int errorCode, String errorText) {
                this.code = errorCode;
                this.message = errorText;
                this.request_id = null;
            }
        }

        public static class BatchResponse
        implements Serializable {
            public List<Response> objects = new ArrayList<Response>();
        }

        public static class Response
        implements Serializable {
            public String oid;
            public long size;
            public Map<String, HyperMediaLink> actions;
            public ObjectError error;
            public transient int successCode;

            public Response(String id, long itemSize, int errorCode, String errorText) {
                this.oid = id;
                this.size = itemSize;
                this.actions = null;
                this.successCode = 0;
                this.error = new ObjectError(errorCode, errorText);
            }

            public Response(String id, long itemSize, int actionCode, String action, String uri) {
                this.oid = id;
                this.size = itemSize;
                this.error = null;
                this.successCode = actionCode;
                this.actions = new HashMap<String, HyperMediaLink>();
                this.actions.put(action, new HyperMediaLink(action, uri));
            }
        }

        public static class Batch
        implements Serializable {
            public String operation;
            public List<Request> objects;
        }

        public static class Request
        implements Serializable {
            public String oid;
            public long size;
        }
    }

    private static class UrlInfo {
        public RepositoryModel repository;
        public String oid;
        public String baseUrl;

        public UrlInfo(RepositoryModel repo, String oid, String baseUrl) {
            this.repository = repo;
            this.oid = oid;
            this.baseUrl = baseUrl;
        }
    }
}

