/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.servlet;

import com.gitblit.extensions.HttpRequestFilter;
import com.gitblit.manager.IPluginManager;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.servlet.FilterRuntimeConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import ro.fortsoft.pf4j.PluginWrapper;

@Singleton
public class ProxyFilter
implements Filter {
    private final IRuntimeManager runtimeManager;
    private final IPluginManager pluginManager;
    private final List<HttpRequestFilter> filters;

    @Inject
    public ProxyFilter(IRuntimeManager runtimeManager, IPluginManager pluginManager) {
        this.runtimeManager = runtimeManager;
        this.pluginManager = pluginManager;
        this.filters = new ArrayList<HttpRequestFilter>();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filters.addAll(this.pluginManager.getExtensions(HttpRequestFilter.class));
        for (HttpRequestFilter f : this.filters) {
            PluginWrapper pluginWrapper = this.pluginManager.whichPlugin(f.getClass());
            FilterRuntimeConfig runtimeConfig = new FilterRuntimeConfig(this.runtimeManager, pluginWrapper.getPluginId(), filterConfig);
            f.init(runtimeConfig);
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, final FilterChain last) throws IOException, ServletException {
        final Iterator<HttpRequestFilter> itr = this.filters.iterator();
        new FilterChain(){

            public void doFilter(ServletRequest req, ServletResponse res) throws IOException, ServletException {
                if (itr.hasNext()) {
                    ((HttpRequestFilter)itr.next()).doFilter(req, res, this);
                } else {
                    last.doFilter(req, res);
                }
            }
        }.doFilter(req, res);
    }

    public void destroy() {
        for (HttpRequestFilter f : this.filters) {
            f.destroy();
        }
    }
}

