/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.servlet;

import com.gitblit.manager.IRuntimeManager;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.eclipse.jgit.lib.FileMode;

@Singleton
public class PtServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final long lastModified = System.currentTimeMillis();
    private IRuntimeManager runtimeManager;

    @Inject
    public PtServlet(IRuntimeManager runtimeManager) {
        this.runtimeManager = runtimeManager;
    }

    protected long getLastModified(HttpServletRequest req) {
        File file = this.runtimeManager.getFileOrFolder("tickets.pt", "${baseFolder}/pt.py");
        if (file.exists()) {
            return Math.max(lastModified, file.lastModified());
        }
        return lastModified;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            response.setContentType("application/octet-stream");
            response.setDateHeader("Last-Modified", lastModified);
            response.setHeader("Cache-Control", "none");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
            boolean windows2 = false;
            try {
                String useragent = request.getHeader("user-agent").toString();
                windows2 = useragent.toLowerCase().contains("windows");
            }
            catch (Exception useragent) {
                // empty catch block
            }
            File file = this.runtimeManager.getFileOrFolder("tickets.pt", "${baseFolder}/pt.py");
            byte[] pyBytes = file.exists() ? this.readAll(new FileInputStream(file)) : this.readAll(((Object)((Object)this)).getClass().getResourceAsStream("/pt.py"));
            if (windows2) {
                response.setHeader("Content-Disposition", "attachment; filename=\"pt.zip\"");
                ServletOutputStream os = response.getOutputStream();
                ZipArchiveOutputStream zos = new ZipArchiveOutputStream((OutputStream)os);
                ZipArchiveEntry pyEntry = new ZipArchiveEntry("pt.py");
                pyEntry.setSize((long)pyBytes.length);
                pyEntry.setUnixMode(FileMode.EXECUTABLE_FILE.getBits());
                pyEntry.setTime(lastModified);
                zos.putArchiveEntry(pyEntry);
                zos.write(pyBytes);
                zos.closeArchiveEntry();
                byte[] cmdBytes = this.readAll(((Object)((Object)this)).getClass().getResourceAsStream("/pt.cmd"));
                ZipArchiveEntry cmdEntry = new ZipArchiveEntry("pt.cmd");
                cmdEntry.setSize((long)cmdBytes.length);
                cmdEntry.setUnixMode(FileMode.REGULAR_FILE.getBits());
                cmdEntry.setTime(lastModified);
                zos.putArchiveEntry(cmdEntry);
                zos.write(cmdBytes);
                zos.closeArchiveEntry();
                byte[] txtBytes = this.readAll(((Object)((Object)this)).getClass().getResourceAsStream("/pt.txt"));
                ZipArchiveEntry txtEntry = new ZipArchiveEntry("readme.txt");
                txtEntry.setSize((long)txtBytes.length);
                txtEntry.setUnixMode(FileMode.REGULAR_FILE.getBits());
                txtEntry.setTime(lastModified);
                zos.putArchiveEntry(txtEntry);
                zos.write(txtBytes);
                zos.closeArchiveEntry();
                zos.finish();
                zos.close();
                os.flush();
            } else {
                response.setHeader("Content-Disposition", "attachment; filename=\"pt.tar.gz\"");
                ServletOutputStream os = response.getOutputStream();
                CompressorOutputStream cos = new CompressorStreamFactory().createCompressorOutputStream("gz", (OutputStream)os);
                TarArchiveOutputStream tos = new TarArchiveOutputStream((OutputStream)cos);
                tos.setAddPaxHeadersForNonAsciiNames(true);
                tos.setLongFileMode(3);
                TarArchiveEntry pyEntry = new TarArchiveEntry("pt");
                pyEntry.setMode(FileMode.EXECUTABLE_FILE.getBits());
                pyEntry.setModTime(lastModified);
                pyEntry.setSize((long)pyBytes.length);
                tos.putArchiveEntry(pyEntry);
                tos.write(pyBytes);
                tos.closeArchiveEntry();
                byte[] txtBytes = this.readAll(((Object)((Object)this)).getClass().getResourceAsStream("/pt.txt"));
                TarArchiveEntry txtEntry = new TarArchiveEntry("README");
                txtEntry.setMode(FileMode.REGULAR_FILE.getBits());
                txtEntry.setModTime(lastModified);
                txtEntry.setSize((long)txtBytes.length);
                tos.putArchiveEntry(txtEntry);
                tos.write(txtBytes);
                tos.closeArchiveEntry();
                tos.finish();
                tos.close();
                cos.close();
                os.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] readAll(InputStream is) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[4096];
            int len = 0;
            while ((len = is.read(buffer)) > -1) {
                os.write(buffer, 0, len);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                os.close();
                is.close();
            }
            catch (Exception exception) {}
        }
        return new byte[0];
    }
}

