/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.servlet;

import com.gitblit.manager.IRepositoryManager;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.models.PathModel;
import com.gitblit.servlet.GitblitContext;
import com.gitblit.utils.ByteFormat;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.MarkdownUtils;
import com.gitblit.utils.StringUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tika.Tika;
import org.apache.wicket.protocol.http.WicketURLEncoder;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RawServlet
extends HttpServlet {
    static final char FSC = '!';
    private static final long serialVersionUID = 1L;
    private transient Logger logger = LoggerFactory.getLogger(RawServlet.class);
    private final IRuntimeManager runtimeManager;
    private final IRepositoryManager repositoryManager;

    @Inject
    public RawServlet(IRuntimeManager runtimeManager, IRepositoryManager repositoryManager) {
        this.runtimeManager = runtimeManager;
        this.repositoryManager = repositoryManager;
    }

    public static String asLink(String baseURL, String repository, String branch, String path) {
        char fsc;
        if (baseURL.length() > 0 && baseURL.charAt(baseURL.length() - 1) == '/') {
            baseURL = baseURL.substring(0, baseURL.length() - 1);
        }
        if (repository.length() > 0 && repository.charAt(repository.length() - 1) == '/') {
            repository = repository.substring(0, repository.length() - 1);
        }
        if (repository.length() > 0 && repository.charAt(0) == '/') {
            repository = repository.substring(1);
        }
        if ((fsc = GitblitContext.getManager(IRuntimeManager.class).getSettings().getChar("web.forwardSlashCharacter", '/')) == '/') {
            fsc = '!';
        }
        if (branch != null) {
            branch = Repository.shortenRefName((String)branch).replace('/', fsc);
        }
        if (path != null && path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        String encodedPath = path == null ? "" : path.replace('/', fsc);
        String fullPath = repository + "/" + (branch == null ? "" : branch + "/" + encodedPath);
        return baseURL + "/raw/" + WicketURLEncoder.FULL_PATH_INSTANCE.encode(fullPath);
    }

    String getBranch(String repository, String pathInfo) {
        if (pathInfo == null || pathInfo.isEmpty() || pathInfo.equals("/")) {
            return "";
        }
        String branch = pathInfo.substring(pathInfo.indexOf(repository) + repository.length() + 1);
        int fs = branch.indexOf(47);
        if (fs > -1) {
            branch = branch.substring(0, fs);
        }
        char c = this.runtimeManager.getSettings().getChar("web.forwardSlashCharacter", '/');
        return branch.replace('!', '/').replace(c, '/');
    }

    String getPath(String repository, String branch, String pathInfo) {
        if (pathInfo == null || pathInfo.isEmpty() || pathInfo.equals("/")) {
            return "";
        }
        char c = this.runtimeManager.getSettings().getChar("web.forwardSlashCharacter", '/');
        char fsc = c == '/' ? (char)'!' : (char)c;
        String base = repository + "/" + Repository.shortenRefName((String)branch).replace('/', fsc);
        if (pathInfo.equals(base)) {
            return "";
        }
        int pathStart = pathInfo.indexOf(base) + base.length();
        if (pathStart < pathInfo.length() && pathInfo.charAt(pathStart) == '/') {
            ++pathStart;
        }
        if (pathInfo.length() == pathStart) {
            return "";
        }
        String path = pathInfo.substring(pathStart);
        if ((path = path.replace('!', '/').replace(c, '/')).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    protected boolean renderIndex() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getPathInfo();
        if (path.toLowerCase().endsWith(".git")) {
            response.sendRedirect(request.getServletPath() + path + "/");
            return;
        }
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        String repository = path;
        Repository r = null;
        int terminator = repository.length();
        do {
            repository = repository.substring(0, terminator);
            r = this.repositoryManager.getRepository(repository, false);
            terminator = repository.lastIndexOf(47);
        } while (r == null && terminator > -1);
        ServletContext context = request.getSession().getServletContext();
        try {
            String basePath;
            if (r == null) {
                String mkd = MessageFormat.format("# Error\nSorry, no valid **repository** specified in this url: {0}!", path);
                this.error(response, mkd);
                return;
            }
            String branch = this.getBranch(repository, path);
            if (StringUtils.isEmpty(branch)) {
                branch = r.getBranch();
                if (branch == null) {
                    String mkd = MessageFormat.format("# Error\nSorry, no valid **branch** specified in this url: {0}!", path);
                    this.error(response, mkd);
                    return;
                }
                String base = request.getRequestURI();
                String url = base + branch + "/";
                response.sendRedirect(url);
                return;
            }
            String requestedPath = this.getPath(repository, branch, path);
            RevCommit commit = JGitUtils.getCommit(r, branch);
            if (commit == null) {
                String mkd = MessageFormat.format("# Error\nSorry, the repository {0} does not have a **{1}** branch!", repository, branch);
                this.error(response, mkd);
                return;
            }
            HashMap<String, String> quickContentTypes = new HashMap<String, String>();
            quickContentTypes.put("html", "text/html");
            quickContentTypes.put("htm", "text/html");
            quickContentTypes.put("xml", "application/xml");
            quickContentTypes.put("json", "application/json");
            List<PathModel> pathEntries = JGitUtils.getFilesInPath(r, requestedPath, commit);
            if (pathEntries.isEmpty()) {
                block37: {
                    String content;
                    String contentType;
                    block38: {
                        String file = StringUtils.getLastPathElement(requestedPath);
                        try {
                            String ext = StringUtils.getFileExtension(file).toLowerCase();
                            boolean isExtensionlessDotfile = file.charAt(0) == '.' && (file.length() == 1 || file.indexOf(46, 1) < 0);
                            String string = contentType = isExtensionlessDotfile ? "text/plain" : (String)quickContentTypes.get(ext);
                            if (contentType == null) {
                                List<String> exts = this.runtimeManager.getSettings().getStrings("web.prettyPrintExtensions");
                                if (exts.contains(ext)) {
                                    contentType = "text/plain";
                                } else {
                                    Tika tika = new Tika();
                                    contentType = tika.detect(file);
                                }
                            }
                            if (contentType == null && (contentType = context.getMimeType(requestedPath)) == null) {
                                contentType = "application/octet-stream";
                            }
                            if (!this.isTextType(contentType) && !this.isTextDataType(contentType)) break block37;
                            String[] encodings = this.runtimeManager.getSettings().getStrings("web.blobEncodings").toArray(new String[0]);
                            content = JGitUtils.getStringContent(r, commit.getTree(), requestedPath, encodings);
                            if (content != null) break block38;
                            this.logger.error("RawServlet Failed to load {} {} {}", new Object[]{repository, commit.getName(), path});
                            this.notFound(response, requestedPath, branch);
                            return;
                        }
                        catch (Exception e) {
                            this.logger.error(null, (Throwable)e);
                        }
                    }
                    byte[] bytes = content.getBytes("UTF-8");
                    this.setContentType(response, contentType);
                    response.setContentLength(bytes.length);
                    ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                    this.sendContent(response, JGitUtils.getCommitDate(commit), is);
                    return;
                }
                if (this.streamFromRepo(request, response, r, commit, requestedPath)) return;
                this.logger.error("RawServlet Failed to load {} {} {}", new Object[]{repository, commit.getName(), path});
                this.notFound(response, requestedPath, branch);
                return;
            } else {
                if (!request.getPathInfo().endsWith("/")) {
                    response.sendRedirect(request.getServletPath() + request.getPathInfo() + "/");
                    return;
                }
                if (this.renderIndex()) {
                    TreeMap<String, String> names = new TreeMap<String, String>();
                    for (PathModel entry : pathEntries) {
                        names.put(entry.name.toLowerCase(), entry.name);
                    }
                    ArrayList<String> extensions = new ArrayList<String>();
                    extensions.add("html");
                    extensions.add("htm");
                    String content = null;
                    for (String ext : extensions) {
                        String fileName;
                        String key = "index." + ext;
                        if (!names.containsKey(key)) continue;
                        String fullPath = fileName = (String)names.get(key);
                        if (!requestedPath.isEmpty()) {
                            fullPath = requestedPath + "/" + fileName;
                        }
                        String[] encodings = this.runtimeManager.getSettings().getStrings("web.blobEncodings").toArray(new String[0]);
                        String stringContent = JGitUtils.getStringContent(r, commit.getTree(), fullPath, encodings);
                        if (stringContent == null) continue;
                        content = stringContent;
                        requestedPath = fullPath;
                        break;
                    }
                    response.setContentType("text/html; charset=UTF-8");
                    byte[] bytes = content.getBytes("UTF-8");
                    response.setContentLength(bytes.length);
                    ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                    this.sendContent(response, JGitUtils.getCommitDate(commit), is);
                    return;
                }
            }
            if (pathEntries.isEmpty()) {
                this.notFound(response, requestedPath, branch);
                return;
            }
            response.setContentType("text/html");
            response.getWriter().append("<style>table th, table td { min-width: 150px; text-align: left; }</style>");
            response.getWriter().append("<table>");
            response.getWriter().append("<thead><tr><th>path</th><th>mode</th><th>size</th></tr>");
            response.getWriter().append("</thead>");
            response.getWriter().append("<tbody>");
            String pattern = "<tr><td><a href=\"{0}/{1}\">{1}</a></td><td>{2}</td><td>{3}</td></tr>";
            ByteFormat byteFormat = new ByteFormat();
            if (!pathEntries.isEmpty() && pathEntries.get((int)0).path.indexOf(47) > -1) {
                String pp = URLEncoder.encode(requestedPath, "UTF-8");
                pathEntries.add(0, new PathModel("..", pp + "/..", null, 0L, FileMode.TREE.getBits(), null, null));
            }
            if ((basePath = request.getServletPath() + request.getPathInfo()).charAt(basePath.length() - 1) == '/') {
                basePath = basePath.substring(0, basePath.length() - 1);
            }
            for (PathModel entry : pathEntries) {
                String pp = URLEncoder.encode(entry.name, "UTF-8");
                response.getWriter().append(MessageFormat.format(pattern, basePath, pp, JGitUtils.getPermissionsFromMode(entry.mode), entry.isFile() ? byteFormat.format(entry.size) : ""));
            }
            response.getWriter().append("</tbody>");
            response.getWriter().append("</table>");
            return;
        }
        catch (Throwable t) {
            this.logger.error("Failed to write page to client", t);
            return;
        }
        finally {
            r.close();
        }
    }

    protected boolean isTextType(String contentType) {
        return contentType.startsWith("text/") || "application/json".equals(contentType) || "application/xml".equals(contentType);
    }

    protected boolean isTextDataType(String contentType) {
        return "image/svg+xml".equals(contentType);
    }

    protected void setContentType(HttpServletResponse response, String contentType) {
        if (this.isTextType(contentType)) {
            response.setContentType("text/plain");
        } else {
            response.setContentType(contentType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean streamFromRepo(HttpServletRequest request, HttpServletResponse response, Repository repository, RevCommit commit, String requestedPath) throws IOException {
        boolean served = false;
        RevWalk rw = new RevWalk(repository);
        TreeWalk tw = new TreeWalk(repository);
        try {
            tw.reset();
            tw.addTree((AnyObjectId)commit.getTree());
            PathFilter f = PathFilter.create((String)requestedPath);
            tw.setFilter((TreeFilter)f);
            tw.setRecursive(true);
            MutableObjectId id = new MutableObjectId();
            ObjectReader reader = tw.getObjectReader();
            while (tw.next()) {
                FileMode mode = tw.getFileMode(0);
                if (mode == FileMode.GITLINK || mode == FileMode.TREE) continue;
                tw.getObjectId(id, 0);
                String filename = StringUtils.getLastPathElement(requestedPath);
                try {
                    String userAgent = request.getHeader("User-Agent");
                    if (userAgent != null && userAgent.indexOf("MSIE 5.5") > -1) {
                        response.setHeader("Content-Disposition", "filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\"");
                    } else if (userAgent != null && userAgent.indexOf("MSIE") > -1) {
                        response.setHeader("Content-Disposition", "attachment; filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\"");
                    } else {
                        response.setHeader("Content-Disposition", "attachment; filename=\"" + new String(filename.getBytes("UTF-8"), "latin1") + "\"");
                    }
                }
                catch (UnsupportedEncodingException e) {
                    response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
                }
                long len = reader.getObjectSize((AnyObjectId)id, 3);
                this.setContentType(response, "application/octet-stream");
                response.setIntHeader("Content-Length", (int)len);
                ObjectLoader ldr = repository.open((AnyObjectId)id);
                ldr.copyTo((OutputStream)response.getOutputStream());
                served = true;
            }
        }
        finally {
            tw.close();
            rw.dispose();
        }
        response.flushBuffer();
        return served;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendContent(HttpServletResponse response, Date date, InputStream is) throws ServletException, IOException {
        try {
            byte[] tmp = new byte[8192];
            int len = 0;
            while ((len = is.read(tmp)) > -1) {
                response.getOutputStream().write(tmp, 0, len);
            }
        }
        finally {
            is.close();
        }
        response.flushBuffer();
    }

    protected void notFound(HttpServletResponse response, String requestedPath, String branch) throws ParseException, ServletException, IOException {
        String str = MessageFormat.format("# Error\nSorry, the requested resource **{0}** was not found in **{1}**.", requestedPath, branch);
        response.setStatus(404);
        this.error(response, str);
    }

    private void error(HttpServletResponse response, String mkd) throws ServletException, IOException, ParseException {
        String content = MarkdownUtils.transformMarkdown(mkd);
        response.setContentType("text/html; charset=UTF-8");
        response.getWriter().write(content);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }
}

