/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.servlet;

import com.gitblit.Constants;
import com.gitblit.GitBlitException;
import com.gitblit.IStoredSettings;
import com.gitblit.manager.IGitblit;
import com.gitblit.models.RefModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.ServerSettings;
import com.gitblit.models.TeamModel;
import com.gitblit.models.UserModel;
import com.gitblit.servlet.JsonServlet;
import com.gitblit.utils.DeepCopier;
import com.gitblit.utils.HttpUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.RpcUtils;
import com.gitblit.utils.StringUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lib.Repository;

@Singleton
public class RpcServlet
extends JsonServlet {
    private static final long serialVersionUID = 1L;
    public static final int PROTOCOL_VERSION = 8;
    private IStoredSettings settings;
    private IGitblit gitblit;

    @Inject
    public RpcServlet(IStoredSettings settings, IGitblit gitblit) {
        this.settings = settings;
        this.gitblit = gitblit;
    }

    @Override
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object result;
        block130: {
            Constants.RpcRequest reqType = Constants.RpcRequest.fromName(request.getParameter("req"));
            String objectName = request.getParameter("name");
            this.logger.info(MessageFormat.format("Rpc {0} request from {1}", new Object[]{reqType, request.getRemoteAddr()}));
            UserModel user = (UserModel)request.getUserPrincipal();
            boolean allowManagement = user != null && user.canAdmin() && this.settings.getBoolean("web.enableRpcManagement", false);
            boolean allowAdmin = user != null && user.canAdmin() && this.settings.getBoolean("web.enableRpcAdministration", false);
            result = null;
            if (Constants.RpcRequest.GET_PROTOCOL.equals((Object)reqType)) {
                result = 8;
            } else if (Constants.RpcRequest.LIST_REPOSITORIES.equals((Object)reqType)) {
                String gitblitUrl = this.settings.getString("web.canonicalUrl", null);
                if (StringUtils.isEmpty(gitblitUrl)) {
                    gitblitUrl = HttpUtils.getGitblitURL(request);
                }
                StringBuilder sb = new StringBuilder();
                sb.append(gitblitUrl);
                sb.append("/r/");
                sb.append("{0}");
                String cloneUrl = sb.toString();
                List<RepositoryModel> list = this.gitblit.getRepositoryModels(user);
                HashMap<String, RepositoryModel> repositories = new HashMap<String, RepositoryModel>();
                for (RepositoryModel model : list) {
                    String url = MessageFormat.format(cloneUrl, model.name);
                    repositories.put(url, model);
                }
                result = repositories;
            } else if (Constants.RpcRequest.LIST_BRANCHES.equals((Object)reqType)) {
                HashMap localBranches = new HashMap();
                List<RepositoryModel> models = this.gitblit.getRepositoryModels(user);
                for (RepositoryModel model : models) {
                    if (!model.hasCommits) continue;
                    if (model.isCollectingGarbage) {
                        this.logger.warn(MessageFormat.format("Temporarily excluding {0} from RPC, busy collecting garbage", model.name));
                        continue;
                    }
                    if (!StringUtils.isEmpty(objectName) && !objectName.equals(model.name)) continue;
                    Repository repository = this.gitblit.getRepository(model.name);
                    List<RefModel> refs = JGitUtils.getLocalBranches(repository, false, -1);
                    if (model.showRemoteBranches) {
                        refs.addAll(JGitUtils.getRemoteBranches(repository, false, -1));
                    }
                    if (refs.size() > 0) {
                        ArrayList<String> branches = new ArrayList<String>();
                        for (RefModel ref : refs) {
                            branches.add(ref.getName());
                        }
                        localBranches.put(model.name, branches);
                    }
                    repository.close();
                }
                result = localBranches;
            } else if (Constants.RpcRequest.GET_USER.equals((Object)reqType)) {
                if (StringUtils.isEmpty(objectName)) {
                    if (UserModel.ANONYMOUS.equals(user)) {
                        response.sendError(403);
                    } else {
                        UserModel requestedUser = DeepCopier.copy(user);
                        result = requestedUser;
                    }
                } else if (user.canAdmin() || objectName.equals(user.username)) {
                    UserModel requestedUser = this.gitblit.getUserModel(objectName);
                    if (requestedUser == null) {
                        response.setStatus(500);
                    } else {
                        result = requestedUser;
                    }
                } else {
                    response.sendError(403);
                }
            } else if (Constants.RpcRequest.LIST_USERS.equals((Object)reqType)) {
                List<String> names = this.gitblit.getAllUsernames();
                ArrayList<UserModel> users = new ArrayList<UserModel>();
                for (String name : names) {
                    users.add(this.gitblit.getUserModel(name));
                }
                result = users;
            } else if (Constants.RpcRequest.LIST_TEAMS.equals((Object)reqType)) {
                List<String> names = this.gitblit.getAllTeamNames();
                ArrayList<TeamModel> teams = new ArrayList<TeamModel>();
                for (String name : names) {
                    teams.add(this.gitblit.getTeamModel(name));
                }
                result = teams;
            } else if (Constants.RpcRequest.CREATE_REPOSITORY.equals((Object)reqType)) {
                RepositoryModel model = this.deserialize(request, response, RepositoryModel.class);
                try {
                    this.gitblit.updateRepositoryModel(model.name, model, true);
                }
                catch (GitBlitException e) {
                    response.setStatus(500);
                }
            } else if (Constants.RpcRequest.FORK_REPOSITORY.equals((Object)reqType)) {
                RepositoryModel origin = this.gitblit.getRepositoryModel(objectName);
                if (origin == null) {
                    response.setStatus(500);
                } else if (user == null || !user.canFork(origin)) {
                    this.logger.error("User {} is not permitted to fork '{}'!", (Object)(user == null ? "anonymous" : user.username), (Object)objectName);
                    response.setStatus(500);
                } else {
                    try {
                        RepositoryModel fork = this.gitblit.fork(origin, user);
                        if (fork == null) {
                            this.logger.error("Failed to fork repository '{}'!", (Object)objectName);
                            response.setStatus(500);
                            break block130;
                        }
                        this.logger.info("User {} has forked '{}'!", (Object)user.username, (Object)objectName);
                    }
                    catch (GitBlitException e) {
                        response.setStatus(500);
                    }
                }
            } else if (Constants.RpcRequest.EDIT_REPOSITORY.equals((Object)reqType)) {
                RepositoryModel model = this.deserialize(request, response, RepositoryModel.class);
                String repoName = objectName;
                if (repoName == null) {
                    repoName = model.name;
                }
                try {
                    this.gitblit.updateRepositoryModel(repoName, model, false);
                }
                catch (GitBlitException e) {
                    response.setStatus(500);
                }
            } else if (Constants.RpcRequest.DELETE_REPOSITORY.equals((Object)reqType)) {
                RepositoryModel model = this.deserialize(request, response, RepositoryModel.class);
                this.gitblit.deleteRepositoryModel(model);
            } else if (Constants.RpcRequest.CREATE_USER.equals((Object)reqType)) {
                UserModel model = this.deserialize(request, response, UserModel.class);
                try {
                    this.gitblit.addUser(model);
                }
                catch (GitBlitException e) {
                    response.setStatus(500);
                }
            } else if (Constants.RpcRequest.EDIT_USER.equals((Object)reqType)) {
                UserModel model = this.deserialize(request, response, UserModel.class);
                String username = objectName;
                if (username == null) {
                    username = model.username;
                }
                try {
                    this.gitblit.reviseUser(username, model);
                }
                catch (GitBlitException e) {
                    response.setStatus(500);
                }
            } else if (Constants.RpcRequest.DELETE_USER.equals((Object)reqType)) {
                UserModel model = this.deserialize(request, response, UserModel.class);
                if (!this.gitblit.deleteUser(model.username)) {
                    response.setStatus(500);
                }
            } else if (Constants.RpcRequest.CREATE_TEAM.equals((Object)reqType)) {
                TeamModel model = this.deserialize(request, response, TeamModel.class);
                try {
                    this.gitblit.addTeam(model);
                }
                catch (GitBlitException e) {
                    response.setStatus(500);
                }
            } else if (Constants.RpcRequest.EDIT_TEAM.equals((Object)reqType)) {
                TeamModel model = this.deserialize(request, response, TeamModel.class);
                String teamname = objectName;
                if (teamname == null) {
                    teamname = model.name;
                }
                try {
                    this.gitblit.reviseTeam(teamname, model);
                }
                catch (GitBlitException e) {
                    response.setStatus(500);
                }
            } else if (Constants.RpcRequest.DELETE_TEAM.equals((Object)reqType)) {
                TeamModel model = this.deserialize(request, response, TeamModel.class);
                if (!this.gitblit.deleteTeam(model.name)) {
                    response.setStatus(500);
                }
            } else if (Constants.RpcRequest.LIST_REPOSITORY_MEMBERS.equals((Object)reqType)) {
                RepositoryModel model = this.gitblit.getRepositoryModel(objectName);
                result = this.gitblit.getRepositoryUsers(model);
            } else if (Constants.RpcRequest.SET_REPOSITORY_MEMBERS.equals((Object)reqType)) {
                response.setStatus(500);
            } else if (Constants.RpcRequest.LIST_REPOSITORY_MEMBER_PERMISSIONS.equals((Object)reqType)) {
                RepositoryModel model = this.gitblit.getRepositoryModel(objectName);
                result = this.gitblit.getUserAccessPermissions(model);
            } else if (Constants.RpcRequest.SET_REPOSITORY_MEMBER_PERMISSIONS.equals((Object)reqType)) {
                RepositoryModel model = this.gitblit.getRepositoryModel(objectName);
                Collection permissions = (Collection)this.deserialize(request, response, RpcUtils.REGISTRANT_PERMISSIONS_TYPE);
                result = this.gitblit.setUserAccessPermissions(model, permissions);
            } else if (Constants.RpcRequest.LIST_REPOSITORY_TEAMS.equals((Object)reqType)) {
                RepositoryModel model = this.gitblit.getRepositoryModel(objectName);
                result = this.gitblit.getRepositoryTeams(model);
            } else if (Constants.RpcRequest.SET_REPOSITORY_TEAMS.equals((Object)reqType)) {
                response.setStatus(500);
            } else if (Constants.RpcRequest.LIST_REPOSITORY_TEAM_PERMISSIONS.equals((Object)reqType)) {
                RepositoryModel model = this.gitblit.getRepositoryModel(objectName);
                result = this.gitblit.getTeamAccessPermissions(model);
            } else if (Constants.RpcRequest.SET_REPOSITORY_TEAM_PERMISSIONS.equals((Object)reqType)) {
                RepositoryModel model = this.gitblit.getRepositoryModel(objectName);
                Collection permissions = (Collection)this.deserialize(request, response, RpcUtils.REGISTRANT_PERMISSIONS_TYPE);
                result = this.gitblit.setTeamAccessPermissions(model, permissions);
            } else if (Constants.RpcRequest.LIST_FEDERATION_REGISTRATIONS.equals((Object)reqType)) {
                if (allowAdmin) {
                    result = this.gitblit.getFederationRegistrations();
                } else {
                    response.sendError(405);
                }
            } else if (Constants.RpcRequest.LIST_FEDERATION_RESULTS.equals((Object)reqType)) {
                if (allowAdmin && this.gitblit.canFederate()) {
                    result = this.gitblit.getFederationResultRegistrations();
                } else {
                    response.sendError(405);
                }
            } else if (Constants.RpcRequest.LIST_FEDERATION_PROPOSALS.equals((Object)reqType)) {
                if (allowAdmin && this.gitblit.canFederate()) {
                    result = this.gitblit.getPendingFederationProposals();
                } else {
                    response.sendError(405);
                }
            } else if (Constants.RpcRequest.LIST_FEDERATION_SETS.equals((Object)reqType)) {
                if (allowAdmin && this.gitblit.canFederate()) {
                    String gitblitUrl = this.settings.getString("web.canonicalUrl", null);
                    if (StringUtils.isEmpty(gitblitUrl)) {
                        gitblitUrl = HttpUtils.getGitblitURL(request);
                    }
                    result = this.gitblit.getFederationSets(gitblitUrl);
                } else {
                    response.sendError(405);
                }
            } else if (Constants.RpcRequest.LIST_SETTINGS.equals((Object)reqType)) {
                ServerSettings serverSettings = this.gitblit.getSettingsModel();
                if (allowAdmin) {
                    result = serverSettings;
                } else {
                    ArrayList<String> keys = new ArrayList<String>();
                    keys.add("web.siteName");
                    keys.add("web.mountParameters");
                    keys.add("web.syndicationEntries");
                    if (allowManagement) {
                        keys.add("realm.minPasswordLength");
                        keys.add("realm.passwordStorage");
                        keys.add("federation.sets");
                    }
                    ServerSettings managementSettings = new ServerSettings();
                    for (String key : keys) {
                        managementSettings.add(serverSettings.get(key));
                    }
                    if (allowManagement) {
                        managementSettings.pushScripts = serverSettings.pushScripts;
                    }
                    result = managementSettings;
                }
            } else if (Constants.RpcRequest.EDIT_SETTINGS.equals((Object)reqType)) {
                if (allowAdmin) {
                    Map map = (Map)this.deserialize(request, response, RpcUtils.SETTINGS_TYPE);
                    this.gitblit.updateSettings(map);
                } else {
                    response.sendError(405);
                }
            } else if (Constants.RpcRequest.LIST_STATUS.equals((Object)reqType)) {
                if (allowAdmin) {
                    result = this.gitblit.getStatus();
                } else {
                    response.sendError(405);
                }
            } else if (Constants.RpcRequest.CLEAR_REPOSITORY_CACHE.equals((Object)reqType)) {
                if (allowManagement) {
                    this.gitblit.resetRepositoryListCache();
                } else {
                    response.sendError(405);
                }
            } else if (Constants.RpcRequest.REINDEX_TICKETS.equals((Object)reqType)) {
                if (allowManagement) {
                    if (StringUtils.isEmpty(objectName)) {
                        this.gitblit.getTicketService().reindex();
                    } else {
                        RepositoryModel model = this.gitblit.getRepositoryModel(objectName);
                        this.gitblit.getTicketService().reindex(model);
                    }
                } else {
                    response.sendError(405);
                }
            }
        }
        this.serialize(response, result);
    }
}

