/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.servlet;

import com.gitblit.Constants;
import com.gitblit.IStoredSettings;
import com.gitblit.manager.IProjectManager;
import com.gitblit.manager.IRepositoryManager;
import com.gitblit.models.FeedEntryModel;
import com.gitblit.models.ProjectModel;
import com.gitblit.models.RefModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.servlet.AuthenticationFilter;
import com.gitblit.utils.BugtraqProcessor;
import com.gitblit.utils.HttpUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.SyndicationUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SyndicationServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private transient Logger logger = LoggerFactory.getLogger(SyndicationServlet.class);
    private IStoredSettings settings;
    private IRepositoryManager repositoryManager;
    private IProjectManager projectManager;

    @Inject
    public SyndicationServlet(IStoredSettings settings, IRepositoryManager repositoryManager, IProjectManager projectManager) {
        this.settings = settings;
        this.repositoryManager = repositoryManager;
        this.projectManager = projectManager;
    }

    public static String asLink(String baseURL, String repository, String objectId, int length) {
        if (baseURL.length() > 0 && baseURL.charAt(baseURL.length() - 1) == '/') {
            baseURL = baseURL.substring(0, baseURL.length() - 1);
        }
        StringBuilder url = new StringBuilder();
        url.append(baseURL);
        url.append("/feed/");
        url.append(repository);
        if (!StringUtils.isEmpty(objectId) || length > 0) {
            StringBuilder parameters = new StringBuilder("?");
            if (StringUtils.isEmpty(objectId)) {
                parameters.append("l=");
                parameters.append(length);
            } else {
                parameters.append("h=");
                parameters.append(objectId);
                if (length > 0) {
                    parameters.append("&l=");
                    parameters.append(length);
                }
            }
            url.append((CharSequence)parameters);
        }
        return url.toString();
    }

    public static String getTitle(String repository, String objectId) {
        String id = objectId;
        if (!StringUtils.isEmpty(id)) {
            if (id.startsWith("refs/heads/")) {
                id = id.substring("refs/heads/".length());
            } else if (id.startsWith("refs/remotes/")) {
                id = id.substring("refs/remotes/".length());
            } else if (id.startsWith("refs/tags/")) {
                id = id.substring("refs/tags/".length());
            }
        }
        return MessageFormat.format("{0} ({1})", repository, id);
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Constants.FeedObjectType type;
        Constants.SearchType type2;
        String servletUrl = request.getContextPath() + request.getServletPath();
        String url = request.getRequestURI().substring(servletUrl.length());
        if (url.length() > 1 && url.charAt(0) == '/') {
            url = url.substring(1);
        }
        String repositoryName = url;
        String objectId = request.getParameter("h");
        String l = request.getParameter("l");
        String page = request.getParameter("pg");
        String searchString = request.getParameter("s");
        Constants.SearchType searchType = Constants.SearchType.COMMIT;
        if (!StringUtils.isEmpty(request.getParameter("st")) && (type2 = Constants.SearchType.forName(request.getParameter("st"))) != null) {
            searchType = type2;
        }
        Constants.FeedObjectType objectType = Constants.FeedObjectType.COMMIT;
        if (!StringUtils.isEmpty(request.getParameter("ot")) && (type = Constants.FeedObjectType.forName(request.getParameter("ot"))) != null) {
            objectType = type;
        }
        int length = this.settings.getInteger("web.syndicationEntries", 25);
        if (StringUtils.isEmpty(objectId)) {
            objectId = "HEAD";
        }
        if (!StringUtils.isEmpty(l)) {
            try {
                length = Integer.parseInt(l);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int offset = 0;
        if (!StringUtils.isEmpty(page)) {
            try {
                offset = length * Integer.parseInt(page);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        response.setContentType("application/rss+xml; charset=UTF-8");
        boolean isProjectFeed = false;
        String feedName = "Gitblit";
        String feedTitle = null;
        String feedDescription = null;
        List<String> repositories = null;
        if (repositoryName.indexOf(47) == -1 && !repositoryName.toLowerCase().endsWith(".git")) {
            ProjectModel project;
            UserModel user = null;
            if (request instanceof AuthenticationFilter.AuthenticatedRequest) {
                user = ((AuthenticationFilter.AuthenticatedRequest)request).getUser();
            }
            if ((project = this.projectManager.getProjectModel(repositoryName, user)) != null) {
                isProjectFeed = true;
                repositories = new ArrayList<String>(project.repositories);
                feedName = project.name;
                feedTitle = project.title;
                feedDescription = project.description;
            }
        }
        if (repositories == null) {
            repositories = Arrays.asList(repositoryName);
        }
        boolean mountParameters = this.settings.getBoolean("web.mountParameters", true);
        String gitblitUrl = this.settings.getString("web.canonicalUrl", null);
        if (StringUtils.isEmpty(gitblitUrl)) {
            gitblitUrl = HttpUtils.getGitblitURL(request);
        }
        char fsc = this.settings.getChar("web.forwardSlashCharacter", '/');
        ArrayList<FeedEntryModel> entries = new ArrayList();
        for (String name : repositories) {
            String urlPattern;
            Repository repository = this.repositoryManager.getRepository(name);
            RepositoryModel model = this.repositoryManager.getRepositoryModel(name);
            if (repository == null) {
                if (model == null || !model.isCollectingGarbage) continue;
                this.logger.warn(MessageFormat.format("Temporarily excluding {0} from feed, busy collecting garbage", name));
                continue;
            }
            if (!isProjectFeed) {
                feedName = model.name;
                feedTitle = model.name;
                feedDescription = model.description;
            }
            if (objectType == Constants.FeedObjectType.TAG) {
                urlPattern = mountParameters ? "{0}/tag/{1}/{2}" : "{0}/tag/?r={1}&h={2}";
                List<RefModel> tags = JGitUtils.getTags(repository, false, length, offset);
                for (RefModel tag : tags) {
                    FeedEntryModel entry = new FeedEntryModel();
                    entry.title = tag.getName();
                    entry.author = tag.getAuthorIdent().getName();
                    entry.link = MessageFormat.format(urlPattern, gitblitUrl, StringUtils.encodeURL(model.name.replace('/', fsc)), tag.getObjectId().getName());
                    entry.published = tag.getDate();
                    entry.contentType = "text/html";
                    entry.content = tag.getFullMessage();
                    entry.repository = model.name;
                    entry.branch = objectId;
                    entry.tags = new ArrayList<String>();
                    entry.tags.add("tag:" + tag.getObjectId().getName());
                    entry.tags.add("commit:" + tag.getReferencedObjectId().getName());
                    entries.add(entry);
                }
                continue;
            }
            urlPattern = mountParameters ? "{0}/commit/{1}/{2}" : "{0}/commit/?r={1}&h={2}";
            List<RevCommit> commits = StringUtils.isEmpty(searchString) ? JGitUtils.getRevLog(repository, objectId, offset, length) : JGitUtils.searchRevlogs(repository, objectId, searchString, searchType, offset, length);
            Map<ObjectId, List<RefModel>> allRefs = JGitUtils.getAllRefs(repository, model.showRemoteBranches);
            BugtraqProcessor processor = new BugtraqProcessor(this.settings);
            for (RevCommit commit : commits) {
                String message;
                FeedEntryModel entry = new FeedEntryModel();
                entry.title = commit.getShortMessage();
                entry.author = commit.getAuthorIdent().getName();
                entry.link = MessageFormat.format(urlPattern, gitblitUrl, StringUtils.encodeURL(model.name.replace('/', fsc)), commit.getName());
                entry.published = commit.getCommitterIdent().getWhen();
                entry.contentType = "text/html";
                entry.content = message = processor.processCommitMessage(repository, model, commit.getFullMessage());
                entry.repository = model.name;
                entry.branch = objectId;
                entry.tags = new ArrayList<String>();
                entry.tags.add("commit:" + commit.getName());
                for (RevCommit parent : commit.getParents()) {
                    entry.tags.add("parent:" + parent.getName());
                }
                List<RefModel> refs = allRefs.get(commit.getId());
                if (refs != null && refs.size() > 0) {
                    for (RefModel ref : refs) {
                        entry.tags.add("ref:" + ref.getName());
                    }
                }
                entries.add(entry);
            }
        }
        Collections.sort(entries);
        if (entries.size() > length) {
            entries = entries.subList(0, length);
        }
        String feedLink = isProjectFeed ? (mountParameters ? MessageFormat.format("{0}/project/{1}", gitblitUrl, StringUtils.encodeURL(feedName)) : MessageFormat.format("{0}/project/?p={1}", gitblitUrl, StringUtils.encodeURL(feedName))) : (mountParameters ? MessageFormat.format("{0}/summary/{1}", gitblitUrl, StringUtils.encodeURL(feedName.replace('/', fsc))) : MessageFormat.format("{0}/summary/?r={1}", gitblitUrl, StringUtils.encodeURL(feedName)));
        try {
            SyndicationUtils.toRSS(gitblitUrl, feedLink, SyndicationServlet.getTitle(feedTitle, objectId), feedDescription, entries, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            this.logger.error("An error occurred during feed generation", (Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }
}

