/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.tickets;

import com.gitblit.manager.INotificationManager;
import com.gitblit.manager.IPluginManager;
import com.gitblit.manager.IRepositoryManager;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.manager.IUserManager;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.TicketModel;
import com.gitblit.tickets.ITicketService;
import com.gitblit.tickets.TicketSerializer;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.FileUtils;
import com.gitblit.utils.StringUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jgit.lib.Repository;

@Singleton
public class FileTicketService
extends ITicketService {
    private static final String JOURNAL = "journal.json";
    private static final String TICKETS_PATH = "tickets/";
    private final Map<String, AtomicLong> lastAssignedId = new ConcurrentHashMap<String, AtomicLong>();

    @Inject
    public FileTicketService(IRuntimeManager runtimeManager, IPluginManager pluginManager, INotificationManager notificationManager, IUserManager userManager, IRepositoryManager repositoryManager) {
        super(runtimeManager, pluginManager, notificationManager, userManager, repositoryManager);
    }

    @Override
    public void onStart() {
        this.log.info("{} started", (Object)this.getClass().getSimpleName());
    }

    @Override
    protected void resetCachesImpl() {
        this.lastAssignedId.clear();
    }

    @Override
    protected void resetCachesImpl(RepositoryModel repository) {
        if (this.lastAssignedId.containsKey(repository.name)) {
            this.lastAssignedId.get(repository.name).set(0L);
        }
    }

    @Override
    protected void close() {
    }

    private String toTicketPath(long ticketId) {
        StringBuilder sb = new StringBuilder();
        sb.append(TICKETS_PATH);
        long m = ticketId % 100L;
        if (m < 10L) {
            sb.append('0');
        }
        sb.append(m);
        sb.append('/');
        sb.append(ticketId);
        return sb.toString();
    }

    private String toAttachmentPath(long ticketId, String filename) {
        return this.toTicketPath(ticketId) + "/attachments/" + filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasTicket(RepositoryModel repository, long ticketId) {
        boolean hasTicket = false;
        try (Repository db = this.repositoryManager.getRepository(repository.name);){
            String journalPath = this.toTicketPath(ticketId) + "/" + JOURNAL;
            hasTicket = new File(db.getDirectory(), journalPath).exists();
        }
        return hasTicket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Set<Long> getIds(RepositoryModel repository) {
        TreeSet<Long> ids = new TreeSet<Long>();
        try (Repository db = this.repositoryManager.getRepository(repository.name);){
            File dir = new File(db.getDirectory(), TICKETS_PATH);
            dir.mkdirs();
            List<File> journals = this.findAll(dir, JOURNAL);
            for (File journal : journals) {
                String path = FileUtils.getRelativePath(dir, journal);
                String tid = path.split("/")[1];
                long ticketId = Long.parseLong(tid);
                ids.add(ticketId);
            }
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long assignNewId(RepositoryModel repository) {
        long newId = 0L;
        try (Repository db = this.repositoryManager.getRepository(repository.name);){
            AtomicLong lastId;
            if (!this.lastAssignedId.containsKey(repository.name)) {
                this.lastAssignedId.put(repository.name, new AtomicLong(0L));
            }
            if ((lastId = this.lastAssignedId.get(repository.name)).get() <= 0L) {
                Set<Long> ids = this.getIds(repository);
                for (long id : ids) {
                    if (id <= lastId.get()) continue;
                    lastId.set(id);
                }
            }
            newId = lastId.incrementAndGet();
            String journalPath = this.toTicketPath(newId) + "/" + JOURNAL;
            File journal = new File(db.getDirectory(), journalPath);
            journal.getParentFile().mkdirs();
            journal.createNewFile();
        }
        return newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TicketModel> getTickets(RepositoryModel repository, ITicketService.TicketFilter filter) {
        ArrayList<TicketModel> list = new ArrayList<TicketModel>();
        try (Repository db = this.repositoryManager.getRepository(repository.name);){
            File dir = new File(db.getDirectory(), TICKETS_PATH);
            List<File> journals = this.findAll(dir, JOURNAL);
            for (File journal : journals) {
                String json = null;
                try {
                    json = new String(FileUtils.readContent(journal), "UTF-8");
                }
                catch (Exception e) {
                    this.log.error(null, (Throwable)e);
                }
                if (StringUtils.isEmpty(json)) continue;
                try {
                    String path = FileUtils.getRelativePath(dir, journal);
                    String tid = path.split("/")[1];
                    long ticketId = Long.parseLong(tid);
                    List<TicketModel.Change> changes = TicketSerializer.deserializeJournal(json);
                    if (ArrayUtils.isEmpty(changes)) {
                        this.log.warn("Empty journal for {}:{}", (Object)repository, (Object)journal);
                        continue;
                    }
                    TicketModel ticket = TicketModel.buildTicket(changes);
                    ticket.project = repository.projectPath;
                    ticket.repository = repository.name;
                    ticket.number = ticketId;
                    if (filter == null) {
                        list.add(ticket);
                        continue;
                    }
                    if (!filter.accept(ticket)) continue;
                    list.add(ticket);
                }
                catch (Exception e) {
                    this.log.error("failed to deserialize {}/{}\n{}", new Object[]{repository, journal, e.getMessage()});
                    this.log.error(null, (Throwable)e);
                }
            }
            Collections.sort(list);
            ArrayList<TicketModel> arrayList = list;
            return arrayList;
        }
    }

    private List<File> findAll(File dir, String filename) {
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files == null) {
            return list;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                list.addAll(this.findAll(file, filename));
                continue;
            }
            if (!file.isFile() || !file.getName().equalsIgnoreCase(filename)) continue;
            list.add(file);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TicketModel getTicketImpl(RepositoryModel repository, long ticketId) {
        try (Repository db = this.repositoryManager.getRepository(repository.name);){
            List<TicketModel.Change> changes = this.getJournal(db, ticketId);
            if (ArrayUtils.isEmpty(changes)) {
                this.log.warn("Empty journal for {}:{}", (Object)repository, (Object)ticketId);
                TicketModel ticketModel = null;
                return ticketModel;
            }
            TicketModel ticket = TicketModel.buildTicket(changes);
            if (ticket != null) {
                ticket.project = repository.projectPath;
                ticket.repository = repository.name;
                ticket.number = ticketId;
            }
            TicketModel ticketModel = ticket;
            return ticketModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<TicketModel.Change> getJournalImpl(RepositoryModel repository, long ticketId) {
        try (Repository db = this.repositoryManager.getRepository(repository.name);){
            List<TicketModel.Change> changes = this.getJournal(db, ticketId);
            if (ArrayUtils.isEmpty(changes)) {
                this.log.warn("Empty journal for {}:{}", (Object)repository, (Object)ticketId);
                List<TicketModel.Change> list = null;
                return list;
            }
            List<TicketModel.Change> list = changes;
            return list;
        }
    }

    private List<TicketModel.Change> getJournal(Repository db, long ticketId) {
        if (ticketId <= 0L) {
            return new ArrayList<TicketModel.Change>();
        }
        String journalPath = this.toTicketPath(ticketId) + "/" + JOURNAL;
        File journal = new File(db.getDirectory(), journalPath);
        if (!journal.exists()) {
            return new ArrayList<TicketModel.Change>();
        }
        String json = null;
        try {
            json = new String(FileUtils.readContent(journal), "UTF-8");
        }
        catch (Exception e) {
            this.log.error(null, (Throwable)e);
        }
        if (StringUtils.isEmpty(json)) {
            return new ArrayList<TicketModel.Change>();
        }
        List<TicketModel.Change> list = TicketSerializer.deserializeJournal(json);
        return list;
    }

    @Override
    public boolean supportsAttachments() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TicketModel.Attachment getAttachment(RepositoryModel repository, long ticketId, String filename) {
        if (ticketId <= 0L) {
            return null;
        }
        TicketModel ticket = this.getTicket(repository, ticketId);
        TicketModel.Attachment attachment = ticket.getAttachment(filename);
        if (attachment == null) {
            return null;
        }
        try (Repository db = this.repositoryManager.getRepository(repository.name);){
            String attachmentPath = this.toAttachmentPath(ticketId, attachment.name);
            File file = new File(db.getDirectory(), attachmentPath);
            if (file.exists()) {
                attachment.content = FileUtils.readContent(file);
                attachment.size = attachment.content.length;
            }
            TicketModel.Attachment attachment2 = attachment;
            return attachment2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized boolean deleteTicketImpl(RepositoryModel repository, TicketModel ticket, String deletedBy) {
        if (ticket == null) {
            throw new RuntimeException("must specify a ticket!");
        }
        boolean success = false;
        try (Repository db = this.repositoryManager.getRepository(ticket.repository);){
            String ticketPath = this.toTicketPath(ticket.number);
            File dir = new File(db.getDirectory(), ticketPath);
            if (dir.exists()) {
                success = FileUtils.delete(dir);
            }
            success = true;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized boolean commitChangeImpl(RepositoryModel repository, long ticketId, TicketModel.Change change) {
        boolean success = false;
        try (Repository db = this.repositoryManager.getRepository(repository.name);){
            List<TicketModel.Change> changes = this.getJournal(db, ticketId);
            changes.add(change);
            String journal = TicketSerializer.serializeJournal(changes).trim();
            String journalPath = this.toTicketPath(ticketId) + "/" + JOURNAL;
            File file = new File(db.getDirectory(), journalPath);
            file.getParentFile().mkdirs();
            FileUtils.writeContent(file, journal);
            success = true;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean deleteAllImpl(RepositoryModel repository) {
        Repository db = this.repositoryManager.getRepository(repository.name);
        if (db == null) {
            return true;
        }
        try {
            File dir = new File(db.getDirectory(), TICKETS_PATH);
            boolean bl = FileUtils.delete(dir);
            return bl;
        }
        catch (Exception e) {
            this.log.error(null, (Throwable)e);
        }
        finally {
            db.close();
        }
        return false;
    }

    @Override
    protected boolean renameImpl(RepositoryModel oldRepository, RepositoryModel newRepository) {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

