/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.tickets;

import com.gitblit.IStoredSettings;
import com.gitblit.extensions.TicketHook;
import com.gitblit.manager.IManager;
import com.gitblit.manager.INotificationManager;
import com.gitblit.manager.IPluginManager;
import com.gitblit.manager.IRepositoryManager;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.manager.IUserManager;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.TicketModel;
import com.gitblit.tickets.QueryBuilder;
import com.gitblit.tickets.QueryResult;
import com.gitblit.tickets.TicketIndexer;
import com.gitblit.tickets.TicketLabel;
import com.gitblit.tickets.TicketMilestone;
import com.gitblit.tickets.TicketNotifier;
import com.gitblit.utils.DeepCopier;
import com.gitblit.utils.DiffUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ITicketService
implements IManager {
    public static final String SETTING_UPDATE_DIFFSTATS = "migration.updateDiffstats";
    private static final String LABEL = "label";
    private static final String MILESTONE = "milestone";
    private static final String STATUS = "status";
    private static final String COLOR = "color";
    private static final String DUE = "due";
    private static final String DUE_DATE_PATTERN = "yyyy-MM-dd";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final IStoredSettings settings;
    protected final IRuntimeManager runtimeManager;
    protected final INotificationManager notificationManager;
    protected final IUserManager userManager;
    protected final IRepositoryManager repositoryManager;
    protected final IPluginManager pluginManager;
    protected final TicketIndexer indexer;
    private final Cache<TicketKey, TicketModel> ticketsCache;
    private final Map<String, List<TicketLabel>> labelsCache;
    private final Map<String, List<TicketMilestone>> milestonesCache;
    private final boolean updateDiffstats;

    public ITicketService(IRuntimeManager runtimeManager, IPluginManager pluginManager, INotificationManager notificationManager, IUserManager userManager, IRepositoryManager repositoryManager) {
        this.settings = runtimeManager.getSettings();
        this.runtimeManager = runtimeManager;
        this.pluginManager = pluginManager;
        this.notificationManager = notificationManager;
        this.userManager = userManager;
        this.repositoryManager = repositoryManager;
        this.indexer = new TicketIndexer(runtimeManager);
        CacheBuilder cb = CacheBuilder.newBuilder();
        this.ticketsCache = cb.maximumSize(1000L).expireAfterAccess(30L, TimeUnit.MINUTES).build();
        this.labelsCache = new ConcurrentHashMap<String, List<TicketLabel>>();
        this.milestonesCache = new ConcurrentHashMap<String, List<TicketMilestone>>();
        this.updateDiffstats = this.settings.getBoolean(SETTING_UPDATE_DIFFSTATS, true);
    }

    @Override
    public final ITicketService start() {
        this.onStart();
        if (this.shouldReindex()) {
            this.log.info("Re-indexing all tickets...");
            this.reindex();
        }
        return this;
    }

    public abstract void onStart();

    @Override
    public final ITicketService stop() {
        this.indexer.close();
        this.ticketsCache.invalidateAll();
        this.repositoryManager.closeAll();
        this.close();
        return this;
    }

    protected abstract void close();

    public TicketNotifier createNotifier() {
        return new TicketNotifier(this.runtimeManager, this.notificationManager, this.userManager, this.repositoryManager, this);
    }

    public boolean isReady() {
        return true;
    }

    public boolean isAcceptingNewPatchsets(RepositoryModel repository) {
        return this.isReady() && this.settings.getBoolean("tickets.acceptNewPatchsets", true) && repository.acceptNewPatchsets && this.isAcceptingTicketUpdates(repository);
    }

    public boolean isAcceptingNewTickets(RepositoryModel repository) {
        return this.isReady() && this.settings.getBoolean("tickets.acceptNewTickets", true) && repository.acceptNewTickets && this.isAcceptingTicketUpdates(repository);
    }

    public boolean isAcceptingTicketUpdates(RepositoryModel repository) {
        return this.isReady() && repository.hasCommits && repository.isBare && !repository.isFrozen && !repository.isMirror;
    }

    public boolean hasTickets(RepositoryModel repository) {
        return this.indexer.hasTickets(repository);
    }

    public final synchronized void resetCaches() {
        this.ticketsCache.invalidateAll();
        this.labelsCache.clear();
        this.milestonesCache.clear();
        this.resetCachesImpl();
    }

    protected abstract void resetCachesImpl();

    public final synchronized void resetCaches(RepositoryModel repository) {
        ArrayList<TicketKey> repoKeys = new ArrayList<TicketKey>();
        for (TicketKey key : this.ticketsCache.asMap().keySet()) {
            if (!key.repository.equals(repository.name)) continue;
            repoKeys.add(key);
        }
        this.ticketsCache.invalidateAll(repoKeys);
        this.labelsCache.remove(repository.name);
        this.milestonesCache.remove(repository.name);
        this.resetCachesImpl(repository);
    }

    protected abstract void resetCachesImpl(RepositoryModel var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TicketLabel> getLabels(RepositoryModel repository) {
        String key = repository.name;
        if (this.labelsCache.containsKey(key)) {
            return this.labelsCache.get(key);
        }
        ArrayList<TicketLabel> list = new ArrayList<TicketLabel>();
        try (Repository db = this.repositoryManager.getRepository(repository.name);){
            StoredConfig config = db.getConfig();
            Set names = config.getSubsections(LABEL);
            for (String name : names) {
                TicketLabel label = new TicketLabel(name);
                label.color = config.getString(LABEL, name, COLOR);
                list.add(label);
            }
            this.labelsCache.put(key, Collections.unmodifiableList(list));
        }
        return list;
    }

    public TicketLabel getLabel(RepositoryModel repository, String label) {
        for (TicketLabel tl : this.getLabels(repository)) {
            if (!tl.name.equalsIgnoreCase(label)) continue;
            String q = QueryBuilder.q(TicketIndexer.Lucene.rid.matches(repository.getRID())).and(TicketIndexer.Lucene.labels.matches(label)).build();
            tl.tickets = this.indexer.queryFor(q, 1, 0, TicketIndexer.Lucene.number.name(), true);
            return tl;
        }
        return new TicketLabel(label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TicketLabel createLabel(RepositoryModel repository, String label, String createdBy) {
        TicketMilestone lb = new TicketMilestone(label);
        try (Repository db = null;){
            db = this.repositoryManager.getRepository(repository.name);
            StoredConfig config = db.getConfig();
            config.setString(LABEL, label, COLOR, lb.color);
            config.save();
        }
        return lb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean updateLabel(RepositoryModel repository, TicketLabel label, String createdBy) {
        try (Repository db = null;){
            db = this.repositoryManager.getRepository(repository.name);
            StoredConfig config = db.getConfig();
            config.setString(LABEL, label.name, COLOR, label.color);
            config.save();
            boolean bl = true;
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean renameLabel(RepositoryModel repository, String oldName, String newName, String createdBy) {
        if (StringUtils.isEmpty(newName)) {
            throw new IllegalArgumentException("new label can not be empty!");
        }
        try (Repository db = null;){
            db = this.repositoryManager.getRepository(repository.name);
            TicketLabel label = this.getLabel(repository, oldName);
            StoredConfig config = db.getConfig();
            config.unsetSection(LABEL, oldName);
            config.setString(LABEL, newName, COLOR, label.color);
            config.save();
            for (QueryResult qr : label.tickets) {
                TicketModel.Change change = new TicketModel.Change(createdBy);
                change.unlabel(oldName);
                change.label(newName);
                this.updateTicket(repository, qr.number, change);
            }
            boolean bl = true;
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean deleteLabel(RepositoryModel repository, String label, String createdBy) {
        if (StringUtils.isEmpty(label)) {
            throw new IllegalArgumentException("label can not be empty!");
        }
        try (Repository db = null;){
            db = this.repositoryManager.getRepository(repository.name);
            StoredConfig config = db.getConfig();
            config.unsetSection(LABEL, label);
            config.save();
            boolean bl = true;
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TicketMilestone> getMilestones(RepositoryModel repository) {
        String key = repository.name;
        if (this.milestonesCache.containsKey(key)) {
            return this.milestonesCache.get(key);
        }
        ArrayList<TicketMilestone> list = new ArrayList<TicketMilestone>();
        try (Repository db = this.repositoryManager.getRepository(repository.name);){
            StoredConfig config = db.getConfig();
            Set names = config.getSubsections(MILESTONE);
            for (String name : names) {
                TicketMilestone milestone = new TicketMilestone(name);
                milestone.status = TicketModel.Status.fromObject(config.getString(MILESTONE, name, STATUS), milestone.status);
                milestone.color = config.getString(MILESTONE, name, COLOR);
                String due = config.getString(MILESTONE, name, DUE);
                if (!StringUtils.isEmpty(due)) {
                    try {
                        milestone.due = new SimpleDateFormat(DUE_DATE_PATTERN).parse(due);
                    }
                    catch (ParseException e) {
                        this.log.error("failed to parse {} milestone {} due date \"{}\"", new Object[]{repository, name, due, e});
                    }
                }
                list.add(milestone);
            }
            this.milestonesCache.put(key, Collections.unmodifiableList(list));
        }
        return list;
    }

    public List<TicketMilestone> getMilestones(RepositoryModel repository, TicketModel.Status status) {
        ArrayList<TicketMilestone> matches = new ArrayList<TicketMilestone>();
        for (TicketMilestone milestone : this.getMilestones(repository)) {
            if (status != milestone.status) continue;
            matches.add(milestone);
        }
        return matches;
    }

    public TicketMilestone getMilestone(RepositoryModel repository, String milestone) {
        for (TicketMilestone ms : this.getMilestones(repository)) {
            if (!ms.name.equalsIgnoreCase(milestone)) continue;
            TicketMilestone tm = DeepCopier.copy(ms);
            String q = QueryBuilder.q(TicketIndexer.Lucene.rid.matches(repository.getRID())).and(TicketIndexer.Lucene.milestone.matches(milestone)).build();
            tm.tickets = this.indexer.queryFor(q, 1, 0, TicketIndexer.Lucene.number.name(), true);
            return tm;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TicketMilestone createMilestone(RepositoryModel repository, String milestone, String createdBy) {
        TicketMilestone ms = new TicketMilestone(milestone);
        try (Repository db = null;){
            db = this.repositoryManager.getRepository(repository.name);
            StoredConfig config = db.getConfig();
            config.setString(MILESTONE, milestone, STATUS, ms.status.name());
            config.setString(MILESTONE, milestone, COLOR, ms.color);
            config.save();
            this.milestonesCache.remove(repository.name);
        }
        return ms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean updateMilestone(RepositoryModel repository, TicketMilestone milestone, String createdBy) {
        try (Repository db = null;){
            db = this.repositoryManager.getRepository(repository.name);
            StoredConfig config = db.getConfig();
            config.setString(MILESTONE, milestone.name, STATUS, milestone.status.name());
            config.setString(MILESTONE, milestone.name, COLOR, milestone.color);
            if (milestone.due != null) {
                config.setString(MILESTONE, milestone.name, DUE, new SimpleDateFormat(DUE_DATE_PATTERN).format(milestone.due));
            }
            config.save();
            this.milestonesCache.remove(repository.name);
            boolean bl = true;
            return bl;
        }
        return false;
    }

    public synchronized boolean renameMilestone(RepositoryModel repository, String oldName, String newName, String createdBy) {
        return this.renameMilestone(repository, oldName, newName, createdBy, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean renameMilestone(RepositoryModel repository, String oldName, String newName, String createdBy, boolean notifyOpenTickets) {
        if (StringUtils.isEmpty(newName)) {
            throw new IllegalArgumentException("new milestone can not be empty!");
        }
        try (Repository db = null;){
            db = this.repositoryManager.getRepository(repository.name);
            TicketMilestone tm = this.getMilestone(repository, oldName);
            if (tm == null) {
                boolean bl = false;
                return bl;
            }
            StoredConfig config = db.getConfig();
            config.unsetSection(MILESTONE, oldName);
            config.setString(MILESTONE, newName, STATUS, tm.status.name());
            config.setString(MILESTONE, newName, COLOR, tm.color);
            if (tm.due != null) {
                config.setString(MILESTONE, newName, DUE, new SimpleDateFormat(DUE_DATE_PATTERN).format(tm.due));
            }
            config.save();
            this.milestonesCache.remove(repository.name);
            TicketNotifier notifier = this.createNotifier();
            for (QueryResult qr : tm.tickets) {
                TicketModel.Change change = new TicketModel.Change(createdBy);
                change.setField(TicketModel.Field.milestone, newName);
                TicketModel ticket = this.updateTicket(repository, qr.number, change);
                if (!notifyOpenTickets || !ticket.isOpen()) continue;
                notifier.queueMailing(ticket);
            }
            if (notifyOpenTickets) {
                notifier.sendAll();
            }
            boolean bl = true;
            return bl;
        }
        return false;
    }

    public synchronized boolean deleteMilestone(RepositoryModel repository, String milestone, String createdBy) {
        return this.deleteMilestone(repository, milestone, createdBy, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean deleteMilestone(RepositoryModel repository, String milestone, String createdBy, boolean notifyOpenTickets) {
        if (StringUtils.isEmpty(milestone)) {
            throw new IllegalArgumentException("milestone can not be empty!");
        }
        try (Repository db = null;){
            TicketMilestone tm = this.getMilestone(repository, milestone);
            if (tm == null) {
                boolean bl = false;
                return bl;
            }
            db = this.repositoryManager.getRepository(repository.name);
            StoredConfig config = db.getConfig();
            config.unsetSection(MILESTONE, milestone);
            config.save();
            this.milestonesCache.remove(repository.name);
            TicketNotifier notifier = this.createNotifier();
            for (QueryResult qr : tm.tickets) {
                TicketModel.Change change = new TicketModel.Change(createdBy);
                change.setField(TicketModel.Field.milestone, "");
                TicketModel ticket = this.updateTicket(repository, qr.number, change);
                if (!notifyOpenTickets || !ticket.isOpen()) continue;
                notifier.queueMailing(ticket);
            }
            if (notifyOpenTickets) {
                notifier.sendAll();
            }
            boolean bl = true;
            return bl;
        }
        return false;
    }

    public abstract Set<Long> getIds(RepositoryModel var1);

    public abstract long assignNewId(RepositoryModel var1);

    public abstract boolean hasTicket(RepositoryModel var1, long var2);

    public List<TicketModel> getTickets(RepositoryModel repository) {
        return this.getTickets(repository, null);
    }

    public abstract List<TicketModel> getTickets(RepositoryModel var1, TicketFilter var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TicketModel getTicket(RepositoryModel repository, long ticketId) {
        TicketKey key = new TicketKey(repository, ticketId);
        TicketModel ticket = (TicketModel)this.ticketsCache.getIfPresent((Object)key);
        if (ticket == null && (ticket = this.getTicketImpl(repository, ticketId)) != null) {
            if (ticket.hasPatchsets() && this.updateDiffstats) {
                try (Repository r = this.repositoryManager.getRepository(repository.name);){
                    TicketModel.Patchset patchset = ticket.getCurrentPatchset();
                    DiffUtils.DiffStat diffStat = DiffUtils.getDiffStat(r, patchset.base, patchset.tip);
                    if (diffStat != null) {
                        ticket.insertions = diffStat.getInsertions();
                        ticket.deletions = diffStat.getDeletions();
                    }
                }
            }
            this.ticketsCache.put((Object)key, (Object)ticket);
        }
        return ticket;
    }

    protected abstract TicketModel getTicketImpl(RepositoryModel var1, long var2);

    public final List<TicketModel.Change> getJournal(RepositoryModel repository, long ticketId) {
        if (this.hasTicket(repository, ticketId)) {
            List<TicketModel.Change> journal = this.getJournalImpl(repository, ticketId);
            return journal;
        }
        return null;
    }

    protected abstract List<TicketModel.Change> getJournalImpl(RepositoryModel var1, long var2);

    public String getTicketUrl(TicketModel ticket) {
        String canonicalUrl = this.settings.getString("web.canonicalUrl", "https://localhost:8443");
        String hrefPattern = "{0}/tickets?r={1}&h={2,number,0}";
        return MessageFormat.format("{0}/tickets?r={1}&h={2,number,0}", canonicalUrl, ticket.repository, ticket.number);
    }

    public String getCompareUrl(TicketModel ticket, String base, String tip) {
        String canonicalUrl = this.settings.getString("web.canonicalUrl", "https://localhost:8443");
        String hrefPattern = "{0}/compare?r={1}&h={2}..{3}";
        return MessageFormat.format("{0}/compare?r={1}&h={2}..{3}", canonicalUrl, ticket.repository, base, tip);
    }

    public abstract boolean supportsAttachments();

    public abstract TicketModel.Attachment getAttachment(RepositoryModel var1, long var2, String var4);

    public TicketModel createTicket(RepositoryModel repository, TicketModel.Change change) {
        return this.createTicket(repository, 0L, change);
    }

    public TicketModel createTicket(RepositoryModel repository, long ticketId, TicketModel.Change change) {
        if (repository == null) {
            throw new RuntimeException("Must specify a repository!");
        }
        if (StringUtils.isEmpty(change.author)) {
            throw new RuntimeException("Must specify a change author!");
        }
        if (!change.hasField(TicketModel.Field.title)) {
            throw new RuntimeException("Must specify a title!");
        }
        change.watch(change.author);
        if (ticketId <= 0L) {
            ticketId = this.assignNewId(repository);
        }
        change.setField(TicketModel.Field.status, (Object)TicketModel.Status.New);
        boolean success = this.commitChangeImpl(repository, ticketId, change);
        if (success) {
            TicketModel ticket = this.getTicket(repository, ticketId);
            this.indexer.index(ticket);
            if (this.pluginManager != null) {
                for (TicketHook hook : this.pluginManager.getExtensions(TicketHook.class)) {
                    try {
                        hook.onNewTicket(ticket);
                    }
                    catch (Exception e) {
                        this.log.error("Failed to execute extension", (Throwable)e);
                    }
                }
            }
            return ticket;
        }
        return null;
    }

    public final TicketModel updateTicket(RepositoryModel repository, long ticketId, TicketModel.Change change) {
        if (change == null) {
            throw new RuntimeException("change can not be null!");
        }
        if (StringUtils.isEmpty(change.author)) {
            throw new RuntimeException("must specify a change author!");
        }
        boolean success = true;
        TicketModel ticket = null;
        if (ticketId > 0L) {
            TicketKey key = new TicketKey(repository, ticketId);
            this.ticketsCache.invalidate((Object)key);
            success = this.commitChangeImpl(repository, ticketId, change);
            if (success) {
                ticket = this.getTicket(repository, ticketId);
                this.ticketsCache.put((Object)key, (Object)ticket);
                this.indexer.index(ticket);
                if (this.pluginManager != null) {
                    for (TicketHook hook : this.pluginManager.getExtensions(TicketHook.class)) {
                        try {
                            hook.onUpdateTicket(ticket, change);
                        }
                        catch (Exception e) {
                            this.log.error("Failed to execute extension", (Throwable)e);
                        }
                    }
                }
            }
        }
        if (success && change.hasPendingLinks()) {
            for (TicketModel.TicketLink link : change.pendingLinks) {
                TicketModel linkedTicket = this.getTicket(repository, link.targetTicketId);
                TicketModel.Change dstChange = null;
                if (linkedTicket != null && link.targetTicketId != ticketId) {
                    dstChange = new TicketModel.Change(change.author, change.date);
                    switch (link.action) {
                        case Comment: {
                            if (ticketId == 0L) {
                                throw new RuntimeException("must specify a ticket when linking a comment!");
                            }
                            dstChange.referenceTicket(ticketId, change.comment.id);
                            break;
                        }
                        case Commit: {
                            dstChange.referenceCommit(link.hash);
                            break;
                        }
                        default: {
                            throw new RuntimeException(String.format("must add persist logic for link of type %s", new Object[]{link.action}));
                        }
                    }
                }
                if (dstChange == null) continue;
                if (link.isDelete) {
                    dstChange.reference.deleted = true;
                }
                if (this.updateTicket(repository, link.targetTicketId, dstChange) == null) continue;
                link.success = true;
            }
        }
        return ticket;
    }

    public boolean deleteAll() {
        boolean success;
        List<String> repositories = this.repositoryManager.getRepositoryList();
        BitSet bitset = new BitSet(repositories.size());
        for (int i = 0; i < repositories.size(); ++i) {
            String name = repositories.get(i);
            RepositoryModel repository = this.repositoryManager.getRepositoryModel(name);
            boolean success2 = this.deleteAll(repository);
            bitset.set(i, success2);
        }
        boolean bl = success = bitset.cardinality() == repositories.size();
        if (success) {
            this.indexer.deleteAll();
            this.resetCaches();
        }
        return success;
    }

    public boolean deleteAll(RepositoryModel repository) {
        boolean success = this.deleteAllImpl(repository);
        if (success) {
            this.log.info("Deleted all tickets for {}", (Object)repository.name);
            this.resetCaches(repository);
            this.indexer.deleteAll(repository);
        }
        return success;
    }

    protected abstract boolean deleteAllImpl(RepositoryModel var1);

    public boolean rename(RepositoryModel oldRepository, RepositoryModel newRepository) {
        if (this.renameImpl(oldRepository, newRepository)) {
            this.resetCaches(oldRepository);
            this.indexer.deleteAll(oldRepository);
            this.reindex(newRepository);
            return true;
        }
        return false;
    }

    protected abstract boolean renameImpl(RepositoryModel var1, RepositoryModel var2);

    public boolean deleteTicket(RepositoryModel repository, long ticketId, String deletedBy) {
        TicketModel ticket = this.getTicket(repository, ticketId);
        boolean success = this.deleteTicketImpl(repository, ticket, deletedBy);
        if (success) {
            this.log.info("Deleted {} ticket #{}: {}", new Object[]{repository.name, ticketId, ticket.title});
            this.ticketsCache.invalidate((Object)new TicketKey(repository, ticketId));
            this.indexer.delete(ticket);
            return true;
        }
        return false;
    }

    protected abstract boolean deleteTicketImpl(RepositoryModel var1, TicketModel var2, String var3);

    public final TicketModel updateComment(TicketModel ticket, String commentId, String updatedBy, String comment) {
        TicketModel.Change revision = new TicketModel.Change(updatedBy);
        revision.comment(comment);
        revision.comment.id = commentId;
        RepositoryModel repository = this.repositoryManager.getRepositoryModel(ticket.repository);
        TicketModel revisedTicket = this.updateTicket(repository, ticket.number, revision);
        return revisedTicket;
    }

    public final TicketModel deleteComment(TicketModel ticket, String commentId, String deletedBy) {
        TicketModel.Change deletion = new TicketModel.Change(deletedBy);
        deletion.comment("");
        deletion.comment.id = commentId;
        deletion.comment.deleted = true;
        RepositoryModel repository = this.repositoryManager.getRepositoryModel(ticket.repository);
        TicketModel revisedTicket = this.updateTicket(repository, ticket.number, deletion);
        return revisedTicket;
    }

    public final TicketModel deletePatchset(TicketModel ticket, TicketModel.Patchset patchset, String userName) {
        TicketModel.Change deletion = new TicketModel.Change(userName);
        deletion.patchset = new TicketModel.Patchset();
        deletion.patchset.number = patchset.number;
        deletion.patchset.rev = patchset.rev;
        deletion.patchset.type = TicketModel.PatchsetType.Delete;
        List<TicketModel.TicketLink> patchsetTicketLinks = JGitUtils.identifyTicketsBetweenCommits(this.repositoryManager.getRepository(ticket.repository), this.settings, patchset.base, patchset.tip);
        for (TicketModel.TicketLink link : patchsetTicketLinks) {
            link.isDelete = true;
        }
        deletion.pendingLinks = patchsetTicketLinks;
        RepositoryModel repositoryModel = this.repositoryManager.getRepositoryModel(ticket.repository);
        TicketModel revisedTicket = this.updateTicket(repositoryModel, ticket.number, deletion);
        return revisedTicket;
    }

    protected abstract boolean commitChangeImpl(RepositoryModel var1, long var2, TicketModel.Change var4);

    public List<QueryResult> searchFor(RepositoryModel repository, String text, int page, int pageSize) {
        return this.indexer.searchFor(repository, text, page, pageSize);
    }

    public List<QueryResult> queryFor(String query, int page, int pageSize, String sortBy, boolean descending) {
        return this.indexer.queryFor(query, page, pageSize, sortBy, descending);
    }

    private boolean shouldReindex() {
        return this.indexer.shouldReindex();
    }

    public void reindex() {
        long start = System.nanoTime();
        this.indexer.deleteAll();
        for (String name : this.repositoryManager.getRepositoryList()) {
            RepositoryModel repository = this.repositoryManager.getRepositoryModel(name);
            try {
                List<TicketModel> tickets2 = this.getTickets(repository);
                if (tickets2.isEmpty()) continue;
                this.log.info("reindexing {} tickets from {} ...", (Object)tickets2.size(), (Object)repository);
                this.indexer.index(tickets2);
                System.gc();
            }
            catch (Exception e) {
                this.log.error("failed to reindex {}", (Object)repository.name);
                this.log.error(null, (Throwable)e);
            }
        }
        long end = System.nanoTime();
        long secs = TimeUnit.NANOSECONDS.toMillis(end - start);
        this.log.info("reindexing completed in {} msecs.", (Object)secs);
    }

    public void reindex(RepositoryModel repository) {
        long start = System.nanoTime();
        List<TicketModel> tickets2 = this.getTickets(repository);
        this.indexer.index(tickets2);
        this.log.info("reindexing {} tickets from {} ...", (Object)tickets2.size(), (Object)repository);
        long end = System.nanoTime();
        long secs = TimeUnit.NANOSECONDS.toMillis(end - start);
        this.log.info("reindexing completed in {} msecs.", (Object)secs);
        this.resetCaches(repository);
    }

    public synchronized void exec(Runnable runnable) {
        runnable.run();
    }

    private static class TicketKey {
        final String repository;
        final long ticketId;

        TicketKey(RepositoryModel repository, long ticketId) {
            this.repository = repository.name;
            this.ticketId = ticketId;
        }

        public int hashCode() {
            return (this.repository + this.ticketId).hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof TicketKey) {
                return o.hashCode() == this.hashCode();
            }
            return false;
        }

        public String toString() {
            return this.repository + ":" + this.ticketId;
        }
    }

    public static interface TicketFilter {
        public boolean accept(TicketModel var1);
    }
}

