/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.tickets;

import com.gitblit.utils.StringUtils;

public class QueryBuilder {
    private final QueryBuilder parent;
    private String q;
    private transient StringBuilder sb;
    private int opCount;

    public static QueryBuilder q(String kernel) {
        return new QueryBuilder(kernel);
    }

    private QueryBuilder(QueryBuilder parent) {
        this.sb = new StringBuilder();
        this.parent = parent;
    }

    public QueryBuilder() {
        this("");
    }

    public QueryBuilder(String query) {
        this.sb = new StringBuilder(query == null ? "" : query);
        this.parent = null;
    }

    public boolean containsField(String field) {
        return this.sb.toString().contains(field + ":");
    }

    public QueryBuilder andSubquery() {
        this.sb.append(" AND (");
        return new QueryBuilder(this);
    }

    public QueryBuilder orSubquery() {
        this.sb.append(" OR (");
        return new QueryBuilder(this);
    }

    public QueryBuilder endSubquery() {
        this.q = this.sb.toString().trim();
        if (this.q.length() > 0) {
            this.parent.sb.append(this.q).append(')');
        }
        return this.parent;
    }

    public QueryBuilder or(String condition) {
        return this.op(condition, " OR ");
    }

    public QueryBuilder and(String condition) {
        return this.op(condition, " AND ");
    }

    public QueryBuilder andNot(String condition) {
        return this.op(condition, " AND NOT ");
    }

    public QueryBuilder toSubquery() {
        if (this.opCount > 1) {
            this.sb.insert(0, '(').append(')');
        }
        return this;
    }

    public QueryBuilder subqueryOf(String condition) {
        if (!StringUtils.isEmpty(condition)) {
            this.toSubquery().and(condition);
        }
        return this;
    }

    public QueryBuilder remove(String condition) {
        int start = this.sb.indexOf(condition);
        if (start == 0) {
            this.sb.replace(0, condition.length(), "");
        } else if (start > 1) {
            int space1 = this.sb.lastIndexOf(" ", start - 1);
            int space0 = this.sb.lastIndexOf(" ", space1 - 1);
            if (space0 > -1 && space1 > -1) {
                String conjunction = this.sb.substring(space0, space1).trim();
                if ("OR".equals(conjunction) || "AND".equals(conjunction)) {
                    this.sb.replace(space0, start + condition.length(), "");
                } else {
                    this.sb.replace(start, start + condition.length(), "");
                }
            } else {
                this.sb.replace(start, start + condition.length(), "");
            }
        }
        return this;
    }

    public String build() {
        if (this.parent != null) {
            throw new IllegalAccessError("You can not build a subquery! endSubquery() instead!");
        }
        this.q = this.sb.toString().trim();
        while (this.q.contains("()")) {
            this.q = this.q.replace("()", "");
        }
        if (this.q.length() > 0 && this.q.charAt(0) == '(' && this.q.charAt(this.q.length() - 1) == ')') {
            this.q = this.q.substring(1, this.q.length() - 1);
        }
        if (this.q.startsWith("AND ")) {
            this.q = this.q.substring(3).trim();
        }
        if (this.q.startsWith("OR ")) {
            this.q = this.q.substring(2).trim();
        }
        return this.q;
    }

    private QueryBuilder op(String condition, String op) {
        ++this.opCount;
        if (!StringUtils.isEmpty(condition)) {
            if (this.sb.length() != 0) {
                this.sb.append(op);
            }
            this.sb.append(condition);
        }
        return this;
    }

    public String toString() {
        return this.sb.toString().trim();
    }
}

