/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.tickets;

import com.gitblit.manager.IRuntimeManager;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.TicketModel;
import com.gitblit.tickets.QueryResult;
import com.gitblit.utils.LuceneIndexStore;
import com.gitblit.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketIndexer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final LuceneIndexStore indexStore;
    private IndexWriter writer;
    private IndexSearcher searcher;

    public TicketIndexer(IRuntimeManager runtimeManager) {
        File luceneDir = runtimeManager.getFileOrFolder("tickets.indexFolder", "${baseFolder}/tickets/lucene");
        this.indexStore = new LuceneIndexStore(luceneDir, 2);
    }

    public void close() {
        this.closeSearcher();
        this.closeWriter();
    }

    public void deleteAll() {
        this.close();
        this.indexStore.delete();
    }

    public boolean deleteAll(RepositoryModel repository) {
        try {
            IndexWriter writer = this.getWriter();
            StandardAnalyzer analyzer = new StandardAnalyzer();
            QueryParser qp = new QueryParser(Lucene.rid.name(), (Analyzer)analyzer);
            BooleanQuery query = new BooleanQuery.Builder().add(qp.parse(repository.getRID()), BooleanClause.Occur.MUST).build();
            int numDocsBefore = writer.numDocs();
            writer.deleteDocuments(new Query[]{query});
            writer.commit();
            this.closeSearcher();
            int numDocsAfter = writer.numDocs();
            if (numDocsBefore == numDocsAfter) {
                this.log.debug("no records found to delete in {}", (Object)repository);
                return false;
            }
            this.log.debug("deleted {} records in {}", (Object)(numDocsBefore - numDocsAfter), (Object)repository);
            return true;
        }
        catch (Exception e) {
            this.log.error("error", (Throwable)e);
            return false;
        }
    }

    boolean shouldReindex() {
        return !this.indexStore.hasIndex();
    }

    public void index(List<TicketModel> tickets2) {
        try {
            IndexWriter writer = this.getWriter();
            for (TicketModel ticket : tickets2) {
                Document doc = this.ticketToDoc(ticket);
                writer.addDocument((Iterable)doc);
            }
            writer.commit();
            this.closeSearcher();
        }
        catch (Exception e) {
            this.log.error("error", (Throwable)e);
        }
    }

    public void index(TicketModel ticket) {
        try {
            IndexWriter writer = this.getWriter();
            this.delete(ticket.repository, ticket.number, writer);
            Document doc = this.ticketToDoc(ticket);
            writer.addDocument((Iterable)doc);
            writer.commit();
            this.closeSearcher();
        }
        catch (Exception e) {
            this.log.error("error", (Throwable)e);
        }
    }

    public boolean delete(TicketModel ticket) {
        try {
            IndexWriter writer = this.getWriter();
            return this.delete(ticket.repository, ticket.number, writer);
        }
        catch (Exception e) {
            this.log.error("Failed to delete ticket {}", (Object)ticket.number, (Object)e);
            return false;
        }
    }

    private boolean delete(String repository, long ticketId, IndexWriter writer) throws Exception {
        StandardAnalyzer analyzer = new StandardAnalyzer();
        QueryParser qp = new QueryParser(Lucene.did.name(), (Analyzer)analyzer);
        BooleanQuery query = new BooleanQuery.Builder().add(qp.parse(StringUtils.getSHA1(repository + ticketId)), BooleanClause.Occur.MUST).build();
        int numDocsBefore = writer.numDocs();
        writer.deleteDocuments(new Query[]{query});
        writer.commit();
        this.closeSearcher();
        int numDocsAfter = writer.numDocs();
        if (numDocsBefore == numDocsAfter) {
            this.log.debug("no records found to delete in {}", (Object)repository);
            return false;
        }
        this.log.debug("deleted {} records in {}", (Object)(numDocsBefore - numDocsAfter), (Object)repository);
        return true;
    }

    public boolean hasTickets(RepositoryModel repository) {
        return !this.queryFor(Lucene.rid.matches(repository.getRID()), 1, 0, null, true).isEmpty();
    }

    public List<QueryResult> searchFor(RepositoryModel repository, String text, int page, int pageSize) {
        if (StringUtils.isEmpty(text)) {
            return Collections.emptyList();
        }
        LinkedHashSet<QueryResult> results = new LinkedHashSet<QueryResult>();
        StandardAnalyzer analyzer = new StandardAnalyzer();
        try {
            BooleanQuery.Builder bldr = new BooleanQuery.Builder();
            QueryParser qp = new QueryParser(Lucene.title.name(), (Analyzer)analyzer);
            qp.setAllowLeadingWildcard(true);
            bldr.add(qp.parse(text), BooleanClause.Occur.SHOULD);
            qp = new QueryParser(Lucene.body.name(), (Analyzer)analyzer);
            qp.setAllowLeadingWildcard(true);
            bldr.add(qp.parse(text), BooleanClause.Occur.SHOULD);
            qp = new QueryParser(Lucene.content.name(), (Analyzer)analyzer);
            qp.setAllowLeadingWildcard(true);
            bldr.add(qp.parse(text), BooleanClause.Occur.SHOULD);
            IndexSearcher searcher = this.getSearcher();
            Query rewrittenQuery = searcher.rewrite((Query)bldr.build());
            this.log.debug(rewrittenQuery.toString());
            TopScoreDocCollector collector = TopScoreDocCollector.create((int)5000);
            searcher.search(rewrittenQuery, (Collector)collector);
            int offset = Math.max(0, (page - 1) * pageSize);
            ScoreDoc[] hits = collector.topDocs((int)offset, (int)pageSize).scoreDocs;
            for (int i = 0; i < hits.length; ++i) {
                int docId = hits[i].doc;
                Document doc = searcher.doc(docId);
                QueryResult result = this.docToQueryResult(doc);
                if (repository != null && !result.repository.equalsIgnoreCase(repository.name)) continue;
                results.add(result);
            }
        }
        catch (Exception e) {
            this.log.error("Exception while searching for {}", (Object)text, (Object)e);
        }
        return new ArrayList<QueryResult>(results);
    }

    public List<QueryResult> queryFor(String queryText, int page, int pageSize, String sortBy, boolean desc) {
        if (StringUtils.isEmpty(queryText)) {
            return Collections.emptyList();
        }
        LinkedHashSet<QueryResult> results = new LinkedHashSet<QueryResult>();
        StandardAnalyzer analyzer = new StandardAnalyzer();
        try {
            QueryParser qp = new QueryParser(Lucene.content.name(), (Analyzer)analyzer);
            Query query = qp.parse(queryText);
            IndexSearcher searcher = this.getSearcher();
            Query rewrittenQuery = searcher.rewrite(query);
            this.log.debug(rewrittenQuery.toString());
            Sort sort = sortBy == null ? new Sort(Lucene.created.asSortField(desc)) : new Sort(Lucene.fromString(sortBy).asSortField(desc));
            int maxSize = 5000;
            TopFieldDocs docs = searcher.search(rewrittenQuery, maxSize, sort, false, false);
            int size = pageSize <= 0 ? maxSize : pageSize;
            int offset = Math.max(0, (page - 1) * size);
            ScoreDoc[] hits = this.subset(docs.scoreDocs, offset, size);
            for (int i = 0; i < hits.length; ++i) {
                int docId = hits[i].doc;
                Document doc = searcher.doc(docId);
                QueryResult result = this.docToQueryResult(doc);
                result.docId = docId;
                result.totalResults = docs.totalHits;
                results.add(result);
            }
        }
        catch (Exception e) {
            this.log.error("Exception while searching for {}", (Object)queryText, (Object)e);
        }
        return new ArrayList<QueryResult>(results);
    }

    private ScoreDoc[] subset(ScoreDoc[] docs, int offset, int size) {
        if (docs.length >= offset + size) {
            ScoreDoc[] set = new ScoreDoc[size];
            System.arraycopy(docs, offset, set, 0, set.length);
            return set;
        }
        if (docs.length >= offset) {
            ScoreDoc[] set = new ScoreDoc[docs.length - offset];
            System.arraycopy(docs, offset, set, 0, set.length);
            return set;
        }
        return new ScoreDoc[0];
    }

    private IndexWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.indexStore.create();
            FSDirectory directory = FSDirectory.open((Path)this.indexStore.getPath());
            StandardAnalyzer analyzer = new StandardAnalyzer();
            IndexWriterConfig config = new IndexWriterConfig((Analyzer)analyzer);
            config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            this.writer = new IndexWriter((Directory)directory, config);
        }
        return this.writer;
    }

    private synchronized void closeWriter() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (Exception e) {
            this.log.error("failed to close writer!", (Throwable)e);
        }
        finally {
            this.writer = null;
        }
    }

    private IndexSearcher getSearcher() throws IOException {
        if (this.searcher == null) {
            this.searcher = new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)this.getWriter(), (boolean)true));
        }
        return this.searcher;
    }

    private synchronized void closeSearcher() {
        try {
            if (this.searcher != null) {
                this.searcher.getIndexReader().close();
            }
        }
        catch (Exception e) {
            this.log.error("failed to close searcher!", (Throwable)e);
        }
        finally {
            this.searcher = null;
        }
    }

    private Document ticketToDoc(TicketModel ticket) {
        Document doc = new Document();
        this.toDocField(doc, Lucene.rid, StringUtils.getSHA1(ticket.repository));
        this.toDocField(doc, Lucene.did, StringUtils.getSHA1(ticket.repository + ticket.number));
        this.toDocField(doc, Lucene.project, ticket.project);
        this.toDocField(doc, Lucene.repository, ticket.repository);
        this.toDocField(doc, Lucene.number, ticket.number);
        this.toDocField(doc, Lucene.title, ticket.title);
        this.toDocField(doc, Lucene.body, ticket.body);
        this.toDocField(doc, Lucene.created, ticket.created);
        this.toDocField(doc, Lucene.createdby, ticket.createdBy);
        this.toDocField(doc, Lucene.updated, ticket.updated);
        this.toDocField(doc, Lucene.updatedby, ticket.updatedBy);
        this.toDocField(doc, Lucene.responsible, ticket.responsible);
        this.toDocField(doc, Lucene.milestone, ticket.milestone);
        this.toDocField(doc, Lucene.topic, ticket.topic);
        this.toDocField(doc, Lucene.status, ticket.status.name());
        this.toDocField(doc, Lucene.comments, ticket.getComments().size());
        this.toDocField(doc, Lucene.type, ticket.type == null ? null : ticket.type.name());
        this.toDocField(doc, Lucene.mergesha, ticket.mergeSha);
        this.toDocField(doc, Lucene.mergeto, ticket.mergeTo);
        this.toDocField(doc, Lucene.labels, StringUtils.flattenStrings(ticket.getLabels(), ";").toLowerCase());
        this.toDocField(doc, Lucene.participants, StringUtils.flattenStrings(ticket.getParticipants(), ";").toLowerCase());
        this.toDocField(doc, Lucene.watchedby, StringUtils.flattenStrings(ticket.getWatchers(), ";").toLowerCase());
        this.toDocField(doc, Lucene.mentions, StringUtils.flattenStrings(ticket.getMentions(), ";").toLowerCase());
        this.toDocField(doc, Lucene.votes, ticket.getVoters().size());
        this.toDocField(doc, Lucene.priority, ticket.priority.getValue());
        this.toDocField(doc, Lucene.severity, ticket.severity.getValue());
        ArrayList<String> attachments = new ArrayList<String>();
        for (TicketModel.Attachment attachment : ticket.getAttachments()) {
            attachments.add(attachment.name.toLowerCase());
        }
        this.toDocField(doc, Lucene.attachments, StringUtils.flattenStrings(attachments, ";"));
        List<TicketModel.Patchset> patches = ticket.getPatchsets();
        if (!patches.isEmpty()) {
            this.toDocField(doc, Lucene.patchsets, patches.size());
            TicketModel.Patchset patchset = patches.get(patches.size() - 1);
            String flat = patchset.number + ":" + patchset.rev + ":" + patchset.tip + ":" + patchset.base + ":" + patchset.commits;
            doc.add((IndexableField)new Field(Lucene.patchset.name(), flat, TextField.TYPE_STORED));
        }
        doc.add((IndexableField)new TextField(Lucene.content.name(), ticket.toIndexableString(), Field.Store.NO));
        return doc;
    }

    private void toDocField(Document doc, Lucene lucene, Date value) {
        if (value == null) {
            return;
        }
        doc.add((IndexableField)new LongField(lucene.name(), value.getTime(), Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField(lucene.name(), value.getTime()));
    }

    private void toDocField(Document doc, Lucene lucene, long value) {
        doc.add((IndexableField)new LongField(lucene.name(), value, Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField(lucene.name(), value));
    }

    private void toDocField(Document doc, Lucene lucene, int value) {
        doc.add((IndexableField)new IntField(lucene.name(), value, Field.Store.YES));
        doc.add((IndexableField)new NumericDocValuesField(lucene.name(), (long)value));
    }

    private void toDocField(Document doc, Lucene lucene, String value) {
        if (StringUtils.isEmpty(value)) {
            return;
        }
        doc.add((IndexableField)new Field(lucene.name(), value, TextField.TYPE_STORED));
        doc.add((IndexableField)new SortedDocValuesField(lucene.name(), new BytesRef((CharSequence)value)));
    }

    private QueryResult docToQueryResult(Document doc) throws ParseException {
        QueryResult result = new QueryResult();
        result.project = this.unpackString(doc, Lucene.project);
        result.repository = this.unpackString(doc, Lucene.repository);
        result.number = this.unpackLong(doc, Lucene.number);
        result.createdBy = this.unpackString(doc, Lucene.createdby);
        result.createdAt = this.unpackDate(doc, Lucene.created);
        result.updatedBy = this.unpackString(doc, Lucene.updatedby);
        result.updatedAt = this.unpackDate(doc, Lucene.updated);
        result.title = this.unpackString(doc, Lucene.title);
        result.body = this.unpackString(doc, Lucene.body);
        result.status = TicketModel.Status.fromObject(this.unpackString(doc, Lucene.status), TicketModel.Status.New);
        result.responsible = this.unpackString(doc, Lucene.responsible);
        result.milestone = this.unpackString(doc, Lucene.milestone);
        result.topic = this.unpackString(doc, Lucene.topic);
        result.type = TicketModel.Type.fromObject(this.unpackString(doc, Lucene.type), TicketModel.Type.defaultType);
        result.mergeSha = this.unpackString(doc, Lucene.mergesha);
        result.mergeTo = this.unpackString(doc, Lucene.mergeto);
        result.commentsCount = this.unpackInt(doc, Lucene.comments);
        result.votesCount = this.unpackInt(doc, Lucene.votes);
        result.attachments = this.unpackStrings(doc, Lucene.attachments);
        result.labels = this.unpackStrings(doc, Lucene.labels);
        result.participants = this.unpackStrings(doc, Lucene.participants);
        result.watchedby = this.unpackStrings(doc, Lucene.watchedby);
        result.mentions = this.unpackStrings(doc, Lucene.mentions);
        result.priority = TicketModel.Priority.fromObject(this.unpackInt(doc, Lucene.priority), TicketModel.Priority.defaultPriority);
        result.severity = TicketModel.Severity.fromObject(this.unpackInt(doc, Lucene.severity), TicketModel.Severity.defaultSeverity);
        if (!StringUtils.isEmpty(doc.get(Lucene.patchset.name()))) {
            String[] values = doc.get(Lucene.patchset.name()).split(":", 5);
            TicketModel.Patchset patchset = new TicketModel.Patchset();
            patchset.number = Integer.parseInt(values[0]);
            patchset.rev = Integer.parseInt(values[1]);
            patchset.tip = values[2];
            patchset.base = values[3];
            patchset.commits = Integer.parseInt(values[4]);
            result.patchset = patchset;
        }
        return result;
    }

    private String unpackString(Document doc, Lucene lucene) {
        return doc.get(lucene.name());
    }

    private List<String> unpackStrings(Document doc, Lucene lucene) {
        if (!StringUtils.isEmpty(doc.get(lucene.name()))) {
            return StringUtils.getStringsFromValue(doc.get(lucene.name()), ";");
        }
        return null;
    }

    private Date unpackDate(Document doc, Lucene lucene) {
        String val = doc.get(lucene.name());
        if (!StringUtils.isEmpty(val)) {
            long time = Long.parseLong(val);
            Date date = new Date(time);
            return date;
        }
        return null;
    }

    private long unpackLong(Document doc, Lucene lucene) {
        String val = doc.get(lucene.name());
        if (StringUtils.isEmpty(val)) {
            return 0L;
        }
        long l = Long.parseLong(val);
        return l;
    }

    private int unpackInt(Document doc, Lucene lucene) {
        String val = doc.get(lucene.name());
        if (StringUtils.isEmpty(val)) {
            return 0;
        }
        int i = Integer.parseInt(val);
        return i;
    }

    public static enum Lucene {
        rid(SortField.Type.STRING),
        did(SortField.Type.STRING),
        project(SortField.Type.STRING),
        repository(SortField.Type.STRING),
        number(SortField.Type.LONG),
        title(SortField.Type.STRING),
        body(SortField.Type.STRING),
        topic(SortField.Type.STRING),
        created(SortField.Type.LONG),
        createdby(SortField.Type.STRING),
        updated(SortField.Type.LONG),
        updatedby(SortField.Type.STRING),
        responsible(SortField.Type.STRING),
        milestone(SortField.Type.STRING),
        status(SortField.Type.STRING),
        type(SortField.Type.STRING),
        labels(SortField.Type.STRING),
        participants(SortField.Type.STRING),
        watchedby(SortField.Type.STRING),
        mentions(SortField.Type.STRING),
        attachments(SortField.Type.INT),
        content(SortField.Type.STRING),
        patchset(SortField.Type.STRING),
        comments(SortField.Type.INT),
        mergesha(SortField.Type.STRING),
        mergeto(SortField.Type.STRING),
        patchsets(SortField.Type.INT),
        votes(SortField.Type.INT),
        priority(SortField.Type.INT),
        severity(SortField.Type.INT);

        static final int INDEX_VERSION = 2;
        final SortField.Type fieldType;

        private Lucene(SortField.Type fieldType) {
            this.fieldType = fieldType;
        }

        public String colon() {
            return this.name() + ":";
        }

        public String matches(String value) {
            boolean not;
            if (StringUtils.isEmpty(value)) {
                return "";
            }
            boolean bl = not = value.charAt(0) == '!';
            if (not) {
                return "!" + this.name() + ":" + this.escape(value.substring(1));
            }
            return this.name() + ":" + this.escape(value);
        }

        public String doesNotMatch(String value) {
            if (StringUtils.isEmpty(value)) {
                return "";
            }
            return "NOT " + this.name() + ":" + this.escape(value);
        }

        public String isNotNull() {
            return this.matches("[* TO *]");
        }

        public SortField asSortField(boolean descending) {
            return new SortField(this.name(), this.fieldType, descending);
        }

        private String escape(String value) {
            if (value.charAt(0) != '\"') {
                for (char c : value.toCharArray()) {
                    if (Character.isLetterOrDigit(c)) continue;
                    return "\"" + value + "\"";
                }
            }
            return value;
        }

        public static Lucene fromString(String value) {
            for (Lucene field : Lucene.values()) {
                if (!field.name().equalsIgnoreCase(value)) continue;
                return field;
            }
            return created;
        }
    }
}

