/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.tickets;

import com.gitblit.IStoredSettings;
import com.gitblit.git.PatchsetCommand;
import com.gitblit.manager.INotificationManager;
import com.gitblit.manager.IRepositoryManager;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.manager.IUserManager;
import com.gitblit.models.Mailing;
import com.gitblit.models.PathModel;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.TicketModel;
import com.gitblit.models.UserModel;
import com.gitblit.tickets.ITicketService;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.DiffUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.MarkdownUtils;
import com.gitblit.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicketNotifier {
    protected final Map<Long, Mailing> queue = new TreeMap<Long, Mailing>();
    private final String SOFT_BRK = "\n";
    private final String HARD_BRK = "\n\n";
    private final String HR = "----\n\n";
    private final IStoredSettings settings;
    private final INotificationManager notificationManager;
    private final IUserManager userManager;
    private final IRepositoryManager repositoryManager;
    private final ITicketService ticketService;
    private final String addPattern = "<span style=\"color:darkgreen;\">+{0}</span>";
    private final String delPattern = "<span style=\"color:darkred;\">-{0}</span>";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public TicketNotifier(IRuntimeManager runtimeManager, INotificationManager notificationManager, IUserManager userManager, IRepositoryManager repositoryManager, ITicketService ticketService) {
        this.settings = runtimeManager.getSettings();
        this.notificationManager = notificationManager;
        this.userManager = userManager;
        this.repositoryManager = repositoryManager;
        this.ticketService = ticketService;
    }

    public void sendAll() {
        for (Mailing mail2 : this.queue.values()) {
            this.notificationManager.send(mail2);
        }
    }

    public void sendMailing(TicketModel ticket) {
        this.queueMailing(ticket);
        this.sendAll();
    }

    public Mailing queueMailing(TicketModel ticket) {
        try {
            String markdown = this.formatLastChange(ticket);
            StringBuilder html = new StringBuilder();
            html.append("<head>");
            html.append(this.readStyle());
            html.append(this.readViewTicketAction(ticket));
            html.append("</head>");
            html.append("<body>");
            html.append(MarkdownUtils.transformGFM(this.settings, markdown, ticket.repository));
            html.append("</body>");
            Mailing mailing = Mailing.newHtml();
            mailing.from = this.getUserModel(ticket.updatedBy == null ? ticket.createdBy : ticket.updatedBy).getDisplayName();
            mailing.subject = this.getSubject(ticket);
            mailing.content = html.toString();
            mailing.id = "ticket." + ticket.number + "." + StringUtils.getSHA1(ticket.repository + ticket.number);
            this.setRecipients(ticket, mailing);
            this.queue.put(ticket.number, mailing);
            return mailing;
        }
        catch (Exception e) {
            this.log.error("failed to queue mailing for #{}", (Object)ticket.number, (Object)e);
            return null;
        }
    }

    protected String getSubject(TicketModel ticket) {
        TicketModel.Change lastChange = ticket.changes.get(ticket.changes.size() - 1);
        boolean newTicket = lastChange.isStatusChange() && ticket.changes.size() == 1;
        String re = newTicket ? "" : "Re: ";
        String subject = MessageFormat.format("{0}[{1}] {2} (#{3,number,0})", re, StringUtils.stripDotGit(ticket.repository), ticket.title, ticket.number);
        return subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String formatLastChange(TicketModel ticket) {
        String title;
        DiffUtils.DiffStat diffstat;
        List<RevCommit> commits;
        boolean isFastForward;
        boolean newTicket;
        StringBuilder sb;
        HashSet<TicketModel.Field> fieldExclusions;
        TicketModel.Change lastChange;
        block59: {
            String pattern;
            UserModel user;
            block58: {
                Object base;
                TicketModel.Patchset patchset;
                block57: {
                    Repository repository;
                    lastChange = ticket.changes.get(ticket.changes.size() - 1);
                    user = this.getUserModel(lastChange.author);
                    fieldExclusions = new HashSet<TicketModel.Field>();
                    fieldExclusions.addAll(Arrays.asList(TicketModel.Field.watchers, TicketModel.Field.voters));
                    sb = new StringBuilder();
                    newTicket = lastChange.isStatusChange() && TicketModel.Status.New == lastChange.getStatus();
                    isFastForward = true;
                    commits = null;
                    diffstat = null;
                    if (!lastChange.hasPatchset()) break block58;
                    patchset = lastChange.patchset;
                    base = "";
                    Object var13_12 = null;
                    try {
                        repository = this.repositoryManager.getRepository(ticket.repository);
                        if (patchset.isFF() && patchset.rev > 1) {
                            isFastForward = true;
                            TicketModel.Patchset prev = ticket.getPatchset(patchset.number, patchset.rev - 1);
                            base = prev.tip;
                        } else {
                            isFastForward = false;
                            base = patchset.base;
                        }
                        diffstat = DiffUtils.getDiffStat(repository, (String)base, patchset.tip);
                        commits = JGitUtils.getRevLog(repository, (String)base, patchset.tip);
                        if (repository == null) break block57;
                    }
                    catch (Exception e) {
                        this.log.error("failed to get changed paths", (Throwable)e);
                        break block57;
                    }
                    repository.close();
                    break block57;
                    finally {
                        if (var13_12 != null) {
                            var13_12.close();
                        }
                    }
                }
                String compareUrl = this.ticketService.getCompareUrl(ticket, (String)base, patchset.tip);
                if (newTicket) {
                    pattern = "**{0}** is proposing a change.";
                    sb.append(MessageFormat.format(pattern, user.getDisplayName()));
                    fieldExclusions.add(TicketModel.Field.status);
                    fieldExclusions.add(TicketModel.Field.title);
                    fieldExclusions.add(TicketModel.Field.body);
                } else if (patchset.isFF()) {
                    pattern = "**{0}** added {1} {2} to patchset {3}.";
                    sb.append(MessageFormat.format(pattern, user.getDisplayName(), patchset.added, patchset.added == 1 ? "commit" : "commits", patchset.number));
                } else {
                    pattern = "**{0}** uploaded patchset {1}. *({2})*";
                    sb.append(MessageFormat.format(pattern, user.getDisplayName(), patchset.number, patchset.type.toString().toUpperCase()));
                }
                sb.append("\n\n");
                sb.append(MessageFormat.format("{0} {1}, {2} {3}, <span style=\"color:darkgreen;\">+{4} insertions</span>, <span style=\"color:darkred;\">-{5} deletions</span> from {6}. [compare]({7})", commits.size(), commits.size() == 1 ? "commit" : "commits", diffstat.paths.size(), diffstat.paths.size() == 1 ? "file" : "files", diffstat.getInsertions(), diffstat.getDeletions(), isFastForward ? "previous revision" : "merge base", compareUrl));
                switch (lastChange.patchset.type) {
                    case Rebase: {
                        if (lastChange.patchset.added <= 0) break;
                        sb.append("\n");
                        sb.append(MessageFormat.format("{0} {1} added.", lastChange.patchset.added, lastChange.patchset.added == 1 ? "commit" : "commits"));
                        break;
                    }
                }
                sb.append("\n\n");
                break block59;
            }
            if (lastChange.isStatusChange()) {
                if (newTicket) {
                    fieldExclusions.add(TicketModel.Field.status);
                    fieldExclusions.add(TicketModel.Field.title);
                    fieldExclusions.add(TicketModel.Field.body);
                    pattern = "**{0}** created this ticket.";
                    sb.append(MessageFormat.format(pattern, user.getDisplayName()));
                } else if (lastChange.hasField(TicketModel.Field.mergeSha)) {
                    pattern = "**{0}** closed this ticket by merging {1} to {2}.";
                    String merged = ticket.mergeSha;
                    for (TicketModel.Patchset patchset : ticket.getPatchsets()) {
                        if (!patchset.tip.equals(ticket.mergeSha)) continue;
                        merged = patchset.toString();
                        break;
                    }
                    sb.append(MessageFormat.format(pattern, user.getDisplayName(), merged, ticket.mergeTo));
                } else {
                    pattern = "**{0}** changed the status of this ticket to **{1}**.";
                    sb.append(MessageFormat.format(pattern, user.getDisplayName(), lastChange.getStatus().toString().toUpperCase()));
                }
                sb.append("\n\n");
            } else if (lastChange.hasReview()) {
                TicketModel.Review review = lastChange.review;
                pattern = "**{0}** has reviewed patchset {1,number,0} revision {2,number,0}.";
                sb.append(MessageFormat.format(pattern, user.getDisplayName(), review.patchset, review.rev));
                sb.append("\n\n");
                String d = this.settings.getString("web.datestampShortFormat", "yyyy-MM-dd");
                String string = this.settings.getString("web.timeFormat", "HH:mm");
                SimpleDateFormat df = new SimpleDateFormat((String)d + " " + string);
                List<TicketModel.Change> reviews = ticket.getReviews(ticket.getPatchset(review.patchset, review.rev));
                sb.append("| Date | Reviewer      | Score | Description  |\n");
                sb.append("| :--- | :------------ | :---: | :----------- |\n");
                for (TicketModel.Change change : reviews) {
                    String score;
                    String name = change.author;
                    UserModel u = this.userManager.getUserModel(change.author);
                    if (u != null) {
                        name = u.getDisplayName();
                    }
                    switch (change.review.score) {
                        case approved: {
                            score = MessageFormat.format("<span style=\"color:darkgreen;\">+{0}</span>", change.review.score.getValue());
                            break;
                        }
                        case vetoed: {
                            score = MessageFormat.format("<span style=\"color:darkred;\">-{0}</span>", Math.abs(change.review.score.getValue()));
                            break;
                        }
                        default: {
                            score = "" + change.review.score.getValue();
                        }
                    }
                    String date = df.format(change.date);
                    sb.append(String.format("| %1$s | %2$s | %3$s | %4$s |\n", date, name, score, change.review.score.toString()));
                }
                sb.append("\n\n");
            } else if (lastChange.hasComment()) {
                sb.append(MessageFormat.format("**{0}** commented on this ticket.", user.getDisplayName()));
                sb.append("\n\n");
            } else if (lastChange.hasReference()) {
                String type = "?";
                switch (lastChange.reference.getSourceType()) {
                    case Commit: {
                        type = "commit";
                        break;
                    }
                    case Ticket: {
                        type = "ticket";
                        break;
                    }
                }
                sb.append(MessageFormat.format("**{0}** referenced this ticket in {1} {2}", type, lastChange.toString()));
                sb.append("\n\n");
            } else {
                pattern = "**{0}** has updated this ticket.";
                sb.append(MessageFormat.format(pattern, user.getDisplayName()));
                sb.append("\n\n");
            }
        }
        sb.append(MessageFormat.format("[view ticket {0,number,0}]({1})", ticket.number, this.ticketService.getTicketUrl(ticket)));
        sb.append("\n\n");
        if (newTicket) {
            sb.append(MessageFormat.format("### {0}", ticket.title));
            sb.append("\n\n");
            if (StringUtils.isEmpty(ticket.body)) {
                sb.append("<span style=\"color: #888;\">no description entered</span>");
            } else {
                sb.append(ticket.body);
            }
            sb.append("\n\n");
            sb.append("----\n\n");
        }
        if (lastChange.hasFieldChanges()) {
            HashMap filtered = new HashMap();
            for (Map.Entry entry : lastChange.fields.entrySet()) {
                if (fieldExclusions.contains(entry.getKey())) continue;
                filtered.put(entry.getKey(), entry.getValue());
            }
            ArrayList fields = new ArrayList(filtered.keySet());
            Collections.sort(fields);
            if (filtered.size() > 0) {
                sb.append("\n\n");
                sb.append("| Field Changes               ||\n");
                sb.append("| ------------: | :----------- |\n");
                for (TicketModel.Field field : fields) {
                    String value = filtered.get((Object)field) == null ? "" : ((String)filtered.get((Object)field)).replace("\r\n", "<br/>").replace("\n", "<br/>").replace("|", "&#124;");
                    sb.append(String.format("| **%1$s:** | %2$s |\n", field.name(), value));
                }
                sb.append("\n\n");
            }
        }
        if (lastChange.hasComment()) {
            sb.append("----\n\n");
            sb.append(lastChange.comment.text);
            sb.append("\n\n");
        }
        if (!lastChange.hasPatchset()) return sb.toString();
        if (!ticket.isOpen()) return sb.toString();
        if (commits != null && commits.size() > 0) {
            title = isFastForward ? "Commits added to previous patchset revision" : "All commits in patchset";
            sb.append(MessageFormat.format("| {0} |||\n", title));
            sb.append("| SHA | Author | Title |\n");
            sb.append("| :-- | :----- | :---- |\n");
            for (RevCommit revCommit : commits) {
                sb.append(MessageFormat.format("| {0} | {1} | {2} |\n", revCommit.getName(), revCommit.getAuthorIdent().getName(), StringUtils.trimString(revCommit.getShortMessage(), 78).replace("|", "&#124;")));
            }
            sb.append("\n\n");
        }
        if (diffstat != null) {
            title = isFastForward ? "Files changed since previous patchset revision" : "All files changed in patchset";
            sb.append(MessageFormat.format("| {0} |||\n", title));
            sb.append("| :-- | :----------- | :-: |\n");
            for (PathModel.PathChangeModel pathChangeModel : diffstat.paths) {
                String add = MessageFormat.format("<span style=\"color:darkgreen;\">+{0}</span>", pathChangeModel.insertions);
                String del = MessageFormat.format("<span style=\"color:darkred;\">-{0}</span>", pathChangeModel.deletions);
                String diff = null;
                switch (pathChangeModel.changeType) {
                    case ADD: {
                        diff = add;
                        break;
                    }
                    case DELETE: {
                        diff = del;
                        break;
                    }
                    case MODIFY: {
                        if (pathChangeModel.insertions > 0 && pathChangeModel.deletions > 0) {
                            diff = add + "/" + del;
                            break;
                        }
                        if (pathChangeModel.insertions > 0) {
                            diff = add;
                            break;
                        }
                        diff = del;
                        break;
                    }
                    default: {
                        diff = pathChangeModel.changeType.name();
                    }
                }
                sb.append(MessageFormat.format("| {0} | {1} | {2} |\n", this.getChangeType(pathChangeModel.changeType), pathChangeModel.name, diff));
            }
            sb.append("\n\n");
        }
        sb.append(this.formatPatchsetInstructions(ticket, lastChange.patchset));
        return sb.toString();
    }

    protected String getChangeType(DiffEntry.ChangeType type) {
        String style = null;
        switch (type) {
            case ADD: {
                style = "color:darkgreen;";
                break;
            }
            case COPY: {
                style = "";
                break;
            }
            case DELETE: {
                style = "color:darkred;";
                break;
            }
            case MODIFY: {
                style = "";
                break;
            }
            case RENAME: {
                style = "";
                break;
            }
        }
        String code = type.name().toUpperCase().substring(0, 1);
        if (style == null) {
            return code;
        }
        return MessageFormat.format("<strong><span style=\"{0}padding:2px;margin:2px;border:1px solid #ddd;\">{1}</span></strong>", style, code);
    }

    protected String formatPatchsetInstructions(TicketModel ticket, TicketModel.Patchset patchset) {
        String canonicalUrl = this.settings.getString("web.canonicalUrl", "https://localhost:8443");
        String repositoryUrl = canonicalUrl + "/r/" + ticket.repository;
        String ticketBranch = Repository.shortenRefName((String)PatchsetCommand.getTicketBranch(ticket.number));
        String patchsetBranch = PatchsetCommand.getPatchsetBranch(ticket.number, patchset.number);
        String reviewBranch = PatchsetCommand.getReviewBranch(ticket.number);
        String instructions = this.readResource("commands.md");
        instructions = instructions.replace("${ticketId}", "" + ticket.number);
        instructions = instructions.replace("${patchset}", "" + patchset.number);
        instructions = instructions.replace("${repositoryUrl}", repositoryUrl);
        instructions = instructions.replace("${ticketRef}", ticketBranch);
        instructions = instructions.replace("${patchsetRef}", patchsetBranch);
        instructions = instructions.replace("${reviewBranch}", reviewBranch);
        instructions = instructions.replace("${ticketBranch}", ticketBranch);
        return instructions;
    }

    protected UserModel getUserModel(String username) {
        UserModel user = this.userManager.getUserModel(username);
        if (user == null) {
            user = new UserModel(username);
        }
        return user;
    }

    protected void setRecipients(TicketModel ticket, Mailing mailing) {
        TicketModel.Change lastChange;
        RepositoryModel repository = this.repositoryManager.getRepositoryModel(ticket.repository);
        TreeSet<String> tos = new TreeSet<String>();
        tos.add(ticket.createdBy);
        if (!StringUtils.isEmpty(ticket.responsible)) {
            tos.add(ticket.responsible);
        }
        TreeSet<String> toAddresses = new TreeSet<String>();
        for (String name : tos) {
            UserModel user = this.userManager.getUserModel(name);
            if (user == null || user.disabled || StringUtils.isEmpty(user.emailAddress)) continue;
            if (user.canView(repository)) {
                toAddresses.add(user.emailAddress);
                continue;
            }
            this.log.warn("ticket {}-{}: {} can not receive notification", new Object[]{repository.name, ticket.number, user.username});
        }
        TreeSet<String> ccs = new TreeSet<String>();
        if (!ArrayUtils.isEmpty(repository.owners)) {
            ccs.addAll(repository.owners);
        }
        if ((lastChange = ticket.changes.get(ticket.changes.size() - 1)).hasComment()) {
            Pattern p = Pattern.compile("\\B@(?<user>[^\\s]+)\\b");
            Matcher m = p.matcher(lastChange.comment.text);
            while (m.find()) {
                String username = m.group("user");
                ccs.add(username);
            }
        }
        ccs.addAll(ticket.getWatchers());
        TreeSet<String> ccAddresses = new TreeSet<String>();
        for (String name : ccs) {
            UserModel user = this.userManager.getUserModel(name);
            if (user == null || user.disabled || StringUtils.isEmpty(user.emailAddress)) continue;
            if (user.canView(repository)) {
                ccAddresses.add(user.emailAddress);
                continue;
            }
            this.log.warn("ticket {}-{}: {} can not receive notification", new Object[]{repository.name, ticket.number, user.username});
        }
        if (!ArrayUtils.isEmpty(repository.mailingLists)) {
            ccAddresses.addAll(repository.mailingLists);
        }
        ccAddresses.addAll(this.settings.getStrings("mail.mailingLists"));
        UserModel lastAuthor = this.userManager.getUserModel(lastChange.author);
        if (lastAuthor != null && !lastAuthor.getPreferences().isEmailMeOnMyTicketChanges()) {
            toAddresses.remove(lastAuthor.emailAddress);
            ccAddresses.remove(lastAuthor.emailAddress);
        }
        mailing.setRecipients(toAddresses);
        mailing.setCCs(ccAddresses);
    }

    protected String readStyle() {
        StringBuilder sb = new StringBuilder();
        sb.append("<style>\n");
        sb.append(this.readResource("email.css"));
        sb.append("</style>\n");
        return sb.toString();
    }

    protected String readViewTicketAction(TicketModel ticket) {
        String action = this.readResource("viewTicket.html");
        action = action.replace("${url}", this.ticketService.getTicketUrl(ticket));
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readResource(String resource) {
        StringBuilder sb = new StringBuilder();
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream(resource);
            List lines = IOUtils.readLines((InputStream)is);
            for (String line : lines) {
                sb.append(line).append('\n');
            }
        }
        catch (UncheckedIOException uncheckedIOException) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }
}

