/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.tickets;

import com.gitblit.models.TicketModel;
import com.gitblit.tickets.TicketLabel;
import com.gitblit.tickets.TicketMilestone;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.JsonUtils;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class TicketSerializer {
    protected static final Type JOURNAL_TYPE = new TypeToken<Collection<TicketModel.Change>>(){}.getType();

    public static List<TicketModel.Change> deserializeJournal(String json) {
        Collection list = (Collection)TicketSerializer.gson(new ExclusionStrategy[0]).fromJson(json, JOURNAL_TYPE);
        return new ArrayList<TicketModel.Change>(list);
    }

    public static TicketModel deserializeTicket(String json) {
        return (TicketModel)TicketSerializer.gson(new ExclusionStrategy[0]).fromJson(json, TicketModel.class);
    }

    public static TicketLabel deserializeLabel(String json) {
        return (TicketLabel)TicketSerializer.gson(new ExclusionStrategy[0]).fromJson(json, TicketLabel.class);
    }

    public static TicketMilestone deserializeMilestone(String json) {
        return (TicketMilestone)TicketSerializer.gson(new ExclusionStrategy[0]).fromJson(json, TicketMilestone.class);
    }

    public static String serializeJournal(List<TicketModel.Change> changes) {
        try {
            Gson gson = TicketSerializer.gson(new ExclusionStrategy[0]);
            return gson.toJson(changes);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String serialize(TicketModel ticket) {
        if (ticket == null) {
            return null;
        }
        try {
            Gson gson = TicketSerializer.gson(new JsonUtils.ExcludeField("com.gitblit.models.TicketModel$Attachment.content"), new JsonUtils.ExcludeField("com.gitblit.models.TicketModel$Attachment.deleted"), new JsonUtils.ExcludeField("com.gitblit.models.TicketModel$Comment.deleted"));
            return gson.toJson((Object)ticket);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String serialize(TicketModel.Change change) {
        if (change == null) {
            return null;
        }
        try {
            Gson gson = TicketSerializer.gson(new JsonUtils.ExcludeField("com.gitblit.models.TicketModel$Attachment.content"));
            return gson.toJson((Object)change);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String serialize(TicketLabel label) {
        if (label == null) {
            return null;
        }
        try {
            Gson gson = TicketSerializer.gson(new ExclusionStrategy[0]);
            return gson.toJson((Object)label);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String serialize(TicketMilestone milestone) {
        if (milestone == null) {
            return null;
        }
        try {
            Gson gson = TicketSerializer.gson(new ExclusionStrategy[0]);
            return gson.toJson((Object)milestone);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Gson gson(ExclusionStrategy ... strategies) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Date.class, (Object)new JsonUtils.GmtDateTypeAdapter());
        builder.registerTypeAdapter(TicketModel.Score.class, (Object)new ScoreTypeAdapter());
        if (!ArrayUtils.isEmpty(strategies)) {
            builder.setExclusionStrategies(strategies);
        }
        return builder.create();
    }

    private static class ScoreTypeAdapter
    implements JsonSerializer<TicketModel.Score>,
    JsonDeserializer<TicketModel.Score> {
        private ScoreTypeAdapter() {
        }

        public synchronized JsonElement serialize(TicketModel.Score score, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive((Number)score.getValue());
        }

        public synchronized TicketModel.Score deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
            try {
                int value = jsonElement.getAsInt();
                for (TicketModel.Score score : TicketModel.Score.values()) {
                    if (score.getValue() != value) continue;
                    return score;
                }
                return TicketModel.Score.not_reviewed;
            }
            catch (Exception e) {
                throw new JsonSyntaxException(jsonElement.getAsString(), (Throwable)e);
            }
        }
    }
}

