/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh;

import com.gitblit.Constants;
import com.gitblit.manager.IRuntimeManager;
import com.gitblit.transport.ssh.IPublicKeyManager;
import com.gitblit.transport.ssh.SshKey;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.Files;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FileKeyManager
extends IPublicKeyManager {
    protected final IRuntimeManager runtimeManager;
    protected final Map<File, Long> lastModifieds;

    @Inject
    public FileKeyManager(IRuntimeManager runtimeManager) {
        this.runtimeManager = runtimeManager;
        this.lastModifieds = new ConcurrentHashMap<File, Long>();
    }

    public String toString() {
        File dir = this.runtimeManager.getFileOrFolder("git.sshKeysFolder", "${baseFolder}/ssh");
        return MessageFormat.format("{0} ({1})", this.getClass().getSimpleName(), dir);
    }

    @Override
    public FileKeyManager start() {
        this.log.info(this.toString());
        return this;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public FileKeyManager stop() {
        return this;
    }

    @Override
    protected boolean isStale(String username) {
        File keystore = this.getKeystore(username);
        if (!keystore.exists()) {
            return true;
        }
        if (this.lastModifieds.containsKey(keystore)) {
            long lastModified = this.lastModifieds.get(keystore);
            return lastModified != keystore.lastModified();
        }
        return true;
    }

    @Override
    protected List<SshKey> getKeysImpl(String username) {
        try {
            this.log.info("loading ssh keystore for {}", (Object)username);
            File keystore = this.getKeystore(username);
            if (!keystore.exists()) {
                return null;
            }
            if (keystore.exists()) {
                ArrayList<SshKey> list = new ArrayList<SshKey>();
                for (String entry : Files.readLines((File)keystore, (Charset)Charsets.ISO_8859_1)) {
                    SshKey key;
                    if (entry.trim().length() == 0 || entry.charAt(0) == '#') continue;
                    String[] parts = entry.split(" ", 2);
                    Constants.AccessPermission perm = Constants.AccessPermission.fromCode(parts[0]);
                    if (perm.equals((Object)Constants.AccessPermission.NONE)) {
                        key = new SshKey(entry);
                        list.add(key);
                        continue;
                    }
                    if (!perm.exceeds(Constants.AccessPermission.NONE)) continue;
                    key = new SshKey(parts[1]);
                    key.setPermission(perm);
                    list.add(key);
                }
                if (list.isEmpty()) {
                    return null;
                }
                this.lastModifieds.put(keystore, keystore.lastModified());
                return list;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read ssh keys", e);
        }
        return null;
    }

    @Override
    public boolean addKey(String username, SshKey key) {
        try {
            boolean replaced = false;
            ArrayList<String> lines = new ArrayList<String>();
            File keystore = this.getKeystore(username);
            if (keystore.exists()) {
                for (String entry : Files.readLines((File)keystore, (Charset)Charsets.ISO_8859_1)) {
                    String line = entry.trim();
                    if (line.length() == 0) {
                        lines.add(entry);
                        continue;
                    }
                    if (line.charAt(0) == '#') {
                        lines.add(entry);
                        continue;
                    }
                    SshKey oldKey = this.parseKey(line);
                    if (key.equals(oldKey)) {
                        lines.add((Object)((Object)key.getPermission()) + " " + key.getRawData());
                        replaced = true;
                        continue;
                    }
                    lines.add(entry);
                }
            }
            if (!replaced) {
                lines.add((Object)((Object)key.getPermission()) + " " + key.getRawData());
            }
            String content = Joiner.on((String)"\n").join(lines).trim().concat("\n");
            Files.write((CharSequence)content, (File)keystore, (Charset)Charsets.ISO_8859_1);
            this.lastModifieds.remove(keystore);
            this.keyCache.invalidate((Object)username);
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot add ssh key", e);
        }
    }

    @Override
    public boolean removeKey(String username, SshKey key) {
        try {
            File keystore = this.getKeystore(username);
            if (keystore.exists()) {
                ArrayList<String> lines = new ArrayList<String>();
                for (String entry : Files.readLines((File)keystore, (Charset)Charsets.ISO_8859_1)) {
                    String line = entry.trim();
                    if (line.length() == 0) {
                        lines.add(entry);
                        continue;
                    }
                    if (line.charAt(0) == '#') {
                        lines.add(entry);
                        continue;
                    }
                    SshKey oldKey = this.parseKey(line);
                    if (key.equals(oldKey)) continue;
                    lines.add(entry);
                }
                if (lines.isEmpty()) {
                    keystore.delete();
                } else {
                    String content = Joiner.on((String)"\n").join(lines).trim().concat("\n");
                    Files.write((CharSequence)content, (File)keystore, (Charset)Charsets.ISO_8859_1);
                }
                this.lastModifieds.remove(keystore);
                this.keyCache.invalidate((Object)username);
                return true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot remove ssh key", e);
        }
        return false;
    }

    @Override
    public boolean removeAllKeys(String username) {
        File keystore = this.getKeystore(username);
        if (keystore.delete()) {
            this.lastModifieds.remove(keystore);
            this.keyCache.invalidate((Object)username);
            return true;
        }
        return false;
    }

    protected File getKeystore(String username) {
        File dir = this.runtimeManager.getFileOrFolder("git.sshKeysFolder", "${baseFolder}/ssh");
        dir.mkdirs();
        File keys = new File(dir, username + ".keys");
        return keys;
    }

    protected SshKey parseKey(String line) {
        String[] parts = line.split(" ", 2);
        Constants.AccessPermission perm = Constants.AccessPermission.fromCode(parts[0]);
        if (perm.equals((Object)Constants.AccessPermission.NONE)) {
            SshKey key = new SshKey(line);
            return key;
        }
        SshKey key = new SshKey(parts[1]);
        key.setPermission(perm);
        return key;
    }
}

