/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.sshd.common.config.keys.PrivateKeyEntryDecoder;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.util.OpenSSHPrivateKeyUtil;
import org.bouncycastle.crypto.util.OpenSSHPublicKeyUtil;
import org.bouncycastle.jcajce.spec.OpenSSHPrivateKeySpec;
import org.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class FileKeyPairProvider
extends AbstractKeyPairProvider {
    private String[] files;

    public FileKeyPairProvider() {
    }

    public FileKeyPairProvider(String[] files) {
        this.files = files;
    }

    public String[] getFiles() {
        return this.files;
    }

    public void setFiles(String[] files) {
        this.files = files;
    }

    public Iterable<KeyPair> loadKeys() {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            throw new IllegalStateException("BouncyCastle must be registered as a JCE provider");
        }
        return new Iterable<KeyPair>(){

            @Override
            public Iterator<KeyPair> iterator() {
                return new Iterator<KeyPair>(){
                    private final Iterator<String> iterator;
                    private KeyPair nextKeyPair;
                    private boolean nextKeyPairSet;
                    {
                        this.iterator = Arrays.asList(FileKeyPairProvider.this.files).iterator();
                        this.nextKeyPairSet = false;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextKeyPairSet || this.setNextObject();
                    }

                    @Override
                    public KeyPair next() {
                        if (!this.nextKeyPairSet && !this.setNextObject()) {
                            throw new NoSuchElementException();
                        }
                        this.nextKeyPairSet = false;
                        return this.nextKeyPair;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private boolean setNextObject() {
                        while (this.iterator.hasNext()) {
                            String file = this.iterator.next();
                            File f = new File(file);
                            if (!f.isFile()) {
                                FileKeyPairProvider.this.log.debug("File does not exist, skipping {}", (Object)file);
                                continue;
                            }
                            this.nextKeyPair = FileKeyPairProvider.this.doLoadKey(file);
                            if (this.nextKeyPair == null) continue;
                            this.nextKeyPairSet = true;
                            return true;
                        }
                        return false;
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KeyPair doLoadKey(String file) {
        try {
            try (PemReader r = new PemReader((Reader)new InputStreamReader(new FileInputStream(file)));){
                PemObject pemObject = r.readPemObject();
                if ("OPENSSH PRIVATE KEY".equals(pemObject.getType())) {
                    block48: {
                        try {
                            byte[] privateKeyContent = pemObject.getContent();
                            AsymmetricKeyParameter privateKeyParameters = OpenSSHPrivateKeyUtil.parsePrivateKeyBlob((byte[])privateKeyContent);
                            if (privateKeyParameters instanceof Ed25519PrivateKeyParameters) {
                                OpenSSHPrivateKeySpec privkeySpec = new OpenSSHPrivateKeySpec(privateKeyContent);
                                Ed25519PublicKeyParameters publicKeyParameters = ((Ed25519PrivateKeyParameters)privateKeyParameters).generatePublicKey();
                                OpenSSHPublicKeySpec pubKeySpec = new OpenSSHPublicKeySpec(OpenSSHPublicKeyUtil.encodePublicKey((AsymmetricKeyParameter)publicKeyParameters));
                                KeyFactory kf = KeyFactory.getInstance("Ed25519", "BC");
                                PrivateKey privateKey = kf.generatePrivate((KeySpec)privkeySpec);
                                PublicKey publicKey = kf.generatePublic((KeySpec)pubKeySpec);
                                KeyPair keyPair = new KeyPair(publicKey, privateKey);
                                return keyPair;
                            }
                        }
                        catch (Exception e) {
                            this.log.warn("Unable to read key " + file, (Throwable)e);
                            break block48;
                        }
                        {
                            this.log.warn("OpenSSH format is only supported for Ed25519 key type. Unable to read key " + file);
                        }
                    }
                    KeyPair e = null;
                    return e;
                }
                if ("EDDSA PRIVATE KEY".equals(pemObject.getType())) {
                    byte[] privateKeyContent = pemObject.getContent();
                    PrivateKeyEntryDecoder decoder = SecurityUtils.getOpenSSHEDDSAPrivateKeyEntryDecoder();
                    PrivateKey privateKey = decoder.decodePrivateKey(null, privateKeyContent, 0, privateKeyContent.length);
                    PublicKey publicKey = SecurityUtils.recoverEDDSAPublicKey((PrivateKey)privateKey);
                    KeyPair keyPair = new KeyPair(publicKey, privateKey);
                    return keyPair;
                }
            }
            r = new PEMParser((Reader)new InputStreamReader(new FileInputStream(file)));
            var3_4 = null;
            try {
                Object o = r.readObject();
                JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();
                pemConverter.setProvider("BC");
                if (o instanceof PEMKeyPair) {
                    o = pemConverter.getKeyPair((PEMKeyPair)o);
                    KeyPair keyPair = (KeyPair)o;
                    return keyPair;
                }
                if (o instanceof KeyPair) {
                    KeyPair keyPair = (KeyPair)o;
                    return keyPair;
                }
                this.log.warn("Cannot read unsupported PEM object of type: " + o.getClass().getCanonicalName());
                return null;
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
            finally {
                if (r != null) {
                    if (var3_4 != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        r.close();
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.warn("Unable to read key " + file, (Throwable)e);
        }
        return null;
    }
}

