/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh;

import com.gitblit.Constants;
import com.gitblit.IStoredSettings;
import com.gitblit.manager.IGitblit;
import com.gitblit.transport.ssh.DisabledFilesystemFactory;
import com.gitblit.transport.ssh.FileKeyPairProvider;
import com.gitblit.transport.ssh.NonForwardingFilter;
import com.gitblit.transport.ssh.SshKeyAuthenticator;
import com.gitblit.transport.ssh.SshKrbAuthenticator;
import com.gitblit.transport.ssh.SshServerSessionFactory;
import com.gitblit.transport.ssh.UsernamePasswordAuthenticator;
import com.gitblit.transport.ssh.WelcomeShell;
import com.gitblit.transport.ssh.commands.SshCommandFactory;
import com.gitblit.utils.JnaUtils;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.WorkQueue;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.io.mina.MinaServiceFactoryFactory;
import org.apache.sshd.common.io.nio2.Nio2ServiceFactoryFactory;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.util.security.SecurityProviderRegistrar;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.common.util.security.bouncycastle.BouncyCastleSecurityProviderRegistrar;
import org.apache.sshd.common.util.security.eddsa.EdDSASecurityProviderRegistrar;
import org.apache.sshd.common.util.security.eddsa.OpenSSHEd25519PrivateKeyEntryDecoder;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.CachingPublicKeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.apache.sshd.server.session.SessionFactory;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.OpenSSHPrivateKeyUtil;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.eclipse.jgit.internal.JGitText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshDaemon {
    private static final Logger log = LoggerFactory.getLogger(SshDaemon.class);
    private static final String AUTH_PUBLICKEY = "publickey";
    private static final String AUTH_PASSWORD = "password";
    private static final String AUTH_KBD_INTERACTIVE = "keyboard-interactive";
    private static final String AUTH_GSSAPI = "gssapi-with-mic";
    public static final int DEFAULT_PORT = 22;
    private final AtomicBoolean run;
    private final IGitblit gitblit;
    private final SshServer sshd;

    public SshDaemon(IGitblit gitblit, WorkQueue workQueue) {
        this.gitblit = gitblit;
        IStoredSettings settings = gitblit.getSettings();
        SecurityUtils.registerSecurityProvider((SecurityProviderRegistrar)new BouncyCastleSecurityProviderRegistrar());
        if (SecurityUtils.isBouncyCastleRegistered()) {
            log.info("BouncyCastle is registered as a JCE provider");
        }
        SecurityUtils.registerSecurityProvider((SecurityProviderRegistrar)new EdDSASecurityProviderRegistrar());
        if (SecurityUtils.isProviderRegistered((String)"EdDSA")) {
            log.info("EdDSA is registered as a JCE provider");
        }
        File rsaKeyStore = new File(gitblit.getBaseFolder(), "ssh-rsa-hostkey.pem");
        File dsaKeyStore = new File(gitblit.getBaseFolder(), "ssh-dsa-hostkey.pem");
        File ecdsaKeyStore = new File(gitblit.getBaseFolder(), "ssh-ecdsa-hostkey.pem");
        File eddsaKeyStore = new File(gitblit.getBaseFolder(), "ssh-eddsa-hostkey.pem");
        File ed25519KeyStore = new File(gitblit.getBaseFolder(), "ssh-ed25519-hostkey.pem");
        SshDaemon.generateKeyPair(rsaKeyStore, "RSA", 2048);
        SshDaemon.generateKeyPair(ecdsaKeyStore, "ECDSA", 256);
        SshDaemon.generateKeyPair(eddsaKeyStore, "EdDSA", 0);
        FileKeyPairProvider hostKeyPairProvider = new FileKeyPairProvider();
        hostKeyPairProvider.setFiles(new String[]{ecdsaKeyStore.getPath(), eddsaKeyStore.getPath(), ed25519KeyStore.getPath(), rsaKeyStore.getPath(), dsaKeyStore.getPath()});
        String sshBackendStr = settings.getString("git.sshBackend", SshSessionBackend.NIO2.name());
        SshSessionBackend backend = SshSessionBackend.valueOf(sshBackendStr);
        System.setProperty(IoServiceFactoryFactory.class.getName(), backend == SshSessionBackend.MINA ? MinaServiceFactoryFactory.class.getName() : Nio2ServiceFactoryFactory.class.getName());
        int port = settings.getInteger("git.sshPort", 0);
        String bindInterface = settings.getString("git.sshBindInterface", "");
        InetSocketAddress addr = StringUtils.isEmpty(bindInterface) ? new InetSocketAddress(port) : new InetSocketAddress(bindInterface, port);
        this.sshd = SshServer.setUpDefaultServer();
        this.sshd.setPort(addr.getPort());
        this.sshd.setHost(addr.getHostName());
        this.sshd.setKeyPairProvider((KeyPairProvider)hostKeyPairProvider);
        List<String> authMethods = settings.getStrings("git.sshAuthenticationMethods");
        if (authMethods.isEmpty()) {
            authMethods.add(AUTH_PUBLICKEY);
            authMethods.add(AUTH_PASSWORD);
        }
        if (settings.getBoolean("git.sshWithKrb5", false) && !authMethods.contains(AUTH_GSSAPI)) {
            authMethods.add(AUTH_GSSAPI);
            log.warn("git.sshWithKrb5 is obsolete!");
            log.warn("Please add {} to {} in gitblit.properties!", (Object)AUTH_GSSAPI, (Object)"git.sshAuthenticationMethods");
            settings.overrideSetting("git.sshAuthenticationMethods", settings.getString("git.sshAuthenticationMethods", "publickey password") + " " + AUTH_GSSAPI);
        }
        if (authMethods.contains(AUTH_PUBLICKEY)) {
            SshKeyAuthenticator keyAuthenticator = new SshKeyAuthenticator(gitblit.getPublicKeyManager(), gitblit);
            this.sshd.setPublickeyAuthenticator((PublickeyAuthenticator)new CachingPublicKeyAuthenticator((PublickeyAuthenticator)keyAuthenticator));
            log.info("SSH: adding public key authentication method.");
        }
        if (authMethods.contains(AUTH_PASSWORD) || authMethods.contains(AUTH_KBD_INTERACTIVE)) {
            this.sshd.setPasswordAuthenticator((PasswordAuthenticator)new UsernamePasswordAuthenticator(gitblit));
            log.info("SSH: adding password authentication method.");
        }
        if (authMethods.contains(AUTH_GSSAPI)) {
            this.sshd.setGSSAuthenticator((GSSAuthenticator)new SshKrbAuthenticator(settings, gitblit));
            log.info("SSH: adding GSSAPI authentication method.");
        }
        this.sshd.setSessionFactory((SessionFactory)new SshServerSessionFactory((ServerFactoryManager)this.sshd));
        this.sshd.setFileSystemFactory((FileSystemFactory)new DisabledFilesystemFactory());
        this.sshd.setForwardingFilter((ForwardingFilter)new NonForwardingFilter());
        this.sshd.setCommandFactory((CommandFactory)new SshCommandFactory(gitblit, workQueue));
        this.sshd.setShellFactory((Factory)new WelcomeShell(gitblit));
        String version = String.format("%s (%s-%s)", Constants.getGitBlitVersion().replace(' ', '_'), this.sshd.getVersion(), sshBackendStr);
        this.sshd.getProperties().put("server-identification", version);
        this.run = new AtomicBoolean(false);
    }

    public String formatUrl(String gituser, String servername, String repository) {
        IStoredSettings settings = this.gitblit.getSettings();
        int port = this.sshd.getPort();
        int displayPort = settings.getInteger("git.sshAdvertisedPort", port);
        String displayServername = settings.getString("git.sshAdvertisedHost", "");
        if (displayServername.isEmpty()) {
            displayServername = servername;
        }
        if (displayPort == 22) {
            return MessageFormat.format("ssh://{0}@{1}/{2}", gituser, displayServername, repository);
        }
        return MessageFormat.format("ssh://{0}@{1}:{2,number,0}/{3}", gituser, displayServername, displayPort, repository);
    }

    public synchronized void start() throws IOException {
        if (this.run.get()) {
            throw new IllegalStateException(JGitText.get().daemonAlreadyRunning);
        }
        this.sshd.start();
        this.run.set(true);
        String sshBackendStr = this.gitblit.getSettings().getString("git.sshBackend", SshSessionBackend.NIO2.name());
        log.info(MessageFormat.format("SSH Daemon ({0}) is listening on {1}:{2,number,0}", sshBackendStr, this.sshd.getHost(), this.sshd.getPort()));
    }

    public boolean isRunning() {
        return this.run.get();
    }

    public synchronized void stop() {
        if (this.run.get()) {
            log.info("SSH Daemon stopping...");
            this.run.set(false);
            try {
                ((SshCommandFactory)this.sshd.getCommandFactory()).stop();
                this.sshd.stop();
            }
            catch (IOException e) {
                log.error("SSH Daemon stop interrupted", (Throwable)e);
            }
        }
    }

    static void generateKeyPair(File file, String algorithm, int keySize) {
        if (file.exists()) {
            return;
        }
        try {
            KeyPairGenerator generator = SecurityUtils.getKeyPairGenerator((String)algorithm);
            if (keySize != 0) {
                generator.initialize(keySize);
                log.info("Generating {}-{} SSH host keypair...", (Object)algorithm, (Object)keySize);
            } else {
                log.info("Generating {} SSH host keypair...", (Object)algorithm);
            }
            KeyPair kp = generator.generateKeyPair();
            Files.touch((File)file);
            try {
                JnaUtils.setFilemode(file, 384);
            }
            catch (UnsatisfiedLinkError | UnsupportedOperationException throwable) {
                // empty catch block
            }
            FileOutputStream os = new FileOutputStream(file);
            PemWriter w = new PemWriter((Writer)new OutputStreamWriter(os));
            if (algorithm.equals("ED25519")) {
                AsymmetricKeyParameter keyParam = PrivateKeyFactory.createKey((byte[])kp.getPrivate().getEncoded());
                byte[] encKey = OpenSSHPrivateKeyUtil.encodePrivateKey((AsymmetricKeyParameter)keyParam);
                w.writeObject((PemObjectGenerator)new PemObject("OPENSSH PRIVATE KEY", encKey));
            } else if (algorithm.equals("EdDSA")) {
                PrivateKey privateKey = kp.getPrivate();
                if (privateKey instanceof EdDSAPrivateKey) {
                    OpenSSHEd25519PrivateKeyEntryDecoder encoder = (OpenSSHEd25519PrivateKeyEntryDecoder)SecurityUtils.getOpenSSHEDDSAPrivateKeyEntryDecoder();
                    EdDSAPrivateKey dsaPrivateKey = (EdDSAPrivateKey)privateKey;
                    ByteArrayOutputStream encos = new ByteArrayOutputStream();
                    String type = encoder.encodePrivateKey((OutputStream)encos, dsaPrivateKey);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    KeyEntryResolver.encodeString((OutputStream)bos, (String)type);
                    encos.writeTo(bos);
                    w.writeObject((PemObjectGenerator)new PemObject("EDDSA PRIVATE KEY", bos.toByteArray()));
                } else {
                    log.warn("Unable to encode EdDSA key, got key type " + privateKey.getClass().getCanonicalName());
                }
            } else {
                w.writeObject((PemObjectGenerator)new JcaMiscPEMGenerator((Object)kp));
            }
            w.flush();
            w.close();
        }
        catch (Exception e) {
            log.warn(MessageFormat.format("Unable to generate {0} keypair", algorithm), (Throwable)e);
        }
    }

    public static enum SshSessionBackend {
        MINA,
        NIO2;

    }
}

