/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh;

import com.gitblit.Constants;
import com.gitblit.utils.StringUtils;
import com.google.common.base.Joiner;
import java.io.Serializable;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.eclipse.jgit.lib.Constants;

public class SshKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String rawData;
    private PublicKey publicKey;
    private String comment;
    private String fingerprint;
    private String toString;
    private Constants.AccessPermission permission;

    public SshKey(String data) {
        this.rawData = Joiner.on((String)"").join((Object[])data.replace("\r\n", "\n").split("\n"));
        this.permission = Constants.AccessPermission.PUSH;
    }

    public SshKey(PublicKey key) {
        this.publicKey = key;
        this.comment = "";
        this.permission = Constants.AccessPermission.PUSH;
    }

    public PublicKey getPublicKey() {
        if (this.publicKey == null && this.rawData != null) {
            String[] parts = this.rawData.split(" ", 3);
            if (this.comment == null && parts.length == 3) {
                this.comment = parts[2];
            }
            byte[] bin = Base64.decodeBase64((byte[])Constants.encodeASCII((String)parts[1]));
            try {
                this.publicKey = new ByteArrayBuffer(bin).getRawPublicKey();
            }
            catch (SshException e) {
                throw new RuntimeException(e);
            }
        }
        return this.publicKey;
    }

    public void detachPublicKey() {
        if (this.rawData == null) {
            this.getRawData();
        }
        this.publicKey = null;
    }

    public String getAlgorithm() {
        return this.getPublicKey().getAlgorithm();
    }

    public String getComment() {
        String[] parts;
        if (this.comment == null && this.rawData != null && (parts = this.rawData.split(" ", 3)).length == 3) {
            this.comment = parts[2];
        }
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
        if (this.rawData != null) {
            this.rawData = null;
        }
    }

    public boolean canClone() {
        return this.permission.atLeast(Constants.AccessPermission.CLONE);
    }

    public boolean canPush() {
        return this.permission.atLeast(Constants.AccessPermission.PUSH);
    }

    public Constants.AccessPermission getPermission() {
        return this.permission;
    }

    public void setPermission(Constants.AccessPermission value) throws IllegalArgumentException {
        List<Constants.AccessPermission> permitted = Arrays.asList(Constants.AccessPermission.SSHPERMISSIONS);
        if (!permitted.contains((Object)value)) {
            throw new IllegalArgumentException("Illegal SSH public key permission specified: " + (Object)((Object)value));
        }
        this.permission = value;
    }

    public String getRawData() {
        if (this.rawData == null && this.publicKey != null) {
            ByteArrayBuffer buf = new ByteArrayBuffer();
            buf.putRawPublicKey(this.publicKey);
            String alg = buf.getString();
            buf.clear();
            buf.putPublicKey(this.publicKey);
            String b64 = Base64.encodeBase64String((byte[])buf.getBytes());
            String c = this.getComment();
            this.rawData = alg + " " + b64 + (StringUtils.isEmpty(c) ? "" : " " + c);
        }
        return this.rawData;
    }

    public String getFingerprint() {
        if (this.fingerprint == null) {
            String hash;
            StringBuilder sb = new StringBuilder();
            if (this.rawData != null) {
                String[] parts = this.rawData.split(" ", 3);
                byte[] bin = Base64.decodeBase64((byte[])Constants.encodeASCII((String)parts[1]));
                hash = StringUtils.getMD5(bin);
            } else {
                hash = StringUtils.getMD5(this.getPublicKey().getEncoded());
            }
            for (int i = 0; i < hash.length(); i += 2) {
                sb.append(hash.charAt(i)).append(hash.charAt(i + 1)).append(':');
            }
            sb.setLength(sb.length() - 1);
            this.fingerprint = sb.toString();
        }
        return this.fingerprint;
    }

    public boolean equals(Object o) {
        if (o instanceof PublicKey) {
            return this.getPublicKey().equals(o);
        }
        if (o instanceof SshKey) {
            return this.getPublicKey().equals(((SshKey)o).getPublicKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getPublicKey().hashCode();
    }

    public String toString() {
        if (this.toString == null) {
            String alg;
            StringBuilder sb = new StringBuilder();
            int keySize = 0;
            if (keySize > 0) {
                sb.append(keySize).append(' ');
            }
            sb.append(' ');
            sb.append(this.getFingerprint());
            String c = this.getComment();
            if (!StringUtils.isEmpty(c)) {
                sb.append(' ');
                sb.append(c);
            }
            if (!StringUtils.isEmpty(alg = this.getAlgorithm())) {
                sb.append(" (").append(alg).append(")");
            }
            this.toString = sb.toString();
        }
        return this.toString;
    }
}

