/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh;

import com.gitblit.manager.IAuthenticationManager;
import com.gitblit.models.UserModel;
import com.gitblit.transport.ssh.IPublicKeyManager;
import com.gitblit.transport.ssh.SshDaemonClient;
import com.gitblit.transport.ssh.SshKey;
import com.google.common.base.Preconditions;
import java.security.PublicKey;
import java.util.List;
import java.util.Locale;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshKeyAuthenticator
implements PublickeyAuthenticator {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final IPublicKeyManager keyManager;
    protected final IAuthenticationManager authManager;

    public SshKeyAuthenticator(IPublicKeyManager keyManager, IAuthenticationManager authManager) {
        this.keyManager = keyManager;
        this.authManager = authManager;
    }

    public boolean authenticate(String username, PublicKey suppliedKey, ServerSession session) {
        SshDaemonClient client = (SshDaemonClient)session.getAttribute(SshDaemonClient.KEY);
        Preconditions.checkState((client.getUser() == null ? 1 : 0) != 0);
        username = username.toLowerCase(Locale.US);
        List<SshKey> keys = this.keyManager.getKeys(username);
        if (keys.isEmpty()) {
            this.log.info("{} has not added any public keys for ssh authentication", (Object)username);
            return false;
        }
        SshKey pk = new SshKey(suppliedKey);
        this.log.debug("auth supplied {}", (Object)pk.getFingerprint());
        for (SshKey key : keys) {
            UserModel user;
            this.log.debug("auth compare to {}", (Object)key.getFingerprint());
            if (!key.getPublicKey().equals(suppliedKey) || (user = this.authManager.authenticate(username, key)) == null) continue;
            client.setUser(user);
            client.setKey(key);
            return true;
        }
        this.log.warn("could not authenticate {} for SSH using the supplied public key", (Object)username);
        return false;
    }
}

