/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh;

import com.gitblit.Constants;
import com.gitblit.IStoredSettings;
import com.gitblit.manager.IGitblit;
import com.gitblit.models.UserModel;
import com.gitblit.transport.ssh.IPublicKeyManager;
import com.gitblit.transport.ssh.SshDaemonClient;
import com.gitblit.transport.ssh.commands.RootDispatcher;
import com.gitblit.transport.ssh.commands.SshCommandFactory;
import com.gitblit.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.sshd.common.Factory;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;
import org.eclipse.jgit.util.SystemReader;

public class WelcomeShell
implements Factory<Command> {
    private final IGitblit gitblit;

    public WelcomeShell(IGitblit gitblit) {
        this.gitblit = gitblit;
    }

    public Command create() {
        return new SendMessage(this.gitblit);
    }

    public Command get() {
        return this.create();
    }

    private static class SendMessage
    implements Command,
    SessionAware {
        private final IPublicKeyManager km;
        private final IStoredSettings settings;
        private ServerSession session;
        private InputStream in;
        private OutputStream out;
        private OutputStream err;
        private ExitCallback exit;

        SendMessage(IGitblit gitblit) {
            this.km = gitblit.getPublicKeyManager();
            this.settings = gitblit.getSettings();
        }

        public void setInputStream(InputStream in) {
            this.in = in;
        }

        public void setOutputStream(OutputStream out) {
            this.out = out;
        }

        public void setErrorStream(OutputStream err) {
            this.err = err;
        }

        public void setExitCallback(ExitCallback callback) {
            this.exit = callback;
        }

        public void setSession(ServerSession session) {
            this.session = session;
        }

        public void start(Environment env) throws IOException {
            this.err.write(org.eclipse.jgit.lib.Constants.encode((String)this.getMessage()));
            this.err.flush();
            this.in.close();
            this.out.close();
            this.err.close();
            this.exit.onExit(127);
        }

        public void destroy() {
            this.session = null;
        }

        String getMessage() {
            SshDaemonClient client = (SshDaemonClient)this.session.getAttribute(SshDaemonClient.KEY);
            UserModel user = client.getUser();
            String hostname = this.getHostname();
            int port = this.settings.getInteger("git.sshPort", 0);
            boolean writeKeysIsSupported = true;
            if (this.km != null) {
                writeKeysIsSupported = this.km.supportsWritingKeys(user);
            }
            String b1 = StringUtils.rightPad("", 72, '\u2550');
            String b2 = StringUtils.rightPad("", 72, '\u2500');
            String nl = "\r\n";
            StringBuilder msg = new StringBuilder();
            msg.append("\r\n");
            msg.append(b1);
            msg.append("\r\n");
            msg.append(" ");
            msg.append(Constants.getGitBlitVersion());
            msg.append("\r\n");
            msg.append(b1);
            msg.append("\r\n");
            msg.append("\r\n");
            msg.append(" Hi ");
            msg.append(user.getDisplayName());
            msg.append(", you have successfully connected over SSH.");
            msg.append("\r\n");
            msg.append(" Interactive shells are not available.");
            msg.append("\r\n");
            msg.append("\r\n");
            msg.append("   client:   ");
            msg.append(this.session.getClientVersion());
            msg.append("\r\n");
            msg.append("\r\n");
            msg.append(b2);
            msg.append("\r\n");
            msg.append("\r\n");
            msg.append(" You may clone a repository with the following Git syntax:");
            msg.append("\r\n");
            msg.append("\r\n");
            msg.append("   git clone ");
            msg.append(this.formatUrl(hostname, port, user.username));
            msg.append("\r\n");
            msg.append("\r\n");
            msg.append(b2);
            msg.append("\r\n");
            msg.append("\r\n");
            if (writeKeysIsSupported && client.getKey() == null) {
                msg.append(" You may upload an SSH public key with the following syntax:");
                msg.append("\r\n");
                msg.append("\r\n");
                msg.append(String.format("   cat ~/.ssh/id_rsa.pub | ssh -l %s -p %d %s keys add", user.username, port, hostname));
                msg.append("\r\n");
                msg.append("\r\n");
                msg.append(b2);
                msg.append("\r\n");
                msg.append("\r\n");
            }
            SshCommandFactory cmdFactory = (SshCommandFactory)this.session.getFactoryManager().getCommandFactory();
            RootDispatcher root = cmdFactory.createRootDispatcher(client, "");
            String usage = root.usage().replace("\n", "\r\n");
            msg.append(usage);
            return msg.toString();
        }

        private String getHostname() {
            String host = null;
            String url = this.settings.getString("web.canonicalUrl", "https://localhost:8443");
            if (url != null) {
                try {
                    host = new URL(url).getHost();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (StringUtils.isEmpty(host)) {
                host = SystemReader.getInstance().getHostname();
            }
            return host;
        }

        private String formatUrl(String hostname, int port, String username) {
            int displayPort = this.settings.getInteger("git.sshAdvertisedPort", port);
            String displayHostname = this.settings.getString("git.sshAdvertisedHost", "");
            if (displayHostname.isEmpty()) {
                displayHostname = hostname;
            }
            if (displayPort == 22) {
                return MessageFormat.format("{0}@{1}/REPOSITORY.git", username, displayHostname);
            }
            return MessageFormat.format("ssh://{0}@{1}:{2,number,0}/REPOSITORY.git", username, displayHostname, displayPort);
        }
    }
}

