/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh.commands;

import com.gitblit.transport.ssh.commands.CommandMetaData;
import com.gitblit.transport.ssh.commands.SshCommandContext;
import com.gitblit.transport.ssh.commands.UsageExample;
import com.gitblit.transport.ssh.commands.UsageExamples;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.WorkQueue;
import com.gitblit.utils.cli.CmdLineParser;
import com.google.common.base.Charsets;
import com.google.common.util.concurrent.Atomics;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.SshException;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;
import org.kohsuke.args4j.CmdLineException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCommand
implements Command,
SessionAware {
    private static final Logger log = LoggerFactory.getLogger(BaseCommand.class);
    private static final int PRIVATE_STATUS = 0x40000000;
    public static final int STATUS_CANCEL = 0x40000001;
    public static final int STATUS_NOT_FOUND = 0x40000002;
    public static final int STATUS_NOT_ADMIN = 0x40000003;
    protected InputStream in;
    protected OutputStream out;
    protected OutputStream err;
    protected ExitCallback exit;
    protected ServerSession session;
    private SshCommandContext ctx;
    private String commandName = "";
    private String[] argv;
    private final AtomicReference<Future<?>> task = Atomics.newReference();
    private WorkQueue workQueue;

    public void setSession(ServerSession session) {
        this.session = session;
    }

    public void destroy() {
        log.debug("destroying " + this.getClass().getName());
        Future future = this.task.getAndSet(null);
        if (future != null && !future.isDone()) {
            future.cancel(true);
        }
        this.session = null;
        this.ctx = null;
    }

    protected static PrintWriter toPrintWriter(OutputStream o) {
        return new PrintWriter(new BufferedWriter(new OutputStreamWriter(o, Charsets.UTF_8)));
    }

    public abstract void start(Environment var1) throws IOException;

    protected void provideStateTo(BaseCommand cmd) {
        cmd.setContext(this.ctx);
        cmd.setWorkQueue(this.workQueue);
        cmd.setInputStream(this.in);
        cmd.setOutputStream(this.out);
        cmd.setErrorStream(this.err);
        cmd.setExitCallback(this.exit);
    }

    public WorkQueue getWorkQueue() {
        return this.workQueue;
    }

    public void setWorkQueue(WorkQueue workQueue) {
        this.workQueue = workQueue;
    }

    public void setContext(SshCommandContext ctx) {
        this.ctx = ctx;
    }

    public SshCommandContext getContext() {
        return this.ctx;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public void setExitCallback(ExitCallback callback) {
        this.exit = callback;
    }

    protected String getName() {
        return this.commandName;
    }

    void setName(String prefix) {
        this.commandName = prefix;
    }

    public String[] getArguments() {
        return this.argv;
    }

    public void setArguments(String[] argv) {
        this.argv = argv;
    }

    protected void parseCommandLine() throws UnloggedFailure {
        this.parseCommandLine(this);
    }

    protected void parseCommandLine(Object options) throws UnloggedFailure {
        CmdLineParser clp;
        block7: {
            clp = this.newCmdLineParser(options);
            try {
                clp.parseArgument(this.argv);
            }
            catch (IllegalArgumentException err) {
                if (!clp.wasHelpRequestedByOption()) {
                    throw new UnloggedFailure(1, "fatal: " + err.getMessage());
                }
            }
            catch (CmdLineException err) {
                if (clp.wasHelpRequestedByOption()) break block7;
                throw new UnloggedFailure(1, "fatal: " + err.getMessage());
            }
        }
        if (clp.wasHelpRequestedByOption()) {
            CommandMetaData meta = this.getClass().getAnnotation(CommandMetaData.class);
            String title = meta.name().toUpperCase() + ": " + meta.description();
            String b = StringUtils.leftPad("", title.length() + 2, '\u2550');
            StringWriter msg = new StringWriter();
            msg.write(10);
            msg.write(b);
            msg.write(10);
            msg.write(32);
            msg.write(title);
            msg.write(10);
            msg.write(b);
            msg.write("\n\n");
            msg.write("USAGE\n");
            msg.write("\u2500\u2500\u2500\u2500\u2500\n");
            msg.write(32);
            msg.write(this.commandName);
            msg.write(10);
            msg.write("  ");
            clp.printSingleLineUsage(msg, null);
            msg.write("\n\n");
            String txt = this.getUsageText();
            if (!StringUtils.isEmpty(txt)) {
                msg.write(txt);
                msg.write("\n\n");
            }
            msg.write("ARGUMENTS & OPTIONS\n");
            msg.write("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n");
            clp.printUsage(msg, null);
            msg.write(10);
            String examples = this.usage().trim();
            if (!StringUtils.isEmpty(examples)) {
                msg.write(10);
                msg.write("EXAMPLES\n");
                msg.write("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n");
                msg.write(examples);
                msg.write(10);
            }
            throw new UnloggedFailure(1, msg.toString());
        }
    }

    protected CmdLineParser newCmdLineParser(Object options) {
        return new CmdLineParser(options);
    }

    public String usage() {
        Class<?> clazz = this.getClass();
        if (clazz.isAnnotationPresent(UsageExamples.class)) {
            return this.examples(clazz.getAnnotation(UsageExamples.class).examples());
        }
        if (clazz.isAnnotationPresent(UsageExample.class)) {
            return this.examples(clazz.getAnnotation(UsageExample.class));
        }
        return "";
    }

    protected String getUsageText() {
        return "";
    }

    protected String examples(UsageExample ... examples) {
        int sshPort = this.getContext().getGitblit().getSettings().getInteger("git.sshPort", 29418);
        String username = this.getContext().getClient().getUsername();
        String hostname = "localhost";
        String ssh = String.format("ssh -l %s -p %d %s", username, sshPort, hostname);
        StringBuilder sb = new StringBuilder();
        for (UsageExample example : examples) {
            sb.append(example.description()).append("\n\n");
            String syntax = example.syntax();
            syntax = syntax.replace("${ssh}", ssh);
            syntax = syntax.replace("${username}", username);
            syntax = syntax.replace("${cmd}", this.commandName);
            sb.append("   ").append(syntax).append("\n\n");
        }
        return sb.toString();
    }

    protected void showHelp() throws UnloggedFailure {
        this.argv = new String[]{"--help"};
        this.parseCommandLine();
    }

    protected void startThread(final Runnable thunk) {
        this.startThread(new CommandRunnable(){

            @Override
            public void run() throws Exception {
                thunk.run();
            }
        });
    }

    protected void onExit(int rc) {
        this.exit.onExit(rc);
    }

    private int handleError(Throwable e) {
        if (e.getClass() == IOException.class && "Pipe closed".equals(e.getMessage()) || e.getClass() == SshException.class && "Already closed".equals(e.getMessage()) || e.getClass() == InterruptedIOException.class) {
            return 127;
        }
        if (!(e instanceof UnloggedFailure)) {
            StringBuilder m = new StringBuilder();
            m.append("Internal server error");
            String user = this.ctx.getClient().getUsername();
            if (user != null) {
                m.append(" (user ");
                m.append(user);
                m.append(")");
            }
            m.append(" during ");
            m.append(this.ctx.getCommandLine());
            log.error(m.toString(), e);
        }
        if (e instanceof Failure) {
            Failure f = (Failure)e;
            try {
                this.err.write((f.getMessage() + "\n").getBytes(Charsets.UTF_8));
                this.err.flush();
            }
            catch (IOException user) {
            }
            catch (Throwable e2) {
                log.warn("Cannot send failure message to client", e2);
            }
            return f.exitCode;
        }
        try {
            this.err.write("fatal: internal server error\n".getBytes(Charsets.UTF_8));
            this.err.flush();
        }
        catch (IOException f) {
        }
        catch (Throwable e2) {
            log.warn("Cannot send internal server error message to client", e2);
        }
        return 128;
    }

    protected void startThread(CommandRunnable thunk) {
        TaskThunk tt = new TaskThunk(thunk);
        this.task.set(this.workQueue.getDefaultQueue().submit(tt));
    }

    public static class UnloggedFailure
    extends Failure {
        private static final long serialVersionUID = 1L;

        public UnloggedFailure(String msg) {
            this(1, msg);
        }

        public UnloggedFailure(int exitCode, String msg) {
            this(exitCode, msg, null);
        }

        public UnloggedFailure(int exitCode, String msg, Throwable why) {
            super(exitCode, msg, why);
        }
    }

    public static class Failure
    extends Exception {
        private static final long serialVersionUID = 1L;
        final int exitCode;

        public Failure(int exitCode, String msg) {
            this(exitCode, msg, null);
        }

        public Failure(int exitCode, String msg, Throwable why) {
            super(msg, why);
            this.exitCode = exitCode;
        }
    }

    public static interface RepositoryCommandRunnable
    extends CommandRunnable {
        public String getRepository();
    }

    public static interface CommandRunnable {
        public void run() throws Exception;
    }

    private final class TaskThunk
    implements WorkQueue.CancelableRunnable {
        private final CommandRunnable thunk;
        private final String taskName;

        private TaskThunk(CommandRunnable thunk) {
            this.thunk = thunk;
            StringBuilder m = new StringBuilder();
            m.append(BaseCommand.this.ctx.getCommandLine());
            this.taskName = m.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            TaskThunk taskThunk = this;
            synchronized (taskThunk) {
                try {
                    BaseCommand.this.onExit(0x40000001);
                }
                finally {
                    BaseCommand.this.ctx = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TaskThunk taskThunk = this;
            synchronized (taskThunk) {
                Thread thisThread = Thread.currentThread();
                String thisName = thisThread.getName();
                int rc = 0;
                try {
                    thisThread.setName("SSH " + this.taskName);
                    this.thunk.run();
                    BaseCommand.this.out.flush();
                    BaseCommand.this.err.flush();
                }
                catch (Throwable e) {
                    try {
                        BaseCommand.this.out.flush();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        BaseCommand.this.err.flush();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    rc = BaseCommand.this.handleError(e);
                }
                finally {
                    try {
                        BaseCommand.this.onExit(rc);
                    }
                    finally {
                        thisThread.setName(thisName);
                    }
                }
            }
        }

        public String toString() {
            return this.taskName;
        }
    }
}

