/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh.commands;

import com.gitblit.models.UserModel;
import com.gitblit.transport.ssh.commands.BaseCommand;
import com.gitblit.transport.ssh.commands.CommandMetaData;
import com.gitblit.utils.StringUtils;
import com.gitblit.utils.cli.SubcommandHandler;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.sshd.server.Environment;
import org.kohsuke.args4j.Argument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.fortsoft.pf4j.ExtensionPoint;

public abstract class DispatchCommand
extends BaseCommand
implements ExtensionPoint {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Argument(index=0, required=false, metaVar="COMMAND", handler=SubcommandHandler.class)
    private String commandName;
    @Argument(index=1, multiValued=true, metaVar="ARG")
    private List<String> args = new ArrayList<String>();
    private final Set<Class<? extends BaseCommand>> commands = new HashSet<Class<? extends BaseCommand>>();
    private final Map<String, DispatchCommand> dispatchers = Maps.newHashMap();
    private final Map<String, String> aliasToCommand = Maps.newHashMap();
    private final Map<String, List<String>> commandToAliases = Maps.newHashMap();
    private final List<BaseCommand> instantiated = new ArrayList<BaseCommand>();
    private Map<String, Class<? extends BaseCommand>> map;

    protected DispatchCommand() {
    }

    @Override
    public void destroy() {
        super.destroy();
        this.commands.clear();
        this.aliasToCommand.clear();
        this.commandToAliases.clear();
        this.map = null;
        for (BaseCommand command : this.instantiated) {
            command.destroy();
        }
        this.instantiated.clear();
        for (DispatchCommand dispatcher : this.dispatchers.values()) {
            dispatcher.destroy();
        }
        this.dispatchers.clear();
    }

    protected abstract void setup();

    protected final void register(Class<? extends BaseCommand> clazz) {
        if (DispatchCommand.class.isAssignableFrom(clazz)) {
            this.registerDispatcher(clazz);
            return;
        }
        this.registerCommand(clazz);
    }

    protected final void register(BaseCommand cmd) {
        if (cmd instanceof DispatchCommand) {
            this.registerDispatcher((DispatchCommand)cmd);
            return;
        }
        this.registerCommand(cmd);
    }

    private void registerDispatcher(Class<? extends DispatchCommand> clazz) {
        try {
            DispatchCommand dispatcher = clazz.newInstance();
            this.registerDispatcher(dispatcher);
        }
        catch (Exception e) {
            this.log.error("failed to instantiate {}", (Object)clazz.getName());
        }
    }

    private void registerDispatcher(DispatchCommand dispatcher) {
        Class<?> dispatcherClass = dispatcher.getClass();
        if (!dispatcherClass.isAnnotationPresent(CommandMetaData.class)) {
            throw new RuntimeException(MessageFormat.format("{0} must be annotated with {1}!", dispatcher.getName(), CommandMetaData.class.getName()));
        }
        UserModel user = this.getContext().getClient().getUser();
        CommandMetaData meta = dispatcherClass.getAnnotation(CommandMetaData.class);
        if (meta.admin() && !user.canAdmin()) {
            this.log.debug(MessageFormat.format("excluding admin dispatcher {0} for {1}", meta.name(), user.username));
            return;
        }
        try {
            dispatcher.setContext(this.getContext());
            dispatcher.setWorkQueue(this.getWorkQueue());
            dispatcher.setup();
            if (dispatcher.commands.isEmpty() && dispatcher.dispatchers.isEmpty()) {
                this.log.debug(MessageFormat.format("excluding empty dispatcher {0} for {1}", meta.name(), user.username));
                return;
            }
            this.log.debug("registering {} dispatcher", (Object)meta.name());
            this.dispatchers.put(meta.name(), dispatcher);
            for (String alias : meta.aliases()) {
                this.aliasToCommand.put(alias, meta.name());
                if (!this.commandToAliases.containsKey(meta.name())) {
                    this.commandToAliases.put(meta.name(), new ArrayList());
                }
                this.commandToAliases.get(meta.name()).add(alias);
            }
        }
        catch (Exception e) {
            this.log.error("failed to register {} dispatcher", (Object)meta.name());
        }
    }

    private void registerCommand(Class<? extends BaseCommand> clazz) {
        if (!clazz.isAnnotationPresent(CommandMetaData.class)) {
            throw new RuntimeException(MessageFormat.format("{0} must be annotated with {1}!", clazz.getName(), CommandMetaData.class.getName()));
        }
        UserModel user = this.getContext().getClient().getUser();
        CommandMetaData meta = clazz.getAnnotation(CommandMetaData.class);
        if (meta.admin() && !user.canAdmin()) {
            this.log.debug(MessageFormat.format("excluding admin command {0} for {1}", meta.name(), user.username));
            return;
        }
        this.commands.add(clazz);
    }

    private void registerCommand(BaseCommand cmd) {
        if (!cmd.getClass().isAnnotationPresent(CommandMetaData.class)) {
            throw new RuntimeException(MessageFormat.format("{0} must be annotated with {1}!", cmd.getName(), CommandMetaData.class.getName()));
        }
        UserModel user = this.getContext().getClient().getUser();
        CommandMetaData meta = cmd.getClass().getAnnotation(CommandMetaData.class);
        if (meta.admin() && !user.canAdmin()) {
            this.log.debug(MessageFormat.format("excluding admin command {0} for {1}", meta.name(), user.username));
            return;
        }
        this.commands.add(cmd.getClass());
        this.instantiated.add(cmd);
    }

    private Map<String, Class<? extends BaseCommand>> getMap() {
        if (this.map == null) {
            this.map = Maps.newHashMapWithExpectedSize((int)this.commands.size());
            for (Class<? extends BaseCommand> clazz : this.commands) {
                CommandMetaData meta = clazz.getAnnotation(CommandMetaData.class);
                if (this.map.containsKey(meta.name()) || this.aliasToCommand.containsKey(meta.name())) {
                    this.log.warn("{} already contains the \"{}\" command!", (Object)this.getName(), (Object)meta.name());
                } else {
                    this.map.put(meta.name(), clazz);
                }
                for (String alias : meta.aliases()) {
                    if (this.map.containsKey(alias) || this.aliasToCommand.containsKey(alias)) {
                        this.log.warn("{} already contains the \"{}\" command!", (Object)this.getName(), (Object)alias);
                        continue;
                    }
                    this.aliasToCommand.put(alias, meta.name());
                    if (!this.commandToAliases.containsKey(meta.name())) {
                        this.commandToAliases.put(meta.name(), new ArrayList());
                    }
                    this.commandToAliases.get(meta.name()).add(alias);
                }
            }
            for (Map.Entry entry : this.dispatchers.entrySet()) {
                this.map.put((String)entry.getKey(), (Class<? extends BaseCommand>)((DispatchCommand)entry.getValue()).getClass());
            }
        }
        return this.map;
    }

    @Override
    public void start(Environment env) throws IOException {
        try {
            this.parseCommandLine();
            if (Strings.isNullOrEmpty((String)this.commandName)) {
                StringWriter msg = new StringWriter();
                msg.write(this.usage());
                throw new BaseCommand.UnloggedFailure(1, msg.toString());
            }
            BaseCommand cmd = this.getCommand();
            if (this.getName().isEmpty()) {
                cmd.setName(this.commandName);
            } else {
                cmd.setName(this.getName() + " " + this.commandName);
            }
            cmd.setArguments(this.args.toArray(new String[this.args.size()]));
            this.provideStateTo(cmd);
            cmd.start(env);
        }
        catch (BaseCommand.UnloggedFailure e) {
            String msg = e.getMessage();
            if (!msg.endsWith("\n")) {
                msg = msg + "\n";
            }
            this.err.write(msg.getBytes(Charsets.UTF_8));
            this.err.flush();
            this.exit.onExit(e.exitCode);
        }
    }

    private BaseCommand getCommand() throws BaseCommand.UnloggedFailure {
        Map<String, Class<? extends BaseCommand>> map = this.getMap();
        String name = this.commandName;
        if (this.aliasToCommand.containsKey(this.commandName)) {
            name = this.aliasToCommand.get(name);
        }
        if (this.dispatchers.containsKey(name)) {
            return this.dispatchers.get(name);
        }
        Class<? extends BaseCommand> c = map.get(name);
        if (c == null) {
            String msg = (this.getName().isEmpty() ? "Gitblit" : this.getName()) + ": " + this.commandName + ": not found";
            throw new BaseCommand.UnloggedFailure(1, msg);
        }
        for (BaseCommand cmd : this.instantiated) {
            if (!cmd.getClass().equals(c)) continue;
            return cmd;
        }
        BaseCommand cmd = null;
        try {
            cmd = c.newInstance();
            this.instantiated.add(cmd);
        }
        catch (Exception e) {
            throw new BaseCommand.UnloggedFailure(1, MessageFormat.format("Failed to instantiate {0} command", this.commandName));
        }
        return cmd;
    }

    private boolean hasVisibleCommands() {
        boolean visible = false;
        for (Class<? extends BaseCommand> clazz : this.commands) {
            if (!(visible |= !clazz.getAnnotation(CommandMetaData.class).hidden())) continue;
            return true;
        }
        for (DispatchCommand dispatchCommand : this.dispatchers.values()) {
            if (!(visible |= dispatchCommand.hasVisibleCommands())) continue;
            return true;
        }
        return false;
    }

    public String getDescription() {
        return this.getClass().getAnnotation(CommandMetaData.class).description();
    }

    @Override
    public String usage() {
        CommandMetaData meta;
        String displayName;
        Class<? extends BaseCommand> c;
        TreeSet<String> cmds = new TreeSet<String>();
        TreeSet<String> dcs = new TreeSet<String>();
        HashMap displayNames = Maps.newHashMap();
        int maxLength = -1;
        Map<String, Class<? extends BaseCommand>> m = this.getMap();
        for (String name : m.keySet()) {
            Class<? extends BaseCommand> c2 = m.get(name);
            CommandMetaData meta2 = c2.getAnnotation(CommandMetaData.class);
            if (meta2.hidden()) continue;
            String displayName2 = name + (meta2.admin() ? "*" : "");
            if (this.commandToAliases.containsKey(meta2.name())) {
                displayName2 = name + (meta2.admin() ? "*" : "") + " (" + Joiner.on((char)',').join((Iterable)this.commandToAliases.get(meta2.name())) + ")";
            }
            displayNames.put(name, displayName2);
            maxLength = Math.max(maxLength, displayName2.length());
            if (DispatchCommand.class.isAssignableFrom(c2)) {
                DispatchCommand d = this.dispatchers.get(name);
                if (!d.hasVisibleCommands()) continue;
                dcs.add(name);
                continue;
            }
            cmds.add(name);
        }
        String format = "%-" + maxLength + "s   %s";
        StringBuilder usage = new StringBuilder();
        if (!StringUtils.isEmpty(this.getName())) {
            String title = this.getName().toUpperCase() + ": " + this.getDescription();
            String b = StringUtils.leftPad("", title.length() + 2, '\u2550');
            usage.append('\n');
            usage.append(b).append('\n');
            usage.append(' ').append(title).append('\n');
            usage.append(b).append('\n');
            usage.append('\n');
        }
        if (!cmds.isEmpty()) {
            usage.append("Available commands");
            if (!this.getName().isEmpty()) {
                usage.append(" of ");
                usage.append(this.getName());
            }
            usage.append(" are:\n");
            usage.append("\n");
            for (String name : cmds) {
                c = m.get(name);
                displayName = (String)displayNames.get(name);
                meta = c.getAnnotation(CommandMetaData.class);
                usage.append("   ");
                usage.append(String.format(format, displayName, Strings.nullToEmpty((String)meta.description())));
                usage.append("\n");
            }
            usage.append("\n");
        }
        if (!dcs.isEmpty()) {
            usage.append("Available command dispatchers");
            if (!this.getName().isEmpty()) {
                usage.append(" of ");
                usage.append(this.getName());
            }
            usage.append(" are:\n");
            usage.append("\n");
            for (String name : dcs) {
                c = m.get(name);
                displayName = (String)displayNames.get(name);
                meta = c.getAnnotation(CommandMetaData.class);
                usage.append("   ");
                usage.append(String.format(format, displayName, Strings.nullToEmpty((String)meta.description())));
                usage.append("\n");
            }
            usage.append("\n");
        }
        usage.append("See '");
        if (!StringUtils.isEmpty(this.getName())) {
            usage.append(this.getName());
            usage.append(' ');
        }
        usage.append("COMMAND --help' for more information.\n");
        usage.append("\n");
        return usage.toString();
    }
}

