/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh.commands;

import com.gitblit.transport.ssh.commands.BaseCommand;
import com.gitblit.transport.ssh.commands.SshCommand;
import com.gitblit.utils.JsonUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.kohsuke.args4j.Option;

public abstract class ListCommand<T>
extends SshCommand {
    @Option(name="--verbose", aliases={"-v"}, usage="verbose")
    protected boolean verbose;
    @Option(name="--tabbed", usage="generate tabbed-text output")
    protected boolean tabbed;
    @Option(name="--json", usage="generate JSON output")
    protected boolean json;
    private DateFormat df;

    protected abstract List<T> getItems() throws BaseCommand.UnloggedFailure;

    protected void validateOutputFormat() throws BaseCommand.UnloggedFailure {
        if (this.tabbed && this.json) {
            throw new BaseCommand.UnloggedFailure(1, "Please specify --tabbed OR --json, not both!");
        }
    }

    @Override
    public void run() throws BaseCommand.UnloggedFailure {
        this.validateOutputFormat();
        List<T> list = this.getItems();
        if (this.tabbed) {
            this.asTabbed(list);
        } else if (this.json) {
            this.asJSON(list);
        } else {
            this.asTable(list);
        }
    }

    protected abstract void asTable(List<T> var1);

    protected abstract void asTabbed(List<T> var1);

    protected void outTabbed(Object ... values) {
        StringBuilder pattern = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            pattern.append("%s\t");
        }
        pattern.setLength(pattern.length() - 1);
        this.stdout.println(String.format(pattern.toString(), values));
    }

    protected void asJSON(List<T> list) {
        this.stdout.println(JsonUtils.toJsonString(list));
    }

    protected String formatDate(Date date) {
        if (this.df == null) {
            this.df = new SimpleDateFormat("yyyy-MM-dd");
        }
        return this.df.format(date);
    }
}

