/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh.git;

import com.gitblit.git.GitblitReceivePackFactory;
import com.gitblit.git.GitblitUploadPackFactory;
import com.gitblit.git.RepositoryResolver;
import com.gitblit.transport.ssh.SshDaemonClient;
import com.gitblit.transport.ssh.commands.BaseCommand;
import java.io.IOException;
import org.apache.sshd.server.Environment;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.UploadPackFactory;
import org.kohsuke.args4j.Argument;

abstract class BaseGitCommand
extends BaseCommand {
    @Argument(index=0, metaVar="REPOSITORY", required=true, usage="repository name")
    protected String repository;
    protected RepositoryResolver<SshDaemonClient> repositoryResolver;
    protected ReceivePackFactory<SshDaemonClient> receivePackFactory;
    protected UploadPackFactory<SshDaemonClient> uploadPackFactory;
    protected Repository repo;

    BaseGitCommand() {
    }

    @Override
    public void destroy() {
        super.destroy();
        this.repositoryResolver = null;
        this.receivePackFactory = null;
        this.uploadPackFactory = null;
        this.repo = null;
    }

    @Override
    public void start(Environment env) {
        this.startThread(new BaseCommand.RepositoryCommandRunnable(){

            @Override
            public void run() throws Exception {
                BaseGitCommand.this.parseCommandLine();
                BaseGitCommand.this.service();
            }

            @Override
            public String getRepository() {
                return BaseGitCommand.this.repository;
            }
        });
    }

    private void service() throws IOException, BaseCommand.Failure {
        try {
            this.repo = this.openRepository();
            this.runImpl();
        }
        finally {
            if (this.repo != null) {
                this.repo.close();
            }
        }
    }

    protected abstract void runImpl() throws IOException, BaseCommand.Failure;

    protected Repository openRepository() throws BaseCommand.Failure {
        this.repository = this.repository.replace('\\', '/');
        if (this.repository.startsWith("/")) {
            this.repository = this.repository.substring(1);
        }
        try {
            return this.repositoryResolver.open(this.getContext().getClient(), this.repository);
        }
        catch (Exception e) {
            throw new BaseCommand.Failure(1, "fatal: '" + this.repository + "': not a git archive", e);
        }
    }

    public void setRepositoryResolver(RepositoryResolver<SshDaemonClient> repositoryResolver) {
        this.repositoryResolver = repositoryResolver;
    }

    public void setReceivePackFactory(GitblitReceivePackFactory<SshDaemonClient> receivePackFactory) {
        this.receivePackFactory = receivePackFactory;
    }

    public void setUploadPackFactory(GitblitUploadPackFactory<SshDaemonClient> uploadPackFactory) {
        this.uploadPackFactory = uploadPackFactory;
    }
}

