/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh.git;

import com.gitblit.transport.ssh.commands.BaseCommand;
import com.gitblit.transport.ssh.commands.CommandMetaData;
import com.gitblit.transport.ssh.commands.UsageExample;
import com.gitblit.transport.ssh.git.BaseGitCommand;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.jgit.api.GarbageCollectCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CommandMetaData(name="gc", description="Cleanup unnecessary files and optimize the local repository", admin=true)
@UsageExample(syntax="${cmd} test/myrepository.git", description="Garbage collect \"test/myrepository.git\"")
public class GarbageCollectionCommand
extends BaseGitCommand {
    private static final Logger log = LoggerFactory.getLogger(GarbageCollectionCommand.class);

    @Override
    protected void runImpl() throws IOException, BaseCommand.Failure {
        try {
            GarbageCollectCommand gc = Git.wrap((Repository)this.repo).gc();
            GarbageCollectionCommand.logGcInfo("before:", gc.getStatistics());
            gc.setProgressMonitor((ProgressMonitor)NullProgressMonitor.INSTANCE);
            Properties statistics = gc.call();
            GarbageCollectionCommand.logGcInfo("after: ", statistics);
        }
        catch (Exception e) {
            throw new BaseCommand.Failure(1, "fatal: Cannot run gc: ", e);
        }
    }

    private static void logGcInfo(String msg, Properties statistics) {
        StringBuilder b = new StringBuilder();
        b.append(msg);
        if (statistics != null) {
            b.append(" ");
            String s = statistics.toString();
            if (s.startsWith("{") && s.endsWith("}")) {
                s = s.substring(1, s.length() - 1);
            }
            b.append(s);
        }
        log.info(b.toString());
    }
}

