/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.transport.ssh.keys;

import com.gitblit.transport.ssh.IPublicKeyManager;
import com.gitblit.transport.ssh.SshKey;
import com.gitblit.transport.ssh.commands.BaseCommand;
import com.gitblit.transport.ssh.commands.SshCommand;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.List;

abstract class BaseKeyCommand
extends SshCommand {
    BaseKeyCommand() {
    }

    protected List<String> readKeys(List<String> sshKeys) throws UnsupportedEncodingException, IOException {
        int idx = -1;
        if (sshKeys.isEmpty() || (idx = sshKeys.indexOf("-")) >= 0) {
            String line;
            String content = "";
            BufferedReader br = new BufferedReader(new InputStreamReader(this.in, Charsets.UTF_8));
            while ((line = br.readLine()) != null) {
                content = content + line + "\n";
            }
            String sshKey = content.trim();
            if (!sshKey.isEmpty()) {
                if (idx == -1) {
                    sshKeys.add(sshKey);
                } else {
                    sshKeys.set(idx, sshKey);
                }
            }
        }
        return sshKeys;
    }

    protected IPublicKeyManager getKeyManager() {
        return this.getContext().getGitblit().getPublicKeyManager();
    }

    protected SshKey parseKey(String rawData) throws BaseCommand.UnloggedFailure {
        if (rawData.contains("PRIVATE")) {
            throw new BaseCommand.UnloggedFailure(1, "Please provide a PUBLIC key, not a PRIVATE key!");
        }
        SshKey key = new SshKey(rawData);
        return key;
    }
}

