/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.IStoredSettings;
import com.gitblit.models.RepositoryModel;
import com.gitblit.utils.MarkdownUtils;
import com.gitblit.utils.StringUtils;
import com.syntevo.bugtraq.BugtraqConfig;
import com.syntevo.bugtraq.BugtraqFormatter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BugtraqProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IStoredSettings settings;

    public BugtraqProcessor(IStoredSettings settings) {
        this.settings = settings;
    }

    public String processCommitMessage(Repository repository, RepositoryModel model, String text) {
        switch (model.commitMessageRenderer) {
            case MARKDOWN: {
                try {
                    String prepared = this.processTextRegex(repository, model.name, text);
                    return MarkdownUtils.transformMarkdown(prepared);
                }
                catch (Exception e) {
                    this.logger.error("Failed to render commit message as markdown", (Throwable)e);
                    break;
                }
            }
        }
        return this.processPlainCommitMessage(repository, model.name, text);
    }

    public String processPlainCommitMessage(Repository repository, String repositoryName, String text) {
        String html = StringUtils.escapeForHtml(text, false);
        html = this.processTextRegex(repository, repositoryName, html);
        return StringUtils.breakLinesForHtml(html);
    }

    public String processText(Repository repository, String repositoryName, String text) {
        String html = this.processTextRegex(repository, repositoryName, text);
        return html;
    }

    protected String processTextRegex(Repository repository, String repositoryName, String text) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.settings.getBoolean("regex.global", false)) {
            for (String string : this.settings.getAllKeys("regex.global")) {
                if (string.equals("regex.global")) continue;
                String subKey = string.substring(string.lastIndexOf(46) + 1);
                map.put(subKey, this.settings.getString(string, ""));
            }
        }
        List<String> keys = this.settings.getAllKeys("regex." + repositoryName.toLowerCase());
        for (String key : keys) {
            String subKey = key.substring(key.lastIndexOf(46) + 1);
            map.put(subKey, this.settings.getString(key, ""));
        }
        for (Map.Entry entry : map.entrySet()) {
            String definition = ((String)entry.getValue()).trim();
            String[] chunks = definition.split("!!!");
            if (chunks.length == 2) {
                text = text.replaceAll(chunks[0], chunks[1]);
                continue;
            }
            this.logger.warn((String)entry.getKey() + " improperly formatted.  Use !!! to separate match from replacement: " + definition);
        }
        try {
            BugtraqConfig bugtraqConfig = BugtraqConfig.read(repository);
            if (bugtraqConfig != null) {
                BugtraqFormatter formatter = new BugtraqFormatter(bugtraqConfig);
                StringBuilder sb = new StringBuilder();
                formatter.formatLogMessage(text, new BugtraqOutputHandler(sb));
                text = sb.toString();
            }
        }
        catch (ConfigInvalidException configInvalidException) {
            this.logger.warn("Bugtraq config for {} is invalid!", (Object)repositoryName, (Object)configInvalidException);
        }
        catch (Exception exception) {
            this.logger.warn("Failed to parse message through Bugtraq.", (Throwable)exception);
        }
        return text;
    }

    private class BugtraqOutputHandler
    implements BugtraqFormatter.OutputHandler {
        final StringBuilder sb;

        BugtraqOutputHandler(StringBuilder sb) {
            this.sb = sb;
        }

        @Override
        public void appendText(String text) {
            this.sb.append(text);
        }

        @Override
        public void appendLink(String name, String target) {
            this.sb.append(MessageFormat.format("<a class=\"bugtraq\" href=\"{1}\" target=\"_blank\">{0}</a>", name, target));
        }
    }
}

