/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.models.RefModel;
import com.gitblit.models.RepositoryCommit;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.ObjectCache;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitCache {
    private static final CommitCache instance = new CommitCache();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Map<String, ObjectCache<List<RepositoryCommit>>> cache = new HashMap<String, ObjectCache<List<RepositoryCommit>>>();
    protected int cacheDays = -1;

    public static CommitCache instance() {
        return instance;
    }

    protected CommitCache() {
    }

    public Date getCutoffDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, -1 * this.cacheDays);
        return cal.getTime();
    }

    public synchronized void setCacheDays(int days) {
        this.cacheDays = days;
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, ObjectCache<List<RepositoryCommit>>> map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(String repositoryName) {
        String repoKey = repositoryName.toLowerCase();
        boolean hadEntries = false;
        Map<String, ObjectCache<List<RepositoryCommit>>> map = this.cache;
        synchronized (map) {
            hadEntries = this.cache.remove(repoKey) != null;
        }
        if (hadEntries) {
            this.logger.info(MessageFormat.format("{0} commit cache cleared", repositoryName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(String repositoryName, String branch) {
        String repoKey = repositoryName.toLowerCase();
        boolean hadEntries = false;
        Map<String, ObjectCache<List<RepositoryCommit>>> map = this.cache;
        synchronized (map) {
            ObjectCache<List<RepositoryCommit>> repoCache = this.cache.get(repoKey);
            if (repoCache != null) {
                List<RepositoryCommit> commits = repoCache.remove(branch.toLowerCase());
                hadEntries = !ArrayUtils.isEmpty(commits);
            }
        }
        if (hadEntries) {
            this.logger.info(MessageFormat.format("{0}:{1} commit cache cleared", repositoryName, branch));
        }
    }

    public List<RepositoryCommit> getCommits(String repositoryName, Repository repository, String branch) {
        return this.getCommits(repositoryName, repository, branch, this.getCutoffDate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RepositoryCommit> getCommits(String repositoryName, Repository repository, String branch, Date sinceDate) {
        List<RepositoryCommit> list;
        long start = System.nanoTime();
        Date cacheCutoffDate = this.getCutoffDate();
        if (this.cacheDays > 0 && sinceDate.getTime() >= cacheCutoffDate.getTime()) {
            ObjectCache<List<RepositoryCommit>> repoCache;
            String repoKey = repositoryName.toLowerCase();
            String branchKey = branch.toLowerCase();
            RevCommit tip = JGitUtils.getCommit(repository, branch);
            Date tipDate = JGitUtils.getCommitDate(tip);
            Object object = this.cache;
            synchronized (object) {
                repoCache = this.cache.get(repoKey);
                if (repoCache == null) {
                    repoCache = new ObjectCache();
                    this.cache.put(repoKey, repoCache);
                }
            }
            object = repoCache;
            synchronized (object) {
                List<RepositoryCommit> commits;
                if (!repoCache.hasCurrent(branchKey, tipDate)) {
                    commits = repoCache.getObject(branchKey);
                    if (ArrayUtils.isEmpty(commits)) {
                        commits = this.get(repositoryName, repository, branch, cacheCutoffDate);
                        repoCache.updateObject(branchKey, tipDate, commits);
                        this.logger.debug(MessageFormat.format("parsed {0} commits from {1}:{2} since {3,date,yyyy-MM-dd} in {4} msecs", commits.size(), repositoryName, branch, cacheCutoffDate, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)));
                    } else {
                        ObjectId sinceCommit = commits.get(0).getId();
                        List<RepositoryCommit> incremental = this.get(repositoryName, repository, branch, sinceCommit);
                        this.logger.info(MessageFormat.format("incrementally added {0} commits to cache for {1}:{2} in {3} msecs", incremental.size(), repositoryName, branch, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)));
                        incremental.addAll(commits);
                        repoCache.updateObject(branchKey, tipDate, incremental);
                        commits = incremental;
                    }
                } else {
                    commits = repoCache.getObject(branchKey);
                    commits = this.reduce(commits, cacheCutoffDate);
                    repoCache.updateObject(branchKey, tipDate, commits);
                }
                list = sinceDate.equals(cacheCutoffDate) ? new ArrayList<RepositoryCommit>(commits) : this.reduce(commits, sinceDate);
            }
            this.logger.debug(MessageFormat.format("retrieved {0} commits from cache of {1}:{2} since {3,date,yyyy-MM-dd} in {4} msecs", list.size(), repositoryName, branch, sinceDate, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)));
        } else {
            list = this.get(repositoryName, repository, branch, sinceDate);
            this.logger.debug(MessageFormat.format("parsed {0} commits from {1}:{2} since {3,date,yyyy-MM-dd} in {4} msecs", list.size(), repositoryName, branch, sinceDate, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)));
        }
        return list;
    }

    protected List<RepositoryCommit> get(String repositoryName, Repository repository, String branch, Date sinceDate) {
        Map<ObjectId, List<RefModel>> allRefs = JGitUtils.getAllRefs(repository, false);
        List<RevCommit> revLog = JGitUtils.getRevLog(repository, branch, sinceDate);
        ArrayList<RepositoryCommit> commits = new ArrayList<RepositoryCommit>(revLog.size());
        for (RevCommit commit : revLog) {
            RepositoryCommit commitModel = new RepositoryCommit(repositoryName, branch, commit);
            List<RefModel> commitRefs = allRefs.get(commitModel.getId());
            commitModel.setRefs(commitRefs);
            commits.add(commitModel);
        }
        return commits;
    }

    protected List<RepositoryCommit> get(String repositoryName, Repository repository, String branch, ObjectId sinceCommit) {
        Map<ObjectId, List<RefModel>> allRefs = JGitUtils.getAllRefs(repository, false);
        List<RevCommit> revLog = JGitUtils.getRevLog(repository, sinceCommit.getName(), branch);
        ArrayList<RepositoryCommit> commits = new ArrayList<RepositoryCommit>(revLog.size());
        for (RevCommit commit : revLog) {
            RepositoryCommit commitModel = new RepositoryCommit(repositoryName, branch, commit);
            List<RefModel> commitRefs = allRefs.get(commitModel.getId());
            commitModel.setRefs(commitRefs);
            commits.add(commitModel);
        }
        return commits;
    }

    protected List<RepositoryCommit> reduce(List<RepositoryCommit> commits, Date sinceDate) {
        ArrayList<RepositoryCommit> filtered = new ArrayList<RepositoryCommit>(commits.size());
        for (RepositoryCommit commit : commits) {
            if (commit.getCommitDate().compareTo(sinceDate) < 0) continue;
            filtered.add(commit);
        }
        return filtered;
    }
}

