/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.manager.IFilestoreManager;
import com.gitblit.models.FilestoreModel;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.IOUtils;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionUtils {
    static final Logger LOGGER = LoggerFactory.getLogger(CompressionUtils.class);

    private static void error(Throwable t, Repository repository, String pattern, Object ... objects) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (objects != null && objects.length > 0) {
            for (Object o : objects) {
                parameters.add(o);
            }
        }
        if (repository != null) {
            parameters.add(0, repository.getDirectory().getAbsolutePath());
        }
        LOGGER.error(MessageFormat.format(pattern, parameters.toArray()), t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zip(Repository repository, IFilestoreManager filestoreManager, String basePath, String objectId, OutputStream os) {
        RevCommit commit = JGitUtils.getCommit(repository, objectId);
        if (commit == null) {
            return false;
        }
        boolean success = false;
        RevWalk rw = new RevWalk(repository);
        TreeWalk tw = new TreeWalk(repository);
        try {
            tw.reset();
            tw.addTree((AnyObjectId)commit.getTree());
            ZipArchiveOutputStream zos = new ZipArchiveOutputStream(os);
            zos.setComment("Generated by Gitblit");
            if (!StringUtils.isEmpty(basePath)) {
                PathFilter f = PathFilter.create((String)basePath);
                tw.setFilter((TreeFilter)f);
            }
            tw.setRecursive(true);
            MutableObjectId id = new MutableObjectId();
            ObjectReader reader = tw.getObjectReader();
            long modified = commit.getAuthorIdent().getWhen().getTime();
            while (tw.next()) {
                FileMode mode = tw.getFileMode(0);
                if (mode == FileMode.GITLINK || mode == FileMode.TREE) continue;
                tw.getObjectId(id, 0);
                ObjectLoader loader = repository.open((AnyObjectId)id);
                ZipArchiveEntry entry = new ZipArchiveEntry(tw.getPathString());
                FilestoreModel filestoreItem = null;
                if (JGitUtils.isPossibleFilestoreItem(loader.getSize())) {
                    filestoreItem = JGitUtils.getFilestoreItem(tw.getObjectReader().open((AnyObjectId)id));
                }
                long size = filestoreItem == null ? loader.getSize() : filestoreItem.getSize();
                entry.setSize(size);
                entry.setComment(commit.getName());
                entry.setUnixMode(mode.getBits());
                entry.setTime(modified);
                zos.putArchiveEntry(entry);
                if (filestoreItem == null) {
                    loader.copyTo((OutputStream)zos);
                } else {
                    try (FileInputStream streamIn = new FileInputStream(filestoreManager.getStoragePath(filestoreItem.oid));){
                        IOUtils.copyLarge((InputStream)streamIn, (OutputStream)zos);
                    }
                    catch (Throwable e) {
                        LOGGER.error(MessageFormat.format("Failed to archive filestore item {0}", filestoreItem.oid), e);
                        throw e;
                    }
                }
                zos.closeArchiveEntry();
            }
            zos.finish();
            success = true;
        }
        catch (IOException e) {
            CompressionUtils.error(e, repository, "{0} failed to zip files from commit {1}", commit.getName());
        }
        finally {
            tw.close();
            rw.dispose();
        }
        return success;
    }

    public static boolean tar(Repository repository, IFilestoreManager filestoreManager, String basePath, String objectId, OutputStream os) {
        return CompressionUtils.tar(null, repository, filestoreManager, basePath, objectId, os);
    }

    public static boolean gz(Repository repository, IFilestoreManager filestoreManager, String basePath, String objectId, OutputStream os) {
        return CompressionUtils.tar("gz", repository, filestoreManager, basePath, objectId, os);
    }

    public static boolean xz(Repository repository, IFilestoreManager filestoreManager, String basePath, String objectId, OutputStream os) {
        return CompressionUtils.tar("xz", repository, filestoreManager, basePath, objectId, os);
    }

    public static boolean bzip2(Repository repository, IFilestoreManager filestoreManager, String basePath, String objectId, OutputStream os) {
        return CompressionUtils.tar("bzip2", repository, filestoreManager, basePath, objectId, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tar(String algorithm, Repository repository, IFilestoreManager filestoreManager, String basePath, String objectId, OutputStream os) {
        RevCommit commit = JGitUtils.getCommit(repository, objectId);
        if (commit == null) {
            return false;
        }
        OutputStream cos = os;
        if (!StringUtils.isEmpty(algorithm)) {
            try {
                cos = new CompressorStreamFactory().createCompressorOutputStream(algorithm, os);
            }
            catch (CompressorException e1) {
                CompressionUtils.error(e1, repository, "{0} failed to open {1} stream", algorithm);
            }
        }
        boolean success = false;
        RevWalk rw = new RevWalk(repository);
        TreeWalk tw = new TreeWalk(repository);
        try {
            tw.reset();
            tw.addTree((AnyObjectId)commit.getTree());
            TarArchiveOutputStream tos = new TarArchiveOutputStream(cos);
            tos.setAddPaxHeadersForNonAsciiNames(true);
            tos.setLongFileMode(3);
            if (!StringUtils.isEmpty(basePath)) {
                PathFilter f = PathFilter.create((String)basePath);
                tw.setFilter((TreeFilter)f);
            }
            tw.setRecursive(true);
            MutableObjectId id = new MutableObjectId();
            long modified = commit.getAuthorIdent().getWhen().getTime();
            while (tw.next()) {
                TarArchiveEntry entry;
                FileMode mode = tw.getFileMode(0);
                if (mode == FileMode.GITLINK || mode == FileMode.TREE) continue;
                tw.getObjectId(id, 0);
                ObjectLoader loader = repository.open((AnyObjectId)id);
                if (FileMode.SYMLINK == mode) {
                    entry = new TarArchiveEntry(tw.getPathString(), 50);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    loader.copyTo((OutputStream)bos);
                    entry.setLinkName(bos.toString());
                    entry.setModTime(modified);
                    tos.putArchiveEntry(entry);
                    tos.closeArchiveEntry();
                    continue;
                }
                entry = new TarArchiveEntry(tw.getPathString());
                entry.setMode(mode.getBits());
                entry.setModTime(modified);
                FilestoreModel filestoreItem = null;
                if (JGitUtils.isPossibleFilestoreItem(loader.getSize())) {
                    filestoreItem = JGitUtils.getFilestoreItem(tw.getObjectReader().open((AnyObjectId)id));
                }
                long size = filestoreItem == null ? loader.getSize() : filestoreItem.getSize();
                entry.setSize(size);
                tos.putArchiveEntry(entry);
                if (filestoreItem == null) {
                    loader.copyTo((OutputStream)tos);
                } else {
                    try (FileInputStream streamIn = new FileInputStream(filestoreManager.getStoragePath(filestoreItem.oid));){
                        IOUtils.copyLarge((InputStream)streamIn, (OutputStream)tos);
                    }
                    catch (Throwable e) {
                        LOGGER.error(MessageFormat.format("Failed to archive filestore item {0}", filestoreItem.oid), e);
                        throw e;
                    }
                }
                tos.closeArchiveEntry();
            }
            tos.finish();
            tos.close();
            cos.close();
            success = true;
        }
        catch (IOException e) {
            CompressionUtils.error(e, repository, "{0} failed to {1} stream files from commit {2}", algorithm, commit.getName());
        }
        finally {
            tw.close();
            rw.dispose();
        }
        return success;
    }
}

