/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.utils.Base64;
import com.gitblit.utils.StringUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ConnectionUtils {
    static final String CHARSET;
    private static final SSLContext SSL_CONTEXT;
    private static final DummyHostnameVerifier HOSTNAME_VERIFIER;

    public static void setAuthorization(URLConnection conn, String username, char[] password) {
        if (!StringUtils.isEmpty(username) && password != null && password.length > 0) {
            conn.setRequestProperty("Authorization", "Basic " + Base64.encodeBytes((username + ":" + new String(password)).getBytes()));
        }
    }

    public static URLConnection openReadConnection(String url, String username, char[] password) throws IOException {
        URLConnection conn = ConnectionUtils.openConnection(url, username, password);
        conn.setRequestProperty("Accept-Charset", CHARSET);
        return conn;
    }

    public static URLConnection openConnection(String url, String username, char[] password) throws IOException {
        URL urlObject = new URL(url);
        URLConnection conn = urlObject.openConnection();
        ConnectionUtils.setAuthorization(conn, username, password);
        conn.setUseCaches(false);
        conn.setDoOutput(true);
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection secureConn = (HttpsURLConnection)conn;
            secureConn.setSSLSocketFactory(SSL_CONTEXT.getSocketFactory());
            secureConn.setHostnameVerifier(HOSTNAME_VERIFIER);
        }
        return conn;
    }

    static {
        SSLContext context = null;
        try {
            context = SSLContext.getInstance("SSL");
            context.init(null, new TrustManager[]{new DummyTrustManager()}, new SecureRandom());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        SSL_CONTEXT = context;
        HOSTNAME_VERIFIER = new DummyHostnameVerifier();
        CHARSET = "UTF-8";
        System.setProperty("jsse.enableSNIExtension", "false");
    }

    private static class DummyHostnameVerifier
    implements HostnameVerifier {
        private DummyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class DummyTrustManager
    implements X509TrustManager {
        private DummyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    public static class BlindSSLSocketFactory
    extends SSLSocketFactory {
        private static final BlindSSLSocketFactory INSTANCE;
        private final SSLSocketFactory sslFactory;

        public static SocketFactory getDefault() {
            return INSTANCE;
        }

        private BlindSSLSocketFactory(SSLSocketFactory sslFactory) {
            this.sslFactory = sslFactory;
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            return this.sslFactory.createSocket(s, host, port, autoClose);
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.sslFactory.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.sslFactory.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket() throws IOException {
            return this.sslFactory.createSocket();
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.sslFactory.createSocket(host, port);
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.sslFactory.createSocket(host, port);
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return this.sslFactory.createSocket(host, port, localHost, localPort);
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.sslFactory.createSocket(address, port, localAddress, localPort);
        }

        static {
            try {
                SSLContext context = SSLContext.getInstance("SSL");
                TrustManager[] trustManagers = new TrustManager[]{new DummyTrustManager()};
                SecureRandom rng = new SecureRandom();
                context.init(null, trustManagers, rng);
                INSTANCE = new BlindSSLSocketFactory(context.getSocketFactory());
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("Cannot create BlindSslSocketFactory", e);
            }
        }
    }
}

