/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.utils.FileUtils;
import java.io.File;
import org.slf4j.Logger;

public class ContainerDetector {
    private static Boolean inContainer;
    private static String detectedType;

    public static boolean detect() {
        if (inContainer == null) {
            File proc = new File("/proc/1/cgroup");
            if (!proc.exists()) {
                inContainer = Boolean.FALSE;
            } else {
                String cgroups = FileUtils.readContent(proc, null);
                if (cgroups.contains("/docker")) {
                    inContainer = Boolean.TRUE;
                    detectedType = "Docker container";
                } else if (cgroups.contains("/ecs")) {
                    inContainer = Boolean.TRUE;
                    detectedType = "ECS container";
                } else if (cgroups.contains("/kubepod") || cgroups.contains("/kubepods")) {
                    inContainer = Boolean.TRUE;
                    detectedType = "Kubernetes pod";
                }
            }
            if (inContainer == null) {
                inContainer = Boolean.FALSE;
            }
        }
        return inContainer;
    }

    public static void report(Logger logger, boolean onlyIfInContainer) {
        if (ContainerDetector.detect()) {
            String msg = "Running in a " + detectedType;
            if (logger == null) {
                System.out.println(msg);
            } else {
                logger.info(msg);
            }
        } else if (!onlyIfInContainer) {
            String msg = "Not detected to be running in a container";
            if (logger == null) {
                System.out.println(msg);
            } else {
                logger.info(msg);
            }
        }
    }

    static {
        detectedType = "";
    }
}

