/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DeepCopier {
    public static BigInteger checksum(Object sourceObject) {
        if (sourceObject == null) {
            return BigInteger.ZERO;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(sourceObject);
            oos.close();
            MessageDigest m = MessageDigest.getInstance("SHA-1");
            m.update(baos.toByteArray());
            return new BigInteger(1, m.digest());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return BigInteger.ZERO;
        }
    }

    public static <T> T copy(T original) {
        Object o = null;
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(byteOut);
            oos.writeObject(original);
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(byteIn);
            try {
                o = ois.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
        return (T)o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T copyParallel(T original) {
        try {
            PipedOutputStream outputStream = new PipedOutputStream();
            PipedInputStream inputStream = new PipedInputStream(outputStream);
            Receiver receiver = new Receiver(inputStream);
            try (ObjectOutputStream ois = new ObjectOutputStream(outputStream);){
                ois.writeObject(original);
            }
            return receiver.getResult();
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
    }

    private static class Receiver<T>
    extends Thread {
        private final InputStream inputStream;
        private volatile T result;
        private volatile Throwable throwable;

        public Receiver(InputStream inputStream) {
            this.inputStream = inputStream;
            this.start();
        }

        @Override
        public void run() {
            try (ObjectInputStream ois = new ObjectInputStream(this.inputStream);){
                this.result = ois.readObject();
                try {
                    while (this.inputStream.read() != -1) {
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            catch (Throwable t) {
                this.throwable = t;
            }
        }

        public T getResult() throws IOException {
            try {
                this.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Unexpected InterruptedException", e);
            }
            if (this.throwable != null) {
                if (this.throwable instanceof ClassNotFoundException) {
                    // empty if block
                }
                throw new RuntimeException(this.throwable);
            }
            return this.result;
        }
    }
}

