/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.models.AnnotatedLine;
import com.gitblit.models.PathModel;
import com.gitblit.utils.DiffStatFormatter;
import com.gitblit.utils.GitBlitDiffFormatter;
import com.gitblit.utils.JGitUtils;
import com.gitblit.utils.PatchFormatter;
import com.gitblit.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.api.BlameCommand;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiffUtils.class);

    public static DiffOutput getCommitDiff(Repository repository, RevCommit commit, DiffComparator comparator, DiffOutputType outputType, int tabLength) {
        return DiffUtils.getDiff(repository, null, commit, null, comparator, outputType, tabLength);
    }

    public static DiffOutput getCommitDiff(Repository repository, RevCommit commit, DiffComparator comparator, DiffOutputType outputType, BinaryDiffHandler handler, int tabLength) {
        return DiffUtils.getDiff(repository, null, commit, null, comparator, outputType, handler, tabLength);
    }

    public static DiffOutput getDiff(Repository repository, RevCommit commit, String path, DiffComparator comparator, DiffOutputType outputType, int tabLength) {
        return DiffUtils.getDiff(repository, null, commit, path, comparator, outputType, tabLength);
    }

    public static DiffOutput getDiff(Repository repository, RevCommit commit, String path, DiffComparator comparator, DiffOutputType outputType, BinaryDiffHandler handler, int tabLength) {
        return DiffUtils.getDiff(repository, null, commit, path, comparator, outputType, handler, tabLength);
    }

    public static DiffOutput getDiff(Repository repository, RevCommit baseCommit, RevCommit commit, DiffComparator comparator, DiffOutputType outputType, int tabLength) {
        return DiffUtils.getDiff(repository, baseCommit, commit, null, comparator, outputType, tabLength);
    }

    public static DiffOutput getDiff(Repository repository, RevCommit baseCommit, RevCommit commit, DiffComparator comparator, DiffOutputType outputType, BinaryDiffHandler handler, int tabLength) {
        return DiffUtils.getDiff(repository, baseCommit, commit, null, comparator, outputType, handler, tabLength);
    }

    public static DiffOutput getDiff(Repository repository, RevCommit baseCommit, RevCommit commit, String path, DiffComparator diffComparator, DiffOutputType outputType, int tabLength) {
        return DiffUtils.getDiff(repository, baseCommit, commit, path, diffComparator, outputType, null, tabLength);
    }

    public static DiffOutput getDiff(Repository repository, RevCommit baseCommit, RevCommit commit, String path, DiffComparator comparator, DiffOutputType outputType, BinaryDiffHandler handler, int tabLength) {
        DiffStat stat = null;
        String diff = null;
        try {
            RevTree baseTree;
            DiffFormatter df;
            ByteArrayOutputStream os = null;
            switch (outputType) {
                case HTML: {
                    df = new GitBlitDiffFormatter(commit.getName(), repository, path, handler, tabLength);
                    break;
                }
                default: {
                    os = new ByteArrayOutputStream();
                    df = new DiffFormatter((OutputStream)os);
                }
            }
            df.setRepository(repository);
            df.setDiffComparator((comparator == null ? DiffComparator.SHOW_WHITESPACE : comparator).textComparator);
            df.setDetectRenames(true);
            RevTree commitTree = commit.getTree();
            if (baseCommit == null) {
                if (commit.getParentCount() > 0) {
                    RevWalk rw = new RevWalk(repository);
                    RevCommit parent = rw.parseCommit((AnyObjectId)commit.getParent(0).getId());
                    rw.dispose();
                    baseTree = parent.getTree();
                } else {
                    baseTree = commitTree;
                }
            } else {
                baseTree = baseCommit.getTree();
            }
            List diffEntries = df.scan(baseTree, commitTree);
            if (path != null && path.length() > 0) {
                for (DiffEntry diffEntry : diffEntries) {
                    if (!diffEntry.getNewPath().equalsIgnoreCase(path)) continue;
                    df.format(diffEntry);
                    break;
                }
            } else {
                df.format(diffEntries);
            }
            df.flush();
            if (df instanceof GitBlitDiffFormatter) {
                diff = ((GitBlitDiffFormatter)df).getHtml();
                stat = ((GitBlitDiffFormatter)df).getDiffStat();
            } else {
                diff = os.toString();
            }
        }
        catch (Throwable t) {
            LOGGER.error("failed to generate commit diff!", t);
        }
        return new DiffOutput(outputType, diff, stat);
    }

    public static String getCommitPatch(Repository repository, RevCommit baseCommit, RevCommit commit, String path) {
        String diff = null;
        try {
            RevTree baseTree;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            RawTextComparator cmp = RawTextComparator.DEFAULT;
            PatchFormatter df = new PatchFormatter(os);
            df.setRepository(repository);
            df.setDiffComparator(cmp);
            df.setDetectRenames(true);
            RevTree commitTree = commit.getTree();
            if (baseCommit == null) {
                if (commit.getParentCount() > 0) {
                    RevWalk rw = new RevWalk(repository);
                    RevCommit parent = rw.parseCommit((AnyObjectId)commit.getParent(0).getId());
                    baseTree = parent.getTree();
                } else {
                    baseTree = commitTree;
                }
            } else {
                baseTree = baseCommit.getTree();
            }
            List diffEntries = df.scan(baseTree, commitTree);
            if (path != null && path.length() > 0) {
                for (DiffEntry diffEntry : diffEntries) {
                    if (!diffEntry.getNewPath().equalsIgnoreCase(path)) continue;
                    df.format(diffEntry);
                    break;
                }
            } else {
                df.format(diffEntries);
            }
            diff = df.getPatch(commit);
            df.flush();
        }
        catch (Throwable t) {
            LOGGER.error("failed to generate commit diff!", t);
        }
        return diff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DiffStat getDiffStat(Repository repository, String base, String tip) {
        RevCommit baseCommit = null;
        RevCommit tipCommit = null;
        RevWalk revWalk = new RevWalk(repository);
        try {
            tipCommit = revWalk.parseCommit((AnyObjectId)repository.resolve(tip));
            if (!StringUtils.isEmpty(base)) {
                baseCommit = revWalk.parseCommit((AnyObjectId)repository.resolve(base));
            }
            DiffStat diffStat = DiffUtils.getDiffStat(repository, baseCommit, tipCommit, null);
            return diffStat;
        }
        catch (Exception e) {
            LOGGER.error("failed to generate diffstat!", (Throwable)e);
        }
        finally {
            revWalk.dispose();
        }
        return null;
    }

    public static DiffStat getDiffStat(Repository repository, RevCommit commit) {
        return DiffUtils.getDiffStat(repository, null, commit, null);
    }

    public static DiffStat getDiffStat(Repository repository, RevCommit baseCommit, RevCommit commit, String path) {
        DiffStat stat = null;
        try {
            RevTree baseTree;
            RawTextComparator cmp = RawTextComparator.DEFAULT;
            DiffStatFormatter df = new DiffStatFormatter(commit.getName(), repository);
            df.setRepository(repository);
            df.setDiffComparator(cmp);
            df.setDetectRenames(true);
            RevTree commitTree = commit.getTree();
            if (baseCommit == null) {
                if (commit.getParentCount() > 0) {
                    RevWalk rw = new RevWalk(repository);
                    RevCommit parent = rw.parseCommit((AnyObjectId)commit.getParent(0).getId());
                    baseTree = parent.getTree();
                } else {
                    baseTree = commitTree;
                }
            } else {
                baseTree = baseCommit.getTree();
            }
            List diffEntries = df.scan(baseTree, commitTree);
            if (path != null && path.length() > 0) {
                for (DiffEntry diffEntry : diffEntries) {
                    if (!diffEntry.getNewPath().equalsIgnoreCase(path)) continue;
                    df.format(diffEntry);
                    break;
                }
            } else {
                df.format(diffEntries);
            }
            stat = df.getDiffStat();
            df.flush();
        }
        catch (Throwable t) {
            LOGGER.error("failed to generate commit diff!", t);
        }
        return stat;
    }

    public static List<AnnotatedLine> blame(Repository repository, String blobPath, String objectId) {
        ArrayList<AnnotatedLine> lines = new ArrayList<AnnotatedLine>();
        try {
            ObjectId object = StringUtils.isEmpty(objectId) ? JGitUtils.getDefaultBranch(repository) : repository.resolve(objectId);
            BlameCommand blameCommand = new BlameCommand(repository);
            blameCommand.setFilePath(blobPath);
            blameCommand.setStartCommit((AnyObjectId)object);
            BlameResult blameResult = blameCommand.call();
            RawText rawText = blameResult.getResultContents();
            int length = rawText.size();
            for (int i = 0; i < length; ++i) {
                RevCommit commit = blameResult.getSourceCommit(i);
                AnnotatedLine line = new AnnotatedLine(commit, i + 1, rawText.getString(i));
                lines.add(line);
            }
        }
        catch (Throwable t) {
            LOGGER.error(MessageFormat.format("failed to generate blame for {0} {1}!", blobPath, objectId), t);
        }
        return lines;
    }

    public static NormalizedDiffStat normalizeDiffStat(int segments, int insertions, int deletions) {
        int sb;
        int sd;
        int si;
        int total = insertions + deletions;
        float fi = (float)insertions / (float)total;
        if (deletions == 0) {
            si = Math.min(insertions, segments);
            sd = 0;
            sb = si < segments ? segments - si : 0;
        } else if (insertions == 0) {
            si = 0;
            sd = Math.min(deletions, segments);
            sb = sd < segments ? segments - sd : 0;
        } else if (total <= segments) {
            si = insertions;
            sd = deletions;
            sb = segments - total;
        } else if (segments % 2 > 0 && fi > 0.45f && fi < 0.55f) {
            si = Math.round((float)insertions / (float)total * (float)(segments - 1));
            sd = segments - 1 - si;
            sb = 1;
        } else {
            si = Math.round((float)insertions / (float)total * (float)segments);
            sd = segments - si;
            sb = 0;
        }
        return new NormalizedDiffStat(si, sd, sb);
    }

    public static class NormalizedDiffStat
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final int insertions;
        public final int deletions;
        public final int blanks;

        NormalizedDiffStat(int insertions, int deletions, int blanks) {
            this.insertions = insertions;
            this.deletions = deletions;
            this.blanks = blanks;
        }
    }

    public static class DiffStat
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final List<PathModel.PathChangeModel> paths = new ArrayList<PathModel.PathChangeModel>();
        private final String commitId;
        private final Repository repository;

        public DiffStat(String commitId, Repository repository) {
            this.commitId = commitId;
            this.repository = repository;
        }

        public PathModel.PathChangeModel addPath(DiffEntry entry) {
            PathModel.PathChangeModel pcm = PathModel.PathChangeModel.from(entry, this.commitId, this.repository);
            this.paths.add(pcm);
            return pcm;
        }

        public int getInsertions() {
            int val = 0;
            for (PathModel.PathChangeModel entry : this.paths) {
                val += entry.insertions;
            }
            return val;
        }

        public int getDeletions() {
            int val = 0;
            for (PathModel.PathChangeModel entry : this.paths) {
                val += entry.deletions;
            }
            return val;
        }

        public PathModel.PathChangeModel getPath(String path) {
            PathModel.PathChangeModel stat = null;
            for (PathModel.PathChangeModel p : this.paths) {
                if (!p.path.equals(path)) continue;
                stat = p;
                break;
            }
            return stat;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (PathModel.PathChangeModel entry : this.paths) {
                sb.append(entry.toString()).append('\n');
            }
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
    }

    public static class DiffOutput
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final DiffOutputType type;
        public final String content;
        public final DiffStat stat;

        DiffOutput(DiffOutputType type, String content, DiffStat stat) {
            this.type = type;
            this.content = content;
            this.stat = stat;
        }

        public PathModel.PathChangeModel getPath(String path) {
            if (this.stat == null) {
                return null;
            }
            return this.stat.getPath(path);
        }
    }

    public static enum DiffComparator {
        SHOW_WHITESPACE(RawTextComparator.DEFAULT),
        IGNORE_WHITESPACE(RawTextComparator.WS_IGNORE_ALL),
        IGNORE_LEADING(RawTextComparator.WS_IGNORE_LEADING),
        IGNORE_TRAILING(RawTextComparator.WS_IGNORE_TRAILING),
        IGNORE_CHANGES(RawTextComparator.WS_IGNORE_CHANGE);

        public final RawTextComparator textComparator;

        private DiffComparator(RawTextComparator textComparator) {
            this.textComparator = textComparator;
        }

        public DiffComparator getOpposite() {
            return this == SHOW_WHITESPACE ? IGNORE_WHITESPACE : SHOW_WHITESPACE;
        }

        public String getTranslationKey() {
            return "gb." + this.name().toLowerCase();
        }

        public static DiffComparator forName(String name) {
            for (DiffComparator type : DiffComparator.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            return null;
        }
    }

    public static enum DiffOutputType {
        PLAIN,
        HTML;


        public static DiffOutputType forName(String name) {
            for (DiffOutputType type : DiffOutputType.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            return null;
        }
    }

    public static interface BinaryDiffHandler {
        public String renderBinaryDiff(DiffEntry var1);
    }
}

