/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileUtils {
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    public static final int GB = 0x40000000;

    public static int convertSizeToInt(String aString, int defaultValue) {
        return (int)FileUtils.convertSizeToLong(aString, defaultValue);
    }

    public static long convertSizeToLong(String aString, long defaultValue) {
        aString = aString.toLowerCase().trim();
        StringBuilder sb = new StringBuilder();
        for (String a : aString.split(" ")) {
            sb.append(a);
        }
        aString = sb.toString();
        int idx = 0;
        int len = aString.length();
        while (Character.isDigit(aString.charAt(idx)) && ++idx != len) {
        }
        long value = 0L;
        String unit = null;
        try {
            value = Long.parseLong(aString.substring(0, idx));
            unit = aString.substring(idx);
        }
        catch (Exception e) {
            return defaultValue;
        }
        if (unit.equals("g") || unit.equals("gb")) {
            return value * 0x40000000L;
        }
        if (unit.equals("m") || unit.equals("mb")) {
            return value * 0x100000L;
        }
        if (unit.equals("k") || unit.equals("kb")) {
            return value * 1024L;
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readContent(File file) {
        byte[] buffer = new byte[(int)file.length()];
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            is.read(buffer, 0, buffer.length);
        }
        catch (Throwable t) {
            System.err.println("Failed to read byte content of " + file.getAbsolutePath());
            t.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    System.err.println("Failed to close file " + file.getAbsolutePath());
                    ioe.printStackTrace();
                }
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readContent(File file, String lineEnding) {
        StringBuilder sb = new StringBuilder();
        InputStreamReader is = null;
        BufferedReader reader = null;
        try {
            is = new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8"));
            reader = new BufferedReader(is);
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                if (lineEnding == null) continue;
                sb.append(lineEnding);
            }
        }
        catch (Throwable t) {
            System.err.println("Failed to read content of " + file.getAbsolutePath());
            t.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    System.err.println("Failed to close file " + file.getAbsolutePath());
                    ioe.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    System.err.println("Failed to close file " + file.getAbsolutePath());
                    ioe.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeContent(File file, String content) {
        OutputStreamWriter os = null;
        try {
            os = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF-8"));
            BufferedWriter writer = new BufferedWriter(os);
            writer.append(content);
            writer.flush();
        }
        catch (Throwable t) {
            System.err.println("Failed to write content of " + file.getAbsolutePath());
            t.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ioe) {
                    System.err.println("Failed to close file " + file.getAbsolutePath());
                    ioe.printStackTrace();
                }
            }
        }
    }

    public static long folderSize(File directory) {
        if (directory == null || !directory.exists()) {
            return -1L;
        }
        if (directory.isDirectory()) {
            long length = 0L;
            for (File file : directory.listFiles()) {
                length += FileUtils.folderSize(file);
            }
            return length;
        }
        if (directory.isFile()) {
            return directory.length();
        }
        return 0L;
    }

    public static boolean delete(File fileOrFolder) {
        File[] files;
        boolean success = false;
        if (fileOrFolder.isDirectory() && (files = fileOrFolder.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    success |= FileUtils.delete(file);
                    continue;
                }
                success |= file.delete();
            }
        }
        return success |= fileOrFolder.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File destinationFolder, File ... filesOrFolders) throws FileNotFoundException, IOException {
        destinationFolder.mkdirs();
        for (File file : filesOrFolders) {
            if (file.isDirectory()) {
                FileUtils.copy(new File(destinationFolder, file.getName()), file.listFiles());
                continue;
            }
            File dFile = new File(destinationFolder, file.getName());
            BufferedInputStream bufin = null;
            FileOutputStream fos = null;
            try {
                bufin = new BufferedInputStream(new FileInputStream(file));
                fos = new FileOutputStream(dFile);
                int len = 8196;
                byte[] buff = new byte[len];
                int n = 0;
                while ((n = bufin.read(buff, 0, len)) != -1) {
                    fos.write(buff, 0, n);
                }
            }
            finally {
                try {
                    if (bufin != null) {
                        bufin.close();
                    }
                }
                catch (Throwable throwable) {}
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Throwable throwable) {}
            }
            dFile.setLastModified(file.lastModified());
        }
    }

    public static String getRelativePath(File basePath, File path) {
        Path exactBase = FileUtils.getExactPath(basePath);
        Path exactPath = FileUtils.getExactPath(path);
        if (exactPath.startsWith(exactBase)) {
            return exactBase.relativize(exactPath).toString().replace('\\', '/');
        }
        return null;
    }

    private static Path getExactPath(File path) {
        try {
            return path.toPath().toRealPath(LinkOption.NOFOLLOW_LINKS);
        }
        catch (IOException iOException) {
            try {
                return Paths.get(path.getCanonicalPath(), new String[0]);
            }
            catch (IOException e) {
                return Paths.get(path.getAbsolutePath(), new String[0]);
            }
        }
    }

    public static File resolveParameter(String parameter, File aFolder, String path) {
        if (aFolder == null) {
            if ((path = path.replace(parameter, "").trim()).length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1);
            }
        } else if (path.contains(parameter)) {
            path = path.replace(parameter, aFolder.getAbsolutePath());
        }
        return new File(path);
    }
}

