/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

public final class FlipTable {
    public static final String EMPTY = "(empty)";
    private final String[] headers;
    private final Object[][] data;
    private final Borders borders;
    private final int columns;
    private final int[] columnWidths;
    private final int emptyWidth;

    public static String of(String[] headers, Object[][] data) {
        return FlipTable.of(headers, data, Borders.FULL);
    }

    public static String of(String[] headers, Object[][] data, Borders borders) {
        if (headers == null) {
            throw new NullPointerException("headers == null");
        }
        if (headers.length == 0) {
            throw new IllegalArgumentException("Headers must not be empty.");
        }
        if (data == null) {
            throw new NullPointerException("data == null");
        }
        return new FlipTable(headers, data, borders).toString();
    }

    private FlipTable(String[] headers, Object[][] data, Borders borders) {
        this.headers = headers;
        this.data = data;
        this.borders = borders;
        this.columns = headers.length;
        this.columnWidths = new int[this.columns];
        for (int row = -1; row < data.length; ++row) {
            String[] rowData;
            Object[] objectArray = rowData = row == -1 ? headers : data[row];
            if (rowData.length != this.columns) {
                throw new IllegalArgumentException(String.format("Row %s's %s columns != %s columns", row + 1, rowData.length, this.columns));
            }
            for (int column = 0; column < this.columns; ++column) {
                String cell = rowData[column];
                if (cell == null) continue;
                for (String rowDataLine : cell.toString().split("\\n")) {
                    this.columnWidths[column] = Math.max(this.columnWidths[column], rowDataLine.length());
                }
            }
        }
        int emptyWidth = 3 * (this.columns - 1);
        for (int columnWidth : this.columnWidths) {
            emptyWidth += columnWidth;
        }
        this.emptyWidth = emptyWidth;
        if (emptyWidth < EMPTY.length()) {
            int n = this.columns - 1;
            this.columnWidths[n] = this.columnWidths[n] + (EMPTY.length() - emptyWidth);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.borders.header()) {
            this.printDivider(builder, "\u2554\u2550\u2564\u2550\u2557");
        }
        this.printData(builder, this.headers, true);
        if (this.data.length == 0) {
            if (this.borders.body()) {
                this.printDivider(builder, "\u2560\u2550\u2567\u2550\u2563");
                builder.append('\u2551').append(FlipTable.pad(this.emptyWidth, EMPTY)).append("\u2551\n");
                this.printDivider(builder, "\u255a\u2550\u2550\u2550\u255d");
            } else if (this.borders.header()) {
                this.printDivider(builder, "\u255a\u2550\u2567\u2550\u255d");
                builder.append(' ').append(FlipTable.pad(this.emptyWidth, EMPTY)).append(" \n");
            }
        } else {
            for (int row = 0; row < this.data.length; ++row) {
                if (row == 0 && this.borders.header()) {
                    if (this.borders.body()) {
                        if (this.borders.columns()) {
                            this.printDivider(builder, "\u2560\u2550\u256a\u2550\u2563");
                        } else {
                            this.printDivider(builder, "\u2560\u2550\u2567\u2550\u2563");
                        }
                    } else if (this.borders.columns()) {
                        this.printDivider(builder, "\u255a\u2550\u256a\u2550\u255d");
                    } else {
                        this.printDivider(builder, "\u255a\u2550\u2567\u2550\u255d");
                    }
                } else if (row == 0 && !this.borders.header()) {
                    if (this.borders.columns()) {
                        this.printDivider(builder, " \u2500\u253c\u2500 ");
                    } else {
                        this.printDivider(builder, " \u2500\u253c\u2500 ");
                    }
                } else if (this.borders.rows()) {
                    if (this.borders.columns()) {
                        this.printDivider(builder, "\u255f\u2500\u253c\u2500\u2562");
                    } else {
                        this.printDivider(builder, "\u255f\u2500\u253c\u2500\u2562");
                    }
                }
                this.printData(builder, this.data[row], false);
            }
            if (this.borders.body()) {
                if (this.borders.columns()) {
                    this.printDivider(builder, "\u255a\u2550\u2567\u2550\u255d");
                } else {
                    this.printDivider(builder, "\u255a\u2550\u2550\u2550\u255d");
                }
            }
        }
        return builder.toString();
    }

    private void printDivider(StringBuilder out, String format) {
        for (int column = 0; column < this.columns; ++column) {
            out.append(column == 0 ? format.charAt(0) : format.charAt(2));
            out.append(FlipTable.pad(this.columnWidths[column], "").replace(' ', format.charAt(1)));
        }
        out.append(format.charAt(4)).append('\n');
    }

    private void printData(StringBuilder out, Object[] data, boolean isHeader) {
        int lines = 1;
        for (int line = 0; line < lines; ++line) {
            for (int column = 0; column < this.columns; ++column) {
                if (column == 0) {
                    if (isHeader && this.borders.header() || this.borders.body()) {
                        out.append('\u2551');
                    } else {
                        out.append(' ');
                    }
                } else if (isHeader || this.borders.columns()) {
                    out.append('\u2502');
                } else {
                    out.append(' ');
                }
                Object cell = data[column];
                if (cell == null) {
                    cell = "";
                }
                String[] cellLines = cell.toString().split("\\n");
                lines = Math.max(lines, cellLines.length);
                String cellLine = line < cellLines.length ? cellLines[line] : "";
                out.append(FlipTable.pad(this.columnWidths[column], cellLine));
            }
            if (isHeader && this.borders.header() || this.borders.body()) {
                out.append("\u2551\n");
                continue;
            }
            out.append('\n');
        }
    }

    private static String pad(int width, String data) {
        return String.format(" %1$-" + width + "s ", data);
    }

    public static enum Borders {
        FULL(15),
        BODY_HCOLS(13),
        HCOLS(12),
        BODY(9),
        HEADER(8),
        COLS(4);

        final int bitmask;

        private Borders(int bitmask) {
            this.bitmask = bitmask;
        }

        boolean header() {
            return this.isset(8);
        }

        boolean body() {
            return this.isset(1);
        }

        boolean rows() {
            return this.isset(2);
        }

        boolean columns() {
            return this.isset(4);
        }

        boolean isset(int v) {
            return (this.bitmask & v) == v;
        }
    }
}

