/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.models.PathModel;
import com.gitblit.utils.DiffUtils;
import com.gitblit.utils.ResettableByteArrayOutputStream;
import com.gitblit.utils.StringUtils;
import com.gitblit.wicket.GitBlitWebApp;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.Application;
import org.apache.wicket.Localizer;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.RawParseUtils;

public class GitBlitDiffFormatter
extends DiffFormatter {
    private static final Pattern trailingWhitespace = Pattern.compile("(\\s+?)\r?\n?$");
    private static final String DIFF_LIMIT_PER_FILE_KEY = "web.maxDiffLinesPerFile";
    private static final String GLOBAL_DIFF_LIMIT_KEY = "web.maxDiffLines";
    private static final int DIFF_LIMIT_PER_FILE = 4000;
    private static final int GLOBAL_DIFF_LIMIT = 20000;
    private static final boolean CONVERT_TABS = true;
    private final DiffOutputStream os;
    private final DiffUtils.DiffStat diffStat;
    private PathModel.PathChangeModel currentPath;
    private int left;
    private int right;
    private final int maxDiffLinesPerFile;
    private final int globalDiffLimit;
    private int nofLinesCurrent;
    private int startCurrent;
    private boolean isOff;
    private DiffEntry entry;
    private int totalNofLinesPrevious;
    private int totalNofLinesCurrent;
    private int truncateTo;
    private boolean truncated;
    private final List<DiffEntry> skipped = new ArrayList<DiffEntry>();
    private int tabLength;

    public GitBlitDiffFormatter(String commitId, Repository repository, String path, DiffUtils.BinaryDiffHandler handler, int tabLength) {
        super((OutputStream)new DiffOutputStream());
        this.os = (DiffOutputStream)this.getOutputStream();
        this.os.setFormatter(this, handler);
        this.diffStat = new DiffUtils.DiffStat(commitId, repository);
        this.tabLength = tabLength;
        this.maxDiffLinesPerFile = path != null ? -1 : this.getLimit(DIFF_LIMIT_PER_FILE_KEY, 500, 4000);
        this.globalDiffLimit = path != null ? -1 : this.getLimit(GLOBAL_DIFF_LIMIT_KEY, 1000, 20000);
    }

    private int getLimit(String key, int minimum, int maximum) {
        Application application;
        if (Application.exists() && (application = Application.get()) instanceof GitBlitWebApp) {
            GitBlitWebApp webApp = (GitBlitWebApp)application;
            int configValue = webApp.settings().getInteger(key, maximum);
            if (configValue < minimum) {
                return minimum;
            }
            if (configValue < maximum) {
                return configValue;
            }
        }
        return maximum;
    }

    private String getMsg(String key, String defaultValue) {
        Localizer localizer;
        if (Application.exists() && (localizer = Application.get().getResourceSettings().getLocalizer()) != null) {
            return localizer.getStringIgnoreSettings(key, null, null, defaultValue);
        }
        return defaultValue;
    }

    public void format(DiffEntry ent) throws IOException {
        this.currentPath = this.diffStat.addPath(ent);
        this.nofLinesCurrent = 0;
        this.isOff = false;
        this.entry = ent;
        if (!this.truncated) {
            this.totalNofLinesPrevious = this.totalNofLinesCurrent;
            if (this.globalDiffLimit > 0 && this.totalNofLinesPrevious > this.globalDiffLimit) {
                this.truncated = true;
                this.isOff = true;
            }
            this.truncateTo = this.os.size();
        } else {
            this.isOff = true;
        }
        if (this.truncated) {
            this.skipped.add(ent);
        } else {
            String id;
            String path;
            if (DiffEntry.ChangeType.DELETE.equals((Object)ent.getChangeType())) {
                path = ent.getOldPath();
                id = ent.getOldId().name();
            } else {
                path = ent.getNewPath();
                id = ent.getNewId().name();
            }
            StringBuilder sb = new StringBuilder(MessageFormat.format("<div class='header'><div class=\"diffHeader\" id=\"n{0}\"><i class=\"icon-file\"></i> ", id));
            sb.append(StringUtils.escapeForHtml(path, false)).append("</div></div>");
            sb.append("<div class=\"diff\"><table cellpadding='0'><tbody>\n");
            this.os.write(sb.toString().getBytes());
        }
        super.format(ent);
        if (!this.truncated) {
            this.os.write("</tbody></table></div>\n".getBytes());
        }
    }

    public void flush() throws IOException {
        if (this.truncated) {
            this.os.resetTo(this.truncateTo);
        }
        super.flush();
    }

    private void reset() {
        if (!this.isOff) {
            this.os.resetTo(this.startCurrent);
            this.writeFullWidthLine(this.getMsg("gb.diffFileDiffTooLarge", "Diff too large"));
            this.totalNofLinesCurrent = this.totalNofLinesPrevious;
            this.isOff = true;
        }
    }

    private void handleChange() {
        String message;
        switch (this.entry.getChangeType()) {
            case ADD: {
                message = this.getMsg("gb.diffNewFile", "New file");
                break;
            }
            case DELETE: {
                message = this.getMsg("gb.diffDeletedFile", "File was deleted");
                this.isOff = true;
                break;
            }
            case RENAME: {
                message = MessageFormat.format(this.getMsg("gb.diffRenamedFile", "File was renamed from {0}"), this.entry.getOldPath());
                break;
            }
            case COPY: {
                message = MessageFormat.format(this.getMsg("gb.diffCopiedFile", "File was copied from {0}"), this.entry.getOldPath());
                break;
            }
            default: {
                return;
            }
        }
        this.writeFullWidthLine(message);
    }

    protected void writeHunkHeader(int aStartLine, int aEndLine, int bStartLine, int bEndLine) throws IOException {
        if (this.nofLinesCurrent++ == 0) {
            this.handleChange();
            this.startCurrent = this.os.size();
        }
        if (!this.isOff) {
            ++this.totalNofLinesCurrent;
            if (this.nofLinesCurrent > this.maxDiffLinesPerFile && this.maxDiffLinesPerFile > 0) {
                this.reset();
            } else {
                this.os.write("<tr><th class='diff-line' data-lineno='..'></th><th class='diff-line' data-lineno='..'></th><th class='diff-state'></th><td class='hunk_header'>".getBytes());
                this.os.write(64);
                this.os.write(64);
                this.writeRange('-', aStartLine + 1, aEndLine - aStartLine);
                this.writeRange('+', bStartLine + 1, bEndLine - bStartLine);
                this.os.write(32);
                this.os.write(64);
                this.os.write(64);
                this.os.write("</td></tr>\n".getBytes());
            }
        }
        this.left = aStartLine + 1;
        this.right = bStartLine + 1;
    }

    protected void writeRange(char prefix, int begin, int cnt) throws IOException {
        this.os.write(32);
        this.os.write(prefix);
        switch (cnt) {
            case 0: {
                this.os.write(Constants.encodeASCII((long)(begin - 1)));
                this.os.write(44);
                this.os.write(48);
                break;
            }
            case 1: {
                this.os.write(Constants.encodeASCII((long)begin));
                break;
            }
            default: {
                this.os.write(Constants.encodeASCII((long)begin));
                this.os.write(44);
                this.os.write(Constants.encodeASCII((long)cnt));
            }
        }
    }

    private void writeFullWidthLine(String text) {
        try {
            this.os.write("<tr><td class='diff-cell' colspan='4'>".getBytes());
            this.os.write(StringUtils.escapeForHtml(text, false).getBytes());
            this.os.write("</td></tr>\n".getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void writeLine(char prefix, RawText text, int cur) throws IOException {
        if (this.nofLinesCurrent++ == 0) {
            this.handleChange();
            this.startCurrent = this.os.size();
        }
        this.currentPath.update(prefix);
        if (this.isOff) {
            return;
        }
        ++this.totalNofLinesCurrent;
        if (this.nofLinesCurrent > this.maxDiffLinesPerFile && this.maxDiffLinesPerFile > 0) {
            this.reset();
        } else {
            this.os.write("<tr>".getBytes());
            switch (prefix) {
                case '+': {
                    this.os.write(("<th class='diff-line'></th><th class='diff-line' data-lineno='" + this.right++ + "'></th>").getBytes());
                    this.os.write("<th class='diff-state diff-state-add'></th>".getBytes());
                    this.os.write("<td class='diff-cell add2'>".getBytes());
                    break;
                }
                case '-': {
                    this.os.write(("<th class='diff-line' data-lineno='" + this.left++ + "'></th><th class='diff-line'></th>").getBytes());
                    this.os.write("<th class='diff-state diff-state-sub'></th>".getBytes());
                    this.os.write("<td class='diff-cell remove2'>".getBytes());
                    break;
                }
                default: {
                    this.os.write(("<th class='diff-line' data-lineno='" + this.left++ + "'></th><th class='diff-line' data-lineno='" + this.right++ + "'></th>").getBytes());
                    this.os.write("<th class='diff-state'></th>".getBytes());
                    this.os.write("<td class='diff-cell context2'>".getBytes());
                }
            }
            this.os.write(Constants.encode((String)this.codeLineToHtml(prefix, text.getString(cur))));
            this.os.write("</td></tr>\n".getBytes());
        }
    }

    private String codeLineToHtml(char prefix, String line) {
        Matcher matcher;
        if ((prefix == '+' || prefix == '-') && (matcher = trailingWhitespace.matcher(line)).find()) {
            StringBuilder result = new StringBuilder(StringUtils.escapeForHtml(line.substring(0, matcher.start()), true, this.tabLength));
            result.append("<span class='trailingws-").append(prefix == '+' ? "add" : "sub").append("'>");
            result.append(StringUtils.escapeForHtml(matcher.group(1), false));
            result.append("</span>");
            return result.toString();
        }
        return StringUtils.escapeForHtml(line, true, this.tabLength);
    }

    public String getHtml() {
        String html = RawParseUtils.decode((byte[])this.os.toByteArray());
        String[] lines = html.split("\n");
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            boolean gitLinkDiff;
            if (line.startsWith("index") || line.startsWith("similarity") || line.startsWith("rename from ") || line.startsWith("rename to ") || line.startsWith("new file") || line.startsWith("deleted file") || line.startsWith("\\ No newline") || line.startsWith("---") || line.startsWith("+++") || line.startsWith("diff")) continue;
            boolean bl = gitLinkDiff = line.length() > 0 && line.substring(1).startsWith("Subproject commit");
            if (gitLinkDiff) {
                sb.append("<tr><th class='diff-line'></th><th class='diff-line'></th>");
                if (line.charAt(0) == '+') {
                    sb.append("<th class='diff-state diff-state-add'></th><td class=\"diff-cell add2\">");
                } else {
                    sb.append("<th class='diff-state diff-state-sub'></th><td class=\"diff-cell remove2\">");
                }
                line = StringUtils.escapeForHtml(line.substring(1), true, this.tabLength);
            }
            sb.append(line);
            if (gitLinkDiff) {
                sb.append("</td></tr>");
            }
            sb.append('\n');
        }
        if (this.truncated) {
            sb.append(MessageFormat.format("<div class='header'><div class='diffHeader'>{0}</div></div>", StringUtils.escapeForHtml(this.getMsg("gb.diffTruncated", "Diff truncated after the above file"), false)));
            sb.append("<div class='diff'><table cellpadding='0'><tbody><tr><td class='diff-cell' colspan='4'>");
            String deletedSuffix = StringUtils.escapeForHtml(this.getMsg("gb.diffDeletedFileSkipped", "(deleted)"), false);
            boolean first = true;
            for (DiffEntry entry : this.skipped) {
                if (!first) {
                    sb.append('\n');
                }
                if (DiffEntry.ChangeType.DELETE.equals((Object)entry.getChangeType())) {
                    sb.append("<span id=\"n" + entry.getOldId().name() + "\">" + StringUtils.escapeForHtml(entry.getOldPath(), false) + ' ' + deletedSuffix + "</span>");
                } else {
                    sb.append("<span id=\"n" + entry.getNewId().name() + "\">" + StringUtils.escapeForHtml(entry.getNewPath(), false) + "</span>");
                }
                first = false;
            }
            this.skipped.clear();
            sb.append("</td></tr></tbody></table></div>");
        }
        return sb.toString();
    }

    public DiffUtils.DiffStat getDiffStat() {
        return this.diffStat;
    }

    private static class DiffOutputStream
    extends ResettableByteArrayOutputStream {
        private static final String BINARY_DIFFERENCE = "Binary files differ\n";
        private GitBlitDiffFormatter formatter;
        private DiffUtils.BinaryDiffHandler binaryDiffHandler;

        private DiffOutputStream() {
        }

        public void setFormatter(GitBlitDiffFormatter formatter, DiffUtils.BinaryDiffHandler handler) {
            this.formatter = formatter;
            this.binaryDiffHandler = handler;
        }

        @Override
        public void write(byte[] b, int offset, int length) {
            String binaryDiff;
            if (this.binaryDiffHandler != null && RawParseUtils.decode((byte[])Arrays.copyOfRange(b, offset, offset + length)).contains(BINARY_DIFFERENCE) && (binaryDiff = this.binaryDiffHandler.renderBinaryDiff(this.formatter.entry)) != null) {
                byte[] bb = ("<tr><td colspan='4' align='center'>" + binaryDiff + "</td></tr>").getBytes(StandardCharsets.UTF_8);
                super.write(bb, 0, bb.length);
                return;
            }
            super.write(b, offset, length);
        }
    }
}

