/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.Constants;
import com.gitblit.GitBlitException;
import com.gitblit.IStoredSettings;
import com.gitblit.git.PatchsetCommand;
import com.gitblit.models.FilestoreModel;
import com.gitblit.models.GitNote;
import com.gitblit.models.PathModel;
import com.gitblit.models.RefModel;
import com.gitblit.models.SubmoduleModel;
import com.gitblit.models.TicketModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.DiffStatFormatter;
import com.gitblit.utils.FileUtils;
import com.gitblit.utils.JnaUtils;
import com.gitblit.utils.PathUtils;
import com.gitblit.utils.StringUtils;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TagCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BlobBasedConfig;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.lib.TreeFormatter;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.RecursiveMerger;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.revwalk.RevBlob;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.PathSuffixFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.FS;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGitUtils {
    static final Logger LOGGER = LoggerFactory.getLogger(JGitUtils.class);

    private static void error(Throwable t, Repository repository, String pattern, Object ... objects) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (objects != null && objects.length > 0) {
            for (Object o : objects) {
                parameters.add(o);
            }
        }
        if (repository != null) {
            parameters.add(0, repository.getDirectory().getAbsolutePath());
        }
        LOGGER.error(MessageFormat.format(pattern, parameters.toArray()), t);
    }

    public static String getDisplayName(PersonIdent person) {
        if (StringUtils.isEmpty(person.getEmailAddress())) {
            return person.getName();
        }
        StringBuilder r = new StringBuilder();
        r.append(person.getName());
        r.append(" <");
        r.append(person.getEmailAddress());
        r.append('>');
        return r.toString().trim();
    }

    public static CloneResult cloneRepository(File repositoriesFolder, String name, String fromUrl) throws Exception {
        return JGitUtils.cloneRepository(repositoriesFolder, name, fromUrl, true, null);
    }

    public static CloneResult cloneRepository(File repositoriesFolder, String name, String fromUrl, boolean bare, CredentialsProvider credentialsProvider) throws Exception {
        CloneResult result = new CloneResult();
        if (bare) {
            if (!name.toLowerCase().endsWith(".git")) {
                name = name + ".git";
            }
        } else if (name.toLowerCase().endsWith(".git")) {
            name = name.substring(0, name.indexOf(".git"));
        }
        result.name = name;
        File folder = new File(repositoriesFolder, name);
        if (folder.exists()) {
            File gitDir = RepositoryCache.FileKey.resolve((File)new File(repositoriesFolder, name), (FS)FS.DETECTED);
            Repository repository = ((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(gitDir)).build();
            result.fetchResult = JGitUtils.fetchRepository(credentialsProvider, repository, new RefSpec[0]);
            repository.close();
        } else {
            CloneCommand clone = new CloneCommand();
            clone.setBare(bare);
            clone.setCloneAllBranches(true);
            clone.setURI(fromUrl);
            clone.setDirectory(folder);
            if (credentialsProvider != null) {
                clone.setCredentialsProvider(credentialsProvider);
            }
            Repository repository = clone.call().getRepository();
            result.createdRepository = true;
            result.fetchResult = JGitUtils.fetchRepository(credentialsProvider, repository, new RefSpec[0]);
            repository.close();
        }
        return result;
    }

    public static FetchResult fetchRepository(CredentialsProvider credentialsProvider, Repository repository, RefSpec ... refSpecs) throws Exception {
        Git git2 = new Git(repository);
        FetchCommand fetch = git2.fetch();
        ArrayList<RefSpec> specs = new ArrayList<RefSpec>();
        if (refSpecs == null || refSpecs.length == 0) {
            specs.add(new RefSpec("+refs/heads/*:refs/remotes/origin/*"));
            specs.add(new RefSpec("+refs/tags/*:refs/tags/*"));
            specs.add(new RefSpec("+refs/notes/*:refs/notes/*"));
        } else {
            specs.addAll(Arrays.asList(refSpecs));
        }
        if (credentialsProvider != null) {
            fetch.setCredentialsProvider(credentialsProvider);
        }
        fetch.setRefSpecs(specs);
        FetchResult fetchRes = fetch.call();
        return fetchRes;
    }

    public static Repository createRepository(File repositoriesFolder, String name) {
        return JGitUtils.createRepository(repositoriesFolder, name, "FALSE");
    }

    public static Repository createRepository(File repositoriesFolder, String name, String shared) {
        try {
            Repository repo = null;
            try {
                Git git2 = Git.init().setDirectory(new File(repositoriesFolder, name)).setBare(true).call();
                repo = git2.getRepository();
            }
            catch (GitAPIException e) {
                throw new RuntimeException(e);
            }
            GitConfigSharedRepository sharedRepository = new GitConfigSharedRepository(shared);
            if (sharedRepository.isShared()) {
                StoredConfig config = repo.getConfig();
                config.setString("core", null, "sharedRepository", sharedRepository.getValue());
                config.setBoolean("receive", null, "denyNonFastforwards", true);
                config.save();
                if (!JnaUtils.isWindows()) {
                    Iterator iter = org.apache.commons.io.FileUtils.iterateFilesAndDirs((File)repo.getDirectory(), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
                    while (iter.hasNext()) {
                        JGitUtils.adjustSharedPerm((File)iter.next(), sharedRepository);
                    }
                }
            }
            return repo;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int adjustSharedPerm(File path, String configShared) {
        return JGitUtils.adjustSharedPerm(path, new GitConfigSharedRepository(configShared));
    }

    public static int adjustSharedPerm(File path, GitConfigSharedRepository configShared) {
        if (!configShared.isShared()) {
            return 0;
        }
        if (!path.exists()) {
            return -1;
        }
        int perm = configShared.getPerm();
        JnaUtils.Filestat stat = JnaUtils.getFilestat(path);
        if (stat == null) {
            return -1;
        }
        int mode = stat.mode;
        if (mode < 0) {
            return -1;
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("linux") && (mode & 0xC00) != 0 && stat.gid != JnaUtils.getegid()) {
            LOGGER.debug("Not adjusting permissions to prevent clearing suid/sgid bits for '" + path + "'");
            return 0;
        }
        if ((mode & 0x80) == 0) {
            perm &= 0xFFFFFF6D;
        }
        if ((mode & 0x40) == 64) {
            perm |= (perm & 0x124) >> 2;
        }
        mode = configShared.isCustom() ? mode & 0xFFFFFE00 | perm : (mode |= perm);
        if (path.isDirectory()) {
            mode |= (mode & 0x124) >> 2;
            mode |= 0x400;
        }
        return JnaUtils.setFilemode(path, mode);
    }

    public static List<String> getRepositoryList(File repositoriesFolder, boolean onlyBare, boolean searchSubfolders, int depth, List<String> exclusions) {
        ArrayList<String> list = new ArrayList<String>();
        if (repositoriesFolder == null || !repositoriesFolder.exists()) {
            return list;
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        if (!ArrayUtils.isEmpty(exclusions)) {
            for (String regex2 : exclusions) {
                patterns.add(Pattern.compile(regex2));
            }
        }
        list.addAll(JGitUtils.getRepositoryList(repositoriesFolder.getAbsolutePath(), repositoriesFolder, onlyBare, searchSubfolders, depth, patterns));
        StringUtils.sortRepositorynames(list);
        list.remove(".git");
        return list;
    }

    private static List<String> getRepositoryList(String basePath, File searchFolder, boolean onlyBare, boolean searchSubfolders, int depth, List<Pattern> patterns) {
        File baseFile = new File(basePath);
        ArrayList<String> list = new ArrayList<String>();
        if (depth == 0) {
            return list;
        }
        int nextDepth = depth == -1 ? -1 : depth - 1;
        for (File file : searchFolder.listFiles()) {
            if (!file.isDirectory()) continue;
            boolean exclude = false;
            for (Pattern pattern : patterns) {
                String path;
                if (!pattern.matcher(path = FileUtils.getRelativePath(baseFile, file).replace('\\', '/')).matches()) continue;
                LOGGER.debug(MessageFormat.format("excluding {0} because of rule {1}", path, pattern.pattern()));
                exclude = true;
                break;
            }
            if (exclude) continue;
            File gitDir = RepositoryCache.FileKey.resolve((File)new File(searchFolder, file.getName()), (FS)FS.DETECTED);
            if (gitDir != null) {
                if (onlyBare && gitDir.getName().equals(".git")) continue;
                if (gitDir.equals(file) || gitDir.getParentFile().equals(file)) {
                    String repository = FileUtils.getRelativePath(baseFile, file);
                    list.add(repository);
                    continue;
                }
                if (!searchSubfolders || !file.canRead()) continue;
                list.addAll(JGitUtils.getRepositoryList(basePath, file, onlyBare, searchSubfolders, nextDepth, patterns));
                continue;
            }
            if (!searchSubfolders || !file.canRead()) continue;
            list.addAll(JGitUtils.getRepositoryList(basePath, file, onlyBare, searchSubfolders, nextDepth, patterns));
        }
        return list;
    }

    public static RevCommit getFirstCommit(Repository repository, String branch) {
        if (!JGitUtils.hasCommits(repository)) {
            return null;
        }
        RevCommit commit = null;
        try {
            ObjectId branchObject = StringUtils.isEmpty(branch) ? JGitUtils.getDefaultBranch(repository) : repository.resolve(branch);
            RevWalk walk = new RevWalk(repository);
            walk.sort(RevSort.REVERSE);
            RevCommit head = walk.parseCommit((AnyObjectId)branchObject);
            walk.markStart(head);
            commit = walk.next();
            walk.dispose();
        }
        catch (Throwable t) {
            JGitUtils.error(t, repository, "{0} failed to determine first commit", new Object[0]);
        }
        return commit;
    }

    public static Date getFirstChange(Repository repository, String branch) {
        RevCommit commit = JGitUtils.getFirstCommit(repository, branch);
        if (commit == null) {
            if (repository == null || !repository.getDirectory().exists()) {
                return new Date(0L);
            }
            return new Date(repository.getDirectory().lastModified());
        }
        return JGitUtils.getCommitDate(commit);
    }

    public static boolean hasCommits(Repository repository) {
        if (repository != null && repository.getDirectory().exists()) {
            return new File(repository.getDirectory(), "objects").list().length > 2 || new File(repository.getDirectory(), "objects/pack").list().length > 0;
        }
        return false;
    }

    public static LastChange getLastChange(Repository repository) {
        if (!JGitUtils.hasCommits(repository)) {
            if (repository == null) {
                return new LastChange();
            }
            return new LastChange(repository.getDirectory().lastModified());
        }
        List<RefModel> branchModels = JGitUtils.getLocalBranches(repository, true, -1);
        if (branchModels.size() > 0) {
            LastChange lastChange = new LastChange();
            for (RefModel branchModel : branchModels) {
                if (!branchModel.getDate().after(lastChange.when)) continue;
                lastChange.when = branchModel.getDate();
                lastChange.who = branchModel.getAuthorIdent().getName();
            }
            return lastChange;
        }
        return new LastChange(repository.getDirectory().lastModified());
    }

    public static Date getCommitDate(RevCommit commit) {
        if (commit == null) {
            return new Date(0L);
        }
        return new Date((long)commit.getCommitTime() * 1000L);
    }

    public static Date getAuthorDate(RevCommit commit) {
        if (commit == null) {
            return new Date(0L);
        }
        if (commit.getAuthorIdent() != null) {
            return commit.getAuthorIdent().getWhen();
        }
        return JGitUtils.getCommitDate(commit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RevCommit getCommit(Repository repository, String objectId) {
        if (!JGitUtils.hasCommits(repository)) {
            return null;
        }
        RevCommit commit = null;
        RevWalk walk = null;
        try {
            RevCommit rev;
            ObjectId branchObject = StringUtils.isEmpty(objectId) || "HEAD".equalsIgnoreCase(objectId) ? JGitUtils.getDefaultBranch(repository) : repository.resolve(objectId);
            if (branchObject == null) {
                RevCommit revCommit = null;
                return revCommit;
            }
            walk = new RevWalk(repository);
            commit = rev = walk.parseCommit((AnyObjectId)branchObject);
        }
        catch (Throwable t) {
            JGitUtils.error(t, repository, "{0} failed to get commit {1}", objectId);
        }
        finally {
            if (walk != null) {
                walk.dispose();
            }
        }
        return commit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getByteContent(Repository repository, RevTree tree, String path, boolean throwError) {
        RevWalk rw = new RevWalk(repository);
        TreeWalk tw = new TreeWalk(repository);
        tw.setFilter(PathFilterGroup.createFromStrings(Collections.singleton(path)));
        byte[] content = null;
        try {
            if (tree == null) {
                ObjectId object = JGitUtils.getDefaultBranch(repository);
                if (object == null) {
                    byte[] byArray = null;
                    return byArray;
                }
                RevCommit commit = rw.parseCommit((AnyObjectId)object);
                tree = commit.getTree();
            }
            tw.reset((AnyObjectId)tree);
            while (tw.next()) {
                if (tw.isSubtree() && !path.equals(tw.getPathString())) {
                    tw.enterSubtree();
                    continue;
                }
                ObjectId entid = tw.getObjectId(0);
                FileMode entmode = tw.getFileMode(0);
                if (entmode == FileMode.GITLINK) continue;
                ObjectLoader ldr = repository.open((AnyObjectId)entid, 3);
                content = ldr.getCachedBytes();
            }
        }
        catch (Throwable t) {
            if (throwError) {
                JGitUtils.error(t, repository, "{0} can''t find {1} in tree {2}", path, tree.name());
            }
        }
        finally {
            rw.dispose();
            tw.close();
        }
        return content;
    }

    public static String getStringContent(Repository repository, RevTree tree, String blobPath, String ... charsets) {
        byte[] content = JGitUtils.getByteContent(repository, tree, blobPath, true);
        if (content == null) {
            return null;
        }
        return StringUtils.decodeString(content, charsets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getByteContent(Repository repository, String objectId) {
        RevWalk rw = new RevWalk(repository);
        byte[] content = null;
        try {
            RevBlob blob = rw.lookupBlob((AnyObjectId)ObjectId.fromString((String)objectId));
            ObjectLoader ldr = repository.open((AnyObjectId)blob.getId(), 3);
            content = ldr.getCachedBytes();
        }
        catch (Throwable t) {
            JGitUtils.error(t, repository, "{0} can''t find blob {1}", objectId);
        }
        finally {
            rw.dispose();
        }
        return content;
    }

    public static String getStringContent(Repository repository, String objectId, String ... charsets) {
        byte[] content = JGitUtils.getByteContent(repository, objectId);
        if (content == null) {
            return null;
        }
        return StringUtils.decodeString(content, charsets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PathModel> getFilesInPath(Repository repository, String path, RevCommit commit) {
        ArrayList<PathModel> list = new ArrayList<PathModel>();
        if (!JGitUtils.hasCommits(repository)) {
            return list;
        }
        if (commit == null) {
            commit = JGitUtils.getCommit(repository, null);
        }
        try (TreeWalk tw = new TreeWalk(repository);){
            tw.addTree((AnyObjectId)commit.getTree());
            if (!StringUtils.isEmpty(path)) {
                PathFilter f = PathFilter.create((String)path);
                tw.setFilter((TreeFilter)f);
                tw.setRecursive(false);
                boolean foundFolder = false;
                while (tw.next()) {
                    if (!foundFolder && tw.isSubtree()) {
                        tw.enterSubtree();
                    }
                    if (tw.getPathString().equals(path)) {
                        foundFolder = true;
                        continue;
                    }
                    if (!foundFolder) continue;
                    list.add(JGitUtils.getPathModel(tw, path, commit));
                }
            } else {
                tw.setRecursive(false);
                while (tw.next()) {
                    list.add(JGitUtils.getPathModel(tw, null, commit));
                }
            }
        }
        Collections.sort(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PathModel> getFilesInPath2(Repository repository, String path, RevCommit commit) {
        ArrayList<PathModel> list = new ArrayList<PathModel>();
        if (!JGitUtils.hasCommits(repository)) {
            return list;
        }
        if (commit == null) {
            commit = JGitUtils.getCommit(repository, null);
        }
        try (TreeWalk tw = new TreeWalk(repository);){
            tw.addTree((AnyObjectId)commit.getTree());
            boolean isPathEmpty = Strings.isNullOrEmpty((String)path);
            if (!isPathEmpty) {
                PathFilter f = PathFilter.create((String)path);
                tw.setFilter((TreeFilter)f);
            }
            tw.setRecursive(true);
            ArrayList<String> paths = new ArrayList<String>();
            while (tw.next()) {
                String pathString = tw.getPathString();
                String child = isPathEmpty ? pathString : pathString.replaceFirst(Pattern.quote(String.format("%s/", path)), "");
                paths.add(child);
            }
            for (String p : PathUtils.compressPaths(paths)) {
                String pathString = isPathEmpty ? p : String.format("%s/%s", path, p);
                list.add(JGitUtils.getPathModel(repository, pathString, path, commit));
            }
        }
        Collections.sort(list);
        return list;
    }

    public static List<PathModel.PathChangeModel> getFilesInCommit(Repository repository, RevCommit commit) {
        return JGitUtils.getFilesInCommit(repository, commit, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PathModel.PathChangeModel> getFilesInCommit(Repository repository, RevCommit commit, boolean calculateDiffStat) {
        ArrayList<PathModel.PathChangeModel> list;
        block15: {
            list = new ArrayList<PathModel.PathChangeModel>();
            if (!JGitUtils.hasCommits(repository)) {
                return list;
            }
            RevWalk rw = new RevWalk(repository);
            try {
                if (commit == null) {
                    ObjectId object = JGitUtils.getDefaultBranch(repository);
                    commit = rw.parseCommit((AnyObjectId)object);
                }
                if (commit.getParentCount() == 0) {
                    TreeWalk tw = new TreeWalk(repository);
                    tw.reset();
                    tw.setRecursive(true);
                    tw.addTree((AnyObjectId)commit.getTree());
                    while (tw.next()) {
                        long size = 0L;
                        FilestoreModel filestoreItem = null;
                        ObjectId objectId = tw.getObjectId(0);
                        try {
                            if (!tw.isSubtree() && tw.getFileMode(0) != FileMode.GITLINK && JGitUtils.isPossibleFilestoreItem(size = tw.getObjectReader().getObjectSize((AnyObjectId)objectId, 3))) {
                                filestoreItem = JGitUtils.getFilestoreItem(tw.getObjectReader().open((AnyObjectId)objectId));
                            }
                        }
                        catch (Throwable t) {
                            JGitUtils.error(t, null, "failed to retrieve blob size for " + tw.getPathString(), new Object[0]);
                        }
                        list.add(new PathModel.PathChangeModel(tw.getPathString(), tw.getPathString(), filestoreItem, size, tw.getRawMode(0), objectId.getName(), commit.getId().getName(), DiffEntry.ChangeType.ADD));
                    }
                    tw.close();
                    break block15;
                }
                RevCommit parent = rw.parseCommit((AnyObjectId)commit.getParent(0).getId());
                DiffStatFormatter df = new DiffStatFormatter(commit.getName(), repository);
                df.setRepository(repository);
                df.setDiffComparator(RawTextComparator.DEFAULT);
                df.setDetectRenames(true);
                List diffs = df.scan(parent.getTree(), commit.getTree());
                for (DiffEntry diff : diffs) {
                    PathModel.PathChangeModel pcm = PathModel.PathChangeModel.from(diff, commit.getName(), repository);
                    if (calculateDiffStat) {
                        df.format(diff);
                        PathModel.PathChangeModel pathStat = df.getDiffStat().getPath(pcm.path);
                        if (pathStat != null) {
                            pcm.insertions = pathStat.insertions;
                            pcm.deletions = pathStat.deletions;
                        }
                    }
                    list.add(pcm);
                }
            }
            catch (Throwable t) {
                JGitUtils.error(t, repository, "{0} failed to determine files in commit!", new Object[0]);
            }
            finally {
                rw.dispose();
            }
        }
        return list;
    }

    public static List<PathModel.PathChangeModel> getFilesInRange(Repository repository, String startCommit, String endCommit) {
        ArrayList<PathModel.PathChangeModel> list = new ArrayList<PathModel.PathChangeModel>();
        if (!JGitUtils.hasCommits(repository)) {
            return list;
        }
        try {
            ObjectId startRange = repository.resolve(startCommit);
            ObjectId endRange = repository.resolve(endCommit);
            RevWalk rw = new RevWalk(repository);
            RevCommit start = rw.parseCommit((AnyObjectId)startRange);
            RevCommit end = rw.parseCommit((AnyObjectId)endRange);
            list.addAll(JGitUtils.getFilesInRange(repository, start, end));
            rw.close();
        }
        catch (Throwable t) {
            JGitUtils.error(t, repository, "{0} failed to determine files in range {1}..{2}!", startCommit, endCommit);
        }
        return list;
    }

    public static List<PathModel.PathChangeModel> getFilesInRange(Repository repository, RevCommit startCommit, RevCommit endCommit) {
        ArrayList<PathModel.PathChangeModel> list = new ArrayList<PathModel.PathChangeModel>();
        if (!JGitUtils.hasCommits(repository)) {
            return list;
        }
        try {
            DiffFormatter df = new DiffFormatter(null);
            df.setRepository(repository);
            df.setDiffComparator(RawTextComparator.DEFAULT);
            df.setDetectRenames(true);
            List diffEntries = df.scan(startCommit.getTree(), endCommit.getTree());
            for (DiffEntry diff : diffEntries) {
                PathModel.PathChangeModel pcm = PathModel.PathChangeModel.from(diff, endCommit.getName(), repository);
                list.add(pcm);
            }
            Collections.sort(list);
        }
        catch (Throwable t) {
            JGitUtils.error(t, repository, "{0} failed to determine files in range {1}..{2}!", startCommit, endCommit);
        }
        return list;
    }

    public static List<PathModel> getDocuments(Repository repository, List<String> extensions) {
        return JGitUtils.getDocuments(repository, extensions, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PathModel> getDocuments(Repository repository, List<String> extensions, String objectId) {
        ArrayList<PathModel> list = new ArrayList<PathModel>();
        if (!JGitUtils.hasCommits(repository)) {
            return list;
        }
        RevCommit commit = JGitUtils.getCommit(repository, objectId);
        try (TreeWalk tw = new TreeWalk(repository);){
            tw.addTree((AnyObjectId)commit.getTree());
            if (extensions != null && extensions.size() > 0) {
                ArrayList<PathSuffixFilter> suffixFilters = new ArrayList<PathSuffixFilter>();
                for (String extension : extensions) {
                    if (extension.charAt(0) == '.') {
                        suffixFilters.add(PathSuffixFilter.create((String)extension));
                        continue;
                    }
                    suffixFilters.add(PathSuffixFilter.create((String)("." + extension)));
                }
                TreeFilter filter = suffixFilters.size() == 1 ? (TreeFilter)suffixFilters.get(0) : OrTreeFilter.create(suffixFilters);
                tw.setFilter(filter);
                tw.setRecursive(true);
            }
            while (tw.next()) {
                list.add(JGitUtils.getPathModel(tw, null, commit));
            }
        }
        Collections.sort(list);
        return list;
    }

    private static PathModel getPathModel(TreeWalk tw, String basePath, RevCommit commit) {
        long size = 0L;
        String name = StringUtils.isEmpty(basePath) ? tw.getPathString() : tw.getPathString().substring(basePath.length() + 1);
        ObjectId objectId = tw.getObjectId(0);
        FilestoreModel filestoreItem = null;
        try {
            if (!tw.isSubtree() && tw.getFileMode(0) != FileMode.GITLINK && JGitUtils.isPossibleFilestoreItem(size = tw.getObjectReader().getObjectSize((AnyObjectId)objectId, 3))) {
                filestoreItem = JGitUtils.getFilestoreItem(tw.getObjectReader().open((AnyObjectId)objectId));
            }
        }
        catch (Throwable t) {
            JGitUtils.error(t, null, "failed to retrieve blob size for " + tw.getPathString(), new Object[0]);
        }
        return new PathModel(name, tw.getPathString(), filestoreItem, size, tw.getFileMode(0).getBits(), objectId.getName(), commit.getName());
    }

    public static boolean isPossibleFilestoreItem(long size) {
        return size >= 125L && size <= 146L;
    }

    public static FilestoreModel getFilestoreItem(ObjectLoader obj) {
        try {
            byte[] blob = obj.getCachedBytes(146);
            String meta = new String(blob, "UTF-8");
            return FilestoreModel.fromMetaString(meta);
        }
        catch (LargeObjectException blob) {
        }
        catch (Exception e) {
            JGitUtils.error(e, null, "failed to retrieve filestoreItem " + obj.toString(), new Object[0]);
        }
        return null;
    }

    private static PathModel getPathModel(Repository repo, String path, String filter, RevCommit commit) throws IOException {
        long size = 0L;
        FilestoreModel filestoreItem = null;
        TreeWalk tw = TreeWalk.forPath((Repository)repo, (String)path, (RevTree)commit.getTree());
        String pathString = path;
        if (!tw.isSubtree() && tw.getFileMode(0) != FileMode.GITLINK) {
            pathString = PathUtils.getLastPathComponent(pathString);
            size = tw.getObjectReader().getObjectSize((AnyObjectId)tw.getObjectId(0), 3);
            if (JGitUtils.isPossibleFilestoreItem(size)) {
                filestoreItem = JGitUtils.getFilestoreItem(tw.getObjectReader().open((AnyObjectId)tw.getObjectId(0)));
            }
        } else if (tw.isSubtree()) {
            if (!Strings.isNullOrEmpty((String)filter)) {
                pathString = path.replaceFirst(filter + "/", "");
            }
            if (pathString != null && pathString.charAt(pathString.length() - 1) == '/') {
                pathString = pathString.substring(0, pathString.length() - 1);
            }
        }
        return new PathModel(pathString, tw.getPathString(), filestoreItem, size, tw.getFileMode(0).getBits(), tw.getObjectId(0).getName(), commit.getName());
    }

    public static String getPermissionsFromMode(int mode) {
        if (FileMode.TREE.equals(mode)) {
            return "drwxr-xr-x";
        }
        if (FileMode.REGULAR_FILE.equals(mode)) {
            return "-rw-r--r--";
        }
        if (FileMode.EXECUTABLE_FILE.equals(mode)) {
            return "-rwxr-xr-x";
        }
        if (FileMode.SYMLINK.equals(mode)) {
            return "symlink";
        }
        if (FileMode.GITLINK.equals(mode)) {
            return "submodule";
        }
        return "missing";
    }

    public static List<RevCommit> getRevLog(Repository repository, String objectId, Date minimumDate) {
        ArrayList<RevCommit> list = new ArrayList<RevCommit>();
        if (!JGitUtils.hasCommits(repository)) {
            return list;
        }
        try {
            ObjectId branchObject = StringUtils.isEmpty(objectId) ? JGitUtils.getDefaultBranch(repository) : repository.resolve(objectId);
            RevWalk rw = new RevWalk(repository);
            rw.markStart(rw.parseCommit((AnyObjectId)branchObject));
            rw.setRevFilter(CommitTimeRevFilter.after((Date)minimumDate));
            RevWalk revlog = rw;
            for (RevCommit rev : revlog) {
                list.add(rev);
            }
            rw.dispose();
        }
        catch (Throwable t) {
            JGitUtils.error(t, repository, "{0} failed to get {1} revlog for minimum date {2}", objectId, minimumDate);
        }
        return list;
    }

    public static List<RevCommit> getRevLog(Repository repository, int maxCount) {
        return JGitUtils.getRevLog(repository, null, 0, maxCount);
    }

    public static List<RevCommit> getRevLog(Repository repository, String objectId, int offset, int maxCount) {
        return JGitUtils.getRevLog(repository, objectId, null, offset, maxCount);
    }

    public static List<RevCommit> getRevLog(Repository repository, String objectId, String path, int offset, int maxCount) {
        ArrayList<RevCommit> list = new ArrayList<RevCommit>();
        if (maxCount == 0) {
            return list;
        }
        if (!JGitUtils.hasCommits(repository)) {
            return list;
        }
        try {
            ObjectId endRange;
            ObjectId startRange = null;
            if (StringUtils.isEmpty(objectId)) {
                endRange = JGitUtils.getDefaultBranch(repository);
            } else if (objectId.contains("..")) {
                String[] parts = objectId.split("\\.\\.");
                startRange = repository.resolve(parts[0]);
                endRange = repository.resolve(parts[1]);
            } else {
                endRange = repository.resolve(objectId);
            }
            if (endRange == null) {
                return list;
            }
            RevWalk rw = new RevWalk(repository);
            rw.markStart(rw.parseCommit((AnyObjectId)endRange));
            if (startRange != null) {
                rw.markUninteresting(rw.parseCommit((AnyObjectId)startRange));
            }
            if (!StringUtils.isEmpty(path)) {
                TreeFilter filter = AndTreeFilter.create((TreeFilter)PathFilterGroup.createFromStrings(Collections.singleton(path)), (TreeFilter)TreeFilter.ANY_DIFF);
                rw.setTreeFilter(filter);
            }
            RevWalk revlog = rw;
            if (offset > 0) {
                int count = 0;
                for (RevCommit rev : revlog) {
                    if (++count <= offset) continue;
                    list.add(rev);
                    if (maxCount <= 0 || list.size() != maxCount) continue;
                    break;
                }
            } else {
                for (RevCommit rev : revlog) {
                    list.add(rev);
                    if (maxCount <= 0 || list.size() != maxCount) continue;
                    break;
                }
            }
            rw.dispose();
        }
        catch (Throwable t) {
            JGitUtils.error(t, repository, "{0} failed to get {1} revlog for path {2}", objectId, path);
        }
        return list;
    }

    public static List<RevCommit> getRevLog(Repository repository, String startRangeId, String endRangeId) {
        ArrayList<RevCommit> list = new ArrayList<RevCommit>();
        if (!JGitUtils.hasCommits(repository)) {
            return list;
        }
        try {
            ObjectId endRange = repository.resolve(endRangeId);
            ObjectId startRange = repository.resolve(startRangeId);
            RevWalk rw = new RevWalk(repository);
            rw.markStart(rw.parseCommit((AnyObjectId)endRange));
            if (startRange.equals((AnyObjectId)ObjectId.zeroId())) {
                list.add(rw.parseCommit((AnyObjectId)endRange));
                rw.dispose();
                return list;
            }
            rw.markUninteresting(rw.parseCommit((AnyObjectId)startRange));
            RevWalk revlog = rw;
            for (RevCommit rev : revlog) {
                list.add(rev);
            }
            rw.dispose();
        }
        catch (Throwable t) {
            JGitUtils.error(t, repository, "{0} failed to get revlog for {1}..{2}", startRangeId, endRangeId);
        }
        return list;
    }

    public static List<RevCommit> searchRevlogs(Repository repository, String objectId, String value, final Constants.SearchType type, int offset, int maxCount) {
        ArrayList<RevCommit> list = new ArrayList<RevCommit>();
        if (StringUtils.isEmpty(value)) {
            return list;
        }
        if (maxCount == 0) {
            return list;
        }
        if (!JGitUtils.hasCommits(repository)) {
            return list;
        }
        final String lcValue = value.toLowerCase();
        try {
            ObjectId branchObject = StringUtils.isEmpty(objectId) ? JGitUtils.getDefaultBranch(repository) : repository.resolve(objectId);
            RevWalk rw = new RevWalk(repository);
            rw.setRevFilter(new RevFilter(){

                public RevFilter clone() {
                    return this;
                }

                public boolean include(RevWalk walker, RevCommit commit) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
                    boolean include = false;
                    switch (type) {
                        case AUTHOR: {
                            include = commit.getAuthorIdent().getName().toLowerCase().indexOf(lcValue) > -1 || commit.getAuthorIdent().getEmailAddress().toLowerCase().indexOf(lcValue) > -1;
                            break;
                        }
                        case COMMITTER: {
                            include = commit.getCommitterIdent().getName().toLowerCase().indexOf(lcValue) > -1 || commit.getCommitterIdent().getEmailAddress().toLowerCase().indexOf(lcValue) > -1;
                            break;
                        }
                        case COMMIT: {
                            include = commit.getFullMessage().toLowerCase().indexOf(lcValue) > -1;
                        }
                    }
                    return include;
                }
            });
            rw.markStart(rw.parseCommit((AnyObjectId)branchObject));
            RevWalk revlog = rw;
            if (offset > 0) {
                int count = 0;
                for (RevCommit rev : revlog) {
                    if (++count <= offset) continue;
                    list.add(rev);
                    if (maxCount <= 0 || list.size() != maxCount) continue;
                    break;
                }
            } else {
                for (RevCommit rev : revlog) {
                    list.add(rev);
                    if (maxCount <= 0 || list.size() != maxCount) continue;
                    break;
                }
            }
            rw.dispose();
        }
        catch (Throwable t) {
            JGitUtils.error(t, repository, "{0} failed to {1} search revlogs for {2}", type.name(), value);
        }
        return list;
    }

    public static ObjectId getDefaultBranch(Repository repository) throws Exception {
        List<RefModel> branchModels;
        ObjectId object = repository.resolve("HEAD");
        if (object == null && (branchModels = JGitUtils.getLocalBranches(repository, true, -1)).size() > 0) {
            RefModel branch = null;
            Date lastDate = new Date(0L);
            for (RefModel branchModel : branchModels) {
                if (!branchModel.getDate().after(lastDate)) continue;
                branch = branchModel;
                lastDate = branch.getDate();
            }
            object = branch.getReferencedObjectId();
        }
        return object;
    }

    public static String getHEADRef(Repository repository) {
        String target = null;
        try {
            target = repository.getFullBranch();
        }
        catch (Throwable t) {
            JGitUtils.error(t, repository, "{0} failed to get symbolic HEAD target", new Object[0]);
        }
        return target;
    }

    public static boolean setHEADtoRef(Repository repository, String targetRef) {
        try {
            RefUpdate.Result result;
            boolean detach = !targetRef.startsWith("refs/heads/");
            RefUpdate head = repository.updateRef("HEAD", detach);
            if (detach) {
                RevCommit commit = JGitUtils.getCommit(repository, targetRef);
                head.setNewObjectId((AnyObjectId)commit.getId());
                result = head.forceUpdate();
            } else {
                result = head.link(targetRef);
            }
            switch (result) {
                case NEW: 
                case FORCED: 
                case NO_CHANGE: 
                case FAST_FORWARD: {
                    return true;
                }
            }
            LOGGER.error(MessageFormat.format("{0} HEAD update to {1} returned result {2}", repository.getDirectory().getAbsolutePath(), targetRef, result));
        }
        catch (Throwable t) {
            JGitUtils.error(t, repository, "{0} failed to set HEAD to {1}", targetRef);
        }
        return false;
    }

    public static boolean setBranchRef(Repository repository, String branch, String commitId) {
        String branchName = branch;
        if (!branchName.startsWith("refs/")) {
            branchName = "refs/heads/" + branch;
        }
        try {
            RefUpdate refUpdate = repository.updateRef(branchName, false);
            refUpdate.setNewObjectId((AnyObjectId)ObjectId.fromString((String)commitId));
            RefUpdate.Result result = refUpdate.forceUpdate();
            switch (result) {
                case NEW: 
                case FORCED: 
                case NO_CHANGE: 
                case FAST_FORWARD: {
                    return true;
                }
            }
            LOGGER.error(MessageFormat.format("{0} {1} update to {2} returned result {3}", repository.getDirectory().getAbsolutePath(), branchName, commitId, result));
        }
        catch (Throwable t) {
            JGitUtils.error(t, repository, "{0} failed to set {1} to {2}", branchName, commitId);
        }
        return false;
    }

    public static boolean deleteBranchRef(Repository repository, String branch) {
        try {
            RefUpdate refUpdate = repository.updateRef(branch, false);
            refUpdate.setForceUpdate(true);
            RefUpdate.Result result = refUpdate.delete();
            switch (result) {
                case NEW: 
                case FORCED: 
                case NO_CHANGE: 
                case FAST_FORWARD: {
                    return true;
                }
            }
            LOGGER.error(MessageFormat.format("{0} failed to delete to {1} returned result {2}", repository.getDirectory().getAbsolutePath(), branch, result));
        }
        catch (Throwable t) {
            JGitUtils.error(t, repository, "{0} failed to delete {1}", branch);
        }
        return false;
    }

    public static List<String> getAvailableHeadTargets(Repository repository) {
        ArrayList<String> targets = new ArrayList<String>();
        for (RefModel branchModel : JGitUtils.getLocalBranches(repository, true, -1)) {
            targets.add(branchModel.getName());
        }
        for (RefModel tagModel : JGitUtils.getTags(repository, true, -1)) {
            targets.add(tagModel.getName());
        }
        return targets;
    }

    public static Map<ObjectId, List<RefModel>> getAllRefs(Repository repository) {
        return JGitUtils.getAllRefs(repository, true);
    }

    public static Map<ObjectId, List<RefModel>> getAllRefs(Repository repository, boolean includeRemoteRefs) {
        List<RefModel> list = JGitUtils.getRefs(repository, "", true, -1);
        HashMap<ObjectId, List<RefModel>> refs = new HashMap<ObjectId, List<RefModel>>();
        for (RefModel ref : list) {
            if (!includeRemoteRefs && ref.getName().startsWith("refs/remotes/")) continue;
            ObjectId objectid = ref.getReferencedObjectId();
            if (!refs.containsKey(objectid)) {
                refs.put(objectid, new ArrayList());
            }
            ((List)refs.get(objectid)).add(ref);
        }
        return refs;
    }

    public static List<RefModel> getTags(Repository repository, boolean fullName, int maxCount) {
        return JGitUtils.getRefs(repository, "refs/tags/", fullName, maxCount);
    }

    public static List<RefModel> getTags(Repository repository, boolean fullName, int maxCount, int offset) {
        return JGitUtils.getRefs(repository, "refs/tags/", fullName, maxCount, offset);
    }

    public static List<RefModel> getLocalBranches(Repository repository, boolean fullName, int maxCount) {
        return JGitUtils.getRefs(repository, "refs/heads/", fullName, maxCount);
    }

    public static List<RefModel> getRemoteBranches(Repository repository, boolean fullName, int maxCount) {
        return JGitUtils.getRefs(repository, "refs/remotes/", fullName, maxCount);
    }

    public static List<RefModel> getNoteBranches(Repository repository, boolean fullName, int maxCount) {
        return JGitUtils.getRefs(repository, "refs/notes/", fullName, maxCount);
    }

    public static List<RefModel> getRefs(Repository repository, String baseRef) {
        return JGitUtils.getRefs(repository, baseRef, true, -1);
    }

    private static List<RefModel> getRefs(Repository repository, String refs, boolean fullName, int maxCount) {
        return JGitUtils.getRefs(repository, refs, fullName, maxCount, 0);
    }

    private static List<RefModel> getRefs(Repository repository, String refs, boolean fullName, int maxCount, int offset) {
        ArrayList<RefModel> list = new ArrayList<RefModel>();
        if (maxCount == 0) {
            return list;
        }
        if (!JGitUtils.hasCommits(repository)) {
            return list;
        }
        try {
            Map map = repository.getRefDatabase().getRefs(refs);
            RevWalk rw = new RevWalk(repository);
            for (Map.Entry entry : map.entrySet()) {
                Ref ref = (Ref)entry.getValue();
                RevObject object = rw.parseAny((AnyObjectId)ref.getObjectId());
                String name = (String)entry.getKey();
                if (fullName && !StringUtils.isEmpty(refs)) {
                    name = refs + name;
                }
                list.add(new RefModel(name, ref, object));
            }
            rw.dispose();
            Collections.sort(list);
            Collections.reverse(list);
            if (maxCount > 0 && list.size() > maxCount) {
                int endIndex;
                if (offset < 0) {
                    offset = 0;
                }
                if ((endIndex = offset + maxCount) > list.size()) {
                    endIndex = list.size();
                }
                list = new ArrayList(list.subList(offset, endIndex));
            }
        }
        catch (IOException e) {
            JGitUtils.error(e, repository, "{0} failed to retrieve {1}", refs);
        }
        return list;
    }

    public static RefModel getPagesBranch(Repository repository) {
        return JGitUtils.getBranch(repository, "gh-pages");
    }

    public static RefModel getBranch(Repository repository, String name) {
        RefModel branch;
        block4: {
            branch = null;
            try {
                for (RefModel ref : JGitUtils.getLocalBranches(repository, false, -1)) {
                    if (!ref.reference.getName().endsWith(name)) continue;
                    branch = ref;
                    break;
                }
                if (branch != null) break block4;
                for (RefModel ref : JGitUtils.getRemoteBranches(repository, false, -1)) {
                    if (!ref.reference.getName().endsWith(name)) continue;
                    branch = ref;
                    break;
                }
            }
            catch (Throwable t) {
                LOGGER.error(MessageFormat.format("Failed to find {0} branch!", name), t);
            }
        }
        return branch;
    }

    public static List<SubmoduleModel> getSubmodules(Repository repository, String commitId) {
        RevCommit commit = JGitUtils.getCommit(repository, commitId);
        return JGitUtils.getSubmodules(repository, commit.getTree());
    }

    public static List<SubmoduleModel> getSubmodules(Repository repository, RevTree tree) {
        ArrayList<SubmoduleModel> list = new ArrayList<SubmoduleModel>();
        byte[] blob = JGitUtils.getByteContent(repository, tree, ".gitmodules", false);
        if (blob == null) {
            return list;
        }
        try {
            BlobBasedConfig config = new BlobBasedConfig((Config)repository.getConfig(), blob);
            for (String module : config.getSubsections("submodule")) {
                String path = config.getString("submodule", module, "path");
                String url = config.getString("submodule", module, "url");
                list.add(new SubmoduleModel(module, path, url));
            }
        }
        catch (ConfigInvalidException e) {
            LOGGER.error("Failed to load .gitmodules file for " + repository.getDirectory(), (Throwable)e);
        }
        return list;
    }

    public static SubmoduleModel getSubmoduleModel(Repository repository, String commitId, String path) {
        for (SubmoduleModel model : JGitUtils.getSubmodules(repository, commitId)) {
            if (!model.path.equals(path)) continue;
            return model;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSubmoduleCommitId(Repository repository, String path, RevCommit commit) {
        String commitId = null;
        RevWalk rw = new RevWalk(repository);
        TreeWalk tw = new TreeWalk(repository);
        tw.setFilter(PathFilterGroup.createFromStrings(Collections.singleton(path)));
        try {
            tw.reset((AnyObjectId)commit.getTree());
            while (tw.next()) {
                if (tw.isSubtree() && !path.equals(tw.getPathString())) {
                    tw.enterSubtree();
                    continue;
                }
                if (FileMode.GITLINK != tw.getFileMode(0)) continue;
                commitId = tw.getObjectId(0).getName();
                break;
            }
        }
        catch (Throwable t) {
            JGitUtils.error(t, repository, "{0} can''t find {1} in commit {2}", path, commit.name());
        }
        finally {
            rw.dispose();
            tw.close();
        }
        return commitId;
    }

    public static List<GitNote> getNotesOnCommit(Repository repository, RevCommit commit) {
        ArrayList<GitNote> list = new ArrayList<GitNote>();
        if (!JGitUtils.hasCommits(repository)) {
            return list;
        }
        List<RefModel> noteBranches = JGitUtils.getNoteBranches(repository, true, -1);
        for (RefModel notesRef : noteBranches) {
            String notePath;
            RevTree notesTree = JGitUtils.getCommit(repository, notesRef.getName()).getTree();
            String text = JGitUtils.getStringContent(repository, notesTree, notePath = commit.getName(), new String[0]);
            if (!StringUtils.isEmpty(text)) {
                List<RevCommit> history = JGitUtils.getRevLog(repository, notesRef.getName(), notePath, 0, -1);
                RefModel noteRef = new RefModel(notesRef.displayName, null, (RevObject)history.get(history.size() - 1));
                GitNote gitNote = new GitNote(noteRef, text);
                list.add(gitNote);
                continue;
            }
            StringBuilder sb = new StringBuilder(commit.getName());
            sb.insert(2, '/');
            notePath = sb.toString();
            text = JGitUtils.getStringContent(repository, notesTree, notePath, new String[0]);
            if (StringUtils.isEmpty(text)) continue;
            List<RevCommit> history = JGitUtils.getRevLog(repository, notesRef.getName(), notePath, 0, -1);
            RefModel noteRef = new RefModel(notesRef.displayName, null, (RevObject)history.get(history.size() - 1));
            GitNote gitNote = new GitNote(noteRef, text);
            list.add(gitNote);
        }
        return list;
    }

    public static boolean createIncrementalRevisionTag(Repository repository, String objectId, PersonIdent tagger, String prefix, String intPattern, String message) {
        boolean result = false;
        Iterator iterator = repository.getTags().entrySet().iterator();
        long lastRev = 0L;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((String)entry.getKey()).startsWith(prefix)) continue;
            try {
                long val = Long.parseLong(((String)entry.getKey()).substring(prefix.length()));
                if (val <= lastRev) continue;
                lastRev = val;
            }
            catch (Exception exception) {}
        }
        DecimalFormat df = new DecimalFormat(intPattern);
        result = JGitUtils.createTag(repository, objectId, tagger, prefix + df.format(lastRev + 1L), message);
        return result;
    }

    public static boolean createTag(Repository repository, String objectId, PersonIdent tagger, String tag, String message) {
        try {
            Git gitClient = Git.open((File)repository.getDirectory());
            TagCommand tagCommand = gitClient.tag();
            tagCommand.setTagger(tagger);
            tagCommand.setMessage(message);
            if (objectId != null) {
                RevCommit revObj = JGitUtils.getCommit(repository, objectId);
                tagCommand.setObjectId((RevObject)revObj);
            }
            tagCommand.setName(tag);
            Ref call = tagCommand.call();
            return call != null;
        }
        catch (Exception e) {
            JGitUtils.error(e, repository, "Failed to create tag {1} in repository {0}", objectId, tag);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean createOrphanBranch(Repository repository, String branchName, PersonIdent author) {
        boolean success = false;
        String message = "Created branch " + branchName;
        if (author == null) {
            author = new PersonIdent("Gitblit", "gitblit@localhost");
        }
        try (ObjectInserter odi = repository.newObjectInserter();){
            ObjectId blobId = odi.insert(3, message.getBytes("UTF-8"));
            TreeFormatter tree = new TreeFormatter();
            tree.append(".branch", FileMode.REGULAR_FILE, (AnyObjectId)blobId);
            ObjectId treeId = odi.insert(tree);
            CommitBuilder commit = new CommitBuilder();
            commit.setAuthor(author);
            commit.setCommitter(author);
            commit.setEncoding("UTF-8");
            commit.setMessage(message);
            commit.setTreeId((AnyObjectId)treeId);
            ObjectId commitId = odi.insert(commit);
            odi.flush();
            try (RevWalk revWalk = new RevWalk(repository);){
                RevCommit revCommit = revWalk.parseCommit((AnyObjectId)commitId);
                if (!branchName.startsWith("refs/")) {
                    branchName = "refs/heads/" + branchName;
                }
                RefUpdate ru = repository.updateRef(branchName);
                ru.setNewObjectId((AnyObjectId)commitId);
                ru.setRefLogMessage("commit: " + revCommit.getShortMessage(), false);
                RefUpdate.Result rc = ru.forceUpdate();
                switch (rc) {
                    case NEW: 
                    case FORCED: 
                    case FAST_FORWARD: {
                        success = true;
                        return success;
                    }
                    default: {
                        success = false;
                        return success;
                    }
                }
            }
        }
        catch (Throwable t) {
            JGitUtils.error(t, repository, "Failed to create orphan branch {1} in repository {0}", branchName);
        }
        return success;
    }

    public static String getSparkleshareId(Repository repository) {
        byte[] content = JGitUtils.getByteContent(repository, null, ".sparkleshare", false);
        if (content == null) {
            return null;
        }
        return StringUtils.decodeString(content, new String[0]);
    }

    public static boolean repairFetchSpecs(Repository repository) {
        StoredConfig rc = repository.getConfig();
        for (String name : rc.getSubsections("remote")) {
            int invalidSpecs = 0;
            int repairedSpecs = 0;
            ArrayList<String> specs = new ArrayList<String>();
            for (String spec : rc.getStringList("remote", name, "fetch")) {
                try {
                    RefSpec rs = new RefSpec(spec);
                    specs.add(spec);
                }
                catch (IllegalArgumentException e) {
                    ++invalidSpecs;
                    if (!spec.contains("//")) continue;
                    spec = spec.replace("//", "/");
                    specs.add(spec);
                    ++repairedSpecs;
                }
            }
            if (invalidSpecs == repairedSpecs && repairedSpecs > 0) {
                rc.setStringList("remote", name, "fetch", specs);
                try {
                    rc.save();
                    rc.load();
                    LOGGER.debug("repaired {} invalid fetch refspecs for {}", (Object)repairedSpecs, (Object)repository.getDirectory());
                    return true;
                }
                catch (Exception e) {
                    LOGGER.error(null, (Throwable)e);
                    continue;
                }
            }
            if (invalidSpecs <= 0) continue;
            LOGGER.error("mirror executor found {} invalid fetch refspecs for {}", (Object)invalidSpecs, (Object)repository.getDirectory());
        }
        return false;
    }

    public static boolean isMergedInto(Repository repository, String commitId, String tipId) {
        try {
            return JGitUtils.isMergedInto(repository, repository.resolve(commitId), repository.resolve(tipId));
        }
        catch (Exception e) {
            LOGGER.error("Failed to determine isMergedInto", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMergedInto(Repository repository, ObjectId commitId, ObjectId tipCommitId) {
        RevWalk rw = new RevWalk(repository);
        try {
            RevCommit tip = rw.lookupCommit((AnyObjectId)tipCommitId);
            RevCommit commit = rw.lookupCommit((AnyObjectId)commitId);
            boolean bl = rw.isMergedInto(commit, tip);
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("Failed to determine isMergedInto", (Throwable)e);
        }
        finally {
            rw.dispose();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMergeBase(Repository repository, ObjectId commitIdA, ObjectId commitIdB) {
        RevWalk rw = new RevWalk(repository);
        try {
            RevCommit a = rw.lookupCommit((AnyObjectId)commitIdA);
            RevCommit b = rw.lookupCommit((AnyObjectId)commitIdB);
            rw.setRevFilter(RevFilter.MERGE_BASE);
            rw.markStart(a);
            rw.markStart(b);
            RevCommit mergeBase = rw.next();
            if (mergeBase == null) {
                String string = null;
                return string;
            }
            String string = mergeBase.getName();
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Failed to determine merge base", (Throwable)e);
        }
        finally {
            rw.dispose();
        }
        return null;
    }

    public static MergeStatus canMerge(Repository repository, String src, String toBranch, Constants.MergeType mergeType) {
        IntegrationStrategy strategy = IntegrationStrategyFactory.create(mergeType, repository, src, toBranch);
        return strategy.canMerge();
    }

    public static MergeResult merge(Repository repository, String src, String toBranch, Constants.MergeType mergeType, PersonIdent committer, String message) {
        if (!toBranch.startsWith("refs/")) {
            toBranch = "refs/heads/" + toBranch;
        }
        IntegrationStrategy strategy = IntegrationStrategyFactory.create(mergeType, repository, src, toBranch);
        MergeResult mergeResult = strategy.merge(committer, message);
        if (mergeResult.status != MergeStatus.MERGED) {
            return mergeResult;
        }
        try {
            RefUpdate mergeRefUpdate = repository.updateRef(toBranch);
            mergeRefUpdate.setNewObjectId((AnyObjectId)strategy.getMergeCommit());
            mergeRefUpdate.setRefLogMessage(strategy.getRefLogMessage(), false);
            mergeRefUpdate.setExpectedOldObjectId((AnyObjectId)strategy.branchTip);
            RefUpdate.Result rc = mergeRefUpdate.update();
            switch (rc) {
                case FAST_FORWARD: {
                    break;
                }
                default: {
                    mergeResult = new MergeResult(MergeStatus.FAILED, null);
                    throw new GitBlitException(MessageFormat.format("Unexpected result \"{0}\" when {1} in {2}", rc.name(), strategy.getOperationMessage(), repository.getDirectory()));
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to merge", (Throwable)e);
        }
        return mergeResult;
    }

    public static String getLfsRepositoryUrl(String baseURL, String repositoryName, String oid) {
        if (baseURL.length() > 0 && baseURL.charAt(baseURL.length() - 1) == '/') {
            baseURL = baseURL.substring(0, baseURL.length() - 1);
        }
        return baseURL + "/r/" + repositoryName + "/" + "info/lfs/" + "objects/" + oid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DirCacheEntry> getTreeEntries(Repository db, String branch, Collection<String> ignorePaths) throws IOException {
        ArrayList<DirCacheEntry> list = new ArrayList<DirCacheEntry>();
        try (TreeWalk tw = null;){
            ObjectId treeId = db.resolve(branch + "^{tree}");
            if (treeId == null) {
                ArrayList<DirCacheEntry> arrayList = list;
                return arrayList;
            }
            tw = new TreeWalk(db);
            int hIdx = tw.addTree((AnyObjectId)treeId);
            tw.setRecursive(true);
            while (tw.next()) {
                String path = tw.getPathString();
                CanonicalTreeParser hTree = null;
                if (hIdx != -1) {
                    hTree = (CanonicalTreeParser)tw.getTree(hIdx, CanonicalTreeParser.class);
                }
                if (ignorePaths.contains(path) || hTree == null) continue;
                DirCacheEntry entry = new DirCacheEntry(path);
                entry.setObjectId((AnyObjectId)hTree.getEntryObjectId());
                entry.setFileMode(hTree.getEntryFileMode());
                list.add(entry);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean commitIndex(Repository db, String branch, DirCache index, ObjectId parentId, boolean forceCommit, String author, String authorEmail, String message) throws IOException, ConcurrentRefUpdateException {
        boolean success = false;
        ObjectId headId = db.resolve(branch + "^{commit}");
        ObjectId baseId = parentId;
        if (baseId == null || headId == null) {
            return false;
        }
        try (ObjectInserter odi = db.newObjectInserter();){
            ObjectId indexTreeId = index.writeTree(odi);
            PersonIdent ident = new PersonIdent(author, authorEmail);
            if (!forceCommit) {
                ThreeWayMerger merger = MergeStrategy.RECURSIVE.newMerger(db, true);
                merger.setObjectInserter(odi);
                merger.setBase((AnyObjectId)baseId);
                boolean mergeSuccess = merger.merge(new AnyObjectId[]{indexTreeId, headId});
                if (mergeSuccess) {
                    indexTreeId = merger.getResultTreeId();
                } else {
                    boolean bl = false;
                    return bl;
                }
            }
            CommitBuilder commit = new CommitBuilder();
            commit.setAuthor(ident);
            commit.setCommitter(ident);
            commit.setEncoding("UTF-8");
            commit.setMessage(message);
            commit.setParentId((AnyObjectId)headId);
            commit.setTreeId((AnyObjectId)indexTreeId);
            ObjectId commitId = odi.insert(commit);
            odi.flush();
            try (RevWalk revWalk = new RevWalk(db);){
                RevCommit revCommit = revWalk.parseCommit((AnyObjectId)commitId);
                RefUpdate ru = db.updateRef(branch);
                ru.setForceUpdate(forceCommit);
                ru.setNewObjectId((AnyObjectId)commitId);
                ru.setExpectedOldObjectId((AnyObjectId)headId);
                ru.setRefLogMessage("commit: " + revCommit.getShortMessage(), false);
                RefUpdate.Result rc = ru.update();
                switch (rc) {
                    case NEW: 
                    case FORCED: 
                    case FAST_FORWARD: {
                        success = true;
                        return success;
                    }
                    case REJECTED: 
                    case LOCK_FAILURE: {
                        throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, ru.getRef(), rc);
                    }
                    default: {
                        throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, branch, commitId.toString(), rc));
                    }
                }
            }
        }
    }

    public static boolean isTip(Repository repository, String commitId) {
        try {
            RefModel tip = JGitUtils.getBranch(repository, commitId);
            return tip != null;
        }
        catch (Exception e) {
            LOGGER.error("Failed to determine isTip", (Throwable)e);
            return false;
        }
    }

    public static long getTicketNumberFromCommitBranch(Repository repository, RevCommit commit) {
        Map map = repository.getAllRefsByPeeledObjectId();
        Set refs = (Set)map.get(commit.getId());
        if (!ArrayUtils.isEmpty(refs)) {
            for (Ref ref : refs) {
                long number = PatchsetCommand.getTicketNumber(ref.getName());
                if (number <= 0L) continue;
                return number;
            }
        }
        return 0L;
    }

    @NotNull
    public static List<TicketModel.TicketLink> identifyTicketsFromCommitMessage(Repository repository, IStoredSettings settings, RevCommit commit) {
        ArrayList<TicketModel.TicketLink> ticketLinks = new ArrayList<TicketModel.TicketLink>();
        ArrayList<Long> linkedTickets = new ArrayList<Long>();
        String xFixDefault = "(?:fixes|closes)[\\s-]+#?(\\d+)";
        String xFix = settings.getString("tickets.closeOnPushCommitMessageRegex", "(?:fixes|closes)[\\s-]+#?(\\d+)");
        if (StringUtils.isEmpty(xFix)) {
            xFix = "(?:fixes|closes)[\\s-]+#?(\\d+)";
        }
        try {
            Pattern p = Pattern.compile(xFix, 2);
            Matcher m = p.matcher(commit.getFullMessage());
            while (m.find()) {
                String val = m.group(1);
                long number = Long.parseLong(val);
                if (number <= 0L) continue;
                ticketLinks.add(new TicketModel.TicketLink(number, TicketModel.TicketAction.Close));
                linkedTickets.add(number);
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("Failed to parse \"%s\" in commit %s", xFix, commit.getName()), (Throwable)e);
        }
        String xRefDefault = "(?:ref|task|issue|bug)?[\\s-]*#(\\d+)";
        String xRef = settings.getString("tickets.linkOnPushCommitMessageRegex", "(?:ref|task|issue|bug)?[\\s-]*#(\\d+)");
        if (StringUtils.isEmpty(xRef)) {
            xRef = "(?:ref|task|issue|bug)?[\\s-]*#(\\d+)";
        }
        try {
            Pattern p = Pattern.compile(xRef, 2);
            Matcher m = p.matcher(commit.getFullMessage());
            while (m.find()) {
                String val = m.group(1);
                long number = Long.parseLong(val);
                if (number <= 0L || linkedTickets.contains(number)) continue;
                ticketLinks.add(new TicketModel.TicketLink(number, TicketModel.TicketAction.Commit, commit.getName()));
                linkedTickets.add(number);
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("Failed to parse \"%s\" in commit %s", xRef, commit.getName()), (Throwable)e);
        }
        return ticketLinks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TicketModel.TicketLink> identifyTicketsBetweenCommits(Repository repository, IStoredSettings settings, String baseSha, String tipSha) {
        ArrayList<TicketModel.TicketLink> links = new ArrayList<TicketModel.TicketLink>();
        if (repository == null) {
            return links;
        }
        RevWalk walk = new RevWalk(repository);
        walk.sort(RevSort.TOPO);
        walk.sort(RevSort.REVERSE, true);
        try {
            RevCommit commit;
            RevCommit tip = walk.parseCommit((AnyObjectId)repository.resolve(tipSha));
            RevCommit base = walk.parseCommit((AnyObjectId)repository.resolve(baseSha));
            walk.markStart(tip);
            walk.markUninteresting(base);
            while ((commit = walk.next()) != null) {
                links.addAll(JGitUtils.identifyTicketsFromCommitMessage(repository, settings, commit));
            }
        }
        catch (IOException e) {
            LOGGER.error("failed to identify tickets between commits.", (Throwable)e);
        }
        finally {
            walk.dispose();
        }
        return links;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countCommits(Repository repository, RevWalk walk, ObjectId baseId, ObjectId tipId) {
        int count = 0;
        walk.reset();
        walk.sort(RevSort.TOPO);
        walk.sort(RevSort.REVERSE, true);
        try {
            RevCommit c;
            RevCommit tip = walk.parseCommit((AnyObjectId)tipId);
            RevCommit base = walk.parseCommit((AnyObjectId)baseId);
            walk.markStart(tip);
            walk.markUninteresting(base);
            while ((c = walk.next()) != null) {
                ++count;
            }
        }
        catch (IOException e) {
            LOGGER.error("failed to get commit count", (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            walk.close();
        }
        return count;
    }

    public static int countCommits(Repository repository, RevWalk walk, String baseId, String tipId) {
        int count = 0;
        try {
            count = JGitUtils.countCommits(repository, walk, repository.resolve(baseId), repository.resolve(tipId));
        }
        catch (IOException e) {
            LOGGER.error("failed to get commit count", (Throwable)e);
        }
        return count;
    }

    private static class IntegrationStrategyFactory {
        private IntegrationStrategyFactory() {
        }

        static IntegrationStrategy create(Constants.MergeType mergeType, Repository repository, String src, String toBranch) {
            switch (mergeType) {
                case FAST_FORWARD_ONLY: {
                    return new FastForwardOnly(repository, src, toBranch);
                }
                case MERGE_IF_NECESSARY: {
                    return new MergeIfNecessary(repository, src, toBranch);
                }
                case MERGE_ALWAYS: {
                    return new MergeAlways(repository, src, toBranch);
                }
            }
            return null;
        }
    }

    private static class MergeAlways
    extends IntegrationStrategy {
        MergeAlways(Repository repository, String src, String toBranch) {
            super(repository, src, toBranch);
        }

        @Override
        MergeStatus _canMerge() throws IOException {
            RecursiveMerger merger = (RecursiveMerger)MergeStrategy.RECURSIVE.newMerger(this.repository, true);
            boolean canMerge = merger.merge(new AnyObjectId[]{this.branchTip, this.srcTip});
            if (canMerge) {
                return MergeStatus.MERGEABLE;
            }
            return MergeStatus.NOT_MERGEABLE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        MergeResult _merge(PersonIdent committer, String message) throws IOException {
            RecursiveMerger merger = (RecursiveMerger)MergeStrategy.RECURSIVE.newMerger(this.repository, true);
            boolean merged = merger.merge(new AnyObjectId[]{this.branchTip, this.srcTip});
            if (merged) {
                ObjectId treeId = merger.getResultTreeId();
                try (ObjectInserter odi = this.repository.newObjectInserter();){
                    CommitBuilder commitBuilder = new CommitBuilder();
                    commitBuilder.setCommitter(committer);
                    commitBuilder.setAuthor(committer);
                    commitBuilder.setEncoding(Constants.CHARSET);
                    if (StringUtils.isEmpty(message)) {
                        message = MessageFormat.format("merge {0} into {1}", this.srcTip.getName(), this.branchTip.getName());
                    }
                    commitBuilder.setMessage(message);
                    commitBuilder.setParentIds((AnyObjectId)this.branchTip.getId(), (AnyObjectId)this.srcTip.getId());
                    commitBuilder.setTreeId((AnyObjectId)treeId);
                    ObjectId mergeCommitId = odi.insert(commitBuilder);
                    odi.flush();
                    this.mergeCommit = this.revWalk.parseCommit((AnyObjectId)mergeCommitId);
                    this.refLogMessage = "commit: " + this.mergeCommit.getShortMessage();
                    this.operationMessage = MessageFormat.format("merging commit {0} into {1}", this.srcTip.getName(), this.branchTip.getName());
                    MergeResult mergeResult = new MergeResult(MergeStatus.MERGED, mergeCommitId.getName());
                    return mergeResult;
                }
            }
            return new MergeResult(MergeStatus.FAILED, null);
        }
    }

    private static class MergeIfNecessary
    extends IntegrationStrategy {
        MergeIfNecessary(Repository repository, String src, String toBranch) {
            super(repository, src, toBranch);
        }

        @Override
        MergeStatus _canMerge() throws IOException {
            if (this.revWalk.isMergedInto(this.branchTip, this.srcTip)) {
                return MergeStatus.MERGEABLE;
            }
            RecursiveMerger merger = (RecursiveMerger)MergeStrategy.RECURSIVE.newMerger(this.repository, true);
            boolean canMerge = merger.merge(new AnyObjectId[]{this.branchTip, this.srcTip});
            if (canMerge) {
                return MergeStatus.MERGEABLE;
            }
            return MergeStatus.NOT_MERGEABLE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        MergeResult _merge(PersonIdent committer, String message) throws IOException {
            if (this.revWalk.isMergedInto(this.branchTip, this.srcTip)) {
                this.mergeCommit = this.srcTip;
                this.refLogMessage = "merge " + this.src + ": Fast-forward";
                this.operationMessage = MessageFormat.format("fast-forwarding {0} to commit {1}", this.branchTip.getName(), this.srcTip.getName());
                return new MergeResult(MergeStatus.MERGED, this.srcTip.getName());
            }
            RecursiveMerger merger = (RecursiveMerger)MergeStrategy.RECURSIVE.newMerger(this.repository, true);
            boolean merged = merger.merge(new AnyObjectId[]{this.branchTip, this.srcTip});
            if (merged) {
                ObjectId treeId = merger.getResultTreeId();
                try (ObjectInserter odi = this.repository.newObjectInserter();){
                    CommitBuilder commitBuilder = new CommitBuilder();
                    commitBuilder.setCommitter(committer);
                    commitBuilder.setAuthor(committer);
                    commitBuilder.setEncoding(Constants.CHARSET);
                    if (StringUtils.isEmpty(message)) {
                        message = MessageFormat.format("merge {0} into {1}", this.srcTip.getName(), this.branchTip.getName());
                    }
                    commitBuilder.setMessage(message);
                    commitBuilder.setParentIds((AnyObjectId)this.branchTip.getId(), (AnyObjectId)this.srcTip.getId());
                    commitBuilder.setTreeId((AnyObjectId)treeId);
                    ObjectId mergeCommitId = odi.insert(commitBuilder);
                    odi.flush();
                    this.mergeCommit = this.revWalk.parseCommit((AnyObjectId)mergeCommitId);
                    this.refLogMessage = "commit: " + this.mergeCommit.getShortMessage();
                    this.operationMessage = MessageFormat.format("merging commit {0} into {1}", this.srcTip.getName(), this.branchTip.getName());
                    MergeResult mergeResult = new MergeResult(MergeStatus.MERGED, mergeCommitId.getName());
                    return mergeResult;
                }
            }
            return new MergeResult(MergeStatus.FAILED, null);
        }
    }

    private static class FastForwardOnly
    extends IntegrationStrategy {
        FastForwardOnly(Repository repository, String src, String toBranch) {
            super(repository, src, toBranch);
        }

        @Override
        MergeStatus _canMerge() throws IOException {
            if (this.revWalk.isMergedInto(this.branchTip, this.srcTip)) {
                return MergeStatus.MERGEABLE;
            }
            return MergeStatus.NOT_MERGEABLE;
        }

        @Override
        MergeResult _merge(PersonIdent committer, String message) throws IOException {
            if (!this.revWalk.isMergedInto(this.branchTip, this.srcTip)) {
                return new MergeResult(MergeStatus.FAILED, null);
            }
            this.mergeCommit = this.srcTip;
            this.refLogMessage = "merge " + this.src + ": Fast-forward";
            this.operationMessage = MessageFormat.format("fast-forwarding {0} to commit {1}", this.srcTip.getName(), this.branchTip.getName());
            return new MergeResult(MergeStatus.MERGED, this.srcTip.getName());
        }
    }

    private static abstract class IntegrationStrategy {
        Repository repository;
        String src;
        String toBranch;
        RevWalk revWalk;
        RevCommit branchTip;
        RevCommit srcTip;
        RevCommit mergeCommit;
        String refLogMessage;
        String operationMessage;

        RevCommit getMergeCommit() {
            return this.mergeCommit;
        }

        String getRefLogMessage() {
            return this.refLogMessage;
        }

        String getOperationMessage() {
            return this.operationMessage;
        }

        IntegrationStrategy(Repository repository, String src, String toBranch) {
            this.repository = repository;
            this.src = src;
            this.toBranch = toBranch;
        }

        void prepare() throws IOException {
            ObjectId srcId;
            ObjectId branchId;
            if (this.revWalk == null) {
                this.revWalk = new RevWalk(this.repository);
            }
            if ((branchId = this.repository.resolve(this.toBranch)) != null) {
                this.branchTip = this.revWalk.lookupCommit((AnyObjectId)branchId);
            }
            if ((srcId = this.repository.resolve(this.src)) != null) {
                this.srcTip = this.revWalk.lookupCommit((AnyObjectId)srcId);
            }
        }

        abstract MergeStatus _canMerge() throws IOException;

        MergeStatus canMerge() {
            try {
                this.prepare();
                if (this.branchTip == null) {
                    MergeStatus mergeStatus = MergeStatus.MISSING_INTEGRATION_BRANCH;
                    return mergeStatus;
                }
                if (this.srcTip == null) {
                    MergeStatus mergeStatus = MergeStatus.MISSING_SRC_BRANCH;
                    return mergeStatus;
                }
                if (this.revWalk.isMergedInto(this.srcTip, this.branchTip)) {
                    MergeStatus mergeStatus = MergeStatus.ALREADY_MERGED;
                    return mergeStatus;
                }
                MergeStatus mergeStatus = this._canMerge();
                return mergeStatus;
            }
            catch (NullPointerException e) {
                LOGGER.error("Failed to determine canMerge", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error("Failed to determine canMerge", (Throwable)e);
            }
            finally {
                if (this.revWalk != null) {
                    this.revWalk.close();
                }
            }
            return MergeStatus.NOT_MERGEABLE;
        }

        abstract MergeResult _merge(PersonIdent var1, String var2) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MergeResult merge(PersonIdent committer, String message) {
            try {
                this.prepare();
                if (this.revWalk.isMergedInto(this.srcTip, this.branchTip)) {
                    MergeResult mergeResult = new MergeResult(MergeStatus.ALREADY_MERGED, null);
                    return mergeResult;
                }
                MergeResult mergeResult = this._merge(committer, message);
                return mergeResult;
            }
            catch (IOException e) {
                LOGGER.error("Failed to merge", (Throwable)e);
            }
            finally {
                if (this.revWalk != null) {
                    this.revWalk.close();
                }
            }
            return new MergeResult(MergeStatus.FAILED, null);
        }
    }

    public static class MergeResult {
        public final MergeStatus status;
        public final String sha;

        MergeResult(MergeStatus status, String sha) {
            this.status = status;
            this.sha = sha;
        }
    }

    public static enum MergeStatus {
        MISSING_INTEGRATION_BRANCH,
        MISSING_SRC_BRANCH,
        NOT_MERGEABLE,
        FAILED,
        ALREADY_MERGED,
        MERGEABLE,
        MERGED;

    }

    public static class LastChange {
        public Date when;
        public String who;

        LastChange() {
            this.when = new Date(0L);
        }

        LastChange(long lastModified) {
            this.when = new Date(lastModified);
        }
    }

    private static class GitConfigSharedRepository {
        private int intValue;
        private GitConfigSharedRepositoryValue enumValue;

        GitConfigSharedRepository(String s) {
            if (s == null || s.trim().isEmpty()) {
                this.enumValue = GitConfigSharedRepositoryValue.GROUP;
            } else {
                try {
                    this.enumValue = GitConfigSharedRepositoryValue.valueOf(s.trim().toUpperCase());
                }
                catch (IllegalArgumentException iae) {
                    try {
                        int i = Integer.parseInt(s, 8);
                        if ((i & 0x180) != 384) {
                            String msg = String.format("Problem with core.sharedRepository filemode value (0%03o).\nThe owner of files must always have read and write permissions.", i);
                            throw new IllegalArgumentException(msg);
                        }
                        this.intValue = i & 0x1B6;
                        this.enumValue = GitConfigSharedRepositoryValue.Oxxx;
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("Bad configuration value for 'shared': '" + s + "'");
                    }
                }
            }
        }

        String getValue() {
            if (this.enumValue == GitConfigSharedRepositoryValue.Oxxx) {
                if (this.intValue == 0) {
                    return "0";
                }
                return String.format("0%o", this.intValue);
            }
            return this.enumValue.getConfigValue();
        }

        int getPerm() {
            if (this.enumValue == GitConfigSharedRepositoryValue.Oxxx) {
                return this.intValue;
            }
            return this.enumValue.getPerm();
        }

        boolean isCustom() {
            return this.enumValue == GitConfigSharedRepositoryValue.Oxxx;
        }

        boolean isShared() {
            return this.enumValue.getPerm() > 0 || this.enumValue == GitConfigSharedRepositoryValue.Oxxx;
        }
    }

    private static enum GitConfigSharedRepositoryValue {
        UMASK("0", 0),
        FALSE("0", 0),
        OFF("0", 0),
        NO("0", 0),
        GROUP("1", 432),
        TRUE("1", 432),
        ON("1", 432),
        YES("1", 432),
        ALL("2", 436),
        WORLD("2", 436),
        EVERYBODY("2", 436),
        Oxxx(null, -1);

        private String configValue;
        private int permValue;

        private GitConfigSharedRepositoryValue(String config, int perm) {
            this.configValue = config;
            this.permValue = perm;
        }

        public String getConfigValue() {
            return this.configValue;
        }

        public int getPerm() {
            return this.permValue;
        }
    }

    public static class CloneResult {
        public String name;
        public FetchResult fetchResult;
        public boolean createdRepository;
    }
}

