/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.utils.JGitUtils;
import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JnaUtils {
    public static final int S_ISUID = 2048;
    public static final int S_ISGID = 1024;
    public static final int S_ISVTX = 512;
    public static final int S_IRWXU = 448;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRWXG = 56;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IRWXO = 7;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    public static final int S_IFMT = 61440;
    public static final int S_IFIFO = 4096;
    public static final int S_IFCHR = 8192;
    public static final int S_IFDIR = 16384;
    public static final int S_IFBLK = 24576;
    public static final int S_IFREG = 32768;
    public static final int S_IFLNK = 40960;
    public static final int S_IFSOCK = 49152;
    private static final Logger LOGGER = LoggerFactory.getLogger(JGitUtils.class);
    private static UnixCLibrary unixlibc = null;

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public static int getgid() {
        if (JnaUtils.isWindows()) {
            throw new UnsupportedOperationException("The method JnaUtils.getgid is not supported under Windows.");
        }
        return JnaUtils.getUnixCLibrary().getgid();
    }

    public static int getegid() {
        if (JnaUtils.isWindows()) {
            throw new UnsupportedOperationException("The method JnaUtils.getegid is not supported under Windows.");
        }
        return JnaUtils.getUnixCLibrary().getegid();
    }

    public static int setFilemode(File file, int mode) {
        return JnaUtils.setFilemode(file.getAbsolutePath(), mode);
    }

    public static int setFilemode(String path, int mode) {
        if (JnaUtils.isWindows()) {
            throw new UnsupportedOperationException("The method JnaUtils.getFilemode is not supported under Windows.");
        }
        return JnaUtils.getUnixCLibrary().chmod(path, mode);
    }

    public static int getFilemode(File path) {
        return JnaUtils.getFilemode(path.getAbsolutePath());
    }

    public static int getFilemode(String path) {
        if (JnaUtils.isWindows()) {
            throw new UnsupportedOperationException("The method JnaUtils.getFilemode is not supported under Windows.");
        }
        Filestat stat = JnaUtils.getFilestat(path);
        if (stat == null) {
            return -1;
        }
        return stat.mode;
    }

    public static Filestat getFilestat(File path) {
        return JnaUtils.getFilestat(path.getAbsolutePath());
    }

    public static Filestat getFilestat(String path) {
        if (JnaUtils.isWindows()) {
            throw new UnsupportedOperationException("The method JnaUtils.getFilestat is not supported under Windows.");
        }
        int mode = 0;
        String lsLine = JnaUtils.runProcessLs(path);
        if (lsLine == null) {
            LOGGER.debug("Could not get file information for path " + path);
            return null;
        }
        Pattern p = Pattern.compile("^(([-bcdlspCDMnP?])([-r][-w][-xSs])([-r][-w][-xSs])([-r][-w][-xTt]))[@+.]? +[0-9]+ +([0-9]+) +([0-9]+) ");
        Matcher m = p.matcher(lsLine);
        if (!m.lookingAt()) {
            LOGGER.debug("Could not parse valid file mode information for path " + path);
            return null;
        }
        String group = m.group(2);
        switch (group.charAt(0)) {
            case 'p': {
                mode |= 0x1000;
                break;
            }
            case 'c': {
                mode |= 0x2000;
                break;
            }
            case 'd': {
                mode |= 0x4000;
                break;
            }
            case 'b': {
                mode |= 0x6000;
                break;
            }
            case '-': {
                mode |= 0x8000;
                break;
            }
            case 'l': {
                mode |= 0xA000;
                break;
            }
            case 's': {
                mode |= 0xC000;
            }
        }
        block22: for (int i = 0; i < 3; ++i) {
            group = m.group(3 + i);
            switch (group.charAt(0)) {
                case 'r': {
                    mode |= 256 >> i * 3;
                    break;
                }
            }
            switch (group.charAt(1)) {
                case 'w': {
                    mode |= 128 >> i * 3;
                    break;
                }
            }
            switch (group.charAt(2)) {
                case 'x': {
                    mode |= 64 >> i * 3;
                    continue block22;
                }
                case 'S': {
                    mode |= 2048 >> i;
                    continue block22;
                }
                case 's': {
                    mode |= 64 >> i * 3;
                    mode |= 2048 >> i;
                    continue block22;
                }
                case 'T': {
                    mode |= 0x200;
                    continue block22;
                }
                case 't': {
                    mode |= 64 >> i * 3;
                    mode |= 0x200;
                    continue block22;
                }
            }
        }
        return new Filestat(mode, Integer.parseInt(m.group(6)), Integer.parseInt(m.group(7)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String runProcessLs(String path) {
        String cmd = "ls -ldn " + path;
        Runtime rt = Runtime.getRuntime();
        Process pr = null;
        InputStreamReader ir = null;
        BufferedReader br = null;
        String output = null;
        try {
            pr = rt.exec(cmd);
            ir = new InputStreamReader(pr.getInputStream());
            br = new BufferedReader(ir);
            output = br.readLine();
            while (br.readLine() != null) {
            }
        }
        catch (IOException e) {
            LOGGER.debug("Exception while running unix command '" + cmd + "': " + e);
        }
        finally {
            if (pr != null) {
                try {
                    pr.waitFor();
                }
                catch (Exception exception) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
            if (ir != null) {
                try {
                    ir.close();
                }
                catch (Exception exception) {}
            }
            if (pr != null) {
                try {
                    pr.getOutputStream().close();
                }
                catch (Exception exception) {}
            }
            if (pr != null) {
                try {
                    pr.getInputStream().close();
                }
                catch (Exception exception) {}
            }
            if (pr != null) {
                try {
                    pr.getErrorStream().close();
                }
                catch (Exception exception) {}
            }
        }
        return output;
    }

    private static UnixCLibrary getUnixCLibrary() {
        if (unixlibc == null && (unixlibc = (UnixCLibrary)Native.loadLibrary((String)"c", UnixCLibrary.class)) == null) {
            throw new RuntimeException("Could not initialize native C library.");
        }
        return unixlibc;
    }

    public static class Filestat {
        public int mode;
        public int uid;
        public int gid;

        Filestat(int mode, int uid, int gid) {
            this.mode = mode;
            this.uid = uid;
            this.gid = gid;
        }
    }

    private static interface UnixCLibrary
    extends Library {
        public int chmod(String var1, int var2);

        public int getgid();

        public int getegid();
    }
}

