/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.Constants;
import com.gitblit.GitBlitException;
import com.gitblit.models.RepositoryModel;
import com.gitblit.models.UserModel;
import com.gitblit.utils.ArrayUtils;
import com.gitblit.utils.ConnectionUtils;
import com.gitblit.utils.StringUtils;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class JsonUtils {
    public static final Type REPOSITORIES_TYPE = new TypeToken<Map<String, RepositoryModel>>(){}.getType();
    public static final Type USERS_TYPE = new TypeToken<Collection<UserModel>>(){}.getType();

    public static String toJsonString(Object o) {
        String json = JsonUtils.gson(new ExclusionStrategy[0]).toJson(o);
        return json;
    }

    public static <X> X fromJsonString(String json, Class<X> clazz) throws JsonParseException, JsonSyntaxException {
        return (X)JsonUtils.gson(new ExclusionStrategy[0]).fromJson(json, clazz);
    }

    public static <X> X fromJsonString(String json, Type type) throws JsonParseException, JsonSyntaxException {
        return (X)JsonUtils.gson(new ExclusionStrategy[0]).fromJson(json, type);
    }

    public static <X> X retrieveJson(String url, Type type) throws IOException, GitBlitException.UnauthorizedException {
        return JsonUtils.retrieveJson(url, type, null, null);
    }

    public static <X> X retrieveJson(String url, Class<? extends X> clazz) throws IOException, GitBlitException.UnauthorizedException {
        return JsonUtils.retrieveJson(url, clazz, null, null);
    }

    public static <X> X retrieveJson(String url, Type type, String username, char[] password) throws IOException {
        String json = JsonUtils.retrieveJsonString(url, username, password);
        if (StringUtils.isEmpty(json)) {
            return null;
        }
        return (X)JsonUtils.gson(new ExclusionStrategy[0]).fromJson(json, type);
    }

    public static <X> X retrieveJson(String url, Class<X> clazz, String username, char[] password) throws IOException {
        String json = JsonUtils.retrieveJsonString(url, username, password);
        if (StringUtils.isEmpty(json)) {
            return null;
        }
        return (X)JsonUtils.gson(new ExclusionStrategy[0]).fromJson(json, clazz);
    }

    public static String retrieveJsonString(String url, String username, char[] password) throws IOException {
        try {
            URLConnection conn = ConnectionUtils.openReadConnection(url, username, password);
            InputStream is = conn.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, ConnectionUtils.CHARSET));
            StringBuilder json = new StringBuilder();
            char[] buffer = new char[4096];
            int len = 0;
            while ((len = reader.read(buffer)) > -1) {
                json.append(buffer, 0, len);
            }
            is.close();
            return json.toString();
        }
        catch (IOException e) {
            if (e.getMessage().indexOf("401") > -1) {
                throw new GitBlitException.UnauthorizedException(url);
            }
            if (e.getMessage().indexOf("403") > -1) {
                throw new GitBlitException.ForbiddenException(url);
            }
            if (e.getMessage().indexOf("405") > -1) {
                throw new GitBlitException.NotAllowedException(url);
            }
            if (e.getMessage().indexOf("501") > -1) {
                throw new GitBlitException.UnknownRequestException(url);
            }
            throw e;
        }
    }

    public static int sendJsonString(String url, String json) throws IOException {
        return JsonUtils.sendJsonString(url, json, null, null);
    }

    public static int sendJsonString(String url, String json, String username, char[] password) throws IOException {
        try {
            byte[] jsonBytes = json.getBytes(ConnectionUtils.CHARSET);
            URLConnection conn = ConnectionUtils.openConnection(url, username, password);
            conn.setRequestProperty("Content-Type", "text/plain;charset=" + ConnectionUtils.CHARSET);
            conn.setRequestProperty("Content-Length", "" + jsonBytes.length);
            OutputStream os = conn.getOutputStream();
            os.write(jsonBytes);
            os.close();
            int status = ((HttpURLConnection)conn).getResponseCode();
            return status;
        }
        catch (IOException e) {
            if (e.getMessage().indexOf("401") > -1) {
                throw new GitBlitException.UnauthorizedException(url);
            }
            if (e.getMessage().indexOf("403") > -1) {
                throw new GitBlitException.ForbiddenException(url);
            }
            if (e.getMessage().indexOf("405") > -1) {
                throw new GitBlitException.NotAllowedException(url);
            }
            if (e.getMessage().indexOf("501") > -1) {
                throw new GitBlitException.UnknownRequestException(url);
            }
            throw e;
        }
    }

    public static Gson gson(ExclusionStrategy ... strategies) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Date.class, (Object)new GmtDateTypeAdapter());
        builder.registerTypeAdapter(Constants.AccessPermission.class, (Object)new AccessPermissionTypeAdapter());
        if (!ArrayUtils.isEmpty(strategies)) {
            builder.setExclusionStrategies(strategies);
        }
        return builder.create();
    }

    public static class ExcludeField
    implements ExclusionStrategy {
        private Class<?> c;
        private String fieldName;

        public ExcludeField(String fqfn) throws SecurityException, NoSuchFieldException, ClassNotFoundException {
            this.c = Class.forName(fqfn.substring(0, fqfn.lastIndexOf(".")));
            this.fieldName = fqfn.substring(fqfn.lastIndexOf(".") + 1);
        }

        public boolean shouldSkipClass(Class<?> arg0) {
            return false;
        }

        public boolean shouldSkipField(FieldAttributes f) {
            return f.getDeclaringClass() == this.c && f.getName().equals(this.fieldName);
        }
    }

    private static class AccessPermissionTypeAdapter
    implements JsonSerializer<Constants.AccessPermission>,
    JsonDeserializer<Constants.AccessPermission> {
        private AccessPermissionTypeAdapter() {
        }

        public synchronized JsonElement serialize(Constants.AccessPermission permission, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(permission.code);
        }

        public synchronized Constants.AccessPermission deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
            return Constants.AccessPermission.fromCode(jsonElement.getAsString());
        }
    }

    public static class GmtDateTypeAdapter
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);

        public GmtDateTypeAdapter() {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized JsonElement serialize(Date date, Type type, JsonSerializationContext jsonSerializationContext) {
            DateFormat dateFormat = this.dateFormat;
            synchronized (dateFormat) {
                String dateFormatAsString = this.dateFormat.format(date);
                return new JsonPrimitive(dateFormatAsString);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Date deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
            try {
                DateFormat dateFormat = this.dateFormat;
                synchronized (dateFormat) {
                    Date date = this.dateFormat.parse(jsonElement.getAsString());
                    return new Date(date.getTime() / 1000L * 1000L);
                }
            }
            catch (ParseException e) {
                throw new JsonSyntaxException(jsonElement.getAsString(), (Throwable)e);
            }
        }
    }
}

