/*
 * Decompiled with CFR 0.152.
 */
package com.gitblit.utils;

import com.gitblit.utils.StringUtils;

public class ModelUtils {
    private static String userRepoPrefix = "~";

    public static void setUserRepoPrefix(String prefix) {
        if (StringUtils.isEmpty(prefix)) {
            userRepoPrefix = "~";
            return;
        }
        String newPrefix = prefix.replace('\\', '/');
        if (prefix.charAt(0) == '/') {
            newPrefix = prefix.substring(1);
        }
        userRepoPrefix = newPrefix;
    }

    public static String getUserRepoPrefix() {
        return userRepoPrefix;
    }

    public static String getPersonalPath(String username) {
        return userRepoPrefix + username.toLowerCase();
    }

    public static boolean isPersonalRepository(String name) {
        return name.startsWith(userRepoPrefix);
    }

    public static boolean isUsersPersonalRepository(String username, String name) {
        return name.equalsIgnoreCase(ModelUtils.getPersonalPath(username));
    }

    public static String getUserNameFromRepoPath(String path) {
        if (!ModelUtils.isPersonalRepository(path)) {
            return "";
        }
        return path.substring(userRepoPrefix.length());
    }
}

